/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.opentypes;

import java.util.ArrayList;
import java.util.Date;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchive3_3;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationPropagationRule;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndCardinality;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefLink;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefStatus;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;

public class OpenMetadataTypesArchive3_4 {
    private static final String archiveGUID = "bce3b0a0-662a-4f87-b8dc-844078a11a6e";
    private static final String archiveName = "Open Metadata Types";
    private static final String archiveDescription = "Standard types for open metadata repositories.";
    private static final OpenMetadataArchiveType archiveType = OpenMetadataArchiveType.CONTENT_PACK;
    private static final String archiveVersion = "3.4";
    private static final String originatorName = "Egeria";
    private static final String originatorLicense = "Apache-2.0";
    private static final Date creationDate = new Date(1588261366992L);
    private static final long versionNumber = 1L;
    private static final String versionName = "1.0";
    private OMRSArchiveBuilder archiveBuilder;
    private OMRSArchiveHelper archiveHelper;

    public OpenMetadataTypesArchive3_4() {
        this.archiveBuilder = new OMRSArchiveBuilder(archiveGUID, archiveName, archiveDescription, archiveType, archiveVersion, originatorName, originatorLicense, creationDate, null);
        this.archiveHelper = new OMRSArchiveHelper(this.archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public OpenMetadataTypesArchive3_4(OMRSArchiveBuilder archiveBuilder) {
        this.archiveBuilder = archiveBuilder;
        this.archiveHelper = new OMRSArchiveHelper(archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public String getArchiveGUID() {
        return archiveGUID;
    }

    public OpenMetadataArchive getOpenMetadataArchive() {
        String methodName = "getOpenMetadataArchive";
        if (this.archiveBuilder != null) {
            this.getOriginalTypes();
            return this.archiveBuilder.getOpenMetadataArchive();
        }
        throw new OMRSLogicErrorException(OMRSErrorCode.ARCHIVE_UNAVAILABLE.getMessageDefinition(), this.getClass().getName(), "getOpenMetadataArchive");
    }

    public void getOriginalTypes() {
        OpenMetadataTypesArchive3_3 previousTypes = new OpenMetadataTypesArchive3_3(this.archiveBuilder);
        previousTypes.getOriginalTypes();
        this.correct0040SoftwareServers();
        this.extend0110Actors();
        this.update0112Team();
        this.update0115ITProfile();
        this.extend0423SecurityDefinitions();
        this.update0223Events();
        this.update0463EngineActions();
    }

    private void correct0040SoftwareServers() {
        this.archiveBuilder.addTypeDefPatch(this.updateServerEndpointRelationship());
    }

    private TypeDefPatch updateServerEndpointRelationship() {
        String typeName = OpenMetadataType.SERVER_ENDPOINT_RELATIONSHIP.typeName;
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        String end1AttributeName = "servers";
        String end1AttributeDescription = "Server(s) supporting this endpoint.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.IT_INFRASTRUCTURE.typeName), "servers", "Server(s) supporting this endpoint.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        typeDefPatch.setEndDef1(relationshipEndDef);
        String end2AttributeName = "endpoints";
        String end2AttributeDescription = "Endpoints supported by this server.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.ENDPOINT.typeName), "endpoints", "Endpoints supported by this server.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        typeDefPatch.setEndDef2(relationshipEndDef);
        return typeDefPatch;
    }

    private void extend0110Actors() {
        this.archiveBuilder.addTypeDefPatch(this.updateUserIdentityEntity());
        this.archiveBuilder.addTypeDefPatch(this.updateProfileIdentityRelationship());
    }

    private TypeDefPatch updateUserIdentityEntity() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.USER_IDENTITY.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.DISTINGUISHED_NAME.name, OpenMetadataProperty.DISTINGUISHED_NAME.description, OpenMetadataProperty.DISTINGUISHED_NAME.descriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateProfileIdentityRelationship() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.PROFILE_IDENTITY_RELATIONSHIP.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.ROLE_TYPE_NAME.name, OpenMetadataProperty.ROLE_TYPE_NAME.description, OpenMetadataProperty.ROLE_TYPE_NAME.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.ROLE_GUID.name, OpenMetadataProperty.ROLE_GUID.description, OpenMetadataProperty.ROLE_GUID.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.DESCRIPTION.name, OpenMetadataProperty.DESCRIPTION.description, OpenMetadataProperty.DESCRIPTION.descriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update0112Team() {
        this.archiveBuilder.addTypeDefPatch(this.updateTeamMembershipRelationship());
        this.archiveBuilder.addTypeDefPatch(this.updateTeamLeadershipRelationship());
    }

    private TypeDefPatch updateTeamMembershipRelationship() {
        String typeName = "TeamMembership";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("TeamMembership");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        String end1EntityType = "PersonRole";
        String end1AttributeName = "teamMembers";
        String end1AttributeDescription = "The members of the team.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("PersonRole"), "teamMembers", "The members of the team.", end1AttributeDescriptionGUID, end1Cardinality);
        typeDefPatch.setEndDef1(relationshipEndDef);
        String end2EntityType = "Team";
        String end2AttributeName = "memberOfTeam";
        String end2AttributeDescription = "The team that this role is a member of.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Team"), "memberOfTeam", "The team that this role is a member of.", end2AttributeDescriptionGUID, end2Cardinality);
        typeDefPatch.setEndDef2(relationshipEndDef);
        return typeDefPatch;
    }

    private TypeDefPatch updateTeamLeadershipRelationship() {
        String typeName = "TeamLeadership";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("TeamLeadership");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        String end1EntityType = "PersonRole";
        String end1AttributeName = "teamLeaders";
        String end1AttributeDescription = "The leaders of the team.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("PersonRole"), "teamLeaders", "The leaders of the team.", end1AttributeDescriptionGUID, end1Cardinality);
        typeDefPatch.setEndDef1(relationshipEndDef);
        String end2EntityType = "Team";
        String end2AttributeName = "leadsTeam";
        String end2AttributeDescription = "The team lead by this person role.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Team"), "leadsTeam", "The team lead by this person role.", end2AttributeDescriptionGUID, end2Cardinality);
        typeDefPatch.setEndDef2(relationshipEndDef);
        return typeDefPatch;
    }

    private void update0115ITProfile() {
        this.archiveBuilder.addRelationshipDef(this.addITInfrastructureProfileRelationship());
    }

    private RelationshipDef addITInfrastructureProfileRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.IT_INFRASTRUCTURE_PROFILE_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "describedByProfile";
        String end1AttributeDescription = "The IT infrastructure that is described by the IT profile.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.ASSET.typeName), "describedByProfile", "The IT infrastructure that is described by the IT profile.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "usedByAsset";
        String end2AttributeDescription = "Description of the user identifies used by the asset.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.IT_PROFILE.typeName), "usedByAsset", "Description of the user identifies used by the asset.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void extend0423SecurityDefinitions() {
        this.archiveBuilder.addEntityDef(this.addSecurityGroupEntity());
        this.archiveBuilder.addClassificationDef(this.addSecurityGroupMembershipClassification());
    }

    private EntityDef addSecurityGroupEntity() {
        String guid = "042d9b5c-677e-477b-811f-1c39bf716759";
        String name = "SecurityGroup";
        String description = "A collection of users that should be given the same security privileges.";
        String descriptionGUID = null;
        String superTypeName = "TechnicalControl";
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("042d9b5c-677e-477b-811f-1c39bf716759", "SecurityGroup", this.archiveBuilder.getEntityDef("TechnicalControl"), "A collection of users that should be given the same security privileges.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.DISTINGUISHED_NAME.name, OpenMetadataProperty.DISTINGUISHED_NAME.description, OpenMetadataProperty.DISTINGUISHED_NAME.descriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private ClassificationDef addSecurityGroupMembershipClassification() {
        String guid = "21a16f1e-9231-4983-b371-a0686d555273";
        String name = "SecurityGroupMembership";
        String description = "Identifies the set of user groups that this user identity is a member of.";
        String descriptionGUID = null;
        ArrayList<TypeDefLink> linkedToEntities = new ArrayList<TypeDefLink>();
        linkedToEntities.add(this.archiveBuilder.getEntityDef(OpenMetadataType.USER_IDENTITY.typeName));
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef("21a16f1e-9231-4983-b371-a0686d555273", "SecurityGroupMembership", null, "Identifies the set of user groups that this user identity is a member of.", descriptionGUID, linkedToEntities, false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "groups";
        String attribute1Description = "List of user group names.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getArrayStringTypeDefAttribute("groups", "List of user group names.", attribute1DescriptionGUID);
        properties.add(property);
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private void update0223Events() {
        this.archiveBuilder.addTypeDefPatch(this.updateKafkaTopic());
    }

    private TypeDefPatch updateKafkaTopic() {
        String typeName = "KafkaTopic";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("KafkaTopic");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "partitions";
        String attribute1Description = "Number of Kafka partitions.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "replicas";
        String attribute2Description = "Number of Kafka replicas.";
        String attribute2DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getIntTypeDefAttribute("partitions", "Number of Kafka partitions.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getIntTypeDefAttribute("replicas", "Number of Kafka replicas.", attribute2DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update0463EngineActions() {
        this.archiveBuilder.addTypeDefPatch(this.deprecateEngineActionExecutorRelationship());
        this.archiveBuilder.addTypeDefPatch(this.deprecateGovernanceActionProcessStepUseRelationship());
        this.archiveBuilder.addTypeDefPatch(this.updateEngineActionEntity());
    }

    private TypeDefPatch deprecateEngineActionExecutorRelationship() {
        String typeName = "EngineActionExecutor";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("EngineActionExecutor");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setTypeDefStatus(TypeDefStatus.DEPRECATED_TYPEDEF);
        return typeDefPatch;
    }

    private TypeDefPatch deprecateGovernanceActionProcessStepUseRelationship() {
        String typeName = "GovernanceActionProcessStepUse";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("GovernanceActionProcessStepUse");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setTypeDefStatus(TypeDefStatus.DEPRECATED_TYPEDEF);
        return typeDefPatch;
    }

    private TypeDefPatch updateEngineActionEntity() {
        String typeName = OpenMetadataType.ENGINE_ACTION.typeName;
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "requestType";
        String attribute1Description = "The request type used to call the service.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "requestParameters";
        String attribute2Description = "Properties that configure the governance service for this type of request.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "executorEngineGUID";
        String attribute3Description = "Unique identifier of the governance engine nominated to run the request.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "executorEngineName";
        String attribute4Description = "Unique identifier of the governance engine nominated to run the request.";
        String attribute4DescriptionGUID = null;
        String attribute5Name = OpenMetadataProperty.PROCESS_NAME.name;
        String attribute5Description = OpenMetadataProperty.PROCESS_NAME.description;
        String attribute5DescriptionGUID = OpenMetadataProperty.PROCESS_NAME.descriptionGUID;
        String attribute6Name = OpenMetadataProperty.PROCESS_STEP_GUID.name;
        String attribute6Description = OpenMetadataProperty.PROCESS_STEP_GUID.description;
        String attribute6DescriptionGUID = OpenMetadataProperty.PROCESS_STEP_GUID.descriptionGUID;
        String attribute7Name = OpenMetadataProperty.PROCESS_STEP_NAME.name;
        String attribute7Description = OpenMetadataProperty.PROCESS_STEP_NAME.description;
        String attribute7DescriptionGUID = OpenMetadataProperty.PROCESS_STEP_NAME.descriptionGUID;
        String attribute8Name = OpenMetadataProperty.GOVERNANCE_ACTION_TYPE_GUID.name;
        String attribute8Description = OpenMetadataProperty.GOVERNANCE_ACTION_TYPE_GUID.description;
        String attribute8DescriptionGUID = OpenMetadataProperty.GOVERNANCE_ACTION_TYPE_GUID.descriptionGUID;
        String attribute9Name = OpenMetadataProperty.GOVERNANCE_ACTION_TYPE_NAME.name;
        String attribute9Description = OpenMetadataProperty.GOVERNANCE_ACTION_TYPE_NAME.description;
        String attribute9DescriptionGUID = OpenMetadataProperty.GOVERNANCE_ACTION_TYPE_NAME.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("requestType", "The request type used to call the service.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringStringTypeDefAttribute("requestParameters", "Properties that configure the governance service for this type of request.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("executorEngineGUID", "Unique identifier of the governance engine nominated to run the request.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("executorEngineName", "Unique identifier of the governance engine nominated to run the request.", attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute5Name, attribute5Description, attribute5DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute6Name, attribute6Description, attribute6DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute7Name, attribute7Description, attribute7DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute8Name, attribute8Description, attribute8DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute9Name, attribute9Description, attribute9DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }
}

