/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.opentypes;

import java.util.ArrayList;
import java.util.Date;
import org.odpi.openmetadata.frameworks.openmetadata.enums.MediaUsage;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchive3_8;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttributeStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;

public class OpenMetadataTypesArchive3_9 {
    private static final String archiveGUID = "bce3b0a0-662a-4f87-b8dc-844078a11a6e";
    private static final String archiveName = "Open Metadata Types";
    private static final String archiveDescription = "Standard types for open metadata repositories.";
    private static final OpenMetadataArchiveType archiveType = OpenMetadataArchiveType.CONTENT_PACK;
    private static final String archiveVersion = "3.9";
    private static final String originatorName = "Egeria";
    private static final String originatorLicense = "Apache-2.0";
    private static final Date creationDate = new Date(1588261366992L);
    private static final long versionNumber = 1L;
    private static final String versionName = "1.0";
    private final OMRSArchiveBuilder archiveBuilder;
    private final OMRSArchiveHelper archiveHelper;

    public OpenMetadataTypesArchive3_9() {
        this.archiveBuilder = new OMRSArchiveBuilder(archiveGUID, archiveName, archiveDescription, archiveType, archiveVersion, originatorName, originatorLicense, creationDate, null);
        this.archiveHelper = new OMRSArchiveHelper(this.archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public OpenMetadataTypesArchive3_9(OMRSArchiveBuilder archiveBuilder) {
        this.archiveBuilder = archiveBuilder;
        this.archiveHelper = new OMRSArchiveHelper(archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public String getArchiveGUID() {
        return archiveGUID;
    }

    public OpenMetadataArchive getOpenMetadataArchive() {
        String methodName = "getOpenMetadataArchive";
        if (this.archiveBuilder != null) {
            this.getOriginalTypes();
            return this.archiveBuilder.getOpenMetadataArchive();
        }
        throw new OMRSLogicErrorException(OMRSErrorCode.ARCHIVE_UNAVAILABLE.getMessageDefinition(), this.getClass().getName(), "getOpenMetadataArchive");
    }

    public void getOriginalTypes() {
        OpenMetadataTypesArchive3_8 previousTypes = new OpenMetadataTypesArchive3_8(this.archiveBuilder);
        previousTypes.getOriginalTypes();
        this.update0015LinkedMediaTypes();
    }

    private void update0015LinkedMediaTypes() {
        this.archiveBuilder.addTypeDefPatch(this.updateExternalReferenceLinkRelationship());
        this.archiveBuilder.addTypeDefPatch(this.updateMediaReferenceRelationship());
        this.archiveBuilder.addTypeDefPatch(this.updateRelatedMediaEntity());
        this.archiveBuilder.addTypeDefPatch(this.updateExternalReferenceEntity());
    }

    private TypeDefPatch updateExternalReferenceLinkRelationship() {
        String typeName = OpenMetadataType.EXTERNAL_REFERENCE_LINK_RELATIONSHIP.typeName;
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.PAGES.name, OpenMetadataProperty.PAGES.description, OpenMetadataProperty.PAGES.descriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateMediaReferenceRelationship() {
        String typeName = OpenMetadataType.MEDIA_REFERENCE_RELATIONSHIP.typeName;
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        TypeDefAttribute property = this.archiveHelper.getEnumTypeDefAttribute(MediaUsage.getOpenTypeName(), OpenMetadataProperty.MEDIA_USAGE.name, OpenMetadataProperty.MEDIA_USAGE.description, OpenMetadataProperty.MEDIA_USAGE.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.MEDIA_USAGE_OTHER_ID.name, OpenMetadataProperty.MEDIA_USAGE_OTHER_ID.description, OpenMetadataProperty.MEDIA_USAGE_OTHER_ID.descriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateRelatedMediaEntity() {
        String typeName = OpenMetadataType.RELATED_MEDIA.typeName;
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        TypeDefAttribute property = this.archiveHelper.getEnumTypeDefAttribute(MediaUsage.getOpenTypeName(), OpenMetadataProperty.DEFAULT_MEDIA_USAGE.name, OpenMetadataProperty.DEFAULT_MEDIA_USAGE.description, OpenMetadataProperty.DEFAULT_MEDIA_USAGE.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.DEFAULT_MEDIA_USAGE_OTHER_ID.name, OpenMetadataProperty.DEFAULT_MEDIA_USAGE_OTHER_ID.description, OpenMetadataProperty.DEFAULT_MEDIA_USAGE_OTHER_ID.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getArrayIntTypeDefAttribute("mediaUsages", "Types of recommended media usage.", null);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        property.setReplacedByAttribute(OpenMetadataProperty.DEFAULT_MEDIA_USAGE.name);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.MEDIA_TYPE_OTHER_ID.name, OpenMetadataProperty.MEDIA_TYPE_OTHER_ID.description, OpenMetadataProperty.MEDIA_TYPE_OTHER_ID.descriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateExternalReferenceEntity() {
        String typeName = OpenMetadataType.EXTERNAL_REFERENCE.typeName;
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.DISPLAY_NAME.name, OpenMetadataProperty.DISPLAY_NAME.description, OpenMetadataProperty.DISPLAY_NAME.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.REFERENCE_TITLE.name, OpenMetadataProperty.REFERENCE_TITLE.description, OpenMetadataProperty.REFERENCE_TITLE.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.REFERENCE_ABSTRACT.name, OpenMetadataProperty.REFERENCE_ABSTRACT.description, OpenMetadataProperty.REFERENCE_ABSTRACT.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.DESCRIPTION.name, OpenMetadataProperty.DESCRIPTION.description, OpenMetadataProperty.DESCRIPTION.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getArrayStringTypeDefAttribute(OpenMetadataProperty.AUTHORS.name, OpenMetadataProperty.AUTHORS.description, OpenMetadataProperty.AUTHORS.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getIntTypeDefAttribute(OpenMetadataProperty.NUMBER_OF_PAGES.name, OpenMetadataProperty.NUMBER_OF_PAGES.description, OpenMetadataProperty.NUMBER_OF_PAGES.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.PAGE_RANGE.name, OpenMetadataProperty.PAGE_RANGE.description, OpenMetadataProperty.PAGE_RANGE.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.SOURCE_ORGANIZATION.name, OpenMetadataProperty.SOURCE_ORGANIZATION.description, OpenMetadataProperty.SOURCE_ORGANIZATION.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.PUBLICATION_SERIES.name, OpenMetadataProperty.PUBLICATION_SERIES.description, OpenMetadataProperty.PUBLICATION_SERIES.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.PUBLICATION_SERIES_VOLUME.name, OpenMetadataProperty.PUBLICATION_SERIES_VOLUME.description, OpenMetadataProperty.PUBLICATION_SERIES_VOLUME.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.EDITION.name, OpenMetadataProperty.EDITION.description, OpenMetadataProperty.EDITION.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.REFERENCE_VERSION.name, OpenMetadataProperty.REFERENCE_VERSION.description, OpenMetadataProperty.REFERENCE_VERSION.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.URL.name, OpenMetadataProperty.URL.description, OpenMetadataProperty.URL.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.PUBLISHER.name, OpenMetadataProperty.PUBLISHER.description, OpenMetadataProperty.PUBLISHER.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getDateTypeDefAttribute(OpenMetadataProperty.FIRST_PUB_DATE.name, OpenMetadataProperty.FIRST_PUB_DATE.description, OpenMetadataProperty.FIRST_PUB_DATE.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getDateTypeDefAttribute(OpenMetadataProperty.PUBLICATION_DATE.name, OpenMetadataProperty.PUBLICATION_DATE.description, OpenMetadataProperty.PUBLICATION_DATE.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.PUBLICATION_CITY.name, OpenMetadataProperty.PUBLICATION_CITY.description, OpenMetadataProperty.PUBLICATION_CITY.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.PUBLICATION_YEAR.name, OpenMetadataProperty.PUBLICATION_YEAR.description, OpenMetadataProperty.PUBLICATION_YEAR.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getArrayStringTypeDefAttribute(OpenMetadataProperty.PUBLICATION_NUMBERS.name, OpenMetadataProperty.PUBLICATION_NUMBERS.description, OpenMetadataProperty.PUBLICATION_NUMBERS.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.LICENSE.name, OpenMetadataProperty.LICENSE.description, OpenMetadataProperty.LICENSE.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.COPYRIGHT.name, OpenMetadataProperty.COPYRIGHT.description, OpenMetadataProperty.COPYRIGHT.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.ATTRIBUTION.name, OpenMetadataProperty.ATTRIBUTION.description, OpenMetadataProperty.ATTRIBUTION.descriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }
}

