/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.opentypes;

import java.util.ArrayList;
import java.util.Date;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchive4_2;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;

public class OpenMetadataTypesArchive4_3 {
    private static final String archiveGUID = "bce3b0a0-662a-4f87-b8dc-844078a11a6e";
    private static final String archiveName = "Open Metadata Types";
    private static final String archiveDescription = "Standard types for open metadata repositories.";
    private static final OpenMetadataArchiveType archiveType = OpenMetadataArchiveType.CONTENT_PACK;
    private static final String archiveVersion = "4.3";
    private static final String originatorName = "Egeria";
    private static final String originatorLicense = "Apache-2.0";
    private static final Date creationDate = new Date(1588261366992L);
    private static final long versionNumber = 1L;
    private static final String versionName = "1.0";
    private final OMRSArchiveBuilder archiveBuilder;
    private final OMRSArchiveHelper archiveHelper;

    public OpenMetadataTypesArchive4_3() {
        this.archiveBuilder = new OMRSArchiveBuilder(archiveGUID, archiveName, archiveDescription, archiveType, archiveVersion, originatorName, originatorLicense, creationDate, null);
        this.archiveHelper = new OMRSArchiveHelper(this.archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public OpenMetadataTypesArchive4_3(OMRSArchiveBuilder archiveBuilder) {
        this.archiveBuilder = archiveBuilder;
        this.archiveHelper = new OMRSArchiveHelper(archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public String getArchiveGUID() {
        return archiveGUID;
    }

    public OpenMetadataArchive getOpenMetadataArchive() {
        String methodName = "getOpenMetadataArchive";
        if (this.archiveBuilder != null) {
            this.getOriginalTypes();
            return this.archiveBuilder.getOpenMetadataArchive();
        }
        throw new OMRSLogicErrorException(OMRSErrorCode.ARCHIVE_UNAVAILABLE.getMessageDefinition(), this.getClass().getName(), "getOpenMetadataArchive");
    }

    public void getOriginalTypes() {
        OpenMetadataTypesArchive4_2 previousTypes = new OpenMetadataTypesArchive4_2(this.archiveBuilder);
        previousTypes.getOriginalTypes();
        this.update0010Base();
        this.update0017ExternalIdentifiers();
        this.update0035Hosts();
        this.update0112People();
        this.update0210DataStores();
        this.update0212APIs();
        this.update0224Databases();
        this.update0215SoftwareComponents();
        this.update0223Events();
    }

    private void update0010Base() {
        this.archiveBuilder.addTypeDefPatch(this.updateDataSet());
        this.archiveBuilder.addTypeDefPatch(this.updateInfrastructure());
    }

    private TypeDefPatch updateDataSet() {
        String typeName = OpenMetadataType.DATA_SET.typeName;
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name;
        String attribute1Description = OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateInfrastructure() {
        String typeName = OpenMetadataType.INFRASTRUCTURE.typeName;
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name;
        String attribute1Description = OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update0017ExternalIdentifiers() {
        this.archiveBuilder.addTypeDefPatch(this.updateExternalId());
    }

    private TypeDefPatch updateExternalId() {
        String typeName = OpenMetadataType.EXTERNAL_ID.typeName;
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.EXT_INSTANCE_CREATED_BY.name;
        String attribute1Description = OpenMetadataProperty.EXT_INSTANCE_CREATED_BY.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.EXT_INSTANCE_CREATED_BY.descriptionGUID;
        String attribute2Name = OpenMetadataProperty.EXT_INSTANCE_CREATION_TIME.name;
        String attribute2Description = OpenMetadataProperty.EXT_INSTANCE_CREATION_TIME.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.EXT_INSTANCE_CREATION_TIME.descriptionGUID;
        String attribute3Name = OpenMetadataProperty.EXT_INSTANCE_LAST_UPDATED_BY.name;
        String attribute3Description = OpenMetadataProperty.EXT_INSTANCE_LAST_UPDATED_BY.description;
        String attribute3DescriptionGUID = OpenMetadataProperty.EXT_INSTANCE_LAST_UPDATED_BY.descriptionGUID;
        String attribute4Name = OpenMetadataProperty.EXT_INSTANCE_LAST_UPDATE_TIME.name;
        String attribute4Description = OpenMetadataProperty.EXT_INSTANCE_LAST_UPDATE_TIME.description;
        String attribute4DescriptionGUID = OpenMetadataProperty.EXT_INSTANCE_LAST_UPDATE_TIME.descriptionGUID;
        String attribute5Name = OpenMetadataProperty.EXT_INSTANCE_VERSION.name;
        String attribute5Description = OpenMetadataProperty.EXT_INSTANCE_VERSION.description;
        String attribute5DescriptionGUID = OpenMetadataProperty.EXT_INSTANCE_VERSION.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getDateTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute3Name, attribute3Description, attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getDateTypeDefAttribute(attribute4Name, attribute4Description, attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getLongTypeDefAttribute(attribute5Name, attribute5Description, attribute5DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update0035Hosts() {
        this.archiveBuilder.addTypeDefPatch(this.updateHostClusterMemberRelationship());
    }

    private TypeDefPatch updateHostClusterMemberRelationship() {
        String typeName = "HostClusterMember";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("HostClusterMember");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "memberRole";
        String attribute1Description = "The role of the member in the host cluster.  This value is typically defined by the technology of the host cluster.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("memberRole", "The role of the member in the host cluster.  This value is typically defined by the technology of the host cluster.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringStringTypeDefAttribute(OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, OpenMetadataProperty.ADDITIONAL_PROPERTIES.description, OpenMetadataProperty.ADDITIONAL_PROPERTIES.descriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update0112People() {
        this.archiveBuilder.addTypeDefPatch(this.updatePerson());
    }

    private TypeDefPatch updatePerson() {
        String typeName = "Person";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("Person");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "residentCountry";
        String attribute1Description = "Country that is the person's primary residence.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "timeZone";
        String attribute2Description = "Principle time zone where this person is located.";
        String attribute2DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("residentCountry", "Country that is the person's primary residence.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("timeZone", "Principle time zone where this person is located.", attribute2DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update0210DataStores() {
        this.archiveBuilder.addTypeDefPatch(this.updateDataStore());
    }

    private TypeDefPatch updateDataStore() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.DATA_STORE.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.description, OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.descriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update0212APIs() {
        this.archiveBuilder.addTypeDefPatch(this.updateDeployedAPI());
    }

    private TypeDefPatch updateDeployedAPI() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.DEPLOYED_API.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.description, OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.descriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update0215SoftwareComponents() {
        this.archiveBuilder.addTypeDefPatch(this.updateDeployedSoftwareComponent());
    }

    private TypeDefPatch updateDeployedSoftwareComponent() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.DEPLOYED_SOFTWARE_COMPONENT.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.description, OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.descriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update0223Events() {
        this.archiveBuilder.addTypeDefPatch(this.updateDataFeed());
    }

    private TypeDefPatch updateDataFeed() {
        String typeName = "DataFeed";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("DataFeed");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.description, OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.descriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update0224Databases() {
        this.archiveBuilder.addEntityDef(this.addRelationalDatabaseEntity());
    }

    private EntityDef addRelationalDatabaseEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.RELATIONAL_DATABASE.typeGUID, OpenMetadataType.RELATIONAL_DATABASE.typeName, this.archiveBuilder.getEntityDef(OpenMetadataType.DATABASE.typeName), OpenMetadataType.RELATIONAL_DATABASE.description, OpenMetadataType.RELATIONAL_DATABASE.descriptionGUID, OpenMetadataType.RELATIONAL_DATABASE.wikiURL);
    }
}

