/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.opentypes;

import java.util.ArrayList;
import java.util.Date;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchive4_3;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationPropagationRule;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndCardinality;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttributeStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefStatus;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;

public class OpenMetadataTypesArchive5_0 {
    private static final String archiveGUID = "bce3b0a0-662a-4f87-b8dc-844078a11a6e";
    private static final String archiveName = "Open Metadata Types";
    private static final String archiveDescription = "Standard types for open metadata repositories.";
    private static final OpenMetadataArchiveType archiveType = OpenMetadataArchiveType.CONTENT_PACK;
    private static final String archiveVersion = "5.0";
    private static final String originatorName = "Egeria";
    private static final String originatorLicense = "Apache-2.0";
    private static final Date creationDate = new Date(1588261366992L);
    private static final long versionNumber = 1L;
    private static final String versionName = "1.0";
    private final OMRSArchiveBuilder archiveBuilder;
    private final OMRSArchiveHelper archiveHelper;

    public OpenMetadataTypesArchive5_0() {
        this.archiveBuilder = new OMRSArchiveBuilder(archiveGUID, archiveName, archiveDescription, archiveType, archiveVersion, originatorName, originatorLicense, creationDate, null);
        this.archiveHelper = new OMRSArchiveHelper(this.archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public OpenMetadataTypesArchive5_0(OMRSArchiveBuilder archiveBuilder) {
        this.archiveBuilder = archiveBuilder;
        this.archiveHelper = new OMRSArchiveHelper(archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public String getArchiveGUID() {
        return archiveGUID;
    }

    public OpenMetadataArchive getOpenMetadataArchive() {
        String methodName = "getOpenMetadataArchive";
        if (this.archiveBuilder != null) {
            this.getOriginalTypes();
            return this.archiveBuilder.getOpenMetadataArchive();
        }
        throw new OMRSLogicErrorException(OMRSErrorCode.ARCHIVE_UNAVAILABLE.getMessageDefinition(), this.getClass().getName(), "getOpenMetadataArchive");
    }

    public void getOriginalTypes() {
        OpenMetadataTypesArchive4_3 previousTypes = new OpenMetadataTypesArchive4_3(this.archiveBuilder);
        previousTypes.getOriginalTypes();
        this.update0010BaseModel();
        this.update0011UpdateTemplates();
        this.update0021Collections();
        this.update0050ApplicationsAndProcesses();
        this.update0137Actions();
        this.update0130Projects();
        this.update0201Connections();
        this.update0210DataStores();
        this.update0220DataFiles();
        this.update0221MediaFiles();
        this.add0226ArchiveFiles();
        this.update0280SoftwareArtifacts();
        this.update0380TermInheritance();
        this.update0461GovernanceEngines();
        this.update0464IntegrationGroups();
        this.update0545ReferenceData();
        this.update0462GovernanceActionTypes();
        this.add00475ContextEvents();
        this.add0603SurveyReports();
        this.update0615SchemaExtraction();
        this.update0690RequestForAction();
        this.add0755UltimateSourcesDestinations();
    }

    private void update0010BaseModel() {
        this.archiveBuilder.addTypeDefPatch(this.updateAnchors());
    }

    private TypeDefPatch updateAnchors() {
        String typeName = OpenMetadataType.ANCHORS_CLASSIFICATION.typeName;
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.ANCHOR_TYPE_NAME.name;
        String attribute1Description = OpenMetadataProperty.ANCHOR_TYPE_NAME.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.ANCHOR_TYPE_NAME.descriptionGUID;
        String attribute2Name = OpenMetadataProperty.ANCHOR_DOMAIN_NAME.name;
        String attribute2Description = OpenMetadataProperty.ANCHOR_DOMAIN_NAME.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.ANCHOR_DOMAIN_NAME.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update0021Collections() {
        this.archiveBuilder.addTypeDefPatch(this.updateCollection());
        this.archiveBuilder.addClassificationDef(this.getRootCollectionClassification());
        this.archiveBuilder.addClassificationDef(this.getDataSpecClassification());
        this.archiveBuilder.addClassificationDef(this.getHomeCollectionClassification());
        this.archiveBuilder.addClassificationDef(this.getRecentAccessClassification());
        this.archiveBuilder.addClassificationDef(this.getWorkItemListClassification());
    }

    private TypeDefPatch updateCollection() {
        String typeName = OpenMetadataType.COLLECTION.typeName;
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.COLLECTION_TYPE.name;
        String attribute1Description = OpenMetadataProperty.COLLECTION_TYPE.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.COLLECTION_TYPE.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private ClassificationDef getRootCollectionClassification() {
        String guid = OpenMetadataType.ROOT_COLLECTION.typeGUID;
        String name = OpenMetadataType.ROOT_COLLECTION.typeName;
        String description = OpenMetadataType.ROOT_COLLECTION.description;
        String descriptionGUID = OpenMetadataType.ROOT_COLLECTION.descriptionGUID;
        String descriptionWiki = OpenMetadataType.ROOT_COLLECTION.wikiURL;
        String linkedToEntity = OpenMetadataType.COLLECTION.typeName;
        return this.archiveHelper.getClassificationDef(guid, name, null, description, descriptionGUID, descriptionWiki, this.archiveBuilder.getEntityDef(linkedToEntity), false);
    }

    private ClassificationDef getDataSpecClassification() {
        String guid = OpenMetadataType.DATA_SPEC_COLLECTION.typeGUID;
        String name = OpenMetadataType.DATA_SPEC_COLLECTION.typeName;
        String description = OpenMetadataType.DATA_SPEC_COLLECTION.description;
        String descriptionGUID = OpenMetadataType.DATA_SPEC_COLLECTION.descriptionGUID;
        String descriptionWiki = OpenMetadataType.DATA_SPEC_COLLECTION.wikiURL;
        String linkedToEntity = OpenMetadataType.COLLECTION.typeName;
        return this.archiveHelper.getClassificationDef(guid, name, null, description, descriptionGUID, descriptionWiki, this.archiveBuilder.getEntityDef(linkedToEntity), false);
    }

    private ClassificationDef getHomeCollectionClassification() {
        String guid = OpenMetadataType.HOME_COLLECTION.typeGUID;
        String name = OpenMetadataType.HOME_COLLECTION.typeName;
        String description = OpenMetadataType.HOME_COLLECTION.description;
        String descriptionGUID = OpenMetadataType.HOME_COLLECTION.descriptionGUID;
        String descriptionWiki = OpenMetadataType.HOME_COLLECTION.wikiURL;
        String linkedToEntity = OpenMetadataType.COLLECTION.typeName;
        return this.archiveHelper.getClassificationDef(guid, name, null, description, descriptionGUID, descriptionWiki, this.archiveBuilder.getEntityDef(linkedToEntity), false);
    }

    private ClassificationDef getRecentAccessClassification() {
        String guid = OpenMetadataType.RECENT_ACCESS.typeGUID;
        String name = OpenMetadataType.RECENT_ACCESS.typeName;
        String description = OpenMetadataType.RECENT_ACCESS.description;
        String descriptionGUID = OpenMetadataType.RECENT_ACCESS.descriptionGUID;
        String descriptionWiki = OpenMetadataType.RECENT_ACCESS.wikiURL;
        String linkedToEntity = OpenMetadataType.COLLECTION.typeName;
        return this.archiveHelper.getClassificationDef(guid, name, null, description, descriptionGUID, descriptionWiki, this.archiveBuilder.getEntityDef(linkedToEntity), false);
    }

    private ClassificationDef getWorkItemListClassification() {
        String guid = OpenMetadataType.WORK_ITEM_LIST.typeGUID;
        String name = OpenMetadataType.WORK_ITEM_LIST.typeName;
        String description = OpenMetadataType.WORK_ITEM_LIST.description;
        String descriptionGUID = OpenMetadataType.WORK_ITEM_LIST.descriptionGUID;
        String descriptionWiki = OpenMetadataType.WORK_ITEM_LIST.wikiURL;
        String linkedToEntity = OpenMetadataType.COLLECTION.typeName;
        return this.archiveHelper.getClassificationDef(guid, name, null, description, descriptionGUID, descriptionWiki, this.archiveBuilder.getEntityDef(linkedToEntity), false);
    }

    private void update0050ApplicationsAndProcesses() {
        this.archiveBuilder.addEntityDef(this.addEventManagerEntity());
        this.archiveBuilder.addEntityDef(this.addAuthorizationManagerEntity());
        this.archiveBuilder.addEntityDef(this.addUserAuthenticationManagerEntity());
    }

    private EntityDef addEventManagerEntity() {
        String guid = OpenMetadataType.EVENT_MANAGER.typeGUID;
        String name = OpenMetadataType.EVENT_MANAGER.typeName;
        String description = OpenMetadataType.EVENT_MANAGER.description;
        String descriptionGUID = OpenMetadataType.EVENT_MANAGER.descriptionGUID;
        String descriptionWiki = OpenMetadataType.EVENT_MANAGER.wikiURL;
        String superTypeName = OpenMetadataType.SOFTWARE_SERVER_CAPABILITY.typeName;
        return this.archiveHelper.getDefaultEntityDef(guid, name, this.archiveBuilder.getEntityDef(superTypeName), description, descriptionGUID, descriptionWiki);
    }

    private EntityDef addAuthorizationManagerEntity() {
        String guid = OpenMetadataType.AUTHORIZATION_MANAGER.typeGUID;
        String name = OpenMetadataType.AUTHORIZATION_MANAGER.typeName;
        String description = OpenMetadataType.AUTHORIZATION_MANAGER.description;
        String descriptionGUID = OpenMetadataType.AUTHORIZATION_MANAGER.descriptionGUID;
        String descriptionWiki = OpenMetadataType.AUTHORIZATION_MANAGER.wikiURL;
        String superTypeName = OpenMetadataType.SOFTWARE_SERVER_CAPABILITY.typeName;
        return this.archiveHelper.getDefaultEntityDef(guid, name, this.archiveBuilder.getEntityDef(superTypeName), description, descriptionGUID, descriptionWiki);
    }

    private EntityDef addUserAuthenticationManagerEntity() {
        String guid = OpenMetadataType.USER_AUTHENTICATION_MANAGER.typeGUID;
        String name = OpenMetadataType.USER_AUTHENTICATION_MANAGER.typeName;
        String description = OpenMetadataType.USER_AUTHENTICATION_MANAGER.description;
        String descriptionGUID = OpenMetadataType.USER_AUTHENTICATION_MANAGER.descriptionGUID;
        String descriptionWiki = OpenMetadataType.USER_AUTHENTICATION_MANAGER.wikiURL;
        String superTypeName = OpenMetadataType.SOFTWARE_SERVER_CAPABILITY.typeName;
        return this.archiveHelper.getDefaultEntityDef(guid, name, this.archiveBuilder.getEntityDef(superTypeName), description, descriptionGUID, descriptionWiki);
    }

    private void update0137Actions() {
        this.archiveBuilder.addEntityDef(this.addActionEntity());
        this.archiveBuilder.addTypeDefPatch(this.updateToDoEntity());
        this.archiveBuilder.addTypeDefPatch(this.updateEngineActionEntity());
        this.archiveBuilder.addTypeDefPatch(this.updateActionsRelationship());
    }

    private EntityDef addActionEntity() {
        String guid = OpenMetadataType.ACTION.typeGUID;
        String name = OpenMetadataType.ACTION.typeName;
        String description = OpenMetadataType.ACTION.description;
        String descriptionGUID = OpenMetadataType.ACTION.descriptionGUID;
        String descriptionWiki = OpenMetadataType.ACTION.wikiURL;
        String superTypeName = OpenMetadataType.REFERENCEABLE.typeName;
        return this.archiveHelper.getDefaultEntityDef(guid, name, this.archiveBuilder.getEntityDef(superTypeName), description, descriptionGUID, descriptionWiki);
    }

    private TypeDefPatch updateToDoEntity() {
        String typeName = OpenMetadataType.TO_DO.typeName;
        String superTypeName = OpenMetadataType.ACTION.typeName;
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setSuperType(this.archiveBuilder.getEntityDef(superTypeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.LAST_REVIEW_TIME.name, OpenMetadataProperty.LAST_REVIEW_TIME.description, OpenMetadataProperty.LAST_REVIEW_TIME.descriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateEngineActionEntity() {
        String typeName = OpenMetadataType.ENGINE_ACTION.typeName;
        String superTypeName = OpenMetadataType.ACTION.typeName;
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setSuperType(this.archiveBuilder.getEntityDef(superTypeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.REQUESTER_USER_ID.name;
        String attribute1Description = OpenMetadataProperty.REQUESTER_USER_ID.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.REQUESTER_USER_ID.descriptionGUID;
        String attribute2Name = "requestedStartDate";
        String attribute2Description = "Time that the ending action should start.  This is the request time plus any requested wait time.";
        String attribute2DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getDateTypeDefAttribute("requestedStartDate", "Time that the ending action should start.  This is the request time plus any requested wait time.", attribute2DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateActionsRelationship() {
        String typeName = OpenMetadataType.ACTION_SPONSOR_RELATIONSHIP.typeName;
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        String end1EntityType = OpenMetadataType.REFERENCEABLE.typeName;
        String end1AttributeName = "actionCause";
        String end1AttributeDescription = "Rule or meeting that is driving the need for the to do.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "actionCause", "Rule or meeting that is driving the need for the to do.", end1AttributeDescriptionGUID, end1Cardinality);
        typeDefPatch.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.ACTION.typeName;
        String end2AttributeName = "relatedActions";
        String end2AttributeDescription = "Potentially impacting requests for change.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "relatedActions", "Potentially impacting requests for change.", end2AttributeDescriptionGUID, end2Cardinality);
        typeDefPatch.setEndDef2(relationshipEndDef);
        return typeDefPatch;
    }

    private void update0130Projects() {
        this.archiveBuilder.addTypeDefPatch(this.updateProject());
        this.archiveBuilder.addClassificationDef(this.getPersonalProjectClassification());
        this.archiveBuilder.addClassificationDef(this.getStudyProjectClassification());
    }

    private TypeDefPatch updateProject() {
        String typeName = OpenMetadataType.PROJECT.typeName;
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.PROJECT_HEALTH.name;
        String attribute1Description = OpenMetadataProperty.PROJECT_HEALTH.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.PROJECT_HEALTH.descriptionGUID;
        String attribute2Name = OpenMetadataProperty.PRIORITY.name;
        String attribute2Description = OpenMetadataProperty.PRIORITY.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.PRIORITY.descriptionGUID;
        String attribute3Name = OpenMetadataProperty.PROJECT_PHASE.name;
        String attribute3Description = OpenMetadataProperty.PROJECT_PHASE.description;
        String attribute3DescriptionGUID = OpenMetadataProperty.PROJECT_PHASE.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getIntTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute3Name, attribute3Description, attribute3DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private ClassificationDef getPersonalProjectClassification() {
        String guid = OpenMetadataType.PERSONAL_PROJECT_CLASSIFICATION.typeGUID;
        String name = OpenMetadataType.PERSONAL_PROJECT_CLASSIFICATION.typeName;
        String description = OpenMetadataType.PERSONAL_PROJECT_CLASSIFICATION.description;
        String descriptionGUID = OpenMetadataType.PERSONAL_PROJECT_CLASSIFICATION.descriptionGUID;
        String linkedToEntity = OpenMetadataType.PROJECT.typeName;
        return this.archiveHelper.getClassificationDef(guid, name, null, description, descriptionGUID, this.archiveBuilder.getEntityDef(linkedToEntity), false);
    }

    private ClassificationDef getStudyProjectClassification() {
        String guid = OpenMetadataType.STUDY_PROJECT_CLASSIFICATION.typeGUID;
        String name = OpenMetadataType.STUDY_PROJECT_CLASSIFICATION.typeName;
        String description = OpenMetadataType.STUDY_PROJECT_CLASSIFICATION.description;
        String descriptionGUID = OpenMetadataType.STUDY_PROJECT_CLASSIFICATION.descriptionGUID;
        String descriptionWiki = OpenMetadataType.STUDY_PROJECT_CLASSIFICATION.wikiURL;
        String linkedToEntity = OpenMetadataType.PROJECT.typeName;
        return this.archiveHelper.getClassificationDef(guid, name, null, description, descriptionGUID, descriptionWiki, this.archiveBuilder.getEntityDef(linkedToEntity), false);
    }

    private void update0011UpdateTemplates() {
        this.archiveBuilder.addRelationshipDef(this.addCatalogTemplateRelationship());
        this.archiveBuilder.addTypeDefPatch(this.updateTemplateClassification());
    }

    private RelationshipDef addCatalogTemplateRelationship() {
        String guid = OpenMetadataType.CATALOG_TEMPLATE_RELATIONSHIP.typeGUID;
        String name = OpenMetadataType.CATALOG_TEMPLATE_RELATIONSHIP.typeName;
        String description = OpenMetadataType.CATALOG_TEMPLATE_RELATIONSHIP.description;
        String descriptionGUID = OpenMetadataType.CATALOG_TEMPLATE_RELATIONSHIP.descriptionGUID;
        String descriptionWiki = OpenMetadataType.CATALOG_TEMPLATE_RELATIONSHIP.wikiURL;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(guid, name, null, description, descriptionGUID, descriptionWiki, classificationPropagationRule);
        String end1EntityType = OpenMetadataType.OPEN_METADATA_ROOT.typeName;
        String end1AttributeName = "implementationTypes";
        String end1AttributeDescription = "Description of a type of technology.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "implementationTypes", "Description of a type of technology.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.OPEN_METADATA_ROOT.typeName;
        String end2AttributeName = "templatesForCataloguing";
        String end2AttributeDescription = "Template element for a new catalog entry.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "templatesForCataloguing", "Template element for a new catalog entry.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private TypeDefPatch updateTemplateClassification() {
        String typeName = OpenMetadataType.TEMPLATE_CLASSIFICATION.typeName;
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.VERSION_IDENTIFIER.name;
        String attribute1Description = OpenMetadataProperty.VERSION_IDENTIFIER.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.VERSION_IDENTIFIER.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update0201Connections() {
        this.archiveBuilder.addTypeDefPatch(this.updateConnectorType());
    }

    private TypeDefPatch updateConnectorType() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.CONNECTOR_TYPE.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update0210DataStores() {
        this.archiveBuilder.addClassificationDef(this.getDataScopeClassification());
    }

    private ClassificationDef getDataScopeClassification() {
        String guid = "22f996d0-c4b7-433a-af0b-6a3e9478e488";
        String name = "DataScope";
        String description = "Defines the scope of the data held in the associated data resource.";
        String descriptionGUID = null;
        String linkedToEntity = OpenMetadataType.REFERENCEABLE.typeName;
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef("22f996d0-c4b7-433a-af0b-6a3e9478e488", "DataScope", null, "Defines the scope of the data held in the associated data resource.", descriptionGUID, this.archiveBuilder.getEntityDef(linkedToEntity), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "minLongitude";
        String attribute1Description = "If the data is bound by an area, this is the longitude for bottom-left corner of the bounding box (BBOX) for the area covered by the data.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "minLatitude";
        String attribute2Description = "If the data is bound by an area, this is the latitude for the bottom-left corner of the bounding box (BBOX) for the area covered by the data.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "maxLongitude";
        String attribute3Description = "If the data is bound by an area, this is the longitude for top-right corner of the bounding box (BBOX) for the area covered by the data..";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "maxLatitude";
        String attribute4Description = "If the data is bound by an area, this is the latitude for top-right corner of the bounding box (BBOX) for the area covered by the data.";
        String attribute4DescriptionGUID = null;
        String attribute5Name = "minHeight";
        String attribute5Description = "If the height above ground is relevant, this is the lowest height that the data covers.";
        String attribute5DescriptionGUID = null;
        String attribute6Name = "maxHeight";
        String attribute6Description = "If the height above ground is relevant, this is the highest height that the data covers.";
        String attribute6DescriptionGUID = null;
        String attribute7Name = OpenMetadataProperty.START_TIME.name;
        String attribute7Description = "If the data is bound by time, this is the start time.";
        String attribute7DescriptionGUID = null;
        String attribute8Name = OpenMetadataProperty.END_TIME.name;
        String attribute8Description = "If the data is bound by time, this is the end time.";
        String attribute8DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getFloatTypeDefAttribute("minLongitude", "If the data is bound by an area, this is the longitude for bottom-left corner of the bounding box (BBOX) for the area covered by the data.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getFloatTypeDefAttribute("minLatitude", "If the data is bound by an area, this is the latitude for the bottom-left corner of the bounding box (BBOX) for the area covered by the data.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getFloatTypeDefAttribute("maxLongitude", "If the data is bound by an area, this is the longitude for top-right corner of the bounding box (BBOX) for the area covered by the data..", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getFloatTypeDefAttribute("maxLatitude", "If the data is bound by an area, this is the latitude for top-right corner of the bounding box (BBOX) for the area covered by the data.", attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getFloatTypeDefAttribute("minHeight", "If the height above ground is relevant, this is the lowest height that the data covers.", attribute5DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getFloatTypeDefAttribute("maxHeight", "If the height above ground is relevant, this is the highest height that the data covers.", attribute6DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getDateTypeDefAttribute(attribute7Name, "If the data is bound by time, this is the start time.", attribute7DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getDateTypeDefAttribute(attribute8Name, "If the data is bound by time, this is the end time.", attribute8DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringStringTypeDefAttribute(OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, OpenMetadataProperty.ADDITIONAL_PROPERTIES.description, OpenMetadataProperty.ADDITIONAL_PROPERTIES.descriptionGUID);
        properties.add(property);
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private void update0220DataFiles() {
        this.archiveBuilder.addTypeDefPatch(this.updateDataFile());
        this.archiveBuilder.addEntityDef(this.addXMLFileEntity());
        this.archiveBuilder.addEntityDef(this.addSpreadsheetFileEntity());
    }

    private TypeDefPatch updateDataFile() {
        String typeName = OpenMetadataType.DATA_FILE.typeName;
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.FILE_EXTENSION.name;
        String attribute1Description = OpenMetadataProperty.FILE_EXTENSION.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.FILE_EXTENSION.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private EntityDef addSpreadsheetFileEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.SPREADSHEET_FILE.typeGUID, OpenMetadataType.SPREADSHEET_FILE.typeName, this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_FILE.typeName), OpenMetadataType.SPREADSHEET_FILE.description, OpenMetadataType.SPREADSHEET_FILE.descriptionGUID, OpenMetadataType.SPREADSHEET_FILE.wikiURL);
    }

    private EntityDef addXMLFileEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.XML_FILE.typeGUID, OpenMetadataType.XML_FILE.typeName, this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_FILE.typeName), OpenMetadataType.XML_FILE.description, OpenMetadataType.XML_FILE.descriptionGUID, OpenMetadataType.XML_FILE.wikiURL);
    }

    private void update0221MediaFiles() {
        this.archiveBuilder.addEntityDef(this.addAudioFileEntity());
        this.archiveBuilder.addEntityDef(this.addVideoFileEntity());
        this.archiveBuilder.addEntityDef(this.add3DImageFileEntity());
        this.archiveBuilder.addEntityDef(this.addRasterFileEntity());
        this.archiveBuilder.addEntityDef(this.addVectorFileEntity());
        this.archiveBuilder.addTypeDefPatch(this.deprecateGroupedMedia());
    }

    private EntityDef addAudioFileEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.AUDIO_FILE.typeGUID, OpenMetadataType.AUDIO_FILE.typeName, this.archiveBuilder.getEntityDef(OpenMetadataType.MEDIA_FILE.typeName), OpenMetadataType.AUDIO_FILE.description, OpenMetadataType.AUDIO_FILE.descriptionGUID, OpenMetadataType.AUDIO_FILE.wikiURL);
    }

    private EntityDef addVideoFileEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.VIDEO_FILE.typeGUID, OpenMetadataType.VIDEO_FILE.typeName, this.archiveBuilder.getEntityDef(OpenMetadataType.MEDIA_FILE.typeName), OpenMetadataType.VIDEO_FILE.description, OpenMetadataType.VIDEO_FILE.descriptionGUID, OpenMetadataType.VIDEO_FILE.wikiURL);
    }

    private EntityDef add3DImageFileEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.THREE_D_IMAGE_FILE.typeGUID, OpenMetadataType.THREE_D_IMAGE_FILE.typeName, this.archiveBuilder.getEntityDef(OpenMetadataType.MEDIA_FILE.typeName), OpenMetadataType.THREE_D_IMAGE_FILE.description, OpenMetadataType.THREE_D_IMAGE_FILE.descriptionGUID, OpenMetadataType.THREE_D_IMAGE_FILE.wikiURL);
    }

    private EntityDef addRasterFileEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.RASTER_FILE.typeGUID, OpenMetadataType.RASTER_FILE.typeName, this.archiveBuilder.getEntityDef(OpenMetadataType.MEDIA_FILE.typeName), OpenMetadataType.RASTER_FILE.description, OpenMetadataType.RASTER_FILE.descriptionGUID, OpenMetadataType.RASTER_FILE.wikiURL);
    }

    private EntityDef addVectorFileEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.VECTOR_FILE.typeGUID, OpenMetadataType.VECTOR_FILE.typeName, this.archiveBuilder.getEntityDef(OpenMetadataType.MEDIA_FILE.typeName), OpenMetadataType.VECTOR_FILE.description, OpenMetadataType.VECTOR_FILE.descriptionGUID, OpenMetadataType.VECTOR_FILE.wikiURL);
    }

    private TypeDefPatch deprecateGroupedMedia() {
        String typeName = "GroupedMedia";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("GroupedMedia");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setTypeDefStatus(TypeDefStatus.DEPRECATED_TYPEDEF);
        return typeDefPatch;
    }

    private void add0226ArchiveFiles() {
        this.archiveBuilder.addEntityDef(this.addArchiveFileEntity());
        this.archiveBuilder.addRelationshipDef(this.addArchiveContentsRelationship());
    }

    private EntityDef addArchiveFileEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.ARCHIVE_FILE.typeGUID, OpenMetadataType.ARCHIVE_FILE.typeName, this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_FILE.typeName), OpenMetadataType.ARCHIVE_FILE.description, OpenMetadataType.ARCHIVE_FILE.descriptionGUID, OpenMetadataType.ARCHIVE_FILE.wikiURL);
    }

    private RelationshipDef addArchiveContentsRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.ARCHIVE_CONTENTS_RELATIONSHIP.typeGUID, OpenMetadataType.ARCHIVE_CONTENTS_RELATIONSHIP.typeName, null, OpenMetadataType.ARCHIVE_CONTENTS_RELATIONSHIP.description, OpenMetadataType.ARCHIVE_CONTENTS_RELATIONSHIP.descriptionGUID, OpenMetadataType.ARCHIVE_CONTENTS_RELATIONSHIP.wikiURL, ClassificationPropagationRule.NONE);
        String end1EntityType = OpenMetadataType.ARCHIVE_FILE.typeName;
        String end1AttributeName = "packagedInArchiveFiles";
        String end1AttributeDescription = "Associated archive file.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "packagedInArchiveFiles", "Associated archive file.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.COLLECTION.typeName;
        String end2AttributeName = "archiveFileContents";
        String end2AttributeDescription = "Collection describing the archive's contents.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "archiveFileContents", "Collection describing the archive's contents.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void update0280SoftwareArtifacts() {
        this.archiveBuilder.addEntityDef(this.addSourceCodeFileEntity());
        this.archiveBuilder.addEntityDef(this.addBuildInstructionFileEntity());
        this.archiveBuilder.addEntityDef(this.addExecutableFileEntity());
        this.archiveBuilder.addEntityDef(this.addScriptFileEntity());
        this.archiveBuilder.addEntityDef(this.addPropertiesFileEntity());
        this.archiveBuilder.addEntityDef(this.addYAMLFileEntity());
    }

    private EntityDef addSourceCodeFileEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.SOURCE_CODE_FILE.typeGUID, OpenMetadataType.SOURCE_CODE_FILE.typeName, this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_FILE.typeName), OpenMetadataType.SOURCE_CODE_FILE.description, OpenMetadataType.SOURCE_CODE_FILE.descriptionGUID, OpenMetadataType.SOURCE_CODE_FILE.wikiURL);
    }

    private EntityDef addBuildInstructionFileEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.BUILD_INSTRUCTION_FILE.typeGUID, OpenMetadataType.BUILD_INSTRUCTION_FILE.typeName, this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_FILE.typeName), OpenMetadataType.BUILD_INSTRUCTION_FILE.description, OpenMetadataType.BUILD_INSTRUCTION_FILE.descriptionGUID, OpenMetadataType.BUILD_INSTRUCTION_FILE.wikiURL);
    }

    private EntityDef addExecutableFileEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.EXECUTABLE_FILE.typeGUID, OpenMetadataType.EXECUTABLE_FILE.typeName, this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_FILE.typeName), OpenMetadataType.EXECUTABLE_FILE.description, OpenMetadataType.EXECUTABLE_FILE.descriptionGUID, OpenMetadataType.EXECUTABLE_FILE.wikiURL);
    }

    private EntityDef addScriptFileEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.SCRIPT_FILE.typeGUID, OpenMetadataType.SCRIPT_FILE.typeName, this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_FILE.typeName), OpenMetadataType.SCRIPT_FILE.description, OpenMetadataType.SCRIPT_FILE.descriptionGUID, OpenMetadataType.SCRIPT_FILE.wikiURL);
    }

    private EntityDef addPropertiesFileEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.PROPERTIES_FILE.typeGUID, OpenMetadataType.PROPERTIES_FILE.typeName, this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_FILE.typeName), OpenMetadataType.PROPERTIES_FILE.description, OpenMetadataType.PROPERTIES_FILE.descriptionGUID, OpenMetadataType.PROPERTIES_FILE.wikiURL);
    }

    private EntityDef addYAMLFileEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.YAML_FILE.typeGUID, OpenMetadataType.YAML_FILE.typeName, this.archiveBuilder.getEntityDef(OpenMetadataType.PROPERTIES_FILE.typeName), OpenMetadataType.YAML_FILE.description, OpenMetadataType.YAML_FILE.descriptionGUID, OpenMetadataType.YAML_FILE.wikiURL);
    }

    private void update0380TermInheritance() {
        this.archiveBuilder.addTypeDefPatch(this.deprecateIsATypeOfRelationship());
        this.archiveBuilder.addRelationshipDef(this.addTermISATYPEOFRelationship());
    }

    private TypeDefPatch deprecateIsATypeOfRelationship() {
        String typeName = "IsATypeOfRelationship";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("IsATypeOfRelationship");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setTypeDefStatus(TypeDefStatus.DEPRECATED_TYPEDEF);
        return typeDefPatch;
    }

    private RelationshipDef addTermISATYPEOFRelationship() {
        String guid = "71f83296-2007-46a5-a4c7-919a7c4a12f5";
        String name = "TermISATYPEOFRelationship";
        String description = "Defines an inheritance relationship between two spine objects.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("71f83296-2007-46a5-a4c7-919a7c4a12f5", "TermISATYPEOFRelationship", null, "Defines an inheritance relationship between two spine objects.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "GlossaryTerm";
        String end1AttributeName = "inherited";
        String end1AttributeDescription = "Inherited (Subtypes) for this object.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GlossaryTerm"), "inherited", "Inherited (Subtypes) for this object.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "GlossaryTerm";
        String end2AttributeName = "inheritedFrom";
        String end2AttributeDescription = "Inherited from type (Supertypes) for this object.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GlossaryTerm"), "inheritedFrom", "Inherited from type (Supertypes) for this object.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute2Name = "status";
        String attribute2Description = "The status of or confidence in the relationship.";
        String attribute2DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.DESCRIPTION.name, OpenMetadataProperty.DESCRIPTION.description, OpenMetadataProperty.DESCRIPTION.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getEnumTypeDefAttribute("TermRelationshipStatus", "status", "The status of or confidence in the relationship.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.STEWARD.name, OpenMetadataProperty.STEWARD.description, OpenMetadataProperty.STEWARD.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.SOURCE.name, OpenMetadataProperty.SOURCE.description, OpenMetadataProperty.SOURCE.descriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void update0461GovernanceEngines() {
        this.archiveBuilder.addEntityDef(this.getContextEventEngineEntity());
        this.archiveBuilder.addEntityDef(this.getContextEventServiceEntity());
        this.archiveBuilder.addEntityDef(this.getSurveyActionEngineEntity());
        this.archiveBuilder.addEntityDef(this.getSurveyActionServiceEntity());
    }

    private EntityDef getContextEventEngineEntity() {
        String guid = OpenMetadataType.CONTEXT_EVENT_ENGINE.typeGUID;
        String name = OpenMetadataType.CONTEXT_EVENT_ENGINE.typeName;
        String description = OpenMetadataType.CONTEXT_EVENT_ENGINE.description;
        String descriptionGUID = OpenMetadataType.CONTEXT_EVENT_ENGINE.descriptionGUID;
        String descriptionWiki = OpenMetadataType.CONTEXT_EVENT_ENGINE.wikiURL;
        String superTypeName = OpenMetadataType.GOVERNANCE_ENGINE.typeName;
        return this.archiveHelper.getDefaultEntityDef(guid, name, this.archiveBuilder.getEntityDef(superTypeName), description, descriptionGUID, descriptionWiki);
    }

    private EntityDef getContextEventServiceEntity() {
        String guid = OpenMetadataType.CONTEXT_EVENT_SERVICE.typeGUID;
        String name = OpenMetadataType.CONTEXT_EVENT_SERVICE.typeName;
        String description = OpenMetadataType.CONTEXT_EVENT_SERVICE.description;
        String descriptionGUID = OpenMetadataType.CONTEXT_EVENT_SERVICE.descriptionGUID;
        String descriptionWiki = OpenMetadataType.CONTEXT_EVENT_SERVICE.wikiURL;
        String superTypeName = OpenMetadataType.GOVERNANCE_SERVICE.typeName;
        return this.archiveHelper.getDefaultEntityDef(guid, name, this.archiveBuilder.getEntityDef(superTypeName), description, descriptionGUID, descriptionWiki);
    }

    private EntityDef getSurveyActionEngineEntity() {
        String guid = OpenMetadataType.SURVEY_ACTION_ENGINE.typeGUID;
        String name = OpenMetadataType.SURVEY_ACTION_ENGINE.typeName;
        String description = OpenMetadataType.SURVEY_ACTION_ENGINE.description;
        String descriptionGUID = OpenMetadataType.SURVEY_ACTION_ENGINE.descriptionGUID;
        String descriptionWiki = OpenMetadataType.SURVEY_ACTION_ENGINE.wikiURL;
        String superTypeName = OpenMetadataType.GOVERNANCE_ENGINE.typeName;
        return this.archiveHelper.getDefaultEntityDef(guid, name, this.archiveBuilder.getEntityDef(superTypeName), description, descriptionGUID, descriptionWiki);
    }

    private EntityDef getSurveyActionServiceEntity() {
        String guid = OpenMetadataType.SURVEY_ACTION_SERVICE.typeGUID;
        String name = OpenMetadataType.SURVEY_ACTION_SERVICE.typeName;
        String description = OpenMetadataType.SURVEY_ACTION_SERVICE.description;
        String descriptionGUID = OpenMetadataType.SURVEY_ACTION_SERVICE.descriptionGUID;
        String descriptionWiki = OpenMetadataType.SURVEY_ACTION_SERVICE.wikiURL;
        String superTypeName = OpenMetadataType.GOVERNANCE_SERVICE.typeName;
        return this.archiveHelper.getDefaultEntityDef(guid, name, this.archiveBuilder.getEntityDef(superTypeName), description, descriptionGUID, descriptionWiki);
    }

    private void update0464IntegrationGroups() {
        this.archiveBuilder.addTypeDefPatch(this.updateCatalogTarget());
    }

    private TypeDefPatch updateCatalogTarget() {
        String typeName = "CatalogTarget";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("CatalogTarget");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "templates";
        String attribute1Description = "Map of template name to qualified name of parent element in associated catalog template.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "connectionName";
        String attribute2Description = "Name of connector to use to access the associated resource.  If this is null, the connection for the asset associated with the catalog target is used.  The asset may be the catalog target itself or the catalog target's anchor.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "metadataSourceQualifiedName";
        String attribute3Description = "Qualified name of a software server capability that is the owner/home of the metadata catalogued by the integration connector.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "configurationProperties";
        String attribute4Description = "Specific configuration properties used to configure the behaviour of the connector.";
        String attribute4DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getMapStringStringTypeDefAttribute("templates", "Map of template name to qualified name of parent element in associated catalog template.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("connectionName", "Name of connector to use to access the associated resource.  If this is null, the connection for the asset associated with the catalog target is used.  The asset may be the catalog target itself or the catalog target's anchor.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("metadataSourceQualifiedName", "Qualified name of a software server capability that is the owner/home of the metadata catalogued by the integration connector.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringObjectTypeDefAttribute("configurationProperties", "Specific configuration properties used to configure the behaviour of the connector.", attribute4DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void add00475ContextEvents() {
        this.archiveBuilder.addEntityDef(this.addContextEventEntity());
        this.archiveBuilder.addRelationshipDef(this.addContextEventEvidenceRelationship());
        this.archiveBuilder.addRelationshipDef(this.addContextEventForTimelineEffectsRelationship());
        this.archiveBuilder.addRelationshipDef(this.addContextEventImpactRelationship());
        this.archiveBuilder.addRelationshipDef(this.addDependentContextEventRelationship());
        this.archiveBuilder.addRelationshipDef(this.addRelatedContextEventRelationship());
        this.archiveBuilder.addEntityDef(this.addContextEventTimelineEntryEntity());
        this.archiveBuilder.addRelationshipDef(this.addContextEventTimelineRelationship());
        this.archiveBuilder.addClassificationDef(this.getContextEventCollectionClassification());
    }

    private EntityDef addContextEventEntity() {
        String guid = "63d2e056-2f39-40ad-b13b-fe5d8a82d6c6";
        String name = "ContextEvent";
        String description = "A description of an event that impacts users, data, services, etcetera.  It is used to describe what was happening during a named time period.";
        String descriptionGUID = null;
        String superTypeName = OpenMetadataType.REFERENCEABLE.typeName;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("63d2e056-2f39-40ad-b13b-fe5d8a82d6c6", "ContextEvent", this.archiveBuilder.getEntityDef(superTypeName), "A description of an event that impacts users, data, services, etcetera.  It is used to describe what was happening during a named time period.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute2Name = "eventEffect";
        String attribute2Description = "Describes the expected effects of the event on the organization.";
        String attribute2DescriptionGUID = null;
        String attribute4Name = "contextEventType";
        String attribute4Description = "Describes the type/category of event.  Valid values for this attribute can be managed in a valid metadata value set";
        String attribute4DescriptionGUID = null;
        String attribute5Name = "plannedStartDate";
        String attribute5Description = "Provides a planned date/time when the event should start.";
        String attribute5DescriptionGUID = null;
        String attribute6Name = "actualStartDate";
        String attribute6Description = "Provides a definitive date/time when the event did start.";
        String attribute6DescriptionGUID = null;
        String attribute7Name = "plannedDuration";
        String attribute7Description = "Defines, in milliseconds, the length of time that the event is expected to last.";
        String attribute7DescriptionGUID = null;
        String attribute8Name = "actualDuration";
        String attribute8Description = "Defines, in milliseconds, the length of time that the event did last.";
        String attribute8DescriptionGUID = null;
        String attribute9Name = "repeatInterval";
        String attribute9Description = "Defines, in milliseconds, how frequently the event is expected to repeat.";
        String attribute9DescriptionGUID = null;
        String attribute10Name = "plannedCompletionDate";
        String attribute10Description = "Provides an expected date/time when the event is complete.";
        String attribute10DescriptionGUID = null;
        String attribute11Name = "actualCompletionDate";
        String attribute11Description = "Provides a date/time when the event did complete.";
        String attribute11DescriptionGUID = null;
        String attribute12Name = "referenceEffectiveFrom";
        String attribute12Description = "Provides a value to use in the starting effective dates for entities, relationships and classifications whose effectivity is triggered by this context event.";
        String attribute12DescriptionGUID = null;
        String attribute13Name = "referenceEffectiveTo";
        String attribute13Description = "Provides a value to use in the ending effective dates for entities, relationships and classifications whose effectivity is ended by this context event.";
        String attribute13DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.NAME.name, OpenMetadataProperty.NAME.description, OpenMetadataProperty.NAME.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("eventEffect", "Describes the expected effects of the event on the organization.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.DESCRIPTION.name, OpenMetadataProperty.DESCRIPTION.description, OpenMetadataProperty.DESCRIPTION.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("contextEventType", "Describes the type/category of event.  Valid values for this attribute can be managed in a valid metadata value set", attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getDateTypeDefAttribute("plannedStartDate", "Provides a planned date/time when the event should start.", attribute5DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getDateTypeDefAttribute("actualStartDate", "Provides a definitive date/time when the event did start.", attribute6DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getLongTypeDefAttribute("plannedDuration", "Defines, in milliseconds, the length of time that the event is expected to last.", attribute7DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getLongTypeDefAttribute("actualDuration", "Defines, in milliseconds, the length of time that the event did last.", attribute8DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getLongTypeDefAttribute("repeatInterval", "Defines, in milliseconds, how frequently the event is expected to repeat.", attribute9DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getDateTypeDefAttribute("plannedCompletionDate", "Provides an expected date/time when the event is complete.", attribute10DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getDateTypeDefAttribute("actualCompletionDate", "Provides a date/time when the event did complete.", attribute11DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getDateTypeDefAttribute("referenceEffectiveFrom", "Provides a value to use in the starting effective dates for entities, relationships and classifications whose effectivity is triggered by this context event.", attribute12DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getDateTypeDefAttribute("referenceEffectiveTo", "Provides a value to use in the ending effective dates for entities, relationships and classifications whose effectivity is ended by this context event.", attribute13DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef addContextEventEvidenceRelationship() {
        String guid = "410ab118-a880-4b6a-950d-dada0363c50e";
        String name = "ContextEventEvidence";
        String description = "Link to evidence that the context event has occurred, started or is expected can appear as alerts/notification or incidents that people have raised.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("410ab118-a880-4b6a-950d-dada0363c50e", "ContextEventEvidence", null, "Link to evidence that the context event has occurred, started or is expected can appear as alerts/notification or incidents that people have raised.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "ContextEvent";
        String end1AttributeName = "relatedToContextEvents";
        String end1AttributeDescription = "Description of a related event.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("ContextEvent"), "relatedToContextEvents", "Description of a related event.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.REFERENCEABLE.typeName;
        String end2AttributeName = "contextEventEvidence";
        String end2AttributeDescription = "Descriptions of notifications, incidents and other indications that the context event is underway.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "contextEventEvidence", "Descriptions of notifications, incidents and other indications that the context event is underway.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef addContextEventForTimelineEffectsRelationship() {
        String guid = "f1f407cc-9047-487d-9ce3-aa892cf39711";
        String name = "ContextEventForTimelineEffects";
        String description = "Associates a ContextEvent to a Referenceable (typically and Asset or DataProduct) whose data is affected by the event.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("f1f407cc-9047-487d-9ce3-aa892cf39711", "ContextEventForTimelineEffects", null, "Associates a ContextEvent to a Referenceable (typically and Asset or DataProduct) whose data is affected by the event.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = OpenMetadataType.REFERENCEABLE.typeName;
        String end1AttributeName = "eventEffectedResources";
        String end1AttributeDescription = "Entities whose data is impacted by the context event.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "eventEffectedResources", "Entities whose data is impacted by the context event.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "ContextEvent";
        String end2AttributeName = "associatedEventForTimelines";
        String end2AttributeDescription = "Descriptions of events that have impacted this resource.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("ContextEvent"), "associatedEventForTimelines", "Descriptions of events that have impacted this resource.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef addContextEventImpactRelationship() {
        String guid = "335f421f-357a-41dd-a365-1c0aa1226ed9";
        String name = "ContextEventImpact";
        String description = "Links a ContextEvent entity to Referenceable entities that describe resources that are impacted by the event.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("335f421f-357a-41dd-a365-1c0aa1226ed9", "ContextEventImpact", null, "Links a ContextEvent entity to Referenceable entities that describe resources that are impacted by the event.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = OpenMetadataType.REFERENCEABLE.typeName;
        String end1AttributeName = "eventImpacts";
        String end1AttributeDescription = "Resources impacted by the context event.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "eventImpacts", "Resources impacted by the context event.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "ContextEvent";
        String end2AttributeName = "impactedByContextEvents";
        String end2AttributeDescription = "Descriptions of context events affecting this resource and the action taken.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("ContextEvent"), "impactedByContextEvents", "Descriptions of context events affecting this resource and the action taken.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "severityLevelIdentifier";
        String attribute1Description = "How severe is the impact on the resource?";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getIntTypeDefAttribute("severityLevelIdentifier", "How severe is the impact on the resource?", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.DESCRIPTION.name, OpenMetadataProperty.DESCRIPTION.description, OpenMetadataProperty.DESCRIPTION.descriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private ClassificationDef getContextEventCollectionClassification() {
        String guid = "a4f037c6-abad-4957-bd3d-1adb3279f274";
        String name = "ContextEventCollection";
        String description = "Defines the scope of the data held in the associated data resource.";
        String descriptionGUID = null;
        String linkedToEntity = "Collection";
        return this.archiveHelper.getClassificationDef("a4f037c6-abad-4957-bd3d-1adb3279f274", "ContextEventCollection", null, "Defines the scope of the data held in the associated data resource.", descriptionGUID, this.archiveBuilder.getEntityDef("Collection"), false);
    }

    private RelationshipDef addDependentContextEventRelationship() {
        String guid = "3ad9d182-f0d5-4216-abe3-8dd641d0e37b";
        String name = "DependentContextEvent";
        String description = "Link between a parent context event and its children.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("3ad9d182-f0d5-4216-abe3-8dd641d0e37b", "DependentContextEvent", null, "Link between a parent context event and its children.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "ContextEvent";
        String end1AttributeName = "parentContextEvents";
        String end1AttributeDescription = "Context event that is driving the child context events.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("ContextEvent"), "parentContextEvents", "Context event that is driving the child context events.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "ContextEvent";
        String end2AttributeName = "childContextEvents";
        String end2AttributeDescription = "Subsequent context events created to help manage the parent context events.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("ContextEvent"), "childContextEvents", "Subsequent context events created to help manage the parent context events.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.DESCRIPTION.name, OpenMetadataProperty.DESCRIPTION.description, OpenMetadataProperty.DESCRIPTION.descriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef addRelatedContextEventRelationship() {
        String guid = "a94db527-7e1c-4f45-914e-a49dc009a305";
        String name = "RelatedContextEvent";
        String description = "Link between context events that are impacting one another in some way.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("a94db527-7e1c-4f45-914e-a49dc009a305", "RelatedContextEvent", null, "Link between context events that are impacting one another in some way.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "ContextEvent";
        String end1AttributeName = "relatedContextEvents";
        String end1AttributeDescription = "Context event that is affecting the other context event.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("ContextEvent"), "relatedContextEvents", "Context event that is affecting the other context event.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "ContextEvent";
        String end2AttributeName = "relatedContextEvents";
        String end2AttributeDescription = "Context event that is affecting the other context event.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("ContextEvent"), "relatedContextEvents", "Context event that is affecting the other context event.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "statusIdentifier";
        String attribute1Description = "Status of this association.";
        String attribute1DescriptionGUID = null;
        String attribute4Name = OpenMetadataProperty.STEWARD_TYPE_NAME.name;
        String attribute4Description = OpenMetadataProperty.STEWARD_TYPE_NAME.description;
        String attribute4DescriptionGUID = OpenMetadataProperty.STEWARD_TYPE_NAME.descriptionGUID;
        String attribute5Name = OpenMetadataProperty.STEWARD_PROPERTY_NAME.name;
        String attribute5Description = OpenMetadataProperty.STEWARD_PROPERTY_NAME.description;
        String attribute5DescriptionGUID = OpenMetadataProperty.STEWARD_PROPERTY_NAME.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getIntTypeDefAttribute("statusIdentifier", "Status of this association.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getIntTypeDefAttribute(OpenMetadataProperty.CONFIDENCE.name, OpenMetadataProperty.CONFIDENCE.description, OpenMetadataProperty.CONFIDENCE.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.STEWARD.name, OpenMetadataProperty.STEWARD.description, OpenMetadataProperty.STEWARD.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute4Name, attribute4Description, attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute5Name, attribute5Description, attribute5DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.SOURCE.name, OpenMetadataProperty.SOURCE.description, OpenMetadataProperty.SOURCE.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.NOTES.name, OpenMetadataProperty.NOTES.description, OpenMetadataProperty.NOTES.descriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef addContextEventTimelineRelationship() {
        String guid = "2b96d76d-bc92-4d1e-8470-5a68db1d6f2f";
        String name = "ContextEventTimeline";
        String description = "Links a ContextEventTimelineEntry entity to either a ContextEvent entity or a collection of ContextEvent entities.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("2b96d76d-bc92-4d1e-8470-5a68db1d6f2f", "ContextEventTimeline", null, "Links a ContextEventTimelineEntry entity to either a ContextEvent entity or a collection of ContextEvent entities.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = OpenMetadataType.REFERENCEABLE.typeName;
        String end1AttributeName = "associatedContextEvents";
        String end1AttributeDescription = "Description of the events described in the timeline.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "associatedContextEvents", "Description of the events described in the timeline.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "ContextEventTimelineEntry";
        String end2AttributeName = "contextEventTimelineEntry";
        String end2AttributeDescription = "Descriptions of notifications or significant activity.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("ContextEventTimelineEntry"), "contextEventTimelineEntry", "Descriptions of notifications or significant activity.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private EntityDef addContextEventTimelineEntryEntity() {
        String guid = "6b8162ba-08fc-4494-83f5-0b32589c7ba3";
        String name = "ContextEventTimelineEntry";
        String description = "Describes a notification, significant activity or other occurrence during the context event.";
        String descriptionGUID = null;
        String superTypeName = OpenMetadataType.REFERENCEABLE.typeName;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("6b8162ba-08fc-4494-83f5-0b32589c7ba3", "ContextEventTimelineEntry", this.archiveBuilder.getEntityDef(superTypeName), "Describes a notification, significant activity or other occurrence during the context event.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "timelineEntryDate";
        String attribute1Description = "When does the entry refer to.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "timelineEntryDescription";
        String attribute2Description = "Describes the entry in the timeline.";
        String attribute2DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getDateTypeDefAttribute("timelineEntryDate", "When does the entry refer to.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("timelineEntryDescription", "Describes the entry in the timeline.", attribute2DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private void update0545ReferenceData() {
        this.archiveBuilder.addTypeDefPatch(this.updateValidValueDefinition());
        this.archiveBuilder.addTypeDefPatch(this.updateValidValuesImplementation());
        this.archiveBuilder.addRelationshipDef(this.getConsistentValidValuesRelationship());
        this.archiveBuilder.addRelationshipDef(this.getValidValueAssociationRelationship());
        this.archiveBuilder.addRelationshipDef(this.getSpecificationPropertyAssignmentRelationship());
    }

    private TypeDefPatch updateValidValueDefinition() {
        String typeName = OpenMetadataType.VALID_VALUE_DEFINITION.typeName;
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "category";
        String attribute1Description = "Descriptive name of the concept that this valid value describes a possible value for.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "isCaseSensitive";
        String attribute2Description = "Is this valid value case-sensitive, or should the values match irrespective of case?";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "dataType";
        String attribute3Description = "The type of the value identifies it format and content.";
        String attribute3DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("category", "Descriptive name of the concept that this valid value describes a possible value for.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getBooleanTypeDefAttribute("isCaseSensitive", "Is this valid value case-sensitive, or should the values match irrespective of case?", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("dataType", "The type of the value identifies it format and content.", attribute3DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateValidValuesImplementation() {
        String typeName = OpenMetadataType.VALID_VALUES_IMPL_RELATIONSHIP.typeName;
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        String end1EntityType = OpenMetadataType.REFERENCEABLE.typeName;
        String end1AttributeName = "validValueImplementations";
        String end1AttributeDescription = "The location where mapped value is stored.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "validValueImplementations", "The location where mapped value is stored.", end1AttributeDescriptionGUID, end1Cardinality);
        typeDefPatch.setEndDef1(relationshipEndDef);
        return typeDefPatch;
    }

    private RelationshipDef getConsistentValidValuesRelationship() {
        String guid = OpenMetadataType.CONSISTENT_VALID_VALUES_RELATIONSHIP.typeGUID;
        String name = OpenMetadataType.CONSISTENT_VALID_VALUES_RELATIONSHIP.typeName;
        String description = OpenMetadataType.CONSISTENT_VALID_VALUES_RELATIONSHIP.description;
        String descriptionGUID = OpenMetadataType.CONSISTENT_VALID_VALUES_RELATIONSHIP.descriptionGUID;
        String descriptionWiki = OpenMetadataType.CONSISTENT_VALID_VALUES_RELATIONSHIP.wikiURL;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(guid, name, null, description, descriptionGUID, descriptionWiki, classificationPropagationRule);
        String end1EntityType = OpenMetadataType.VALID_VALUE_DEFINITION.typeName;
        String end1AttributeName = "consistentValue";
        String end1AttributeDescription = "Valid value for another valid value set (property) that is consistent with this value.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "consistentValue", "Valid value for another valid value set (property) that is consistent with this value.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.VALID_VALUE_DEFINITION.typeName;
        String end2AttributeName = "consistentValue";
        String end2AttributeDescription = "Valid value for another valid value set (property) that is consistent with this value.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "consistentValue", "Valid value for another valid value set (property) that is consistent with this value.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getValidValueAssociationRelationship() {
        String guid = OpenMetadataType.VALID_VALUE_ASSOCIATION_RELATIONSHIP.typeGUID;
        String name = OpenMetadataType.VALID_VALUE_ASSOCIATION_RELATIONSHIP.typeName;
        String description = OpenMetadataType.VALID_VALUE_ASSOCIATION_RELATIONSHIP.description;
        String descriptionGUID = OpenMetadataType.VALID_VALUE_ASSOCIATION_RELATIONSHIP.descriptionGUID;
        String descriptionWiki = OpenMetadataType.VALID_VALUE_ASSOCIATION_RELATIONSHIP.wikiURL;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(guid, name, null, description, descriptionGUID, descriptionWiki, classificationPropagationRule);
        String end1EntityType = OpenMetadataType.VALID_VALUE_DEFINITION.typeName;
        String end1AttributeName = "associatedValues1";
        String end1AttributeDescription = "Valid value at end one of this association.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "associatedValues1", "Valid value at end one of this association.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.VALID_VALUE_DEFINITION.typeName;
        String end2AttributeName = "associatedValues2";
        String end2AttributeDescription = "Valid value at end two of this association.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "associatedValues2", "Valid value at end two of this association.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.ASSOCIATION_NAME.name, OpenMetadataProperty.ASSOCIATION_NAME.description, OpenMetadataProperty.ASSOCIATION_NAME.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.ASSOCIATION_TYPE.name, OpenMetadataProperty.ASSOCIATION_TYPE.description, OpenMetadataProperty.ASSOCIATION_TYPE.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringStringTypeDefAttribute(OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, OpenMetadataProperty.ADDITIONAL_PROPERTIES.description, OpenMetadataProperty.ADDITIONAL_PROPERTIES.descriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getSpecificationPropertyAssignmentRelationship() {
        String guid = OpenMetadataType.SPECIFICATION_PROPERTY_ASSIGNMENT_RELATIONSHIP.typeGUID;
        String name = OpenMetadataType.SPECIFICATION_PROPERTY_ASSIGNMENT_RELATIONSHIP.typeName;
        String description = OpenMetadataType.SPECIFICATION_PROPERTY_ASSIGNMENT_RELATIONSHIP.description;
        String descriptionGUID = OpenMetadataType.SPECIFICATION_PROPERTY_ASSIGNMENT_RELATIONSHIP.descriptionGUID;
        String descriptionWiki = OpenMetadataType.SPECIFICATION_PROPERTY_ASSIGNMENT_RELATIONSHIP.wikiURL;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(guid, name, null, description, descriptionGUID, descriptionWiki, classificationPropagationRule);
        String end1EntityType = OpenMetadataType.REFERENCEABLE.typeName;
        String end1AttributeName = "implementingItem";
        String end1AttributeDescription = "Connector or template, or similar implementation.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "implementingItem", "Connector or template, or similar implementation.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.VALID_VALUE_DEFINITION.typeName;
        String end2AttributeName = "specificationProperty";
        String end2AttributeDescription = "Valid value representing a property type that controls its behaviour.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "specificationProperty", "Valid value representing a property type that controls its behaviour.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.PROPERTY_TYPE.name;
        String attribute1Description = OpenMetadataProperty.PROPERTY_TYPE.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.PROPERTY_TYPE.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void update0462GovernanceActionTypes() {
        this.archiveBuilder.addTypeDefPatch(this.updateGovernanceActionType());
    }

    private TypeDefPatch updateGovernanceActionType() {
        String typeName = "GovernanceActionType";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("GovernanceActionType");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "supportedGuards";
        String attribute1Description = "Deprecated list of produced guards.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getArrayStringTypeDefAttribute("supportedGuards", "Deprecated list of produced guards.", attribute1DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        property.setReplacedByAttribute("producedGuards");
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void add0603SurveyReports() {
        this.archiveBuilder.addEntityDef(this.addSurveyReportEntity());
        this.archiveBuilder.addRelationshipDef(this.addAssetSurveyReportRelationship());
        this.archiveBuilder.addRelationshipDef(this.addEngineActionSurveyReportRelationship());
        this.archiveBuilder.addRelationshipDef(this.getReportedAnnotationRelationship());
        this.archiveBuilder.addRelationshipDef(this.getAssociatedAnnotationRelationship());
    }

    private EntityDef addSurveyReportEntity() {
        String guid = OpenMetadataType.SURVEY_REPORT.typeGUID;
        String name = OpenMetadataType.SURVEY_REPORT.typeName;
        String description = OpenMetadataType.SURVEY_REPORT.description;
        String descriptionGUID = OpenMetadataType.SURVEY_REPORT.descriptionGUID;
        String descriptionWiki = OpenMetadataType.SURVEY_REPORT.wikiURL;
        String superTypeName = OpenMetadataType.REFERENCEABLE.typeName;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(guid, name, this.archiveBuilder.getEntityDef(superTypeName), description, descriptionGUID, descriptionWiki);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute3Name = OpenMetadataProperty.PURPOSE.name;
        String attribute3Description = OpenMetadataProperty.PURPOSE.description;
        String attribute3DescriptionGUID = OpenMetadataProperty.PURPOSE.descriptionGUID;
        String attribute4Name = OpenMetadataProperty.ANALYSIS_PARAMETERS.name;
        String attribute4Description = OpenMetadataProperty.ANALYSIS_PARAMETERS.description;
        String attribute4DescriptionGUID = OpenMetadataProperty.ANALYSIS_PARAMETERS.descriptionGUID;
        String attribute5Name = OpenMetadataProperty.ANALYSIS_STEP.name;
        String attribute5Description = OpenMetadataProperty.ANALYSIS_STEP.description;
        String attribute5DescriptionGUID = OpenMetadataProperty.ANALYSIS_STEP.descriptionGUID;
        String attribute6Name = OpenMetadataProperty.START_DATE.name;
        String attribute6Description = OpenMetadataProperty.START_DATE.description;
        String attribute6DescriptionGUID = OpenMetadataProperty.START_DATE.descriptionGUID;
        String attribute7Name = OpenMetadataProperty.COMPLETION_DATE.name;
        String attribute7Description = OpenMetadataProperty.COMPLETION_DATE.description;
        String attribute7DescriptionGUID = OpenMetadataProperty.COMPLETION_DATE.descriptionGUID;
        String attribute8Name = OpenMetadataProperty.COMPLETION_MESSAGE.name;
        String attribute8Description = OpenMetadataProperty.COMPLETION_MESSAGE.description;
        String attribute8DescriptionGUID = OpenMetadataProperty.COMPLETION_MESSAGE.descriptionGUID;
        String attribute9Name = OpenMetadataProperty.USER.name;
        String attribute9Description = OpenMetadataProperty.USER.description;
        String attribute9DescriptionGUID = OpenMetadataProperty.USER.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.DISPLAY_NAME.name, OpenMetadataProperty.DISPLAY_NAME.description, OpenMetadataProperty.DISPLAY_NAME.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.DESCRIPTION.name, OpenMetadataProperty.DESCRIPTION.description, OpenMetadataProperty.DESCRIPTION.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute3Name, attribute3Description, attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringStringTypeDefAttribute(attribute4Name, attribute4Description, attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute5Name, attribute5Description, attribute5DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getDateTypeDefAttribute(attribute6Name, attribute6Description, attribute6DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getDateTypeDefAttribute(attribute7Name, attribute7Description, attribute7DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute8Name, attribute8Description, attribute8DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute9Name, attribute9Description, attribute9DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef addAssetSurveyReportRelationship() {
        String guid = OpenMetadataType.ASSET_SURVEY_REPORT_RELATIONSHIP.typeGUID;
        String name = OpenMetadataType.ASSET_SURVEY_REPORT_RELATIONSHIP.typeName;
        String description = OpenMetadataType.ASSET_SURVEY_REPORT_RELATIONSHIP.description;
        String descriptionGUID = OpenMetadataType.ASSET_SURVEY_REPORT_RELATIONSHIP.descriptionGUID;
        String descriptionWiki = OpenMetadataType.ASSET_SURVEY_REPORT_RELATIONSHIP.wikiURL;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(guid, name, null, description, descriptionGUID, descriptionWiki, classificationPropagationRule);
        String end1EntityType = OpenMetadataType.ASSET.typeName;
        String end1AttributeName = "surveyReportTarget";
        String end1AttributeDescription = "The asset describing the resource that was surveyed.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "surveyReportTarget", "The asset describing the resource that was surveyed.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.SURVEY_REPORT.typeName;
        String end2AttributeName = "surveyReports";
        String end2AttributeDescription = "Survey reports for the asset.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "surveyReports", "Survey reports for the asset.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef addEngineActionSurveyReportRelationship() {
        String guid = OpenMetadataType.ENGINE_ACTION_SURVEY_REPORT_RELATIONSHIP.typeGUID;
        String name = OpenMetadataType.ENGINE_ACTION_SURVEY_REPORT_RELATIONSHIP.typeName;
        String description = OpenMetadataType.ENGINE_ACTION_SURVEY_REPORT_RELATIONSHIP.description;
        String descriptionGUID = OpenMetadataType.ENGINE_ACTION_SURVEY_REPORT_RELATIONSHIP.descriptionGUID;
        String descriptionWiki = OpenMetadataType.ENGINE_ACTION_SURVEY_REPORT_RELATIONSHIP.wikiURL;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(guid, name, null, description, descriptionGUID, descriptionWiki, classificationPropagationRule);
        String end1EntityType = OpenMetadataType.ENGINE_ACTION.typeName;
        String end1AttributeName = "engineAction";
        String end1AttributeDescription = "The engine action controlling the survey action service invocation.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "engineAction", "The engine action controlling the survey action service invocation.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.SURVEY_REPORT.typeName;
        String end2AttributeName = "surveyReport";
        String end2AttributeDescription = "Survey report generated form the execution of the survey action service.  Typically only one unless failures occurred.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "surveyReport", "Survey report generated form the execution of the survey action service.  Typically only one unless failures occurred.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getReportedAnnotationRelationship() {
        String guid = OpenMetadataType.REPORTED_ANNOTATION_RELATIONSHIP.typeGUID;
        String name = OpenMetadataType.REPORTED_ANNOTATION_RELATIONSHIP.typeName;
        String description = OpenMetadataType.REPORTED_ANNOTATION_RELATIONSHIP.description;
        String descriptionGUID = OpenMetadataType.REPORTED_ANNOTATION_RELATIONSHIP.descriptionGUID;
        String descriptionWiki = OpenMetadataType.REPORTED_ANNOTATION_RELATIONSHIP.wikiURL;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(guid, name, null, description, descriptionGUID, descriptionWiki, classificationPropagationRule);
        String end1EntityType = OpenMetadataType.SURVEY_REPORT.typeName;
        String end1AttributeName = "fromSurveyReport";
        String end1AttributeDescription = "The report that the annotations belong to.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "fromSurveyReport", "The report that the annotations belong to.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.ANNOTATION.typeName;
        String end2AttributeName = "reportedAnnotations";
        String end2AttributeDescription = "The annotations providing the contents for the report.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "reportedAnnotations", "The annotations providing the contents for the report.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getAssociatedAnnotationRelationship() {
        String guid = OpenMetadataType.ASSOCIATED_ANNOTATION_RELATIONSHIP.typeGUID;
        String name = OpenMetadataType.ASSOCIATED_ANNOTATION_RELATIONSHIP.typeName;
        String description = OpenMetadataType.ASSOCIATED_ANNOTATION_RELATIONSHIP.description;
        String descriptionGUID = OpenMetadataType.ASSOCIATED_ANNOTATION_RELATIONSHIP.descriptionGUID;
        String descriptionWiki = OpenMetadataType.ASSOCIATED_ANNOTATION_RELATIONSHIP.wikiURL;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(guid, name, null, description, descriptionGUID, descriptionWiki, classificationPropagationRule);
        String end1EntityType = OpenMetadataType.OPEN_METADATA_ROOT.typeName;
        String end1AttributeName = "annotationSubject";
        String end1AttributeDescription = "The element described in the annotation.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "annotationSubject", "The element described in the annotation.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.ANNOTATION.typeName;
        String end2AttributeName = "associatedAnnotations";
        String end2AttributeDescription = "The annotations describing the element or its real-world counterpart.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "associatedAnnotations", "The annotations describing the element or its real-world counterpart.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void update0615SchemaExtraction() {
        this.archiveBuilder.addTypeDefPatch(this.updateDataFieldEntity());
        this.archiveBuilder.addRelationshipDef(this.getLinkedDataFieldRelationship());
    }

    private TypeDefPatch updateDataFieldEntity() {
        String typeName = OpenMetadataType.DATA_FIELD.typeName;
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "minimumLength";
        String attribute1Description = "Minimum length of the data value (zero means unlimited).";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "length";
        String attribute2Description = "Length of the data field (zero means unlimited).";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "significantDigits";
        String attribute3Description = "Number of significant digits before the decimal point (zero means it is an integer).";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "isNullable";
        String attribute4Description = "Accepts null values or not.";
        String attribute4DescriptionGUID = null;
        String attribute6Name = "minCardinality";
        String attribute6Description = "Minimum number of occurrences of this attribute allowed.";
        String attribute6DescriptionGUID = null;
        String attribute7Name = "maxCardinality";
        String attribute7Description = "Maximum number of occurrences of this attribute allowed.";
        String attribute7DescriptionGUID = null;
        String attribute8Name = "precision";
        String attribute8Description = "Number of digits after the decimal point.";
        String attribute8DescriptionGUID = null;
        String attribute9Name = "isDeprecated";
        String attribute9Description = "Is this field deprecated?";
        String attribute9DescriptionGUID = null;
        String attribute10Name = "version";
        String attribute10Description = "Incrementing version number.";
        String attribute10DescriptionGUID = null;
        String attribute11Name = OpenMetadataProperty.VERSION_IDENTIFIER.name;
        String attribute11Description = OpenMetadataProperty.VERSION_IDENTIFIER.description;
        String attribute11DescriptionGUID = OpenMetadataProperty.VERSION_IDENTIFIER.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getIntTypeDefAttribute("minimumLength", "Minimum length of the data value (zero means unlimited).", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getIntTypeDefAttribute("length", "Length of the data field (zero means unlimited).", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getIntTypeDefAttribute("significantDigits", "Number of significant digits before the decimal point (zero means it is an integer).", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getBooleanTypeDefAttribute("isNullable", "Accepts null values or not.", attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getIntTypeDefAttribute("minCardinality", "Minimum number of occurrences of this attribute allowed.", attribute6DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getIntTypeDefAttribute("maxCardinality", "Maximum number of occurrences of this attribute allowed.", attribute7DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getIntTypeDefAttribute("precision", "Number of digits after the decimal point.", attribute8DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getBooleanTypeDefAttribute("isDeprecated", "Is this field deprecated?", attribute9DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getLongTypeDefAttribute("version", "Incrementing version number.", attribute10DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute11Name, attribute11Description, attribute11DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private RelationshipDef getLinkedDataFieldRelationship() {
        String guid = "cca4b116-4490-44c4-84e1-535231ae46a1";
        String name = "LinkedDataField";
        String description = "Represents an association between two data fields in a schema.  This may describe a full relationship in the schema (for example, in a relational schema) or a relationship end (for example, in a graph schema).";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("cca4b116-4490-44c4-84e1-535231ae46a1", "LinkedDataField", null, "Represents an association between two data fields in a schema.  This may describe a full relationship in the schema (for example, in a relational schema) or a relationship end (for example, in a graph schema).", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "DataField";
        String end1AttributeName = "linkFromDataFields";
        String end1AttributeDescription = "Data field that is linked from.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("DataField"), "linkFromDataFields", "Data field that is linked from.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "DataField";
        String end2AttributeName = "linkToDataFields";
        String end2AttributeDescription = "Data field that is linked to.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("DataField"), "linkToDataFields", "Data field that is linked to.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "relationshipTypeName";
        String attribute1Description = "Unique name of the relationship type to use in the associated schema.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "relationshipEnd";
        String attribute2Description = "If the end of a relationship is significant set to 1 or 2 to indicated the end; otherwise use 0.";
        String attribute2DescriptionGUID = null;
        String attribute5Name = "minCardinality";
        String attribute5Description = "Minimum number of occurrences of this relationship (or relationship end) allowed.";
        String attribute5DescriptionGUID = null;
        String attribute6Name = "maxCardinality";
        String attribute6Description = "Maximum number of occurrences of this relationship (or relationship end) allowed.";
        String attribute6DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("relationshipTypeName", "Unique name of the relationship type to use in the associated schema.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getIntTypeDefAttribute("relationshipEnd", "If the end of a relationship is significant set to 1 or 2 to indicated the end; otherwise use 0.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.NAME.name, OpenMetadataProperty.NAME.description, OpenMetadataProperty.NAME.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.DESCRIPTION.name, OpenMetadataProperty.DESCRIPTION.description, OpenMetadataProperty.DESCRIPTION.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getIntTypeDefAttribute("minCardinality", "Minimum number of occurrences of this relationship (or relationship end) allowed.", attribute5DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getIntTypeDefAttribute("maxCardinality", "Maximum number of occurrences of this relationship (or relationship end) allowed.", attribute6DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringStringTypeDefAttribute(OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, OpenMetadataProperty.ADDITIONAL_PROPERTIES.description, OpenMetadataProperty.ADDITIONAL_PROPERTIES.descriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void update0690RequestForAction() {
        this.archiveBuilder.addRelationshipDef(this.getRequestForActionTargetRelationship());
    }

    private RelationshipDef getRequestForActionTargetRelationship() {
        String guid = OpenMetadataType.REQUEST_FOR_ACTION_TARGET.typeGUID;
        String name = OpenMetadataType.REQUEST_FOR_ACTION_TARGET.typeName;
        String description = OpenMetadataType.REQUEST_FOR_ACTION_TARGET.description;
        String descriptionGUID = OpenMetadataType.REQUEST_FOR_ACTION_TARGET.descriptionGUID;
        String wikiURL = OpenMetadataType.REQUEST_FOR_ACTION_TARGET.wikiURL;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(guid, name, null, description, descriptionGUID, wikiURL, classificationPropagationRule);
        String end1EntityType = OpenMetadataType.REQUEST_FOR_ACTION_ANNOTATION.typeName;
        String end1AttributeName = "identifiedInRequestForActions";
        String end1AttributeDescription = "Request for action that originated the action.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "identifiedInRequestForActions", "Request for action that originated the action.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.REFERENCEABLE.typeName;
        String end2AttributeName = "requestForActionTargets";
        String end2AttributeDescription = "Elements that originated the data.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "requestForActionTargets", "Elements that originated the data.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.ACTION_TARGET_NAME.name;
        String attribute1Description = "Unique name of the action target.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, "Unique name of the action target.", attribute1DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void add0755UltimateSourcesDestinations() {
        this.archiveBuilder.addRelationshipDef(this.getUltimateSourceRelationship());
        this.archiveBuilder.addRelationshipDef(this.getUltimateDestinationRelationship());
    }

    private RelationshipDef getUltimateSourceRelationship() {
        String guid = "e5649e7a-4d97-4a41-a91d-20f521f961aa";
        String name = "UltimateSource";
        String description = "Links a node in the lineage graph to its ultimate source - ie the node at the start of the lineage data flow.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("e5649e7a-4d97-4a41-a91d-20f521f961aa", "UltimateSource", null, "Links a node in the lineage graph to its ultimate source - ie the node at the start of the lineage data flow.", descriptionGUID, classificationPropagationRule);
        relationshipDef.setMultiLink(true);
        String end1EntityType = OpenMetadataType.REFERENCEABLE.typeName;
        String end1AttributeName = "downstreamFromLineageSource";
        String end1AttributeDescription = "Elements that receives data from the ultimate source (via other processing).";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "downstreamFromLineageSource", "Elements that receives data from the ultimate source (via other processing).", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.REFERENCEABLE.typeName;
        String end2AttributeName = "ultimateSources";
        String end2AttributeDescription = "Elements that originated the data.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "ultimateSources", "Elements that originated the data.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute2Name = "distance";
        String attribute2Description = "The number of hops along the lineage graph to the ultimate source organized by type of element.";
        String attribute2DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.QUALIFIED_NAME.name, OpenMetadataProperty.QUALIFIED_NAME.description, OpenMetadataProperty.QUALIFIED_NAME.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringIntTypeDefAttribute("distance", "The number of hops along the lineage graph to the ultimate source organized by type of element.", attribute2DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getUltimateDestinationRelationship() {
        String guid = "27d48f4a-a5bd-4320-a4ba-55f03adbb27b";
        String name = "UltimateDestination";
        String description = "Links a node in the lineage graph to its ultimate destination - ie the node at the end of the lineage data flow.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("27d48f4a-a5bd-4320-a4ba-55f03adbb27b", "UltimateDestination", null, "Links a node in the lineage graph to its ultimate destination - ie the node at the end of the lineage data flow.", descriptionGUID, classificationPropagationRule);
        relationshipDef.setMultiLink(true);
        String end1EntityType = OpenMetadataType.REFERENCEABLE.typeName;
        String end1AttributeName = "upstreamFromLineageDestination";
        String end1AttributeDescription = "Elements that sends data from the ultimate destination (via other processing).";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "upstreamFromLineageDestination", "Elements that sends data from the ultimate destination (via other processing).", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.REFERENCEABLE.typeName;
        String end2AttributeName = "ultimateDestinations";
        String end2AttributeDescription = "Elements that ultimately receive the data.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "ultimateDestinations", "Elements that ultimately receive the data.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute2Name = "distance";
        String attribute2Description = "The number of hops along the lineage graph to the ultimate destination organized by type of element.";
        String attribute2DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.QUALIFIED_NAME.name, OpenMetadataProperty.QUALIFIED_NAME.description, OpenMetadataProperty.QUALIFIED_NAME.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringIntTypeDefAttribute("distance", "The number of hops along the lineage graph to the ultimate destination organized by type of element.", attribute2DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }
}

