/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.samples.archiveutilities;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchive;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveWriter;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.OpenMetadataArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;
import org.odpi.openmetadata.samples.archiveutilities.GovernanceArchiveHelper;

public abstract class EgeriaBaseArchiveWriter
extends OMRSArchiveWriter {
    protected static final String archiveLicense = "Apache 2.0";
    protected static final OpenMetadataArchiveType archiveType = OpenMetadataArchiveType.CONTENT_PACK;
    protected static final String originatorName = "Egeria Project";
    protected static final String guidMapFileName = "EgeriaContentPacksGUIDMap.json";
    protected static final String openMetadataValidValueSetPrefix = "OpenMetadata.ValidValueSet.";
    protected static final String versionName = "5.1";
    protected OMRSArchiveBuilder archiveBuilder;
    protected GovernanceArchiveHelper archiveHelper;
    protected final String archiveGUID;
    protected final String archiveName;
    protected final Date creationDate;
    protected final String archiveFileName;

    protected EgeriaBaseArchiveWriter(String archiveGUID, String archiveName, String archiveDescription, Date creationDate, String archiveFileName) {
        this(archiveGUID, archiveName, archiveDescription, creationDate, archiveFileName, null);
    }

    protected EgeriaBaseArchiveWriter(String archiveGUID, String archiveName, String archiveDescription, Date creationDate, String archiveFileName, OpenMetadataArchive[] additionalDependencies) {
        this.archiveGUID = archiveGUID;
        this.archiveName = archiveName;
        this.creationDate = creationDate;
        ArrayList<OpenMetadataArchive> dependentOpenMetadataArchives = new ArrayList<OpenMetadataArchive>();
        dependentOpenMetadataArchives.add(new OpenMetadataTypesArchive().getOpenMetadataArchive());
        if (additionalDependencies != null) {
            dependentOpenMetadataArchives.addAll(Arrays.asList(additionalDependencies));
        }
        this.archiveBuilder = new OMRSArchiveBuilder(archiveGUID, archiveName, archiveDescription, archiveType, originatorName, archiveLicense, creationDate, dependentOpenMetadataArchives);
        this.archiveHelper = new GovernanceArchiveHelper((OpenMetadataArchiveBuilder)this.archiveBuilder, archiveGUID, archiveName, originatorName, creationDate, creationDate.getTime(), versionName, guidMapFileName);
        this.archiveFileName = archiveFileName;
    }

    public void setArchiveBuilder(OMRSArchiveBuilder archiveBuilder, GovernanceArchiveHelper archiveHelper) {
        this.archiveBuilder = archiveBuilder;
        this.archiveHelper = archiveHelper;
    }

    public OpenMetadataArchive getOpenMetadataArchive() {
        this.getArchiveContent();
        return this.archiveBuilder.getOpenMetadataArchive();
    }

    public abstract void getArchiveContent();

    public void writeOpenMetadataArchive() {
        this.writeOpenMetadataArchive(null);
    }

    public void writeOpenMetadataArchive(String folderName) {
        try {
            Object pathName = this.archiveFileName;
            if (folderName != null) {
                pathName = folderName + "/" + this.archiveFileName;
            }
            System.out.println("Writing to file: " + (String)pathName);
            super.writeOpenMetadataArchive((String)pathName, this.getOpenMetadataArchive());
        }
        catch (Exception error) {
            System.out.println("error is " + error);
        }
        this.archiveHelper.saveGUIDs();
        this.archiveHelper.saveUsedGUIDs();
    }
}

