/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.archiveutilities.bigglossaries;

import java.util.ArrayList;
import java.util.Arrays;
import org.odpi.openmetadata.archiveutilities.bigglossaries.catalogcontent.BigGlossaryArchiveBuilder;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchive;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveWriter;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;

public class BigGlossariesArchiveWriter
extends OMRSArchiveWriter {
    private static final String openMetadataArchiveRootName = "BigGlossary";
    private static final String bigGlossaryArchiveFileNamePostFix = ".omarchive";

    private void writeOpenMetadataArchives() {
        String[] indexes = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
        ArrayList<String> glossaryIdentifiers = new ArrayList<String>(Arrays.asList(indexes));
        try {
            ArrayList<OpenMetadataArchive> dependentArchives = new ArrayList<OpenMetadataArchive>();
            for (String glossaryIdentifier : glossaryIdentifiers) {
                String glossaryFileName = openMetadataArchiveRootName + glossaryIdentifier + bigGlossaryArchiveFileNamePostFix;
                System.out.println("Creating glossary: " + glossaryIdentifier);
                dependentArchives.add(new OpenMetadataTypesArchive().getOpenMetadataArchive());
                BigGlossaryArchiveBuilder apiArchiveBuilder = new BigGlossaryArchiveBuilder(glossaryIdentifier);
                OpenMetadataArchive newArchive = apiArchiveBuilder.getOpenMetadataArchive();
                dependentArchives.add(newArchive);
                super.writeOpenMetadataArchive(glossaryFileName, newArchive);
            }
        }
        catch (Exception error) {
            System.out.println("error is " + error);
        }
    }

    public static void main(String[] args) {
        try {
            BigGlossariesArchiveWriter archiveWriter = new BigGlossariesArchiveWriter();
            archiveWriter.writeOpenMetadataArchives();
        }
        catch (Exception error) {
            System.err.println("Exception: " + error);
            System.exit(-1);
        }
    }
}

