/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.controls;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.DeployedImplementationTypeDefinition;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class SupportedTechnologyType {
    private String name = null;
    private String description = null;
    private String dataType = null;

    public SupportedTechnologyType() {
    }

    public SupportedTechnologyType(SupportedTechnologyType template) {
        if (template != null) {
            this.name = template.getName();
            this.description = template.getDescription();
            this.dataType = template.getDataType();
        }
    }

    public SupportedTechnologyType(DeployedImplementationTypeDefinition template) {
        if (template != null) {
            this.name = template.getDeployedImplementationType();
            this.description = template.getDescription();
            this.dataType = template.getAssociatedTypeName();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public static List<SupportedTechnologyType> getSupportedTechnologyTypes(SupportedTechnologyType[] technologyTypes) {
        if (technologyTypes == null || technologyTypes.length == 0) {
            return null;
        }
        return new ArrayList<SupportedTechnologyType>(Arrays.asList(technologyTypes));
    }

    public static List<SupportedTechnologyType> getSupportedTechnologyTypes(DeployedImplementationTypeDefinition[] deployedImplementationTypes) {
        if (deployedImplementationTypes == null || deployedImplementationTypes.length == 0) {
            return null;
        }
        ArrayList<SupportedTechnologyType> supportedTechnologyTypes = new ArrayList<SupportedTechnologyType>();
        for (DeployedImplementationTypeDefinition deployedImplementationType : deployedImplementationTypes) {
            supportedTechnologyTypes.add(new SupportedTechnologyType(deployedImplementationType));
        }
        return supportedTechnologyTypes;
    }

    public String toString() {
        return "SupportedTechnologyType{name='" + this.name + "', description='" + this.description + "', dataType='" + this.dataType + "'}";
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof SupportedTechnologyType)) {
            return false;
        }
        SupportedTechnologyType that = (SupportedTechnologyType)objectToCompare;
        return Objects.equals(this.dataType, that.dataType) && Objects.equals(this.name, that.name) && Objects.equals(this.description, that.description);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.dataType);
    }
}

