/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties.users;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public enum AccessOperation {
    READ(0, "Read", "The user requests to read the metadata element in the catalog."),
    CREATE(1, "Create", "The user requests to create a metadata element in the catalog."),
    UPDATE_PROPERTIES(2, "UpdateProperties", "The user requests to change the properties of the metadata element in the catalog."),
    UPDATE_STATUS(3, "Update", "The user requests to change the status of the metadata element in the catalog."),
    DELETE(4, "Delete", "The user requests to remove the metadata element from the catalog (archive, soft-delete or purge)."),
    ATTACH(5, "Attach", "The user requests to attach a non-anchored element to the metadata element in the catalog."),
    DETACH(6, "Detach", "The user requests to detach a non-anchored element from the metadata element in the catalog."),
    ADD_MEMBER(7, "AddMember", "The user requests to attach an anchored element to the metadata element in the catalog."),
    DELETE_MEMBER(8, "DeleteMember", "The user requests to remove an anchored element from the metadata element in the catalog."),
    ADD_FEEDBACK(9, "AddFeedback", "The user requests to attach feedback elements (comments, tags, likes, reviews) to the metadata element in the catalog."),
    DELETE_FEEDBACK(10, "DeleteFeedback", "The user requests to detach feedback elements (comments, tags, likes, reviews) from the metadata element in the catalog."),
    CLASSIFY(11, "Classify", "The user requests to attach a classification to the metadata element in the catalog, or update an existing classification's properties."),
    DECLASSIFY(12, "Declassify", "The user requests to remove a classification from the metadata element in the catalog.");

    private final int ordinal;
    private final String name;
    private final String description;

    private AccessOperation(int ordinal, String name, String description) {
        this.ordinal = ordinal;
        this.name = name;
        this.description = description;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return "AccessOperation{ordinal=" + this.ordinal + ", name='" + this.name + "', description='" + this.description + "'}";
    }
}

