/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.governanceaction.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CatalogTargetProperties;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementStub;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementVersions;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class CatalogTarget
extends CatalogTargetProperties {
    private String relationshipGUID = null;
    private ElementVersions relationshipVersions = null;
    private ElementStub catalogTargetElement = null;

    public CatalogTarget() {
    }

    public CatalogTarget(CatalogTarget template) {
        super(template);
        if (template != null) {
            this.relationshipGUID = template.getRelationshipGUID();
            this.relationshipVersions = template.getRelationshipVersions();
            this.catalogTargetElement = template.getCatalogTargetElement();
        }
    }

    public String getRelationshipGUID() {
        return this.relationshipGUID;
    }

    public void setRelationshipGUID(String relationshipGUID) {
        this.relationshipGUID = relationshipGUID;
    }

    public ElementVersions getRelationshipVersions() {
        return this.relationshipVersions;
    }

    public void setRelationshipVersions(ElementVersions relationshipVersions) {
        this.relationshipVersions = relationshipVersions;
    }

    public ElementStub getCatalogTargetElement() {
        return this.catalogTargetElement;
    }

    public void setCatalogTargetElement(ElementStub catalogTargetElement) {
        this.catalogTargetElement = catalogTargetElement;
    }

    @Override
    public String toString() {
        return "CatalogTarget{relationshipGUID='" + this.relationshipGUID + "', relationshipVersions=" + this.relationshipVersions + ", catalogTargetElement=" + this.catalogTargetElement + "} " + super.toString();
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        CatalogTarget that = (CatalogTarget)objectToCompare;
        return Objects.equals(this.relationshipGUID, that.relationshipGUID) && Objects.equals(this.relationshipVersions, that.relationshipVersions) && Objects.equals(this.catalogTargetElement, that.catalogTargetElement);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.relationshipGUID, this.relationshipVersions, this.catalogTargetElement);
    }
}

