/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.governanceaction.properties;

import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataRelationship;

public class OpenMetadataElementGraph
extends OpenMetadataElement {
    private List<OpenMetadataElement> anchoredElements = null;
    private List<OpenMetadataRelationship> relationships = null;
    private String mermaidGraph = null;

    public OpenMetadataElementGraph() {
    }

    public OpenMetadataElementGraph(OpenMetadataElement template) {
        super(template);
    }

    public OpenMetadataElementGraph(OpenMetadataElementGraph template) {
        super(template);
        if (template != null) {
            this.anchoredElements = template.getAnchoredElements();
            this.relationships = template.getRelationships();
            this.mermaidGraph = template.getMermaidGraph();
        }
    }

    public List<OpenMetadataElement> getAnchoredElements() {
        return this.anchoredElements;
    }

    public void setAnchoredElements(List<OpenMetadataElement> anchoredElements) {
        this.anchoredElements = anchoredElements;
    }

    public List<OpenMetadataRelationship> getRelationships() {
        return this.relationships;
    }

    public void setRelationships(List<OpenMetadataRelationship> relationships) {
        this.relationships = relationships;
    }

    public String getMermaidGraph() {
        return this.mermaidGraph;
    }

    public void setMermaidGraph(String mermaidGraph) {
        this.mermaidGraph = mermaidGraph;
    }

    @Override
    public String toString() {
        return "OpenMetadataElementGraph{anchoredElements=" + this.anchoredElements + ", relationships=" + this.relationships + ", mermaidGraph=" + this.mermaidGraph + "} " + super.toString();
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        OpenMetadataElementGraph that = (OpenMetadataElementGraph)objectToCompare;
        return Objects.equals(this.anchoredElements, that.anchoredElements) && Objects.equals(this.relationships, that.relationships) && Objects.equals(this.mermaidGraph, that.mermaidGraph);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.anchoredElements, this.relationships, this.mermaidGraph);
    }
}

