/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.integration.connectors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectionCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CatalogTarget;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyHelper;
import org.odpi.openmetadata.frameworks.integration.connectors.CatalogTargetChangeListener;
import org.odpi.openmetadata.frameworks.integration.connectors.CatalogTargetIntegrator;
import org.odpi.openmetadata.frameworks.integration.context.IntegrationContext;
import org.odpi.openmetadata.frameworks.integration.ffdc.OIFAuditCode;
import org.odpi.openmetadata.frameworks.integration.properties.RequestedCatalogTarget;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;

public class RequestedCatalogTargetsManager
implements CatalogTargetChangeListener {
    private final CatalogTargetMap currentCatalogTargetMap = new CatalogTargetMap();
    private final List<CatalogTargetChangeListener> registeredChangeListeners = new ArrayList<CatalogTargetChangeListener>();
    private final PropertyHelper propertyHelper = new PropertyHelper();
    private final Map<String, Object> connectorConfigProperties;
    private final String connectorName;
    private final AuditLog auditLog;

    public RequestedCatalogTargetsManager(Map<String, Object> connectorConfigProperties, String connectorName, AuditLog auditLog) {
        this.connectorConfigProperties = connectorConfigProperties != null ? new HashMap<String, Object>(connectorConfigProperties) : new HashMap<String, Object>();
        this.connectorName = connectorName;
        this.auditLog = auditLog;
    }

    private Map<String, Object> getCombinedConfigurationProperties(Map<String, Object> targetConfigProperties) {
        HashMap<String, Object> combinedConfigurationProperties = new HashMap<String, Object>(this.connectorConfigProperties);
        if (targetConfigProperties != null) {
            combinedConfigurationProperties.putAll(targetConfigProperties);
        }
        if (combinedConfigurationProperties.isEmpty()) {
            return null;
        }
        return combinedConfigurationProperties;
    }

    public List<RequestedCatalogTarget> refreshKnownCatalogTargets(IntegrationContext integrationContext, CatalogTargetIntegrator catalogTargetIntegrator) throws ConnectorCheckedException {
        String methodName = "refreshKnownCatalogTargets";
        try {
            int startFrom = 0;
            List<CatalogTarget> catalogTargetList = integrationContext.getCatalogTargets(startFrom, integrationContext.getMaxPageSize());
            while (catalogTargetList != null) {
                for (CatalogTarget catalogTarget : catalogTargetList) {
                    if (catalogTarget == null) continue;
                    RequestedCatalogTarget knownCatalogTarget = this.currentCatalogTargetMap.get(catalogTarget.getRelationshipGUID());
                    if (knownCatalogTarget == null) {
                        knownCatalogTarget = this.setUpNewRequestedCatalogTarget(catalogTargetIntegrator, catalogTarget, integrationContext);
                        this.newCatalogTarget(knownCatalogTarget);
                        continue;
                    }
                    if (knownCatalogTarget.getRelationshipVersions().equals(catalogTarget.getRelationshipVersions())) continue;
                    RequestedCatalogTarget oldCatalogTarget = knownCatalogTarget;
                    knownCatalogTarget = this.setUpNewRequestedCatalogTarget(catalogTargetIntegrator, catalogTarget, integrationContext);
                    this.updatedCatalogTarget(oldCatalogTarget, knownCatalogTarget);
                }
                catalogTargetList = integrationContext.getCatalogTargets(startFrom += integrationContext.getMaxPageSize(), integrationContext.getMaxPageSize());
            }
            return new ArrayList<RequestedCatalogTarget>(this.currentCatalogTargetMap.values());
        }
        catch (ConnectorCheckedException exception) {
            throw exception;
        }
        catch (Exception exception) {
            this.auditLog.logException("refreshKnownCatalogTargets", OIFAuditCode.GET_CATALOG_TARGET_EXCEPTION.getMessageDefinition(exception.getClass().getName(), this.connectorName, exception.getMessage()), exception);
            return null;
        }
    }

    private RequestedCatalogTarget setUpNewRequestedCatalogTarget(CatalogTargetIntegrator catalogTargetIntegrator, CatalogTarget retrievedCatalogTarget, IntegrationContext integrationContext) throws ConnectorCheckedException, InvalidParameterException, PropertyServerException, ConnectionCheckedException, UserNotAuthorizedException {
        Connector connectorToTarget = null;
        if (this.propertyHelper.isTypeOf(retrievedCatalogTarget.getCatalogTargetElement(), OpenMetadataType.ASSET.typeName)) {
            connectorToTarget = integrationContext.getConnectedAssetContext().getConnectorToAsset(retrievedCatalogTarget.getCatalogTargetElement().getGUID(), this.auditLog);
        }
        RequestedCatalogTarget newRequestedCatalogTarget = catalogTargetIntegrator.getNewRequestedCatalogTargetSkeleton(retrievedCatalogTarget, connectorToTarget);
        newRequestedCatalogTarget.setConfigurationProperties(this.getCombinedConfigurationProperties(retrievedCatalogTarget.getConfigurationProperties()));
        return newRequestedCatalogTarget;
    }

    public List<RequestedCatalogTarget> getRequestedCatalogTargets() {
        return this.currentCatalogTargetMap.values();
    }

    void registerCatalogTargetChangeListener(CatalogTargetChangeListener listener) {
        if (listener != null) {
            this.registeredChangeListeners.add(listener);
        }
    }

    @Override
    public void newCatalogTarget(RequestedCatalogTarget catalogTarget) {
        String methodName = "newCatalogTarget";
        this.currentCatalogTargetMap.put(catalogTarget);
        for (CatalogTargetChangeListener listener : this.registeredChangeListeners) {
            listener.newCatalogTarget(catalogTarget);
        }
        this.startConnector(catalogTarget, "newCatalogTarget");
    }

    @Override
    public void updatedCatalogTarget(RequestedCatalogTarget oldCatalogTarget, RequestedCatalogTarget newCatalogTarget) {
        String methodName = "updatedCatalogTarget";
        this.disconnectConnector(oldCatalogTarget, "updatedCatalogTarget");
        this.currentCatalogTargetMap.put(newCatalogTarget);
        for (CatalogTargetChangeListener listener : this.registeredChangeListeners) {
            listener.updatedCatalogTarget(oldCatalogTarget, newCatalogTarget);
        }
        this.startConnector(newCatalogTarget, "updatedCatalogTarget");
    }

    @Override
    public void removedCatalogTarget(RequestedCatalogTarget catalogTarget) {
        String methodName = "removedCatalogTarget";
        this.disconnectConnector(catalogTarget, "removedCatalogTarget");
        this.currentCatalogTargetMap.remove(catalogTarget.getRelationshipGUID());
        for (CatalogTargetChangeListener listener : this.registeredChangeListeners) {
            listener.removedCatalogTarget(catalogTarget);
        }
    }

    private void startConnector(RequestedCatalogTarget catalogTarget, String methodName) {
        if (catalogTarget.getCatalogTargetConnector() != null) {
            try {
                catalogTarget.getCatalogTargetConnector().start();
            }
            catch (Exception error) {
                this.auditLog.logMessage(methodName, OIFAuditCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), catalogTarget.getCatalogTargetName(), error.getMessage()));
            }
        }
    }

    private void disconnectConnector(RequestedCatalogTarget catalogTarget, String methodName) {
        if (catalogTarget != null && catalogTarget.getCatalogTargetConnector() != null) {
            try {
                catalogTarget.getCatalogTargetConnector().disconnect();
            }
            catch (Exception error) {
                this.auditLog.logMessage(methodName, OIFAuditCode.DISCONNECT_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), catalogTarget.getCatalogTargetName(), error.getMessage()));
            }
        }
    }

    public void disconnect() throws ConnectorCheckedException {
        for (RequestedCatalogTarget catalogTarget : this.currentCatalogTargetMap.values()) {
            if (catalogTarget.getCatalogTargetConnector() == null) continue;
            catalogTarget.getCatalogTargetConnector().disconnect();
        }
    }

    static class CatalogTargetMap {
        private final Map<String, RequestedCatalogTarget> currentCatalogTargetMap = new HashMap<String, RequestedCatalogTarget>();

        CatalogTargetMap() {
        }

        synchronized void put(RequestedCatalogTarget requestedCatalogTarget) {
            this.currentCatalogTargetMap.put(requestedCatalogTarget.getRelationshipGUID(), requestedCatalogTarget);
        }

        synchronized RequestedCatalogTarget get(String relationshipGUID) {
            return this.currentCatalogTargetMap.get(relationshipGUID);
        }

        synchronized List<RequestedCatalogTarget> values() {
            return new ArrayList<RequestedCatalogTarget>(this.currentCatalogTargetMap.values());
        }

        synchronized void remove(String relationshipGUID) {
            this.currentCatalogTargetMap.remove(relationshipGUID);
        }
    }
}

