/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.enums;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import org.odpi.openmetadata.frameworks.openmetadata.enums.OpenMetadataEnum;
import org.odpi.openmetadata.frameworks.openmetadata.mapper.OpenMetadataValidValues;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public enum ConfidenceLevel implements OpenMetadataEnum
{
    UNCLASSIFIED(0, "960c2b75-3126-41c2-97b7-351ac6526f90", "Unclassified", "There is no assessment of the confidence level for this data.", true),
    AD_HOC(1, "db29afb9-1758-4589-97e8-94c4a4c6f2bc", "Ad Hoc", "The data comes from an ad hoc process.", false),
    TRANSACTIONAL(2, "efa85f15-f3b3-43ae-ad24-d2918aa18d68", "Transactional", "The data comes from a transactional system so it may have a narrow scope.", false),
    AUTHORITATIVE(3, "1739e5af-c810-437d-8c7b-98451fe85574", "Authoritative", "The data comes from an authoritative source. This is the best set of values.", false),
    DERIVED(4, "b631b7e3-3793-45bd-8ab6-ead3494a3cfe", "Derived", "The data is derived from other data through an analytical process.", false),
    OBSOLETE(5, "3f2a97ab-7276-4f92-b194-7ca215d6daa6", "Obsolete", "The data comes from an obsolete source and must no longer be used.", false),
    OTHER(99, "dcfe3806-3a55-445e-995c-eb3db9ac59a5", "Other", "Another classification assignment status.", false);

    private static final String ENUM_TYPE_GUID = "ae846797-d88a-4421-ad9a-318bf7c1fe6f";
    private static final String ENUM_TYPE_NAME = "ConfidenceLevel";
    private static final String ENUM_DESCRIPTION = "Defines the level of confidence to place in the accuracy of a data item.";
    private static final String ENUM_DESCRIPTION_GUID = "1f7a3730-8471-496b-a6e5-21eac7bb3b98";
    private static final String ENUM_DESCRIPTION_WIKI = "https://egeria-project.org/types/4/0421-Governance-Classification-Levels/";
    private final String descriptionGUID;
    private final int ordinal;
    private final String name;
    private final String description;
    private final boolean isDefault;

    private ConfidenceLevel(int ordinal, String descriptionGUID, String name, String description, boolean isDefault) {
        this.ordinal = ordinal;
        this.name = name;
        this.descriptionGUID = descriptionGUID;
        this.description = description;
        this.isDefault = isDefault;
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getDescriptionGUID() {
        return this.descriptionGUID;
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    public static String getOpenTypeGUID() {
        return ENUM_TYPE_GUID;
    }

    public static String getOpenTypeName() {
        return ENUM_TYPE_NAME;
    }

    public static String getOpenTypeDescription() {
        return ENUM_DESCRIPTION;
    }

    public static String getOpenTypeDescriptionGUID() {
        return ENUM_DESCRIPTION_GUID;
    }

    public static String getOpenTypeDescriptionWiki() {
        return ENUM_DESCRIPTION_WIKI;
    }

    public String getQualifiedName() {
        return OpenMetadataValidValues.constructValidValueQualifiedName(ENUM_TYPE_NAME, OpenMetadataProperty.CONFIDENCE_LEVEL_IDENTIFIER.name, null, this.name);
    }

    public String getCategory() {
        return OpenMetadataValidValues.constructValidValueCategory(ENUM_TYPE_NAME, OpenMetadataProperty.CONFIDENCE_LEVEL_IDENTIFIER.name, null);
    }

    public String toString() {
        return "ConfidenceLevel{name='" + this.name + "}";
    }
}

