/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.enums;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import org.odpi.openmetadata.frameworks.openmetadata.enums.OpenMetadataEnum;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public enum IncidentReportStatus implements OpenMetadataEnum
{
    RAISED("24b49c38-b1dc-4c2a-9ffb-f475dcfc1568", 0, "Raised", "The incident report has been raised but no processing has occurred.", false),
    REVIEWED("174869e9-6741-4302-9229-ce5c8cbd8512", 1, "Reviewed", "The incident report has been reviewed, possibly classified but no action has been taken.", false),
    VALIDATED("b646cc66-953b-4797-a177-6b0bd91f6a09", 2, "Validated", "The incident report records a valid incident and work is underway to resolve it.", false),
    RESOLVED("5987fe10-73bd-493d-8c9d-25bfc600b105", 3, "Resolved", "The reported incident has been resolved.", false),
    INVALID("d99a85d6-d6d8-45fa-9e24-01e9d2aed251", 4, "Invalid", "The incident report does not describe a valid incident and has been closed.", false),
    IGNORED("52013732-b5b4-4b85-98e1-9b58ca1cd710", 10, "Ignored", "The incident report is valid but has been closed with no action.", false),
    OTHER("7555a3f3-9f44-4c7a-9426-51dbb628108e", 99, "Other", "\"Another incident report status.", false);

    private static final String ENUM_TYPE_GUID = "a9d4f64b-fa24-4eb8-8bf6-308926ef2c14";
    private static final String ENUM_TYPE_NAME = "IncidentReportStatus";
    private static final String ENUM_DESCRIPTION = "Defines the status of an incident report.";
    private static final String ENUM_DESCRIPTION_GUID = "f04543aa-3623-4ad6-af4a-cca56e6eaae5";
    private static final String ENUM_DESCRIPTION_WIKI = "https://egeria-project.org/types/4/0470-Incident-Reporting/";
    private final String descriptionGUID;
    private final int ordinal;
    private final String name;
    private final String description;
    private final boolean isDefault;

    private IncidentReportStatus(String descriptionGUID, int ordinal, String name, String description, boolean isDefault) {
        this.ordinal = ordinal;
        this.name = name;
        this.descriptionGUID = descriptionGUID;
        this.description = description;
        this.isDefault = isDefault;
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getDescriptionGUID() {
        return this.descriptionGUID;
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    public static String getOpenTypeGUID() {
        return ENUM_TYPE_GUID;
    }

    public static String getOpenTypeName() {
        return ENUM_TYPE_NAME;
    }

    public static String getOpenTypeDescription() {
        return ENUM_DESCRIPTION;
    }

    public static String getOpenTypeDescriptionGUID() {
        return ENUM_DESCRIPTION_GUID;
    }

    public static String getOpenTypeDescriptionWiki() {
        return ENUM_DESCRIPTION_WIKI;
    }

    public String toString() {
        return "IncidentReportStatus{" + this.name + "}";
    }
}

