/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.enums;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import org.odpi.openmetadata.frameworks.openmetadata.enums.OpenMetadataEnum;
import org.odpi.openmetadata.frameworks.openmetadata.mapper.OpenMetadataValidValues;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public enum PortType implements OpenMetadataEnum
{
    INPUT_PORT("dbca8005-949d-4cc9-bc5f-f5aa66f09906", 0, "Input Port", "Data is passed into the process."),
    OUTPUT_PORT("e6182593-ce3c-43ca-9163-5300b57b5017", 1, "Output Port", "Data is produced by the process."),
    INOUT_PORT("59fcdb6c-b57a-46db-bb79-256ed9af0a67", 2, "Input-Output Port", "A request response interface is provided by the process."),
    OUTIN_PORT("4564ff30-68eb-46b6-8887-83d8575d19b6", 3, "Output-Input Port", "A request response call is made by the process."),
    OTHER("a3fa3fa4-8f25-408d-8093-f84619c2859e", 99, "Other", "None of the above.");

    private static final String ENUM_TYPE_GUID = "b57Fbce7-42ac-71D1-D6a6-9f62Cb7C6dc3";
    private static final String ENUM_TYPE_NAME = "PortType";
    private static final String ENUM_DESCRIPTION = "Descriptor for a port that indicates the direction that data is flowing.";
    private static final String ENUM_DESCRIPTION_GUID = "d5142643-0bc3-4a77-a1ec-1537db2fbe79";
    private static final String ENUM_DESCRIPTION_WIKI = "https://egeria-project.org/types/2/0217-Ports/";
    private final String descriptionGUID;
    private final int ordinal;
    private final String name;
    private final String description;

    private PortType(String descriptionGUID, int ordinal, String name, String description) {
        this.ordinal = ordinal;
        this.name = name;
        this.descriptionGUID = descriptionGUID;
        this.description = description;
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getDescriptionGUID() {
        return this.descriptionGUID;
    }

    @Override
    public boolean isDefault() {
        return false;
    }

    public static String getOpenTypeGUID() {
        return ENUM_TYPE_GUID;
    }

    public static String getOpenTypeName() {
        return ENUM_TYPE_NAME;
    }

    public static String getOpenTypeDescription() {
        return ENUM_DESCRIPTION;
    }

    public static String getOpenTypeDescriptionGUID() {
        return ENUM_DESCRIPTION_GUID;
    }

    public static String getOpenTypeDescriptionWiki() {
        return ENUM_DESCRIPTION_WIKI;
    }

    public String getQualifiedName() {
        return OpenMetadataValidValues.constructValidValueQualifiedName(ENUM_TYPE_NAME, OpenMetadataProperty.CONTAINMENT_TYPE.name, null, this.name);
    }

    public String getCategory() {
        return OpenMetadataValidValues.constructValidValueCategory(ENUM_TYPE_NAME, OpenMetadataProperty.PORT_TYPE.name, null);
    }

    public String toString() {
        return "PortType{" + this.name + "}";
    }
}

