/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.enums;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import org.odpi.openmetadata.frameworks.openmetadata.enums.OpenMetadataEnum;
import org.odpi.openmetadata.frameworks.openmetadata.mapper.OpenMetadataValidValues;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public enum ProcessContainmentType implements OpenMetadataEnum
{
    OWNED("b05e2d4b-91e3-479f-96cc-6bf32c27ab9f", 0, "Owned", "The parent process owns the child process in the relationship, such that if the parent is removed the child should also be removed. A child can have at most one such parent."),
    USED("b63ef91c-e496-40e3-85d0-eca4899b9980", 1, "Used", "The child process is simply used by the parent. A child process can have many such relationships to parents."),
    OTHER("5afd9a09-3215-4ed2-b005-add5888de74e", 99, "Other", "None of the above.");

    private static final String ENUM_TYPE_GUID = "1bb4b908-7983-4802-a2b5-91b095552ee9";
    private static final String ENUM_TYPE_NAME = "ProcessContainmentType";
    private static final String ENUM_DESCRIPTION = "The containment relationship between two processes: the parent and one of its children.";
    private static final String ENUM_DESCRIPTION_GUID = "bb3cd2b2-d3c9-449c-b2f7-39db7d217caf";
    private static final String ENUM_DESCRIPTION_WIKI = "https://egeria-project.org/types/2/0215-Software-Components/";
    private final String descriptionGUID;
    private final int ordinal;
    private final String name;
    private final String description;

    private ProcessContainmentType(String descriptionGUID, int ordinal, String name, String description) {
        this.ordinal = ordinal;
        this.name = name;
        this.descriptionGUID = descriptionGUID;
        this.description = description;
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getDescriptionGUID() {
        return this.descriptionGUID;
    }

    @Override
    public boolean isDefault() {
        return false;
    }

    public static String getOpenTypeGUID() {
        return ENUM_TYPE_GUID;
    }

    public static String getOpenTypeName() {
        return ENUM_TYPE_NAME;
    }

    public static String getOpenTypeDescription() {
        return ENUM_DESCRIPTION;
    }

    public static String getOpenTypeDescriptionGUID() {
        return ENUM_DESCRIPTION_GUID;
    }

    public static String getOpenTypeDescriptionWiki() {
        return ENUM_DESCRIPTION_WIKI;
    }

    public String getQualifiedName() {
        return OpenMetadataValidValues.constructValidValueQualifiedName(ENUM_TYPE_NAME, OpenMetadataProperty.CONTAINMENT_TYPE.name, null, this.name);
    }

    public String getCategory() {
        return OpenMetadataValidValues.constructValidValueCategory(ENUM_TYPE_NAME, OpenMetadataProperty.CONTAINMENT_TYPE.name, null);
    }

    public String toString() {
        return "ProcessContainmentType{codeName='" + this.name + "'}";
    }
}

