/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.properties.governance;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Date;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.openmetadata.properties.governance.GovernanceClassificationBase;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class RetentionClassificationProperties
extends GovernanceClassificationBase {
    private int retentionBasis = 0;
    private String associatedGUID = null;
    private Date archiveAfter = null;
    private Date deleteAfter = null;

    public RetentionClassificationProperties() {
    }

    public RetentionClassificationProperties(RetentionClassificationProperties template) {
        super(template);
        if (template != null) {
            this.retentionBasis = template.getRetentionBasis();
            this.associatedGUID = template.getAssociatedGUID();
            this.archiveAfter = template.getArchiveAfter();
            this.deleteAfter = template.getDeleteAfter();
        }
    }

    public int getRetentionBasis() {
        return this.retentionBasis;
    }

    public void setRetentionBasis(int retentionBasis) {
        this.retentionBasis = retentionBasis;
    }

    public String getAssociatedGUID() {
        return this.associatedGUID;
    }

    public void setAssociatedGUID(String associatedGUID) {
        this.associatedGUID = associatedGUID;
    }

    public Date getArchiveAfter() {
        return this.archiveAfter;
    }

    public void setArchiveAfter(Date archiveAfter) {
        this.archiveAfter = archiveAfter;
    }

    public Date getDeleteAfter() {
        return this.deleteAfter;
    }

    public void setDeleteAfter(Date deleteAfter) {
        this.deleteAfter = deleteAfter;
    }

    @Override
    public String toString() {
        return "RetentionClassificationProperties{retentionBasis=" + this.retentionBasis + ", associatedGUID='" + this.associatedGUID + "', archiveAfter=" + this.archiveAfter + ", deleteAfter=" + this.deleteAfter + ", status=" + this.getStatus() + ", confidence=" + this.getConfidence() + ", steward='" + this.getSteward() + "', source='" + this.getSource() + "', notes='" + this.getNotes() + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        RetentionClassificationProperties that = (RetentionClassificationProperties)objectToCompare;
        return this.retentionBasis == that.retentionBasis && Objects.equals(this.associatedGUID, that.associatedGUID) && Objects.equals(this.archiveAfter, that.archiveAfter) && Objects.equals(this.deleteAfter, that.deleteAfter);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.retentionBasis, this.associatedGUID, this.archiveAfter, this.deleteAfter);
    }
}

