/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.properties.security;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.openmetadata.properties.ClassificationProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class SecurityTagsProperties
extends ClassificationProperties {
    private List<String> securityLabels = null;
    private Map<String, Object> securityProperties = null;
    private Map<String, List<String>> accessGroups = null;

    public SecurityTagsProperties() {
    }

    public SecurityTagsProperties(SecurityTagsProperties template) {
        super(template);
        if (template != null) {
            this.securityLabels = template.getSecurityLabels();
            this.securityProperties = template.getSecurityProperties();
            this.accessGroups = template.getAccessGroups();
        }
    }

    public List<String> getSecurityLabels() {
        return this.securityLabels;
    }

    public void setSecurityLabels(List<String> securityLabels) {
        this.securityLabels = securityLabels;
    }

    public Map<String, Object> getSecurityProperties() {
        return this.securityProperties;
    }

    public void setSecurityProperties(Map<String, Object> securityProperties) {
        this.securityProperties = securityProperties;
    }

    public Map<String, List<String>> getAccessGroups() {
        return this.accessGroups;
    }

    public void setAccessGroups(Map<String, List<String>> accessGroups) {
        this.accessGroups = accessGroups;
    }

    @Override
    public String toString() {
        return "SecurityTagsProperties{securityLabels=" + this.securityLabels + ", securityProperties=" + this.securityProperties + ", accessGroups=" + this.accessGroups + "} " + super.toString();
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        SecurityTagsProperties that = (SecurityTagsProperties)objectToCompare;
        return Objects.equals(this.securityLabels, that.securityLabels) && Objects.equals(this.securityProperties, that.securityProperties) && Objects.equals(this.accessGroups, that.accessGroups);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.securityLabels, this.securityProperties, this.accessGroups);
    }
}

