/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.refdata;

import org.odpi.openmetadata.frameworks.openmetadata.mapper.OpenMetadataValidValues;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;

public enum ProjectHealth {
    NOT_STARTED("Not Started", "Project activity has not yet started.", "orange"),
    ON_TRACK("On Track", "The project activity is proceeding, consuming time and resources as anticipated, whilst making the planned amount of progress towards the desired deliverables.", "green"),
    AT_RISK("At Risk", "Some aspects of the project are beginning to deviate from either the planned schedule, or are not consuming time/resources as anticipated.  A small course correction is needed to bring it back on track.", "yellow"),
    OFF_TRACK("Off Track", "Work on the project is not making the expected amount of progress for the time and resources spent on it.  A major change needs to be made if the project is to be brought back on track.", "red"),
    NO_ACTIVITY("No Activity", "The project is no longer being worked on either because it completed successfully, or was cancelled, or put on hold.", "blue");

    private final String name;
    private final String description;
    private final String colour;

    private ProjectHealth(String name, String description, String colour) {
        this.name = name;
        this.description = description;
        this.colour = colour;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getColour() {
        return this.colour;
    }

    public String getQualifiedName() {
        return OpenMetadataValidValues.constructValidValueQualifiedName(null, OpenMetadataProperty.PROJECT_HEALTH.name, null, this.name);
    }

    public String getCategory() {
        return OpenMetadataValidValues.constructValidValueCategory(null, OpenMetadataProperty.PROJECT_HEALTH.name, null);
    }

    public String toString() {
        return "ProjectHealth{" + this.name + "}";
    }
}

