/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.surveyaction.controls;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.frameworks.surveyaction.controls.AnalysisStep;
import org.odpi.openmetadata.frameworks.surveyaction.controls.AnnotationType;
import org.odpi.openmetadata.frameworks.surveyaction.controls.AnnotationTypeType;
import org.odpi.openmetadata.frameworks.surveyaction.measurements.FileMetric;
import org.odpi.openmetadata.frameworks.surveyaction.measurements.SurveyMetric;

public enum SurveyFileAnnotationType implements AnnotationType
{
    MEASUREMENTS("Extract File Properties", OpenMetadataType.RESOURCE_MEASURE_ANNOTATION.typeName, AnalysisStep.MEASURE_RESOURCE, "Extract properties from the file.", "Extract the properties that visible through the standard File interface and classify the file using reference data.", FileMetric.getMetrics()),
    DERIVE_SCHEMA_FROM_DATA("Derive Schema From Data", OpenMetadataType.SCHEMA_ANALYSIS_ANNOTATION.typeName, AnalysisStep.SCHEMA_EXTRACTION, "Extract schema from column names and values.", "The schema is built using the values in the first line of the CSV file.  The survey action service will attempt to derive the type of data in each column based on the values stored. If this is not possible the type of the column is assumed to be string.", null);

    public final String name;
    public final String openMetadataTypeName;
    public final AnalysisStep analysisStep;
    public final String summary;
    public final String explanation;
    public final List<SurveyMetric> metrics;

    private SurveyFileAnnotationType(String name, String openMetadataTypeName, AnalysisStep analysisStep, String summary, String explanation, List<SurveyMetric> metrics) {
        this.name = name;
        this.openMetadataTypeName = openMetadataTypeName;
        this.analysisStep = analysisStep;
        this.summary = summary;
        this.explanation = explanation;
        this.metrics = metrics;
    }

    public static List<AnnotationTypeType> getCSVSurveyAnnotationTypeTypes() {
        ArrayList<AnnotationTypeType> annotationTypeTypes = new ArrayList<AnnotationTypeType>();
        for (SurveyFileAnnotationType atlasAnnotationType : SurveyFileAnnotationType.values()) {
            annotationTypeTypes.add(atlasAnnotationType.getAnnotationTypeType());
        }
        return annotationTypeTypes;
    }

    public static List<AnnotationTypeType> getFileSurveyAnnotationTypeTypes() {
        ArrayList<AnnotationTypeType> annotationTypeTypes = new ArrayList<AnnotationTypeType>();
        annotationTypeTypes.add(MEASUREMENTS.getAnnotationTypeType());
        return annotationTypeTypes;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getAnalysisStep() {
        return this.analysisStep.getName();
    }

    @Override
    public String getOpenMetadataTypeName() {
        return this.openMetadataTypeName;
    }

    @Override
    public String getSummary() {
        return this.summary;
    }

    @Override
    public String getExplanation() {
        return this.explanation;
    }

    @Override
    public String getExpression() {
        return null;
    }

    public AnnotationTypeType getAnnotationTypeType() {
        AnnotationTypeType annotationTypeType = new AnnotationTypeType();
        annotationTypeType.setName(this.name);
        annotationTypeType.setOpenMetadataTypeName(this.openMetadataTypeName);
        annotationTypeType.setAnalysisStepName(AnalysisStep.PROFILING_ASSOCIATED_RESOURCES.getName());
        annotationTypeType.setSummary(this.summary);
        annotationTypeType.setExplanation(this.explanation);
        if (this.metrics != null) {
            HashMap<String, String> metricsMap = new HashMap<String, String>();
            for (SurveyMetric folderMetric : this.metrics) {
                metricsMap.put(folderMetric.getDisplayName(), folderMetric.getDescription());
            }
            annotationTypeType.setOtherPropertyValues(metricsMap);
        }
        return annotationTypeType;
    }

    public String toString() {
        return "SurveyFileAnnotationType{ name='" + this.name + "}";
    }
}

