/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.surveyaction.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.surveyaction.properties.DataFieldAnnotation;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ClassificationAnnotation
extends DataFieldAnnotation {
    private Map<String, String> candidateClassifications = null;

    public ClassificationAnnotation() {
    }

    public ClassificationAnnotation(ClassificationAnnotation template) {
        super(template);
        if (template != null) {
            this.candidateClassifications = template.getCandidateClassifications();
        }
    }

    public Map<String, String> getCandidateClassifications() {
        return this.candidateClassifications;
    }

    public void setCandidateClassifications(Map<String, String> candidateClassifications) {
        this.candidateClassifications = candidateClassifications;
    }

    @Override
    public String toString() {
        return "ClassificationAnnotation{candidateClassifications=" + this.candidateClassifications + "} " + super.toString();
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        ClassificationAnnotation that = (ClassificationAnnotation)objectToCompare;
        return Objects.equals(this.candidateClassifications, that.candidateClassifications);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.candidateClassifications);
    }
}

