/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.opentypes;

import java.util.ArrayList;
import java.util.Date;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchive1_5;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttributeStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;

public class OpenMetadataTypesArchive1_6 {
    private static final String archiveGUID = "bce3b0a0-662a-4f87-b8dc-844078a11a6e";
    private static final String archiveName = "Open Metadata Types";
    private static final String archiveDescription = "Standard types for open metadata repositories.";
    private static final OpenMetadataArchiveType archiveType = OpenMetadataArchiveType.CONTENT_PACK;
    private static final String archiveVersion = "1.6";
    private static final String originatorName = "ODPi Egeria";
    private static final String originatorLicense = "Apache-2.0";
    private static final Date creationDate = new Date(1516313040008L);
    private static final long versionNumber = 1L;
    private static final String versionName = "1.0";
    private OMRSArchiveBuilder archiveBuilder;
    private OMRSArchiveHelper archiveHelper;

    public OpenMetadataTypesArchive1_6() {
        this.archiveBuilder = new OMRSArchiveBuilder(archiveGUID, archiveName, archiveDescription, archiveType, archiveVersion, originatorName, originatorLicense, creationDate, null);
        this.archiveHelper = new OMRSArchiveHelper(this.archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public OpenMetadataTypesArchive1_6(OMRSArchiveBuilder archiveBuilder) {
        this.archiveBuilder = archiveBuilder;
        this.archiveHelper = new OMRSArchiveHelper(archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public String getArchiveGUID() {
        return archiveGUID;
    }

    public OpenMetadataArchive getOpenMetadataArchive() {
        String methodName = "getOpenMetadataArchive";
        if (this.archiveBuilder != null) {
            this.getOriginalTypes();
            return this.archiveBuilder.getOpenMetadataArchive();
        }
        throw new OMRSLogicErrorException(OMRSErrorCode.ARCHIVE_UNAVAILABLE.getMessageDefinition(), this.getClass().getName(), "getOpenMetadataArchive");
    }

    public void getOriginalTypes() {
        OpenMetadataTypesArchive1_5 previousTypes = new OpenMetadataTypesArchive1_5(this.archiveBuilder);
        previousTypes.getOriginalTypes();
        this.update0501SchemaElements();
        this.update0505SchemaAttributes();
        this.update0512DerivedSchemaAttributes();
    }

    private void update0501SchemaElements() {
        this.archiveBuilder.addTypeDefPatch(this.updateSchemaElementEntity());
    }

    private TypeDefPatch updateSchemaElementEntity() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.SCHEMA_ELEMENT.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "isDeprecated";
        String attribute1Description = "This element may still be used but is flagged that it will be removed at some point in the future.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getBooleanTypeDefAttribute("isDeprecated", "This element may still be used but is flagged that it will be removed at some point in the future.", attribute1DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update0505SchemaAttributes() {
        this.archiveBuilder.addTypeDefPatch(this.updateSchemaAttributeEntity());
        this.archiveBuilder.addTypeDefPatch(this.updateTypeEmbeddedAttributeClassification());
    }

    private TypeDefPatch updateSchemaAttributeEntity() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.SCHEMA_ATTRIBUTE.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "minimumLength";
        String attribute1Description = "Minimum length of the data value (zero means unlimited).";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "length";
        String attribute2Description = "Length of the data field (zero means unlimited).";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "significantDigits";
        String attribute3Description = "Number of significant digits before the decimal point (zero means it is an integer).";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "isNullable";
        String attribute4Description = "Accepts null values or not.";
        String attribute4DescriptionGUID = null;
        String attribute6Name = "cardinality";
        String attribute6Description = "Number of occurrences of this attribute allowed (deprecated).";
        String attribute6DescriptionGUID = null;
        String attribute6ReplacedBy = "maxCardinality";
        TypeDefAttribute property = this.archiveHelper.getIntTypeDefAttribute("minimumLength", "Minimum length of the data value (zero means unlimited).", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getIntTypeDefAttribute("length", "Length of the data field (zero means unlimited).", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getIntTypeDefAttribute("significantDigits", "Number of significant digits before the decimal point (zero means it is an integer).", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getBooleanTypeDefAttribute("isNullable", "Accepts null values or not.", attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("cardinality", "Number of occurrences of this attribute allowed (deprecated).", attribute6DescriptionGUID);
        property.setReplacedByAttribute("maxCardinality");
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.NAME.name, OpenMetadataProperty.NAME.description, OpenMetadataProperty.NAME.descriptionGUID);
        property.setReplacedByAttribute(OpenMetadataProperty.DISPLAY_NAME.name);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateTypeEmbeddedAttributeClassification() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.TYPE_EMBEDDED_ATTRIBUTE_CLASSIFICATION.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "schemaTypeName";
        String attribute1Description = "Type name for the schema type.";
        String attribute1DescriptionGUID = null;
        String attribute5Name = "versionNumber";
        String attribute5Description = "Version of the schema type.";
        String attribute5DescriptionGUID = null;
        String attribute6Name = "author";
        String attribute6Description = "User name of the person or process that created the schema type.";
        String attribute6DescriptionGUID = null;
        String attribute8Name = "defaultValue";
        String attribute8Description = "Initial value for data stored in this schema type (primitive and enum types).";
        String attribute8DescriptionGUID = null;
        String attribute9Name = "fixedValue";
        String attribute9Description = "Fixed value for data stored in this schema type (literal schema type).";
        String attribute9DescriptionGUID = null;
        String attribute11Name = "isDeprecated";
        String attribute11Description = "This element may still be used but is flagged that it will be removed at some point in the future.";
        String attribute11DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("schemaTypeName", "Type name for the schema type.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.QUALIFIED_NAME.name, OpenMetadataProperty.QUALIFIED_NAME.description, OpenMetadataProperty.QUALIFIED_NAME.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.DISPLAY_NAME.name, OpenMetadataProperty.DISPLAY_NAME.description, OpenMetadataProperty.DISPLAY_NAME.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.DESCRIPTION.name, OpenMetadataProperty.DESCRIPTION.description, OpenMetadataProperty.DESCRIPTION.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("versionNumber", "Version of the schema type.", attribute5DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("author", "User name of the person or process that created the schema type.", attribute6DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.USAGE.name, OpenMetadataProperty.USAGE.description, OpenMetadataProperty.USAGE.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("defaultValue", "Initial value for data stored in this schema type (primitive and enum types).", attribute8DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("fixedValue", "Fixed value for data stored in this schema type (literal schema type).", attribute9DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringStringTypeDefAttribute(OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, OpenMetadataProperty.ADDITIONAL_PROPERTIES.description, OpenMetadataProperty.ADDITIONAL_PROPERTIES.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getBooleanTypeDefAttribute("isDeprecated", "This element may still be used but is flagged that it will be removed at some point in the future.", attribute11DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update0512DerivedSchemaAttributes() {
        this.archiveBuilder.addTypeDefPatch(this.updateDerivedSchemaAttributeEntity());
    }

    private TypeDefPatch updateDerivedSchemaAttributeEntity() {
        String typeName = "DerivedSchemaAttribute";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("DerivedSchemaAttribute");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "comment";
        String attribute1Description = "Comment from source system (deprecated).";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "id";
        String attribute2Description = "Id of derived schema attribute (deprecated).";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "aggregatingFunction";
        String attribute3Description = "Aggregating function of derived schema attribute (deprecated).";
        String attribute3DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("comment", "Comment from source system (deprecated).", attribute1DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("id", "Id of derived schema attribute (deprecated).", attribute2DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("aggregatingFunction", "Aggregating function of derived schema attribute (deprecated).", attribute3DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }
}

