/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.opentypes;

import java.util.ArrayList;
import java.util.Date;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchive2_4;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationPropagationRule;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumElementDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndCardinality;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefLink;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefStatus;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;

public class OpenMetadataTypesArchive2_5 {
    private static final String archiveGUID = "bce3b0a0-662a-4f87-b8dc-844078a11a6e";
    private static final String archiveName = "Open Metadata Types";
    private static final String archiveDescription = "Standard types for open metadata repositories.";
    private static final OpenMetadataArchiveType archiveType = OpenMetadataArchiveType.CONTENT_PACK;
    private static final String archiveVersion = "2.5";
    private static final String originatorName = "ODPi Egeria";
    private static final String originatorLicense = "Apache-2.0";
    private static final Date creationDate = new Date(1588261366992L);
    private static final long versionNumber = 1L;
    private static final String versionName = "1.0";
    private final OMRSArchiveBuilder archiveBuilder;
    private final OMRSArchiveHelper archiveHelper;

    public OpenMetadataTypesArchive2_5() {
        this.archiveBuilder = new OMRSArchiveBuilder(archiveGUID, archiveName, archiveDescription, archiveType, archiveVersion, originatorName, originatorLicense, creationDate, null);
        this.archiveHelper = new OMRSArchiveHelper(this.archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public OpenMetadataTypesArchive2_5(OMRSArchiveBuilder archiveBuilder) {
        this.archiveBuilder = archiveBuilder;
        this.archiveHelper = new OMRSArchiveHelper(archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public String getArchiveGUID() {
        return archiveGUID;
    }

    public OpenMetadataArchive getOpenMetadataArchive() {
        String methodName = "getOpenMetadataArchive";
        if (this.archiveBuilder != null) {
            this.getOriginalTypes();
            return this.archiveBuilder.getOpenMetadataArchive();
        }
        throw new OMRSLogicErrorException(OMRSErrorCode.ARCHIVE_UNAVAILABLE.getMessageDefinition(), this.getClass().getName(), "getOpenMetadataArchive");
    }

    public void getOriginalTypes() {
        OpenMetadataTypesArchive2_4 previousTypes = new OpenMetadataTypesArchive2_4(this.archiveBuilder);
        previousTypes.getOriginalTypes();
        this.update0010BaseEntity();
        this.update0017ExternalIdentifiers();
        this.add0056AssetManager();
        this.add0395SupplementaryProperties();
        this.update0750DataPassing();
        this.update0770LineageMapping();
    }

    private void update0010BaseEntity() {
        this.archiveBuilder.addEntityDef(this.addOpenMetadataRootEntity());
        this.archiveBuilder.addTypeDefPatch(this.updateReferenceable());
        this.archiveBuilder.addTypeDefPatch(this.updateSearchKeyword());
        this.archiveBuilder.addTypeDefPatch(this.updateLike());
        this.archiveBuilder.addTypeDefPatch(this.updateRating());
        this.archiveBuilder.addTypeDefPatch(this.updateInformalTag());
        this.archiveBuilder.addTypeDefPatch(this.updateAnnotation());
        this.archiveBuilder.addTypeDefPatch(this.updateAnnotationReview());
        this.archiveBuilder.addTypeDefPatch(this.updateAnchorsClassification());
    }

    private EntityDef addOpenMetadataRootEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.OPEN_METADATA_ROOT, null);
    }

    private TypeDefPatch updateReferenceable() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.REFERENCEABLE.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setSuperType(this.archiveBuilder.getEntityDef(OpenMetadataType.OPEN_METADATA_ROOT.typeName));
        return typeDefPatch;
    }

    private TypeDefPatch updateSearchKeyword() {
        String typeName = "SearchKeyword";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("SearchKeyword");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setSuperType(this.archiveBuilder.getEntityDef(OpenMetadataType.OPEN_METADATA_ROOT.typeName));
        return typeDefPatch;
    }

    private TypeDefPatch updateLike() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.LIKE.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setSuperType(this.archiveBuilder.getEntityDef(OpenMetadataType.OPEN_METADATA_ROOT.typeName));
        return typeDefPatch;
    }

    private TypeDefPatch updateRating() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.RATING.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setSuperType(this.archiveBuilder.getEntityDef(OpenMetadataType.OPEN_METADATA_ROOT.typeName));
        return typeDefPatch;
    }

    private TypeDefPatch updateInformalTag() {
        String typeName = "InformalTag";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("InformalTag");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setSuperType(this.archiveBuilder.getEntityDef(OpenMetadataType.OPEN_METADATA_ROOT.typeName));
        return typeDefPatch;
    }

    private TypeDefPatch updateAnnotation() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.ANNOTATION.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setSuperType(this.archiveBuilder.getEntityDef(OpenMetadataType.OPEN_METADATA_ROOT.typeName));
        return typeDefPatch;
    }

    private TypeDefPatch updateAnnotationReview() {
        String typeName = "AnnotationReview";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("AnnotationReview");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setSuperType(this.archiveBuilder.getEntityDef(OpenMetadataType.OPEN_METADATA_ROOT.typeName));
        return typeDefPatch;
    }

    private TypeDefPatch updateAnchorsClassification() {
        String typeName = OpenMetadataType.ANCHORS_CLASSIFICATION.typeName;
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefLink> linkedToEntities = new ArrayList<TypeDefLink>();
        linkedToEntities.add(this.archiveBuilder.getEntityDef(OpenMetadataType.OPEN_METADATA_ROOT.typeName));
        typeDefPatch.setValidEntityDefs(linkedToEntities);
        return typeDefPatch;
    }

    private void update0017ExternalIdentifiers() {
        this.archiveBuilder.addEnumDef(this.getPermittedSynchronizationEnum());
        this.archiveBuilder.addTypeDefPatch(this.updateExternalIdScopeRelationship());
        this.archiveBuilder.addTypeDefPatch(this.updateExternalIdLinkRelationship());
    }

    private EnumDef getPermittedSynchronizationEnum() {
        String guid = "973a9f4c-93fa-43a5-a0c5-d97dbd164e78";
        String name = "PermittedSynchronization";
        String description = "Defines the synchronization rules between a third party technology and open metadata.";
        String descriptionGUID = null;
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef("973a9f4c-93fa-43a5-a0c5-d97dbd164e78", "PermittedSynchronization", "Defines the synchronization rules between a third party technology and open metadata.", descriptionGUID);
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        boolean element1Ordinal = false;
        String element1Value = "BothDirections";
        String element1Description = "Metadata exchange is permitted in both directions.";
        String element1DescriptionGUID = null;
        EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(0, "BothDirections", "Metadata exchange is permitted in both directions.", element1DescriptionGUID);
        elementDefs.add(elementDef);
        boolean element2Ordinal = true;
        String element2Value = "ToThirdParty";
        String element2Description = "The third party technology is logically downstream of open metadata and is just receiving metadata.";
        String element2DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(1, "ToThirdParty", "The third party technology is logically downstream of open metadata and is just receiving metadata.", element2DescriptionGUID);
        elementDefs.add(elementDef);
        int element3Ordinal = 2;
        String element3Value = "FromThirdParty";
        String element3Description = "The third party technology is logically upstream and is publishing metadata to open metadata.";
        String element3DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(2, "FromThirdParty", "The third party technology is logically upstream and is publishing metadata to open metadata.", element3DescriptionGUID);
        elementDefs.add(elementDef);
        int element8Ordinal = 99;
        String element8Value = "Other";
        String element8Description = "Another synchronization rule.";
        String element8DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(99, "Other", "Another synchronization rule.", element8DescriptionGUID);
        elementDefs.add(elementDef);
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private TypeDefPatch updateExternalIdScopeRelationship() {
        String typeName = OpenMetadataType.EXTERNAL_ID_SCOPE_RELATIONSHIP.typeName;
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.PERMITTED_SYNCHRONIZATION.name;
        String attribute1Description = OpenMetadataProperty.PERMITTED_SYNCHRONIZATION.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.PERMITTED_SYNCHRONIZATION.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getEnumTypeDefAttribute(OpenMetadataProperty.PERMITTED_SYNCHRONIZATION.type, attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.DESCRIPTION.name, OpenMetadataProperty.DESCRIPTION.description, OpenMetadataProperty.DESCRIPTION.descriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateExternalIdLinkRelationship() {
        String typeName = OpenMetadataType.EXTERNAL_ID_LINK_RELATIONSHIP.typeName;
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        String end1AttributeName = "resources";
        String end1AttributeDescription = "Resource being identified.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.OPEN_METADATA_ROOT.typeName), "resources", "Resource being identified.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        typeDefPatch.setEndDef1(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.LAST_SYNCHRONIZED.name;
        String attribute1Description = OpenMetadataProperty.LAST_SYNCHRONIZED.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.LAST_SYNCHRONIZED.descriptionGUID;
        String attribute2Name = OpenMetadataProperty.MAPPING_PROPERTIES.name;
        String attribute2Description = OpenMetadataProperty.MAPPING_PROPERTIES.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.MAPPING_PROPERTIES.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getDateTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringStringTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void add0056AssetManager() {
        this.archiveBuilder.addClassificationDef(this.addAssetManagerClassification());
    }

    private ClassificationDef addAssetManagerClassification() {
        return this.archiveHelper.getClassificationDef(OpenMetadataType.ASSET_MANAGER.typeGUID, OpenMetadataType.ASSET_MANAGER.typeName, null, OpenMetadataType.ASSET_MANAGER.description, OpenMetadataType.ASSET_MANAGER.descriptionGUID, OpenMetadataType.ASSET_MANAGER.wikiURL, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), false);
    }

    private void add0395SupplementaryProperties() {
        this.archiveBuilder.addClassificationDef(this.addElementSupplementClassification());
        this.archiveBuilder.addRelationshipDef(this.getSupplementaryPropertiesRelationship());
    }

    private ClassificationDef addElementSupplementClassification() {
        String guid = "58520015-ce6e-47b7-a1fd-864030544819";
        String name = "ElementSupplement";
        String description = "Identifies a glossary term that is being used to supplement asset descriptions.";
        String descriptionGUID = null;
        return this.archiveHelper.getClassificationDef("58520015-ce6e-47b7-a1fd-864030544819", "ElementSupplement", null, "Identifies a glossary term that is being used to supplement asset descriptions.", descriptionGUID, this.archiveBuilder.getEntityDef(OpenMetadataType.GLOSSARY_TERM.typeName), false);
    }

    private RelationshipDef getSupplementaryPropertiesRelationship() {
        String guid = "2bb10ba5-7aa2-456a-8b3a-8fdbd75c95cd";
        String name = "SupplementaryProperties";
        String description = "Provides additional descriptive properties to augment technical metadata extracted from a third party technology.";
        String descriptionGUID = null;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("2bb10ba5-7aa2-456a-8b3a-8fdbd75c95cd", "SupplementaryProperties", null, "Provides additional descriptive properties to augment technical metadata extracted from a third party technology.", descriptionGUID, ClassificationPropagationRule.NONE);
        String end1AttributeName = "supplementsElement";
        String end1AttributeDescription = "Describes this technical element.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "supplementsElement", "Describes this technical element.", end1AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "supplementaryProperties";
        String end2AttributeDescription = "Provides more information about this element.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.GLOSSARY_TERM.typeName), "supplementaryProperties", "Provides more information about this element.", end2AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void update0750DataPassing() {
        this.archiveBuilder.addTypeDefPatch(this.deprecateProcessInputRelationship());
        this.archiveBuilder.addTypeDefPatch(this.deprecateProcessOutputRelationship());
        this.archiveBuilder.addTypeDefPatch(this.updateProcessCallRelationship());
        this.archiveBuilder.addRelationshipDef(this.addDataFlowRelationship());
        this.archiveBuilder.addRelationshipDef(this.addControlFlowRelationship());
    }

    private TypeDefPatch deprecateProcessInputRelationship() {
        String typeName = "ProcessInput";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("ProcessInput");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setTypeDefStatus(TypeDefStatus.DEPRECATED_TYPEDEF);
        return typeDefPatch;
    }

    private TypeDefPatch deprecateProcessOutputRelationship() {
        String typeName = "ProcessInput";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("ProcessInput");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setTypeDefStatus(TypeDefStatus.DEPRECATED_TYPEDEF);
        return typeDefPatch;
    }

    private TypeDefPatch updateProcessCallRelationship() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.PROCESS_CALL.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setDescription(OpenMetadataType.PROCESS_CALL.description);
        String end1AttributeName = "caller";
        String end1AttributeDescription = "Call originator.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "caller", "Call originator.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        typeDefPatch.setEndDef1(relationshipEndDef);
        String end2AttributeName = "called";
        String end2AttributeDescription = "Called element that performs the processing.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "called", "Called element that performs the processing.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        typeDefPatch.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.QUALIFIED_NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.FORMULA));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private RelationshipDef addDataFlowRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.DATA_FLOW, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "dataSupplier";
        String end1AttributeDescription = "Caller element.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "dataSupplier", "Caller element.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "dataConsumer";
        String end2AttributeDescription = "Called element.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "dataConsumer", "Called element.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.QUALIFIED_NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.FORMULA));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef addControlFlowRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.CONTROL_FLOW, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "currentStep";
        String end1AttributeDescription = "Element that executes first.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "currentStep", "Element that executes first.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "nextStep";
        String end2AttributeDescription = "Element that executes next.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "nextStep", "Element that executes next.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.QUALIFIED_NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.GUARD));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void update0770LineageMapping() {
        this.archiveBuilder.addTypeDefPatch(this.updateLineageMappingRelationship());
    }

    private TypeDefPatch updateLineageMappingRelationship() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.LINEAGE_MAPPING.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        String end1AttributeName = "sourceElement";
        String end1AttributeDescription = "Source Attribute.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "sourceElement", "Source Attribute.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        typeDefPatch.setEndDef1(relationshipEndDef);
        String end2AttributeName = "targetElement";
        String end2AttributeDescription = "Target Attribute.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "targetElement", "Target Attribute.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        typeDefPatch.setEndDef2(relationshipEndDef);
        return typeDefPatch;
    }
}

