/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.opentypes;

import java.util.ArrayList;
import java.util.Date;
import org.odpi.openmetadata.frameworks.openmetadata.enums.CriticalityLevel;
import org.odpi.openmetadata.frameworks.openmetadata.enums.EngineActionStatus;
import org.odpi.openmetadata.frameworks.openmetadata.enums.GovernanceClassificationStatus;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ImpactSeverity;
import org.odpi.openmetadata.frameworks.openmetadata.enums.IncidentReportStatus;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchive2_5;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationPropagationRule;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumElementDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndCardinality;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;

public class OpenMetadataTypesArchive2_6 {
    private static final String archiveGUID = "bce3b0a0-662a-4f87-b8dc-844078a11a6e";
    private static final String archiveName = "Open Metadata Types";
    private static final String archiveDescription = "Standard types for open metadata repositories.";
    private static final OpenMetadataArchiveType archiveType = OpenMetadataArchiveType.CONTENT_PACK;
    private static final String archiveVersion = "2.6";
    private static final String originatorName = "ODPi Egeria";
    private static final String originatorLicense = "Apache-2.0";
    private static final Date creationDate = new Date(1588261366992L);
    private static final long versionNumber = 1L;
    private static final String versionName = "1.0";
    private final OMRSArchiveBuilder archiveBuilder;
    private final OMRSArchiveHelper archiveHelper;

    public OpenMetadataTypesArchive2_6() {
        this.archiveBuilder = new OMRSArchiveBuilder(archiveGUID, archiveName, archiveDescription, archiveType, archiveVersion, originatorName, originatorLicense, creationDate, null);
        this.archiveHelper = new OMRSArchiveHelper(this.archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public OpenMetadataTypesArchive2_6(OMRSArchiveBuilder archiveBuilder) {
        this.archiveBuilder = archiveBuilder;
        this.archiveHelper = new OMRSArchiveHelper(archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public String getArchiveGUID() {
        return archiveGUID;
    }

    public OpenMetadataArchive getOpenMetadataArchive() {
        String methodName = "getOpenMetadataArchive";
        if (this.archiveBuilder != null) {
            this.getOriginalTypes();
            return this.archiveBuilder.getOpenMetadataArchive();
        }
        throw new OMRSLogicErrorException(OMRSErrorCode.ARCHIVE_UNAVAILABLE.getMessageDefinition(), this.getClass().getName(), "getOpenMetadataArchive");
    }

    public void getOriginalTypes() {
        OpenMetadataTypesArchive2_5 previousTypes = new OpenMetadataTypesArchive2_5(this.archiveBuilder);
        previousTypes.getOriginalTypes();
        this.update0010ManagingMemento();
        this.update0215MoreProcessTypes();
        this.update0422GovernanceActionClassifications();
        this.update0445GovernanceRoles();
        this.update0460GovernanceExecutionPoints();
        this.add0461GovernanceActionEngines();
        this.add0462GovernanceActionProcesses();
        this.add0463EngineActions();
        this.add0465DuplicateProcessing();
        this.add0470IncidentReports();
        this.add0550InstanceMetadata();
        this.update06xxDiscoveryEnginesAndServices();
    }

    private void update0010ManagingMemento() {
        this.archiveBuilder.addClassificationDef(this.addMementoClassification());
    }

    private ClassificationDef addMementoClassification() {
        String guid = OpenMetadataType.MEMENTO_CLASSIFICATION.typeGUID;
        String name = OpenMetadataType.MEMENTO_CLASSIFICATION.typeName;
        String description = OpenMetadataType.MEMENTO_CLASSIFICATION.description;
        String descriptionGUID = OpenMetadataType.MEMENTO_CLASSIFICATION.descriptionGUID;
        String descriptionWiki = OpenMetadataType.MEMENTO_CLASSIFICATION.wikiURL;
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef(guid, name, null, description, descriptionGUID, descriptionWiki, this.archiveBuilder.getEntityDef(OpenMetadataType.OPEN_METADATA_ROOT.typeName), true);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.ARCHIVE_DATE.name;
        String attribute1Description = OpenMetadataProperty.ARCHIVE_DATE.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.ARCHIVE_DATE.descriptionGUID;
        String attribute2Name = OpenMetadataProperty.ARCHIVE_USER.name;
        String attribute2Description = OpenMetadataProperty.ARCHIVE_USER.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.ARCHIVE_USER.descriptionGUID;
        String attribute3Name = OpenMetadataProperty.ARCHIVE_PROCESS.name;
        String attribute3Description = OpenMetadataProperty.ARCHIVE_PROCESS.description;
        String attribute3DescriptionGUID = OpenMetadataProperty.ARCHIVE_PROCESS.descriptionGUID;
        String attribute4Name = OpenMetadataProperty.ARCHIVE_SERVICE.name;
        String attribute4Description = OpenMetadataProperty.ARCHIVE_SERVICE.description;
        String attribute4DescriptionGUID = OpenMetadataProperty.ARCHIVE_SERVICE.descriptionGUID;
        String attribute5Name = OpenMetadataProperty.ARCHIVE_METHOD.name;
        String attribute5Description = OpenMetadataProperty.ARCHIVE_METHOD.description;
        String attribute5DescriptionGUID = OpenMetadataProperty.ARCHIVE_METHOD.descriptionGUID;
        String attribute6Name = OpenMetadataProperty.ARCHIVE_PROPERTIES.name;
        String attribute6Description = OpenMetadataProperty.ARCHIVE_PROPERTIES.description;
        String attribute6DescriptionGUID = OpenMetadataProperty.ARCHIVE_PROPERTIES.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getDateTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute3Name, attribute3Description, attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute4Name, attribute4Description, attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute5Name, attribute5Description, attribute5DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringStringTypeDefAttribute(attribute6Name, attribute6Description, attribute6DescriptionGUID);
        properties.add(property);
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private void update0215MoreProcessTypes() {
        this.archiveBuilder.addEntityDef(this.addEmbeddedProcessEntity());
        this.archiveBuilder.addEntityDef(this.addTransientEmbeddedProcessEntity());
    }

    private EntityDef addEmbeddedProcessEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.EMBEDDED_PROCESS.typeGUID, OpenMetadataType.EMBEDDED_PROCESS.typeName, this.archiveBuilder.getEntityDef(OpenMetadataType.PROCESS.typeName), OpenMetadataType.EMBEDDED_PROCESS.description, OpenMetadataType.EMBEDDED_PROCESS.descriptionGUID, OpenMetadataType.EMBEDDED_PROCESS.wikiURL);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        TypeDefAttribute property = this.archiveHelper.getDateTypeDefAttribute(OpenMetadataProperty.PROCESS_START_TIME.name, OpenMetadataProperty.PROCESS_START_TIME.description, OpenMetadataProperty.PROCESS_START_TIME.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getDateTypeDefAttribute(OpenMetadataProperty.PROCESS_END_TIME.name, OpenMetadataProperty.PROCESS_END_TIME.description, OpenMetadataProperty.PROCESS_END_TIME.descriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef addTransientEmbeddedProcessEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.TRANSIENT_EMBEDDED_PROCESS.typeGUID, OpenMetadataType.TRANSIENT_EMBEDDED_PROCESS.typeName, this.archiveBuilder.getEntityDef(OpenMetadataType.EMBEDDED_PROCESS.typeName), OpenMetadataType.TRANSIENT_EMBEDDED_PROCESS.description, OpenMetadataType.TRANSIENT_EMBEDDED_PROCESS.descriptionGUID, OpenMetadataType.TRANSIENT_EMBEDDED_PROCESS.wikiURL);
    }

    private void update0422GovernanceActionClassifications() {
        this.archiveBuilder.addEnumDef(this.getImpactSeverityEnum());
        this.archiveBuilder.addClassificationDef(this.addImpactClassification());
    }

    private EnumDef getImpactSeverityEnum() {
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef(ImpactSeverity.getOpenTypeGUID(), ImpactSeverity.getOpenTypeName(), ImpactSeverity.getOpenTypeDescription(), ImpactSeverity.getOpenTypeDescriptionGUID(), ImpactSeverity.getOpenTypeDescriptionWiki());
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        for (ImpactSeverity enumValues : ImpactSeverity.values()) {
            EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(enumValues.getOrdinal(), enumValues.getName(), enumValues.getDescription(), enumValues.getDescriptionGUID());
            elementDefs.add(elementDef);
            if (!enumValues.isDefault()) continue;
            enumDef.setDefaultValue(elementDef);
        }
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private ClassificationDef addImpactClassification() {
        String guid = "3a6c4ba7-3cc5-48cd-8952-a50a92da016d";
        String name = "Impact";
        String description = "Defines the severity of a situation on the attach entity.";
        String descriptionGUID = null;
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef("3a6c4ba7-3cc5-48cd-8952-a50a92da016d", "Impact", null, "Defines the severity of a situation on the attach entity.", descriptionGUID, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), true);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "status";
        String attribute1Description = "Status of this classification.";
        String attribute1DescriptionGUID = null;
        String attribute6Name = "level";
        String attribute6Description = "Level of severity associated with this classification";
        String attribute6DescriptionGUID = null;
        String attribute7Name = "levelIdentifier";
        String attribute7Description = "Defined level for this classification.";
        String attribute7DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getEnumTypeDefAttribute(GovernanceClassificationStatus.getOpenTypeName(), "status", "Status of this classification.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getIntTypeDefAttribute(OpenMetadataProperty.CONFIDENCE.name, OpenMetadataProperty.CONFIDENCE.description, OpenMetadataProperty.CONFIDENCE.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.STEWARD.name, OpenMetadataProperty.STEWARD.description, OpenMetadataProperty.STEWARD.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.SOURCE.name, OpenMetadataProperty.SOURCE.description, OpenMetadataProperty.SOURCE.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.NOTES.name, OpenMetadataProperty.NOTES.description, OpenMetadataProperty.NOTES.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getEnumTypeDefAttribute(ImpactSeverity.getOpenTypeName(), "level", "Level of severity associated with this classification", attribute6DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getIntTypeDefAttribute("levelIdentifier", "Defined level for this classification.", attribute7DescriptionGUID);
        properties.add(property);
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private void update0445GovernanceRoles() {
        this.archiveBuilder.addEnumDef(this.getOwnerTypeEnum());
    }

    private EnumDef getOwnerTypeEnum() {
        String guid = "5ce92a70-b86a-4e0d-a9d7-fc961121de97";
        String name = "OwnerType";
        String description = "Defines the type of identifier for a governance owner.";
        String descriptionGUID = null;
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef("5ce92a70-b86a-4e0d-a9d7-fc961121de97", "OwnerType", "Defines the type of identifier for a governance owner.", descriptionGUID);
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        boolean element1Ordinal = false;
        String element1Value = "UserId";
        String element1Description = "The owner's userId is specified (default).";
        String element1DescriptionGUID = null;
        EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(0, "UserId", "The owner's userId is specified (default).", element1DescriptionGUID);
        elementDefs.add(elementDef);
        boolean element2Ordinal = true;
        String element2Value = "ProfileId";
        String element2Description = "The unique identifier (guid) of the profile of the owner.";
        String element2DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(1, "ProfileId", "The unique identifier (guid) of the profile of the owner.", element2DescriptionGUID);
        elementDefs.add(elementDef);
        int element99Ordinal = 99;
        String element99Value = "Other";
        String element99Description = "Another type of owner identifier, probably not supported by open metadata.";
        String element99DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(99, "Other", "Another type of owner identifier, probably not supported by open metadata.", element99DescriptionGUID);
        elementDefs.add(elementDef);
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    public void update0460GovernanceExecutionPoints() {
        this.archiveBuilder.addEntityDef(this.addExecutionPointDefinitionEntity());
        this.archiveBuilder.addEntityDef(this.addControlPointDefinitionEntity());
        this.archiveBuilder.addEntityDef(this.addVerificationPointDefinitionEntity());
        this.archiveBuilder.addEntityDef(this.addEnforcementPointDefinitionEntity());
        this.archiveBuilder.addRelationshipDef(this.addExecutionPointUseRelationship());
        this.archiveBuilder.addTypeDefPatch(this.updateControlPointClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateVerificationPointClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateEnforcementPointClassification());
    }

    private EntityDef addExecutionPointDefinitionEntity() {
        String guid = "d7f8d1d2-8cec-4fd2-b9fd-c8307cad750d";
        String name = "ExecutionPointDefinition";
        String description = "A description of an activity that supports the implementation of a governance requirement.";
        String descriptionGUID = null;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("d7f8d1d2-8cec-4fd2-b9fd-c8307cad750d", "ExecutionPointDefinition", this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "A description of an activity that supports the implementation of a governance requirement.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.DISPLAY_NAME.name, OpenMetadataProperty.DISPLAY_NAME.description, OpenMetadataProperty.DISPLAY_NAME.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.DESCRIPTION.name, OpenMetadataProperty.DESCRIPTION.description, OpenMetadataProperty.DESCRIPTION.descriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef addControlPointDefinitionEntity() {
        String guid = "a376a993-5f1c-4926-b74e-a15a38e1d55a";
        String name = "ControlPointDefinition";
        String description = "A decision needs to be made on how to proceed.";
        String descriptionGUID = null;
        String superTypeName = "ExecutionPointDefinition";
        return this.archiveHelper.getDefaultEntityDef("a376a993-5f1c-4926-b74e-a15a38e1d55a", "ControlPointDefinition", this.archiveBuilder.getEntityDef("ExecutionPointDefinition"), "A decision needs to be made on how to proceed.", descriptionGUID);
    }

    private EntityDef addVerificationPointDefinitionEntity() {
        String guid = "27db26a1-ff66-4042-9932-ddc728b977b9";
        String name = "VerificationPointDefinition";
        String description = "A test is made to ensure the current situation is valid.";
        String descriptionGUID = null;
        String superTypeName = "ExecutionPointDefinition";
        return this.archiveHelper.getDefaultEntityDef("27db26a1-ff66-4042-9932-ddc728b977b9", "VerificationPointDefinition", this.archiveBuilder.getEntityDef("ExecutionPointDefinition"), "A test is made to ensure the current situation is valid.", descriptionGUID);
    }

    private EntityDef addEnforcementPointDefinitionEntity() {
        String guid = "e87ff806-bb9c-4c5d-8106-f38f2dd21037";
        String name = "EnforcementPointDefinition";
        String description = "A change is made to enforce a governance requirement.";
        String descriptionGUID = null;
        String superTypeName = "ExecutionPointDefinition";
        return this.archiveHelper.getDefaultEntityDef("e87ff806-bb9c-4c5d-8106-f38f2dd21037", "EnforcementPointDefinition", this.archiveBuilder.getEntityDef("ExecutionPointDefinition"), "A change is made to enforce a governance requirement.", descriptionGUID);
    }

    private RelationshipDef addExecutionPointUseRelationship() {
        String guid = "3eb268f4-9419-4281-a487-d25ccd88eba3";
        String name = "ExecutionPointUse";
        String description = "Link between a governance execution point definition and the governance definition it supports.";
        String descriptionGUID = null;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("3eb268f4-9419-4281-a487-d25ccd88eba3", "ExecutionPointUse", null, "Link between a governance execution point definition and the governance definition it supports.", descriptionGUID, ClassificationPropagationRule.NONE);
        String end1EntityType = "GovernanceDefinition";
        String end1AttributeName = "supportsGovernanceDefinitions";
        String end1AttributeDescription = "Governance definition that is implemented by this execution point.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GovernanceDefinition"), "supportsGovernanceDefinitions", "Governance definition that is implemented by this execution point.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "ExecutionPointDefinition";
        String end2AttributeName = "executedThrough";
        String end2AttributeDescription = "Description of the execution points that support the implementation of this governance definition.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("ExecutionPointDefinition"), "executedThrough", "Description of the execution points that support the implementation of this governance definition.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private TypeDefPatch updateControlPointClassification() {
        String typeName = "ControlPoint";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("ControlPoint");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.QUALIFIED_NAME.name, OpenMetadataProperty.QUALIFIED_NAME.description, OpenMetadataProperty.QUALIFIED_NAME.descriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateVerificationPointClassification() {
        String typeName = "VerificationPoint";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("VerificationPoint");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.QUALIFIED_NAME.name, OpenMetadataProperty.QUALIFIED_NAME.description, OpenMetadataProperty.QUALIFIED_NAME.descriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateEnforcementPointClassification() {
        String typeName = "EnforcementPoint";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("EnforcementPoint");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.QUALIFIED_NAME.name, OpenMetadataProperty.QUALIFIED_NAME.description, OpenMetadataProperty.QUALIFIED_NAME.descriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void add0461GovernanceActionEngines() {
        this.archiveBuilder.addEntityDef(this.addGovernanceEngineEntity());
        this.archiveBuilder.addEntityDef(this.addGovernanceServiceEntity());
        this.archiveBuilder.addEntityDef(this.addGovernanceActionEngineEntity());
        this.archiveBuilder.addEntityDef(this.addGovernanceActionServiceEntity());
        this.archiveBuilder.addRelationshipDef(this.addSupportedGovernanceServiceRelationship());
    }

    private EntityDef addGovernanceEngineEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.GOVERNANCE_ENGINE.typeGUID, OpenMetadataType.GOVERNANCE_ENGINE.typeName, this.archiveBuilder.getEntityDef(OpenMetadataType.SOFTWARE_SERVER_CAPABILITY.typeName), OpenMetadataType.GOVERNANCE_ENGINE.description, OpenMetadataType.GOVERNANCE_ENGINE.descriptionGUID, OpenMetadataType.GOVERNANCE_ENGINE.wikiURL);
    }

    private EntityDef addGovernanceServiceEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.GOVERNANCE_SERVICE.typeGUID, OpenMetadataType.GOVERNANCE_SERVICE.typeName, this.archiveBuilder.getEntityDef(OpenMetadataType.DEPLOYED_CONNECTOR.typeName), OpenMetadataType.GOVERNANCE_SERVICE.description, OpenMetadataType.GOVERNANCE_SERVICE.descriptionGUID, OpenMetadataType.GOVERNANCE_SERVICE.wikiURL);
    }

    private EntityDef addGovernanceActionEngineEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.GOVERNANCE_ACTION_ENGINE.typeGUID, OpenMetadataType.GOVERNANCE_ACTION_ENGINE.typeName, this.archiveBuilder.getEntityDef(OpenMetadataType.GOVERNANCE_ENGINE.typeName), OpenMetadataType.GOVERNANCE_ACTION_ENGINE.description, OpenMetadataType.GOVERNANCE_ACTION_ENGINE.descriptionGUID, OpenMetadataType.GOVERNANCE_ACTION_ENGINE.wikiURL);
    }

    private EntityDef addGovernanceActionServiceEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.GOVERNANCE_ACTION_SERVICE.typeGUID, OpenMetadataType.GOVERNANCE_ACTION_SERVICE.typeName, this.archiveBuilder.getEntityDef(OpenMetadataType.GOVERNANCE_SERVICE.typeName), OpenMetadataType.GOVERNANCE_ACTION_SERVICE.description, OpenMetadataType.GOVERNANCE_ACTION_SERVICE.descriptionGUID, OpenMetadataType.GOVERNANCE_ACTION_SERVICE.wikiURL);
    }

    private RelationshipDef addSupportedGovernanceServiceRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.SUPPORTED_GOVERNANCE_SERVICE_RELATIONSHIP.typeGUID, OpenMetadataType.SUPPORTED_GOVERNANCE_SERVICE_RELATIONSHIP.typeName, null, OpenMetadataType.SUPPORTED_GOVERNANCE_SERVICE_RELATIONSHIP.description, OpenMetadataType.SUPPORTED_GOVERNANCE_SERVICE_RELATIONSHIP.descriptionGUID, OpenMetadataType.SUPPORTED_GOVERNANCE_SERVICE_RELATIONSHIP.wikiURL, ClassificationPropagationRule.NONE);
        String end1AttributeName = "calledFromGovernanceEngines";
        String end1AttributeDescription = "Governance Engine making use of the governance service.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.GOVERNANCE_ENGINE.typeName), "calledFromGovernanceEngines", "Governance Engine making use of the governance service.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "supportedGovernanceServices";
        String end2AttributeDescription = "Governance service that is part of the governance engine.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.GOVERNANCE_SERVICE.typeName), "supportedGovernanceServices", "Governance service that is part of the governance engine.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.REQUEST_TYPE.name, OpenMetadataProperty.REQUEST_TYPE.description, OpenMetadataProperty.REQUEST_TYPE.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringStringTypeDefAttribute(OpenMetadataProperty.REQUEST_PARAMETERS.name, OpenMetadataProperty.REQUEST_PARAMETERS.description, OpenMetadataProperty.REQUEST_PARAMETERS.descriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void add0462GovernanceActionProcesses() {
        this.archiveBuilder.addEntityDef(this.addGovernanceActionProcessEntity());
        this.archiveBuilder.addEntityDef(this.addGovernanceActionTypeEntity());
        this.archiveBuilder.addEntityDef(this.addGovernanceActionProcessStepEntity());
        this.archiveBuilder.addRelationshipDef(this.addGovernanceActionProcessFlowRelationship());
        this.archiveBuilder.addRelationshipDef(this.addNextGovernanceActionProcessStepRelationship());
        this.archiveBuilder.addRelationshipDef(this.addGovernanceActionExecutorRelationship());
    }

    private EntityDef addGovernanceActionProcessEntity() {
        String guid = "4d3a2b8d-9e2e-4832-b338-21c74e45b238";
        String name = "GovernanceActionProcess";
        String description = "A process implemented by chained engine actions that call governance services.";
        String descriptionGUID = null;
        return this.archiveHelper.getDefaultEntityDef("4d3a2b8d-9e2e-4832-b338-21c74e45b238", "GovernanceActionProcess", this.archiveBuilder.getEntityDef(OpenMetadataType.PROCESS.typeName), "A process implemented by chained engine actions that call governance services.", descriptionGUID);
    }

    private EntityDef addGovernanceActionTypeEntity() {
        String guid = "92e20083-0393-40c0-a95b-090724a91ddc";
        String name = "GovernanceActionType";
        String description = "A description of a call to a governance engine that acts as a template when creating the appropriate engine action instance.";
        String descriptionGUID = null;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("92e20083-0393-40c0-a95b-090724a91ddc", "GovernanceActionType", this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "A description of a call to a governance engine that acts as a template when creating the appropriate engine action instance.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "domainIdentifier";
        String attribute1Description = "Identifier used to show which governance domain this action type belongs to.";
        String attribute1DescriptionGUID = null;
        String attribute4Name = "waitTime";
        String attribute4Description = "The minimum number of minutes that the governance engine should wait before calling the governance service.";
        String attribute4DescriptionGUID = null;
        String attribute5Name = "supportedGuards";
        String attribute5Description = "List of guards that this action type supports.";
        String attribute5DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getIntTypeDefAttribute("domainIdentifier", "Identifier used to show which governance domain this action type belongs to.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.DISPLAY_NAME.name, OpenMetadataProperty.DISPLAY_NAME.description, OpenMetadataProperty.DISPLAY_NAME.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.DESCRIPTION.name, OpenMetadataProperty.DESCRIPTION.description, OpenMetadataProperty.DESCRIPTION.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getIntTypeDefAttribute("waitTime", "The minimum number of minutes that the governance engine should wait before calling the governance service.", attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getArrayStringTypeDefAttribute("supportedGuards", "List of guards that this action type supports.", attribute5DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef addGovernanceActionProcessStepEntity() {
        String guid = "7ae66fcc-09be-4d16-b39f-b5e299473586";
        String name = "GovernanceActionProcessStep";
        String description = "A description of a call to a step in a governance action process that acts as a template when creating the appropriate engine action instance.";
        String descriptionGUID = null;
        String superTypeName = "GovernanceActionType";
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("7ae66fcc-09be-4d16-b39f-b5e299473586", "GovernanceActionProcessStep", this.archiveBuilder.getEntityDef("GovernanceActionType"), "A description of a call to a step in a governance action process that acts as a template when creating the appropriate engine action instance.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "ignoreMultipleTriggers";
        String attribute1Description = "Trigger one or many engine action instances?";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getBooleanTypeDefAttribute("ignoreMultipleTriggers", "Trigger one or many engine action instances?", attribute1DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef addGovernanceActionProcessFlowRelationship() {
        String guid = "5f6ddee5-31ea-4d4f-9c3f-00ad2fcb2aa0";
        String name = "GovernanceActionProcessFlow";
        String description = "A link between a governance action process and its first process step.";
        String descriptionGUID = null;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("5f6ddee5-31ea-4d4f-9c3f-00ad2fcb2aa0", "GovernanceActionProcessFlow", null, "A link between a governance action process and its first process step.", descriptionGUID, ClassificationPropagationRule.NONE);
        String end1EntityType = "GovernanceActionProcess";
        String end1AttributeName = "triggeredFrom";
        String end1AttributeDescription = "Governance process that describes the set of process steps.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GovernanceActionProcess"), "triggeredFrom", "Governance process that describes the set of process steps.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "GovernanceActionProcessStep";
        String end2AttributeName = "firstStep";
        String end2AttributeDescription = "First step to execute in a governance action process.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GovernanceActionProcessStep"), "firstStep", "First step to execute in a governance action process.", end2AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef addNextGovernanceActionProcessStepRelationship() {
        String guid = "d9567840-9904-43a5-990b-4585c0446e00";
        String name = "NextGovernanceActionProcessStep";
        String description = "Link between a process steps in a governance action process flow.";
        String descriptionGUID = null;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("d9567840-9904-43a5-990b-4585c0446e00", "NextGovernanceActionProcessStep", null, "Link between a process steps in a governance action process flow.", descriptionGUID, ClassificationPropagationRule.NONE);
        String end1EntityType = "GovernanceActionProcessStep";
        String end1AttributeName = "dependedOnProcessSteps";
        String end1AttributeDescription = "Governance Action Process Step caller.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GovernanceActionProcessStep"), "dependedOnProcessSteps", "Governance Action Process Step caller.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "GovernanceActionProcessStep";
        String end2AttributeName = "followOnProcessSteps";
        String end2AttributeDescription = "Governance Action Process Step called.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GovernanceActionProcessStep"), "followOnProcessSteps", "Governance Action Process Step called.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "guard";
        String attribute1Description = "The guard that is returned by the previous step that triggers this next step to run.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "mandatoryGuard";
        String attribute2Description = "Is this guard mandatory for the next step to run.";
        String attribute2DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("guard", "The guard that is returned by the previous step that triggers this next step to run.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getBooleanTypeDefAttribute("mandatoryGuard", "Is this guard mandatory for the next step to run.", attribute2DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef addGovernanceActionExecutorRelationship() {
        String guid = "f672245f-35b5-4ca7-b645-014cf61d5b75";
        String name = "GovernanceActionExecutor";
        String description = "Link between a governance action type, or process step, and the governance engine that will execute it.";
        String descriptionGUID = null;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("f672245f-35b5-4ca7-b645-014cf61d5b75", "GovernanceActionExecutor", null, "Link between a governance action type, or process step, and the governance engine that will execute it.", descriptionGUID, ClassificationPropagationRule.NONE);
        String end1EntityType = "GovernanceActionType";
        String end1AttributeName = "supportsGovernanceActions";
        String end1AttributeDescription = "Governance action that drives calls to a governance engine.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GovernanceActionType"), "supportsGovernanceActions", "Governance action that drives calls to a governance engine.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.GOVERNANCE_ENGINE.typeName;
        String end2AttributeName = "governanceActionExecutor";
        String end2AttributeDescription = "Governance engine that will run the requested action.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "governanceActionExecutor", "Governance engine that will run the requested action.", end2AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "requestType";
        String attribute1Description = "The request type used to call the service.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "requestParameters";
        String attribute2Description = "Properties that configure the governance service for this type of request.";
        String attribute2DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("requestType", "The request type used to call the service.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringStringTypeDefAttribute("requestParameters", "Properties that configure the governance service for this type of request.", attribute2DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void add0463EngineActions() {
        this.archiveBuilder.addEnumDef(this.getEngineActionStatusEnum());
        this.archiveBuilder.addEntityDef(this.addEngineActionEntity());
        this.archiveBuilder.addRelationshipDef(this.addEngineActionRequestSourceRelationship());
        this.archiveBuilder.addRelationshipDef(this.addGovernanceActionProcessStepUseRelationship());
        this.archiveBuilder.addRelationshipDef(this.addTargetForActionRelationship());
        this.archiveBuilder.addRelationshipDef(this.addNextEngineActionRelationship());
        this.archiveBuilder.addRelationshipDef(this.addEngineActionExecutorRelationship());
    }

    private EnumDef getEngineActionStatusEnum() {
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef(EngineActionStatus.getOpenTypeGUID(), EngineActionStatus.getOpenTypeName(), EngineActionStatus.getOpenTypeDescription(), EngineActionStatus.getOpenTypeDescriptionGUID(), EngineActionStatus.getOpenTypeDescriptionWiki());
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        for (EngineActionStatus enumValues : EngineActionStatus.values()) {
            EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(enumValues.getOrdinal(), enumValues.getName(), enumValues.getDescription(), enumValues.getDescriptionGUID());
            elementDefs.add(elementDef);
            if (!enumValues.isDefault()) continue;
            enumDef.setDefaultValue(elementDef);
        }
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private EntityDef addEngineActionEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.ENGINE_ACTION.typeGUID, OpenMetadataType.ENGINE_ACTION.typeName, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), OpenMetadataType.ENGINE_ACTION.description, OpenMetadataType.ENGINE_ACTION.descriptionGUID, OpenMetadataType.ENGINE_ACTION.wikiURL);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "domainIdentifier";
        String attribute1Description = "Identifier used to show which governance domain this action belongs to.";
        String attribute1DescriptionGUID = null;
        String attribute4Name = "processingEngineUserId";
        String attribute4Description = "Governance engine responsible for this engine action.";
        String attribute4DescriptionGUID = null;
        String attribute6Name = "actionStatus";
        String attribute6Description = "Current lifecycle state of the engine action.";
        String attribute6DescriptionGUID = null;
        String attribute7Name = "startDate";
        String attribute7Description = "Date and time when the governance service started running.";
        String attribute7DescriptionGUID = null;
        String attribute8Name = "completionDate";
        String attribute8Description = "Date and time when the governance service completed.";
        String attribute8DescriptionGUID = null;
        String attribute9Name = "completionGuards";
        String attribute9Description = "List of guards returned by the governance service.";
        String attribute9DescriptionGUID = null;
        String attribute10Name = "receivedGuards";
        String attribute10Description = "List of guards received from the previous governance service(s).";
        String attribute10DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getIntTypeDefAttribute("domainIdentifier", "Identifier used to show which governance domain this action belongs to.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.DISPLAY_NAME.name, OpenMetadataProperty.DISPLAY_NAME.description, OpenMetadataProperty.DISPLAY_NAME.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.DESCRIPTION.name, OpenMetadataProperty.DESCRIPTION.description, OpenMetadataProperty.DESCRIPTION.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("processingEngineUserId", "Governance engine responsible for this engine action.", attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getEnumTypeDefAttribute(EngineActionStatus.getOpenTypeName(), "actionStatus", "Current lifecycle state of the engine action.", attribute6DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getDateTypeDefAttribute("startDate", "Date and time when the governance service started running.", attribute7DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getDateTypeDefAttribute("completionDate", "Date and time when the governance service completed.", attribute8DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getArrayStringTypeDefAttribute("completionGuards", "List of guards returned by the governance service.", attribute9DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getArrayStringTypeDefAttribute("receivedGuards", "List of guards received from the previous governance service(s).", attribute10DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef addEngineActionRequestSourceRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.ENGINE_ACTION_REQUEST_SOURCE, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "sourceActivity";
        String end1AttributeDescription = "Element(s) that caused this engine action to be created.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.OPEN_METADATA_ROOT.typeName), "sourceActivity", "Element(s) that caused this engine action to be created.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.ENGINE_ACTION.typeName;
        String end2AttributeName = "identifiedActions";
        String end2AttributeDescription = "Engine actions that were initiated for the linked element.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "identifiedActions", "Engine actions that were initiated for the linked element.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "originGovernanceService";
        String attribute1Description = "The qualifiedName of the governance service that caused the engine action to be created.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "originGovernanceEngine";
        String attribute2Description = "The qualifiedName of the governance engine that caused the engine action to be created.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "requestSourceName";
        String attribute3Description = "The name to identify the request source to the governance service that processes it.";
        String attribute3DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("originGovernanceService", "The qualifiedName of the governance service that caused the engine action to be created.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("originGovernanceEngine", "The qualifiedName of the governance engine that caused the engine action to be created.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("requestSourceName", "The name to identify the request source to the governance service that processes it.", attribute3DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef addGovernanceActionProcessStepUseRelationship() {
        String guid = "31e734ec-5baf-4e96-9f0d-e8a85081cb14";
        String name = "GovernanceActionProcessStepUse";
        String description = "Link between a governance action process step and a resulting engine action.";
        String descriptionGUID = null;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("31e734ec-5baf-4e96-9f0d-e8a85081cb14", "GovernanceActionProcessStepUse", null, "Link between a governance action process step and a resulting engine action.", descriptionGUID, ClassificationPropagationRule.NONE);
        String end1EntityType = "GovernanceActionProcessStep";
        String end1AttributeName = "fromProcessStepTemplate";
        String end1AttributeDescription = "Governance action process step that was the template for this engine action.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GovernanceActionProcessStep"), "fromProcessStepTemplate", "Governance action process step that was the template for this engine action.", end1AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.ENGINE_ACTION.typeName;
        String end2AttributeName = "spawnedActions";
        String end2AttributeDescription = "Engine actions that were created from this process step template.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "spawnedActions", "Engine actions that were created from this process step template.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "originGovernanceService";
        String attribute1Description = "The qualifiedName of the governance service that caused the engine action to be created.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "originGovernanceEngine";
        String attribute2Description = "The qualifiedName of the governance engine that caused the engine action to be created.";
        String attribute2DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("originGovernanceService", "The qualifiedName of the governance service that caused the engine action to be created.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("originGovernanceEngine", "The qualifiedName of the governance engine that caused the engine action to be created.", attribute2DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef addTargetForActionRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.TARGET_FOR_ACTION, null, ClassificationPropagationRule.NONE);
        String end1EntityType = OpenMetadataType.ENGINE_ACTION.typeName;
        String end1AttributeName = "identifiedEngineActions";
        String end1AttributeDescription = "Engine action that is acting on this element.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "identifiedEngineActions", "Engine action that is acting on this element.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "actionTarget";
        String end2AttributeDescription = "Element(s) to work on.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "actionTarget", "Element(s) to work on.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        TypeDefAttribute property = this.archiveHelper.getEnumTypeDefAttribute(EngineActionStatus.getOpenTypeName(), OpenMetadataProperty.ACTION_STATUS.name, OpenMetadataProperty.ACTION_STATUS.description, OpenMetadataProperty.ACTION_STATUS.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getDateTypeDefAttribute(OpenMetadataProperty.START_DATE.name, OpenMetadataProperty.START_DATE.description, OpenMetadataProperty.START_DATE.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getDateTypeDefAttribute(OpenMetadataProperty.COMPLETION_DATE.name, OpenMetadataProperty.COMPLETION_DATE.description, OpenMetadataProperty.COMPLETION_DATE.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.ACTION_TARGET_NAME.name, OpenMetadataProperty.ACTION_TARGET_NAME.description, OpenMetadataProperty.ACTION_TARGET_NAME.descriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef addNextEngineActionRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.NEXT_ENGINE_ACTION, null, ClassificationPropagationRule.NONE);
        String end1EntityType = OpenMetadataType.ENGINE_ACTION.typeName;
        String end1AttributeName = "previousActions";
        String end1AttributeDescription = "Engine action that triggered this engine action.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "previousActions", "Engine action that triggered this engine action.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.ENGINE_ACTION.typeName;
        String end2AttributeName = "followOnActions";
        String end2AttributeDescription = "Engine action(s) that should run next.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "followOnActions", "Engine action(s) that should run next.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "guard";
        String attribute1Description = "The guard that is returned by the previous action that means this next action will run.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "mandatoryGuard";
        String attribute2Description = "Is this guard mandatory for the next action to run.";
        String attribute2DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("guard", "The guard that is returned by the previous action that means this next action will run.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getBooleanTypeDefAttribute("mandatoryGuard", "Is this guard mandatory for the next action to run.", attribute2DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef addEngineActionExecutorRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.ENGINE_ACTION_EXECUTOR.typeGUID, OpenMetadataType.ENGINE_ACTION_EXECUTOR.typeName, null, OpenMetadataType.ENGINE_ACTION_EXECUTOR.description, OpenMetadataType.ENGINE_ACTION_EXECUTOR.descriptionGUID, ClassificationPropagationRule.NONE);
        String end1EntityType = OpenMetadataType.ENGINE_ACTION.typeName;
        String end1AttributeName = "supportsEngineAction";
        String end1AttributeDescription = "Engine action that drives a governance engine.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "supportsEngineAction", "Engine action that drives a governance engine.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.GOVERNANCE_ENGINE.typeName;
        String end2AttributeName = "governanceActionExecutor";
        String end2AttributeDescription = "Governance engine that will run the governance action.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "governanceActionExecutor", "Governance engine that will run the governance action.", end2AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "requestType";
        String attribute1Description = "The request type used to call the service.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "requestParameters";
        String attribute2Description = "Properties that configure the governance service for this type of request.";
        String attribute2DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("requestType", "The request type used to call the service.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringStringTypeDefAttribute("requestParameters", "Properties that configure the governance service for this type of request.", attribute2DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    public void add0465DuplicateProcessing() {
        this.archiveBuilder.addEnumDef(this.addDuplicateTypeEnum());
        this.archiveBuilder.addClassificationDef(this.addKnowDuplicateClassification());
        this.archiveBuilder.addRelationshipDef(this.addKnownDuplicateLinkRelationship());
    }

    private EnumDef addDuplicateTypeEnum() {
        String guid = "2f6a3dc1-aa98-4b92-add4-68de53b7369c";
        String name = "DuplicateType";
        String description = "Defines if the duplicates are peers or one is a consolidated duplicate.";
        String descriptionGUID = null;
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef("2f6a3dc1-aa98-4b92-add4-68de53b7369c", "DuplicateType", "Defines if the duplicates are peers or one is a consolidated duplicate.", descriptionGUID);
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        boolean element1Ordinal = false;
        String element1Value = "Peer";
        String element1Description = "The duplicates are peers.";
        String element1DescriptionGUID = null;
        EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(0, "Peer", "The duplicates are peers.", element1DescriptionGUID);
        elementDefs.add(elementDef);
        boolean element2Ordinal = true;
        String element2Value = "Consolidated";
        String element2Description = "One duplicate has been constructed from the other (ands its peers).";
        String element2DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(1, "Consolidated", "One duplicate has been constructed from the other (ands its peers).", element2DescriptionGUID);
        elementDefs.add(elementDef);
        int element99Ordinal = 99;
        String element99Value = "Other";
        String element99Description = "Another duplicate type.";
        String element99DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(99, "Other", "Another duplicate type.", element99DescriptionGUID);
        elementDefs.add(elementDef);
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private ClassificationDef addKnowDuplicateClassification() {
        String guid = "e55062b2-907f-44bd-9831-255642285731";
        String name = "KnownDuplicate";
        String description = "Defines that duplicate resolution processing is required.";
        String descriptionGUID = null;
        return this.archiveHelper.getClassificationDef("e55062b2-907f-44bd-9831-255642285731", "KnownDuplicate", null, "Defines that duplicate resolution processing is required.", descriptionGUID, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), true);
    }

    private RelationshipDef addKnownDuplicateLinkRelationship() {
        String guid = "7540d9fb-1848-472e-baef-97a44b9f0c45";
        String name = "KnownDuplicateLink";
        String description = "Link between duplicate entities.";
        String descriptionGUID = null;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("7540d9fb-1848-472e-baef-97a44b9f0c45", "KnownDuplicateLink", null, "Link between duplicate entities.", descriptionGUID, ClassificationPropagationRule.NONE);
        String end1AttributeName = "knownDuplicateOrigin";
        String end1AttributeDescription = "Oldest element.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "knownDuplicateOrigin", "Oldest element.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "knownDuplicatePartner";
        String end2AttributeDescription = "Newest element.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "knownDuplicatePartner", "Newest element.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "duplicateType";
        String attribute1Description = "Type of duplicate.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "status";
        String attribute2Description = "Status of the duplicate processing.";
        String attribute2DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getEnumTypeDefAttribute("DuplicateType", "duplicateType", "Type of duplicate.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getEnumTypeDefAttribute("GovernanceClassificationStatus", "status", "Status of the duplicate processing.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.STEWARD.name, OpenMetadataProperty.STEWARD.description, OpenMetadataProperty.STEWARD.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.SOURCE.name, OpenMetadataProperty.SOURCE.description, OpenMetadataProperty.SOURCE.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.NOTES.name, OpenMetadataProperty.NOTES.description, OpenMetadataProperty.NOTES.descriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    public void add0470IncidentReports() {
        this.archiveBuilder.addEnumDef(this.getIncidentReportStatusEnum());
        this.archiveBuilder.addEntityDef(this.addIncidentClassifierEntity());
        this.archiveBuilder.addEntityDef(this.addIncidentReportEntity());
        this.archiveBuilder.addRelationshipDef(this.addIncidentOriginatorRelationship());
        this.archiveBuilder.addRelationshipDef(this.addImpactedResourceRelationship());
        this.archiveBuilder.addRelationshipDef(this.addIncidentDependencyRelationship());
    }

    private EnumDef getIncidentReportStatusEnum() {
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef(IncidentReportStatus.getOpenTypeGUID(), IncidentReportStatus.getOpenTypeName(), IncidentReportStatus.getOpenTypeDescription(), IncidentReportStatus.getOpenTypeDescriptionGUID(), IncidentReportStatus.getOpenTypeDescriptionWiki());
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        for (CriticalityLevel enumValues : CriticalityLevel.values()) {
            EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(enumValues.getOrdinal(), enumValues.getName(), enumValues.getDescription(), enumValues.getDescriptionGUID());
            elementDefs.add(elementDef);
            if (!enumValues.isDefault()) continue;
            enumDef.setDefaultValue(elementDef);
        }
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private EntityDef addIncidentClassifierEntity() {
        String guid = "1fad7fe4-5115-412b-ae31-a418e93888fe";
        String name = "IncidentClassifier";
        String description = "A definition of a classifier used to label incident reports.";
        String descriptionGUID = null;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("1fad7fe4-5115-412b-ae31-a418e93888fe", "IncidentClassifier", this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "A definition of a classifier used to label incident reports.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "classifierLabel";
        String attribute1Description = "Label to add to the incident.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "classifierIdentifier";
        String attribute2Description = "Unique identifier for the classifier associated with the classifier label.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "classifierName";
        String attribute3Description = "Display name for the classifier identifier.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "classifierDescription";
        String attribute4Description = "Description of the meaning of the classifier identifier.";
        String attribute4DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("classifierLabel", "Label to add to the incident.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getIntTypeDefAttribute("classifierIdentifier", "Unique identifier for the classifier associated with the classifier label.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("classifierName", "Display name for the classifier identifier.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("classifierDescription", "Description of the meaning of the classifier identifier.", attribute4DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef addIncidentReportEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.INCIDENT_REPORT.typeGUID, OpenMetadataType.INCIDENT_REPORT.typeName, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), OpenMetadataType.INCIDENT_REPORT.description, OpenMetadataType.INCIDENT_REPORT.descriptionGUID, OpenMetadataType.INCIDENT_REPORT.wikiURL);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "domainIdentifier";
        String attribute1Description = "Identifier used to show which governance domain this incident belongs to.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "background";
        String attribute2Description = "Description of the background cause or activity.";
        String attribute2DescriptionGUID = null;
        String attribute4Name = "owner";
        String attribute4Description = "Person, team or engine responsible for this incident.";
        String attribute4DescriptionGUID = null;
        String attribute5Name = "ownerType";
        String attribute5Description = "Type of element representing the owner.";
        String attribute5DescriptionGUID = null;
        String attribute6Name = "incidentStatus";
        String attribute6Description = "Current lifecycle state of the incident report.";
        String attribute6DescriptionGUID = null;
        String attribute7Name = OpenMetadataProperty.START_DATE.name;
        String attribute7Description = OpenMetadataProperty.START_DATE.description;
        String attribute7DescriptionGUID = OpenMetadataProperty.START_DATE.descriptionGUID;
        String attribute8Name = OpenMetadataProperty.COMPLETION_DATE.name;
        String attribute8Description = OpenMetadataProperty.COMPLETION_DATE.description;
        String attribute8DescriptionGUID = OpenMetadataProperty.COMPLETION_DATE.descriptionGUID;
        String attribute9Name = "incidentClassifiers";
        String attribute9Description = "Map of label to level indicator to provide customizable grouping of incidents.";
        String attribute9DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getIntTypeDefAttribute("domainIdentifier", "Identifier used to show which governance domain this incident belongs to.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("background", "Description of the background cause or activity.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.DESCRIPTION.name, OpenMetadataProperty.DESCRIPTION.description, OpenMetadataProperty.DESCRIPTION.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("owner", "Person, team or engine responsible for this incident.", attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getEnumTypeDefAttribute("AssetOwnerType", "ownerType", "Type of element representing the owner.", attribute5DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getEnumTypeDefAttribute("IncidentReportStatus", "incidentStatus", "Current lifecycle state of the incident report.", attribute6DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getDateTypeDefAttribute(attribute7Name, attribute7Description, attribute7DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getDateTypeDefAttribute(attribute8Name, attribute8Description, attribute8DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringIntTypeDefAttribute("incidentClassifiers", "Map of label to level indicator to provide customizable grouping of incidents.", attribute9DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef addIncidentOriginatorRelationship() {
        String guid = "e490772e-c2c5-445a-aea6-1aab3499a76c";
        String name = "IncidentOriginator";
        String description = "Link between an incident report and its originator (person, process, engine, ...).";
        String descriptionGUID = null;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("e490772e-c2c5-445a-aea6-1aab3499a76c", "IncidentOriginator", null, "Link between an incident report and its originator (person, process, engine, ...).", descriptionGUID, ClassificationPropagationRule.NONE);
        String end1AttributeName = "originators";
        String end1AttributeDescription = "Source(s) of the incident report.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "originators", "Source(s) of the incident report.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "IncidentReport";
        String end2AttributeName = "resultingIncidentReports";
        String end2AttributeDescription = "Descriptions of detected incidents.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("IncidentReport"), "resultingIncidentReports", "Descriptions of detected incidents.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef addImpactedResourceRelationship() {
        String guid = "0908e153-e0fd-499c-8a30-5ea8b81395cd";
        String name = "ImpactedResource";
        String description = "Link between an impacted referenceable and an incident report.";
        String descriptionGUID = null;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("0908e153-e0fd-499c-8a30-5ea8b81395cd", "ImpactedResource", null, "Link between an impacted referenceable and an incident report.", descriptionGUID, ClassificationPropagationRule.NONE);
        String end1AttributeName = "impactedResources";
        String end1AttributeDescription = "Resources impacted by the incident.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "impactedResources", "Resources impacted by the incident.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "IncidentReport";
        String end2AttributeName = "incidentReports";
        String end2AttributeDescription = "Descriptions of incidents affecting this resource and the action taken.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("IncidentReport"), "incidentReports", "Descriptions of incidents affecting this resource and the action taken.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "severityLevelIdentifier";
        String attribute1Description = "How severe is the impact on the resource?";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getIntTypeDefAttribute("severityLevelIdentifier", "How severe is the impact on the resource?", attribute1DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef addIncidentDependencyRelationship() {
        String guid = "017be6a8-0037-49d8-af5d-c45c41f25e0b";
        String name = "IncidentDependency";
        String description = "Link between an incident report and its predecessors.";
        String descriptionGUID = null;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("017be6a8-0037-49d8-af5d-c45c41f25e0b", "IncidentDependency", null, "Link between an incident report and its predecessors.", descriptionGUID, ClassificationPropagationRule.NONE);
        String end1EntityType = "IncidentReport";
        String end1AttributeName = "priorReportedIncidents";
        String end1AttributeDescription = "Previous reports on the same or related incident.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("IncidentReport"), "priorReportedIncidents", "Previous reports on the same or related incident.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "IncidentReport";
        String end2AttributeName = "followOnReportedIncidents";
        String end2AttributeDescription = "Subsequent reports on the same or related incident.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("IncidentReport"), "followOnReportedIncidents", "Subsequent reports on the same or related incident.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.DESCRIPTION.name, OpenMetadataProperty.DESCRIPTION.description, OpenMetadataProperty.DESCRIPTION.descriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    public void add0550InstanceMetadata() {
        this.archiveBuilder.addClassificationDef(this.addInstanceMetadataClassification());
    }

    private ClassificationDef addInstanceMetadataClassification() {
        String guid = OpenMetadataType.INSTANCE_METADATA_CLASSIFICATION.typeGUID;
        String name = OpenMetadataType.INSTANCE_METADATA_CLASSIFICATION.typeName;
        String description = OpenMetadataType.INSTANCE_METADATA_CLASSIFICATION.description;
        String descriptionGUID = OpenMetadataType.INSTANCE_METADATA_CLASSIFICATION.descriptionGUID;
        String descriptionWiki = OpenMetadataType.INSTANCE_METADATA_CLASSIFICATION.wikiURL;
        String linkedToEntity = "SchemaElement";
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef(guid, name, null, description, descriptionGUID, descriptionWiki, this.archiveBuilder.getEntityDef("SchemaElement"), true);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.INSTANCE_METADATA_TYPE_NAME.name, OpenMetadataProperty.INSTANCE_METADATA_TYPE_NAME.description, OpenMetadataProperty.INSTANCE_METADATA_TYPE_NAME.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.DESCRIPTION.name, OpenMetadataProperty.DESCRIPTION.description, OpenMetadataProperty.DESCRIPTION.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringStringTypeDefAttribute(OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, OpenMetadataProperty.ADDITIONAL_PROPERTIES.description, OpenMetadataProperty.ADDITIONAL_PROPERTIES.descriptionGUID);
        properties.add(property);
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private void update06xxDiscoveryEnginesAndServices() {
        this.archiveBuilder.addTypeDefPatch(this.updateOpenDiscoveryEngine());
        this.archiveBuilder.addTypeDefPatch(this.updateOpenDiscoveryService());
    }

    private TypeDefPatch updateOpenDiscoveryEngine() {
        String typeName = OpenMetadataType.OPEN_DISCOVERY_ENGINE.typeName;
        String superTypeName = OpenMetadataType.GOVERNANCE_ENGINE.typeName;
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setSuperType(this.archiveBuilder.getEntityDef(superTypeName));
        return typeDefPatch;
    }

    private TypeDefPatch updateOpenDiscoveryService() {
        String typeName = OpenMetadataType.OPEN_DISCOVERY_SERVICE.typeName;
        String superTypeName = OpenMetadataType.GOVERNANCE_SERVICE.typeName;
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setSuperType(this.archiveBuilder.getEntityDef(superTypeName));
        return typeDefPatch;
    }
}

