/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.opentypes;

import java.util.ArrayList;
import java.util.Date;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchive3_14;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationPropagationRule;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndCardinality;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttributeStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;

public class OpenMetadataTypesArchive3_15 {
    private static final String archiveGUID = "bce3b0a0-662a-4f87-b8dc-844078a11a6e";
    private static final String archiveName = "Open Metadata Types";
    private static final String archiveDescription = "Standard types for open metadata repositories.";
    private static final OpenMetadataArchiveType archiveType = OpenMetadataArchiveType.CONTENT_PACK;
    private static final String archiveVersion = "3.15";
    private static final String originatorName = "Egeria";
    private static final String originatorLicense = "Apache-2.0";
    private static final Date creationDate = new Date(1588261366992L);
    private static final long versionNumber = 1L;
    private static final String versionName = "1.0";
    private final OMRSArchiveBuilder archiveBuilder;
    private final OMRSArchiveHelper archiveHelper;

    public OpenMetadataTypesArchive3_15() {
        this.archiveBuilder = new OMRSArchiveBuilder(archiveGUID, archiveName, archiveDescription, archiveType, archiveVersion, originatorName, originatorLicense, creationDate, null);
        this.archiveHelper = new OMRSArchiveHelper(this.archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public OpenMetadataTypesArchive3_15(OMRSArchiveBuilder archiveBuilder) {
        this.archiveBuilder = archiveBuilder;
        this.archiveHelper = new OMRSArchiveHelper(archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public String getArchiveGUID() {
        return archiveGUID;
    }

    public OpenMetadataArchive getOpenMetadataArchive() {
        String methodName = "getOpenMetadataArchive";
        if (this.archiveBuilder != null) {
            this.getOriginalTypes();
            return this.archiveBuilder.getOpenMetadataArchive();
        }
        throw new OMRSLogicErrorException(OMRSErrorCode.ARCHIVE_UNAVAILABLE.getMessageDefinition(), this.getClass().getName(), "getOpenMetadataArchive");
    }

    public void getOriginalTypes() {
        OpenMetadataTypesArchive3_14 previousTypes = new OpenMetadataTypesArchive3_14(this.archiveBuilder);
        previousTypes.getOriginalTypes();
        this.updateGovernanceEngines();
        this.updateEngineActions();
        this.update0710DigitalServices();
        this.update0715DigitalServiceOwnership();
        this.update0735SolutionPortsAndWires();
    }

    private void updateGovernanceEngines() {
        this.archiveBuilder.addTypeDefPatch(this.updateSupportedGovernanceServiceRelationship());
    }

    private TypeDefPatch updateSupportedGovernanceServiceRelationship() {
        String typeName = OpenMetadataType.SUPPORTED_GOVERNANCE_SERVICE_RELATIONSHIP.typeName;
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.SERVICE_REQUEST_TYPE.name;
        String attribute1Description = OpenMetadataProperty.SERVICE_REQUEST_TYPE.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.SERVICE_REQUEST_TYPE.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void updateEngineActions() {
        this.archiveBuilder.addTypeDefPatch(this.updateEngineActionEntity());
        this.archiveBuilder.addTypeDefPatch(this.updateTargetForActionRelationship());
    }

    private TypeDefPatch updateEngineActionEntity() {
        String typeName = OpenMetadataType.ENGINE_ACTION.typeName;
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.COMPLETION_MESSAGE.name;
        String attribute1Description = OpenMetadataProperty.COMPLETION_MESSAGE.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.COMPLETION_MESSAGE.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateTargetForActionRelationship() {
        String typeName = OpenMetadataType.TARGET_FOR_ACTION.typeName;
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.COMPLETION_MESSAGE.name, OpenMetadataProperty.COMPLETION_MESSAGE.description, OpenMetadataProperty.COMPLETION_MESSAGE.descriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update0710DigitalServices() {
        this.archiveBuilder.addRelationshipDef(this.getDigitalServiceProductRelationship());
        this.archiveBuilder.addTypeDefPatch(this.updateDigitalProductClassification());
    }

    private RelationshipDef getDigitalServiceProductRelationship() {
        String guid = "51465a59-c785-406d-929c-def34596e9af";
        String name = "DigitalServiceProduct";
        String description = "A digital product that is maintained by a digital service.";
        String descriptionGUID = null;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("51465a59-c785-406d-929c-def34596e9af", "DigitalServiceProduct", null, "A digital product that is maintained by a digital service.", descriptionGUID, ClassificationPropagationRule.NONE);
        String end1EntityType = "DigitalService";
        String end1AttributeName = "managingDigitalService";
        String end1AttributeDescription = "Digital service responsible for the production of the digital product.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("DigitalService"), "managingDigitalService", "Digital service responsible for the production of the digital product.", end1AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "digitalProducts";
        String end2AttributeDescription = "The associated digital products.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "digitalProducts", "The associated digital products.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private TypeDefPatch updateDigitalProductClassification() {
        String typeName = OpenMetadataType.DIGITAL_PRODUCT_CLASSIFICATION.typeName;
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "syncDatesByKey";
        String attribute1Description = "Collection of synchronization dates identified by a key (deprecated, added in error).";
        String attribute1DescriptionGUID = null;
        String attribute2Name = OpenMetadataProperty.PRODUCT_NAME.name;
        String attribute2Description = OpenMetadataProperty.PRODUCT_NAME.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.PRODUCT_NAME.descriptionGUID;
        String attribute3Name = OpenMetadataProperty.PRODUCT_TYPE.name;
        String attribute3Description = OpenMetadataProperty.PRODUCT_TYPE.description;
        String attribute3DescriptionGUID = OpenMetadataProperty.PRODUCT_TYPE.descriptionGUID;
        String attribute4Name = OpenMetadataProperty.INTRODUCTION_DATE.name;
        String attribute4Description = OpenMetadataProperty.INTRODUCTION_DATE.description;
        String attribute4DescriptionGUID = OpenMetadataProperty.INTRODUCTION_DATE.descriptionGUID;
        String attribute5Name = OpenMetadataProperty.MATURITY.name;
        String attribute5Description = OpenMetadataProperty.MATURITY.description;
        String attribute5DescriptionGUID = OpenMetadataProperty.MATURITY.descriptionGUID;
        String attribute6Name = OpenMetadataProperty.SERVICE_LIFE.name;
        String attribute6Description = OpenMetadataProperty.SERVICE_LIFE.description;
        String attribute6DescriptionGUID = OpenMetadataProperty.SERVICE_LIFE.descriptionGUID;
        String attribute7Name = OpenMetadataProperty.CURRENT_VERSION.name;
        String attribute7Description = OpenMetadataProperty.CURRENT_VERSION.description;
        String attribute7DescriptionGUID = OpenMetadataProperty.CURRENT_VERSION.descriptionGUID;
        String attribute8Name = OpenMetadataProperty.NEXT_VERSION_DATE.name;
        String attribute8Description = OpenMetadataProperty.NEXT_VERSION_DATE.description;
        String attribute8DescriptionGUID = OpenMetadataProperty.NEXT_VERSION_DATE.descriptionGUID;
        String attribute9Name = OpenMetadataProperty.WITHDRAW_DATE.name;
        String attribute9Description = OpenMetadataProperty.WITHDRAW_DATE.description;
        String attribute9DescriptionGUID = OpenMetadataProperty.WITHDRAW_DATE.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getMapStringLongTypeDefAttribute("syncDatesByKey", "Collection of synchronization dates identified by a key (deprecated, added in error).", attribute1DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute3Name, attribute3Description, attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getDateTypeDefAttribute(attribute4Name, attribute4Description, attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute5Name, attribute5Description, attribute5DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute6Name, attribute6Description, attribute6DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute7Name, attribute7Description, attribute7DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getDateTypeDefAttribute(attribute8Name, attribute8Description, attribute8DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getDateTypeDefAttribute(attribute9Name, attribute9Description, attribute9DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringStringTypeDefAttribute(OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, OpenMetadataProperty.ADDITIONAL_PROPERTIES.description, OpenMetadataProperty.ADDITIONAL_PROPERTIES.descriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update0715DigitalServiceOwnership() {
        this.archiveBuilder.addTypeDefPatch(this.updateDigitalServiceOperatorRelationship());
    }

    private TypeDefPatch updateDigitalServiceOperatorRelationship() {
        String typeName = "DigitalServiceOperator";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("DigitalServiceOperator");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        String end2AttributeName = "digitalServiceOperators";
        String end2AttributeDescription = "The unit (team, capability, ...) responsible for managing this digital service.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "digitalServiceOperators", "The unit (team, capability, ...) responsible for managing this digital service.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        typeDefPatch.setEndDef2(relationshipEndDef);
        return typeDefPatch;
    }

    private void update0735SolutionPortsAndWires() {
        this.archiveBuilder.addTypeDefPatch(this.updateSolutionLinkingWireRelationship());
    }

    private TypeDefPatch updateSolutionLinkingWireRelationship() {
        String typeName = "DigitalServiceOperator";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("DigitalServiceOperator");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        String end2AttributeName = "digitalServiceOperators";
        String end2AttributeDescription = "The unit (team, capability, ...) responsible for managing this digital service.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "digitalServiceOperators", "The unit (team, capability, ...) responsible for managing this digital service.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        typeDefPatch.setEndDef2(relationshipEndDef);
        return typeDefPatch;
    }
}

