/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.opentypes;

import java.util.ArrayList;
import java.util.Date;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchive3_4;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationPropagationRule;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndCardinality;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefLink;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefStatus;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;

public class OpenMetadataTypesArchive3_5 {
    private static final String archiveGUID = "bce3b0a0-662a-4f87-b8dc-844078a11a6e";
    private static final String archiveName = "Open Metadata Types";
    private static final String archiveDescription = "Standard types for open metadata repositories.";
    private static final OpenMetadataArchiveType archiveType = OpenMetadataArchiveType.CONTENT_PACK;
    private static final String archiveVersion = "3.5";
    private static final String originatorName = "Egeria";
    private static final String originatorLicense = "Apache-2.0";
    private static final Date creationDate = new Date(1588261366992L);
    private static final long versionNumber = 1L;
    private static final String versionName = "1.0";
    private final OMRSArchiveBuilder archiveBuilder;
    private final OMRSArchiveHelper archiveHelper;

    public OpenMetadataTypesArchive3_5() {
        this.archiveBuilder = new OMRSArchiveBuilder(archiveGUID, archiveName, archiveDescription, archiveType, archiveVersion, originatorName, originatorLicense, creationDate, null);
        this.archiveHelper = new OMRSArchiveHelper(this.archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public OpenMetadataTypesArchive3_5(OMRSArchiveBuilder archiveBuilder) {
        this.archiveBuilder = archiveBuilder;
        this.archiveHelper = new OMRSArchiveHelper(archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public String getArchiveGUID() {
        return archiveGUID;
    }

    public OpenMetadataArchive getOpenMetadataArchive() {
        String methodName = "getOpenMetadataArchive";
        if (this.archiveBuilder != null) {
            this.getOriginalTypes();
            return this.archiveBuilder.getOpenMetadataArchive();
        }
        throw new OMRSLogicErrorException(OMRSErrorCode.ARCHIVE_UNAVAILABLE.getMessageDefinition(), this.getClass().getName(), "getOpenMetadataArchive");
    }

    public void getOriginalTypes() {
        OpenMetadataTypesArchive3_4 previousTypes = new OpenMetadataTypesArchive3_4(this.archiveBuilder);
        previousTypes.getOriginalTypes();
        this.update0041ServerPurpose();
        this.update00420045SoftwareCapabilities();
        this.extend0112Person();
        this.update0130Projects();
        this.update0140Communities();
    }

    private void update00420045SoftwareCapabilities() {
        this.archiveBuilder.addEntityDef(this.getSoftwareCapabilityEntity());
        this.archiveBuilder.addRelationshipDef(this.getSupportedSoftwareCapabilityRelationship());
        this.archiveBuilder.addTypeDefPatch(this.deprecateSoftwareServerSupportedCapabilityRelationship());
        this.archiveBuilder.addTypeDefPatch(this.updateSoftwareServerCapabilityEntity());
        this.archiveBuilder.addTypeDefPatch(this.updateFileSystemClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateFileManagerClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateNotificationManagerClassification());
        this.archiveBuilder.addClassificationDef(this.addSourceControlLibraryClassification());
        this.archiveBuilder.addClassificationDef(this.addChangeManagementLibraryClassification());
        this.archiveBuilder.addClassificationDef(this.addSoftwareLibraryClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateDatabaseManagerClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateContentCollectionManagerClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateCloudServiceClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateServerAssetUseRelationship());
        this.archiveBuilder.addTypeDefPatch(this.updateSoftwareServerDeploymentRelationship());
    }

    private EntityDef getSoftwareCapabilityEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.SOFTWARE_CAPABILITY, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute3Name = OpenMetadataProperty.CAPABILITY_TYPE.name;
        String attribute3Description = OpenMetadataProperty.CAPABILITY_TYPE.description;
        String attribute3DescriptionGUID = OpenMetadataProperty.CAPABILITY_TYPE.descriptionGUID;
        String attribute4Name = OpenMetadataProperty.CAPABILITY_VERSION.name;
        String attribute4Description = OpenMetadataProperty.CAPABILITY_VERSION.description;
        String attribute4DescriptionGUID = OpenMetadataProperty.CAPABILITY_VERSION.descriptionGUID;
        String attribute5Name = OpenMetadataProperty.PATCH_LEVEL.name;
        String attribute5Description = OpenMetadataProperty.PATCH_LEVEL.description;
        String attribute5DescriptionGUID = OpenMetadataProperty.PATCH_LEVEL.descriptionGUID;
        String attribute7Name = OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name;
        String attribute7Description = OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.description;
        String attribute7DescriptionGUID = OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.NAME.name, OpenMetadataProperty.NAME.description, OpenMetadataProperty.NAME.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.DESCRIPTION.name, OpenMetadataProperty.DESCRIPTION.description, OpenMetadataProperty.DESCRIPTION.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute3Name, attribute3Description, attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute4Name, attribute4Description, attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute5Name, attribute5Description, attribute5DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.SOURCE.name, OpenMetadataProperty.SOURCE.description, OpenMetadataProperty.SOURCE.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute7Name, attribute7Description, attribute7DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef getSupportedSoftwareCapabilityRelationship() {
        String guid = OpenMetadataType.SUPPORTED_CAPABILITY_RELATIONSHIP.typeGUID;
        String name = OpenMetadataType.SUPPORTED_CAPABILITY_RELATIONSHIP.typeName;
        String description = OpenMetadataType.SUPPORTED_CAPABILITY_RELATIONSHIP.description;
        String descriptionGUID = OpenMetadataType.SUPPORTED_CAPABILITY_RELATIONSHIP.descriptionGUID;
        String descriptionWiki = OpenMetadataType.SUPPORTED_CAPABILITY_RELATIONSHIP.wikiURL;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(guid, name, null, description, descriptionGUID, descriptionWiki, ClassificationPropagationRule.NONE);
        String end1EntityType = OpenMetadataType.IT_INFRASTRUCTURE.typeName;
        String end1AttributeName = "hostedByDeployedITInfrastructure";
        String end1AttributeDescription = "IT infrastructure hosting this capability.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "hostedByDeployedITInfrastructure", "IT infrastructure hosting this capability.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "capabilities";
        String end2AttributeDescription = "Capabilities deployed on this IT infrastructure.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.SOFTWARE_CAPABILITY.typeName), "capabilities", "Capabilities deployed on this IT infrastructure.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.DEPLOYMENT_TIME.name;
        String attribute1Description = OpenMetadataProperty.DEPLOYMENT_TIME.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.DEPLOYMENT_TIME.descriptionGUID;
        String attribute2Name = OpenMetadataProperty.DEPLOYER.name;
        String attribute2Description = OpenMetadataProperty.DEPLOYER.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.DEPLOYER.descriptionGUID;
        String attribute3Name = OpenMetadataProperty.DEPLOYER_TYPE_NAME.name;
        String attribute3Description = OpenMetadataProperty.DEPLOYER_TYPE_NAME.description;
        String attribute3DescriptionGUID = OpenMetadataProperty.DEPLOYER_TYPE_NAME.descriptionGUID;
        String attribute4Name = OpenMetadataProperty.DEPLOYER_PROPERTY_NAME.name;
        String attribute4Description = OpenMetadataProperty.DEPLOYER_PROPERTY_NAME.description;
        String attribute4DescriptionGUID = OpenMetadataProperty.DEPLOYER_PROPERTY_NAME.descriptionGUID;
        String attribute5Name = OpenMetadataProperty.OPERATIONAL_STATUS.name;
        String attribute5Description = OpenMetadataProperty.OPERATIONAL_STATUS.description;
        String attribute5DescriptionGUID = OpenMetadataProperty.OPERATIONAL_STATUS.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getDateTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute3Name, attribute3Description, attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute4Name, attribute4Description, attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getEnumTypeDefAttribute("OperationalStatus", attribute5Name, attribute5Description, attribute5DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private TypeDefPatch deprecateSoftwareServerSupportedCapabilityRelationship() {
        String typeName = "SoftwareServerSupportedCapability";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("SoftwareServerSupportedCapability");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setTypeDefStatus(TypeDefStatus.DEPRECATED_TYPEDEF);
        return typeDefPatch;
    }

    private TypeDefPatch updateSoftwareServerCapabilityEntity() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.SOFTWARE_SERVER_CAPABILITY.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setSuperType(this.archiveBuilder.getEntityDef(OpenMetadataType.SOFTWARE_CAPABILITY.typeName));
        return typeDefPatch;
    }

    private TypeDefPatch updateFileSystemClassification() {
        String typeName = "FileSystem";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("FileSystem");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefLink> validEntityDefs = new ArrayList<TypeDefLink>();
        validEntityDefs.add(new TypeDefLink(this.archiveBuilder.getTypeDefByName(OpenMetadataType.REFERENCEABLE.typeName)));
        typeDefPatch.setValidEntityDefs(validEntityDefs);
        return typeDefPatch;
    }

    private TypeDefPatch updateFileManagerClassification() {
        String typeName = "FileManager";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("FileManager");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefLink> validEntityDefs = new ArrayList<TypeDefLink>();
        validEntityDefs.add(new TypeDefLink(this.archiveBuilder.getTypeDefByName(OpenMetadataType.REFERENCEABLE.typeName)));
        typeDefPatch.setValidEntityDefs(validEntityDefs);
        return typeDefPatch;
    }

    private TypeDefPatch updateNotificationManagerClassification() {
        String typeName = OpenMetadataType.NOTIFICATION_MANAGER.typeName;
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefLink> validEntityDefs = new ArrayList<TypeDefLink>();
        validEntityDefs.add(new TypeDefLink(this.archiveBuilder.getTypeDefByName(OpenMetadataType.REFERENCEABLE.typeName)));
        typeDefPatch.setValidEntityDefs(validEntityDefs);
        return typeDefPatch;
    }

    private TypeDefPatch updateContentCollectionManagerClassification() {
        String typeName = "ContentCollectionManager";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("ContentCollectionManager");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefLink> validEntityDefs = new ArrayList<TypeDefLink>();
        validEntityDefs.add(new TypeDefLink(this.archiveBuilder.getTypeDefByName(OpenMetadataType.REFERENCEABLE.typeName)));
        typeDefPatch.setValidEntityDefs(validEntityDefs);
        return typeDefPatch;
    }

    private ClassificationDef addSourceControlLibraryClassification() {
        String guid = "0ef3c90d-20d7-4259-8d66-9c8bb109f2ae";
        String name = "SourceControlLibrary";
        String description = "Defines a software source code library that provides version control.";
        String descriptionGUID = null;
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef("0ef3c90d-20d7-4259-8d66-9c8bb109f2ae", "SourceControlLibrary", null, "Defines a software source code library that provides version control.", descriptionGUID, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), true);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "libraryType";
        String attribute1Description = "The type of library - may be a product name or open source project name.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("libraryType", "The type of library - may be a product name or open source project name.", attribute1DescriptionGUID);
        properties.add(property);
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private ClassificationDef addChangeManagementLibraryClassification() {
        String guid = "4e236548-b802-4a1d-a329-4abdeaae5323";
        String name = "ChangeManagementLibrary";
        String description = "Defines a managed collection of requirements, defects and proposed changes to a project.";
        String descriptionGUID = null;
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef("4e236548-b802-4a1d-a329-4abdeaae5323", "ChangeManagementLibrary", null, "Defines a managed collection of requirements, defects and proposed changes to a project.", descriptionGUID, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), true);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "libraryType";
        String attribute1Description = "The type of library - may be a product name or open source project name.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("libraryType", "The type of library - may be a product name or open source project name.", attribute1DescriptionGUID);
        properties.add(property);
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private ClassificationDef addSoftwareLibraryClassification() {
        String guid = "5708fa1a-2b64-4706-8e14-a020e4567db3";
        String name = "SoftwareLibrary";
        String description = "Defines a collection of software modules.  Also known as the definitive software library.";
        String descriptionGUID = null;
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef("5708fa1a-2b64-4706-8e14-a020e4567db3", "SoftwareLibrary", null, "Defines a collection of software modules.  Also known as the definitive software library.", descriptionGUID, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), true);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "libraryType";
        String attribute1Description = "The type of library - may be a product name or open source project name.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("libraryType", "The type of library - may be a product name or open source project name.", attribute1DescriptionGUID);
        properties.add(property);
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private TypeDefPatch updateCloudServiceClassification() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.CLOUD_SERVICE_CLASSIFICATION.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefLink> validEntityDefs = new ArrayList<TypeDefLink>();
        validEntityDefs.add(new TypeDefLink(this.archiveBuilder.getTypeDefByName(OpenMetadataType.SOFTWARE_CAPABILITY.typeName)));
        typeDefPatch.setValidEntityDefs(validEntityDefs);
        return typeDefPatch;
    }

    private TypeDefPatch updateDatabaseManagerClassification() {
        String typeName = "DatabaseManager";
        String attachToEntity = "DataManager";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("DatabaseManager");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefLink> validEntityDefs = new ArrayList<TypeDefLink>();
        validEntityDefs.add(new TypeDefLink(this.archiveBuilder.getTypeDefByName("DataManager")));
        typeDefPatch.setValidEntityDefs(validEntityDefs);
        return typeDefPatch;
    }

    private TypeDefPatch updateServerAssetUseRelationship() {
        String typeName = "ServerAssetUse";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("ServerAssetUse");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        String end1AttributeName = "consumedBy";
        String end1AttributeDescription = "Capability consuming this asset.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.SOFTWARE_CAPABILITY.typeName), "consumedBy", "Capability consuming this asset.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        typeDefPatch.setEndDef1(relationshipEndDef);
        String end2AttributeName = "consumedAsset";
        String end2AttributeDescription = "Asset that this software capability is dependent on.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.ASSET.typeName), "consumedAsset", "Asset that this software capability is dependent on.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        typeDefPatch.setEndDef2(relationshipEndDef);
        return typeDefPatch;
    }

    private TypeDefPatch updateSoftwareServerDeploymentRelationship() {
        String typeName = "SoftwareServerDeployment";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("SoftwareServerDeployment");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        String end1EntityType = "SoftwareServerPlatform";
        String end1AttributeName = "hostingPlatforms";
        String end1AttributeDescription = "Supporting platforms for the software server.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("SoftwareServerPlatform"), "hostingPlatforms", "Supporting platforms for the software server.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        typeDefPatch.setEndDef1(relationshipEndDef);
        return typeDefPatch;
    }

    private void update0041ServerPurpose() {
        this.archiveBuilder.addClassificationDef(this.addServerPurposeClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateApplicationServerClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateWebserverClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateDatabaseServerClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateMetadataServerClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateRepositoryProxyClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateGovernanceDaemonClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateStewardshipServerClassification());
        this.archiveBuilder.addClassificationDef(this.addIntegrationServerClassification());
    }

    private ClassificationDef addServerPurposeClassification() {
        ArrayList<TypeDefLink> linkedToEntities = new ArrayList<TypeDefLink>();
        linkedToEntities.add(this.archiveBuilder.getEntityDef(OpenMetadataType.IT_INFRASTRUCTURE.typeName));
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef(OpenMetadataType.SERVER_PURPOSE_CLASSIFICATION.typeGUID, OpenMetadataType.SERVER_PURPOSE_CLASSIFICATION.typeName, null, OpenMetadataType.SERVER_PURPOSE_CLASSIFICATION.description, OpenMetadataType.SERVER_PURPOSE_CLASSIFICATION.descriptionGUID, OpenMetadataType.SERVER_PURPOSE_CLASSIFICATION.wikiURL, linkedToEntities, false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name;
        String attribute1Description = OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private TypeDefPatch updateApplicationServerClassification() {
        String typeName = OpenMetadataType.APPLICATION_SERVER_CLASSIFICATION.typeName;
        String superTypeName = OpenMetadataType.SERVER_PURPOSE_CLASSIFICATION.typeName;
        String attachToEntity = OpenMetadataType.IT_INFRASTRUCTURE.typeName;
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setSuperType(this.archiveBuilder.getTypeDefByName(superTypeName));
        ArrayList<TypeDefLink> validEntityDefs = new ArrayList<TypeDefLink>();
        validEntityDefs.add(new TypeDefLink(this.archiveBuilder.getTypeDefByName(attachToEntity)));
        typeDefPatch.setValidEntityDefs(validEntityDefs);
        return typeDefPatch;
    }

    private TypeDefPatch updateWebserverClassification() {
        String typeName = OpenMetadataType.WEBSERVER_CLASSIFICATION.typeName;
        String superTypeName = OpenMetadataType.SERVER_PURPOSE_CLASSIFICATION.typeName;
        String attachToEntity = OpenMetadataType.IT_INFRASTRUCTURE.typeName;
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setSuperType(this.archiveBuilder.getTypeDefByName(superTypeName));
        ArrayList<TypeDefLink> validEntityDefs = new ArrayList<TypeDefLink>();
        validEntityDefs.add(new TypeDefLink(this.archiveBuilder.getTypeDefByName(attachToEntity)));
        typeDefPatch.setValidEntityDefs(validEntityDefs);
        return typeDefPatch;
    }

    private TypeDefPatch updateDatabaseServerClassification() {
        String typeName = OpenMetadataType.DATABASE_SERVER_CLASSIFICATION.typeName;
        String superTypeName = OpenMetadataType.SERVER_PURPOSE_CLASSIFICATION.typeName;
        String attachToEntity = OpenMetadataType.IT_INFRASTRUCTURE.typeName;
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setSuperType(this.archiveBuilder.getTypeDefByName(superTypeName));
        ArrayList<TypeDefLink> validEntityDefs = new ArrayList<TypeDefLink>();
        validEntityDefs.add(new TypeDefLink(this.archiveBuilder.getTypeDefByName(attachToEntity)));
        typeDefPatch.setValidEntityDefs(validEntityDefs);
        return typeDefPatch;
    }

    private TypeDefPatch updateMetadataServerClassification() {
        String typeName = OpenMetadataType.METADATA_SERVER_CLASSIFICATION.typeName;
        String superTypeName = OpenMetadataType.SERVER_PURPOSE_CLASSIFICATION.typeName;
        String attachToEntity = OpenMetadataType.IT_INFRASTRUCTURE.typeName;
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setSuperType(this.archiveBuilder.getTypeDefByName(superTypeName));
        ArrayList<TypeDefLink> validEntityDefs = new ArrayList<TypeDefLink>();
        validEntityDefs.add(new TypeDefLink(this.archiveBuilder.getTypeDefByName(attachToEntity)));
        typeDefPatch.setValidEntityDefs(validEntityDefs);
        return typeDefPatch;
    }

    private TypeDefPatch updateRepositoryProxyClassification() {
        String typeName = OpenMetadataType.REPOSITORY_PROXY_CLASSIFICATION.typeName;
        String superTypeName = OpenMetadataType.SERVER_PURPOSE_CLASSIFICATION.typeName;
        String attachToEntity = OpenMetadataType.IT_INFRASTRUCTURE.typeName;
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setSuperType(this.archiveBuilder.getTypeDefByName(superTypeName));
        ArrayList<TypeDefLink> validEntityDefs = new ArrayList<TypeDefLink>();
        validEntityDefs.add(new TypeDefLink(this.archiveBuilder.getTypeDefByName(attachToEntity)));
        typeDefPatch.setValidEntityDefs(validEntityDefs);
        return typeDefPatch;
    }

    private TypeDefPatch updateGovernanceDaemonClassification() {
        String typeName = OpenMetadataType.GOVERNANCE_DAEMON_CLASSIFICATION.typeName;
        String superTypeName = OpenMetadataType.SERVER_PURPOSE_CLASSIFICATION.typeName;
        String attachToEntity = OpenMetadataType.IT_INFRASTRUCTURE.typeName;
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setSuperType(this.archiveBuilder.getTypeDefByName(superTypeName));
        ArrayList<TypeDefLink> validEntityDefs = new ArrayList<TypeDefLink>();
        validEntityDefs.add(new TypeDefLink(this.archiveBuilder.getTypeDefByName(attachToEntity)));
        typeDefPatch.setValidEntityDefs(validEntityDefs);
        return typeDefPatch;
    }

    private TypeDefPatch updateStewardshipServerClassification() {
        String typeName = OpenMetadataType.STEWARDSHIP_SERVER_CLASSIFICATION.typeName;
        String superTypeName = OpenMetadataType.SERVER_PURPOSE_CLASSIFICATION.typeName;
        String attachToEntity = OpenMetadataType.IT_INFRASTRUCTURE.typeName;
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setSuperType(this.archiveBuilder.getTypeDefByName(superTypeName));
        ArrayList<TypeDefLink> validEntityDefs = new ArrayList<TypeDefLink>();
        validEntityDefs.add(new TypeDefLink(this.archiveBuilder.getTypeDefByName(attachToEntity)));
        typeDefPatch.setValidEntityDefs(validEntityDefs);
        return typeDefPatch;
    }

    private ClassificationDef addIntegrationServerClassification() {
        ArrayList<TypeDefLink> linkedToEntities = new ArrayList<TypeDefLink>();
        linkedToEntities.add(this.archiveBuilder.getEntityDef(OpenMetadataType.IT_INFRASTRUCTURE.typeName));
        return this.archiveHelper.getClassificationDef(OpenMetadataType.INTEGRATION_SERVER_CLASSIFICATION.typeGUID, OpenMetadataType.INTEGRATION_SERVER_CLASSIFICATION.typeName, (TypeDefLink)this.archiveBuilder.getClassificationDef(OpenMetadataType.SERVER_PURPOSE_CLASSIFICATION.typeName), OpenMetadataType.INTEGRATION_SERVER_CLASSIFICATION.description, OpenMetadataType.INTEGRATION_SERVER_CLASSIFICATION.descriptionGUID, OpenMetadataType.INTEGRATION_SERVER_CLASSIFICATION.wikiURL, linkedToEntities, false);
    }

    private void extend0112Person() {
        this.archiveBuilder.addTypeDefPatch(this.updatePersonEntity());
    }

    private TypeDefPatch updatePersonEntity() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.PERSON.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.COURTESY_TITLE.name, OpenMetadataProperty.COURTESY_TITLE.description, OpenMetadataProperty.COURTESY_TITLE.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.GIVEN_NAMES.name, OpenMetadataProperty.GIVEN_NAMES.description, OpenMetadataProperty.GIVEN_NAMES.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.SURNAME.name, OpenMetadataProperty.SURNAME.description, OpenMetadataProperty.SURNAME.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.EMPLOYEE_NUMBER.name, OpenMetadataProperty.EMPLOYEE_NUMBER.description, OpenMetadataProperty.EMPLOYEE_NUMBER.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.EMPLOYEE_TYPE.name, OpenMetadataProperty.EMPLOYEE_TYPE.description, OpenMetadataProperty.EMPLOYEE_TYPE.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.PREFERRED_LANGUAGE.name, OpenMetadataProperty.PREFERRED_LANGUAGE.description, OpenMetadataProperty.PREFERRED_LANGUAGE.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.INITIALS.name, OpenMetadataProperty.INITIALS.description, OpenMetadataProperty.INITIALS.descriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update0130Projects() {
        this.archiveBuilder.addTypeDefPatch(this.updateProjectManagementRelationship());
    }

    private TypeDefPatch updateProjectManagementRelationship() {
        String typeName = "ProjectManagement";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("ProjectManagement");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        String end2AttributeName = "projectManagers";
        String end2AttributeDescription = "The roles for managing this project.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.PERSON_ROLE.typeName), "projectManagers", "The roles for managing this project.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        typeDefPatch.setEndDef2(relationshipEndDef);
        return typeDefPatch;
    }

    private void update0140Communities() {
        this.archiveBuilder.addTypeDefPatch(this.updateCommunityMembershipRelationship());
    }

    private TypeDefPatch updateCommunityMembershipRelationship() {
        String typeName = "CommunityMembership";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("CommunityMembership");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        String end2AttributeName = "communityMembers";
        String end2AttributeDescription = "Members of the community.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.PERSON_ROLE.typeName), "communityMembers", "Members of the community.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        typeDefPatch.setEndDef2(relationshipEndDef);
        return typeDefPatch;
    }
}

