/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.opentypes;

import java.util.ArrayList;
import java.util.Date;
import org.odpi.openmetadata.frameworks.openmetadata.enums.CollectionMemberStatus;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ToDoStatus;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchive3_15;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationPropagationRule;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumElementDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndCardinality;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;

public class OpenMetadataTypesArchive4_0 {
    private static final String archiveGUID = "bce3b0a0-662a-4f87-b8dc-844078a11a6e";
    private static final String archiveName = "Open Metadata Types";
    private static final String archiveDescription = "Standard types for open metadata repositories.";
    private static final OpenMetadataArchiveType archiveType = OpenMetadataArchiveType.CONTENT_PACK;
    private static final String archiveVersion = "4.0";
    private static final String originatorName = "Egeria";
    private static final String originatorLicense = "Apache-2.0";
    private static final Date creationDate = new Date(1588261366992L);
    private static final long versionNumber = 1L;
    private static final String versionName = "1.0";
    private final OMRSArchiveBuilder archiveBuilder;
    private final OMRSArchiveHelper archiveHelper;

    public OpenMetadataTypesArchive4_0() {
        this.archiveBuilder = new OMRSArchiveBuilder(archiveGUID, archiveName, archiveDescription, archiveType, archiveVersion, originatorName, originatorLicense, creationDate, null);
        this.archiveHelper = new OMRSArchiveHelper(this.archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public OpenMetadataTypesArchive4_0(OMRSArchiveBuilder archiveBuilder) {
        this.archiveBuilder = archiveBuilder;
        this.archiveHelper = new OMRSArchiveHelper(archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public String getArchiveGUID() {
        return archiveGUID;
    }

    public OpenMetadataArchive getOpenMetadataArchive() {
        String methodName = "getOpenMetadataArchive";
        if (this.archiveBuilder != null) {
            this.getOriginalTypes();
            return this.archiveBuilder.getOpenMetadataArchive();
        }
        throw new OMRSLogicErrorException(OMRSErrorCode.ARCHIVE_UNAVAILABLE.getMessageDefinition(), this.getClass().getName(), "getOpenMetadataArchive");
    }

    public void getOriginalTypes() {
        OpenMetadataTypesArchive3_15 previousTypes = new OpenMetadataTypesArchive3_15(this.archiveBuilder);
        previousTypes.getOriginalTypes();
        this.update0021Collections();
        this.update0137ToDos();
        this.add0220DataFileCollectionDataSet();
        this.add0224TableDataSet();
        this.add0239DeployedReportType();
        this.update0385ControlledGlossaries();
        this.update0462GovernanceActionProcesses();
        this.create0464DynamicIntegrationGroups();
        this.update0470IncidentClassifierSet();
        this.update0484AgreementActor();
        this.update0545ReferenceData();
        this.update0720InformationSupplyChains();
        this.addFormulaTypeAttribute();
    }

    private void update0385ControlledGlossaries() {
        this.archiveBuilder.addTypeDefPatch(this.updateControlledGlossaryTermEntity());
        this.archiveBuilder.addRelationshipDef(this.addGlossaryTermEvolutionRelationship());
    }

    private TypeDefPatch updateControlledGlossaryTermEntity() {
        String typeName = "ControlledGlossaryTerm";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("ControlledGlossaryTerm");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "userDefinedStatus";
        String attribute1Description = "Extend or replace the valid instance statuses with additional statuses controlled through valid metadata values.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("userDefinedStatus", "Extend or replace the valid instance statuses with additional statuses controlled through valid metadata values.", attribute1DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        ArrayList<InstanceStatus> validInstanceStatusList = new ArrayList<InstanceStatus>();
        validInstanceStatusList.add(InstanceStatus.DRAFT);
        validInstanceStatusList.add(InstanceStatus.PREPARED);
        validInstanceStatusList.add(InstanceStatus.PROPOSED);
        validInstanceStatusList.add(InstanceStatus.APPROVED);
        validInstanceStatusList.add(InstanceStatus.REJECTED);
        validInstanceStatusList.add(InstanceStatus.ACTIVE);
        validInstanceStatusList.add(InstanceStatus.DEPRECATED);
        validInstanceStatusList.add(InstanceStatus.OTHER);
        validInstanceStatusList.add(InstanceStatus.DELETED);
        typeDefPatch.setValidInstanceStatusList(validInstanceStatusList);
        return typeDefPatch;
    }

    private RelationshipDef addGlossaryTermEvolutionRelationship() {
        String guid = "b323c9cf-f254-49c7-a391-11222e9da70f";
        String name = "GlossaryTermEvolution";
        String description = "Links a live glossary term with a future version of the term.";
        String descriptionGUID = null;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("b323c9cf-f254-49c7-a391-11222e9da70f", "GlossaryTermEvolution", null, "Links a live glossary term with a future version of the term.", descriptionGUID, ClassificationPropagationRule.NONE);
        String end1EntityType = "ControlledGlossaryTerm";
        String end1AttributeName = "glossaryTermUpdates";
        String end1AttributeDescription = "A glossary term that contains proposed updates to the live glossary term.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("ControlledGlossaryTerm"), "glossaryTermUpdates", "A glossary term that contains proposed updates to the live glossary term.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "liveGlossaryTerm";
        String end2AttributeDescription = "The approved term that is in use.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.GLOSSARY_TERM.typeName), "liveGlossaryTerm", "The approved term that is in use.", end2AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.DESCRIPTION.name, OpenMetadataProperty.DESCRIPTION.description, OpenMetadataProperty.DESCRIPTION.descriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void update0021Collections() {
        this.archiveBuilder.addEnumDef(this.getMembershipStatusEnum());
        this.archiveBuilder.addTypeDefPatch(this.updateCollectionMembershipRelationship());
    }

    private EnumDef getMembershipStatusEnum() {
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef(CollectionMemberStatus.getOpenTypeGUID(), CollectionMemberStatus.getOpenTypeName(), CollectionMemberStatus.getOpenTypeDescription(), CollectionMemberStatus.getOpenTypeDescriptionGUID(), CollectionMemberStatus.getOpenTypeDescriptionWiki());
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        for (CollectionMemberStatus collectionMemberStatus : CollectionMemberStatus.values()) {
            EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(collectionMemberStatus.getOrdinal(), collectionMemberStatus.getName(), collectionMemberStatus.getDescription(), collectionMemberStatus.getDescriptionGUID());
            elementDefs.add(elementDef);
            if (!collectionMemberStatus.isDefault()) continue;
            enumDef.setDefaultValue(elementDef);
        }
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private TypeDefPatch updateCollectionMembershipRelationship() {
        String typeName = OpenMetadataType.COLLECTION_MEMBERSHIP_RELATIONSHIP.typeName;
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.MEMBERSHIP_RATIONALE.name;
        String attribute1Description = OpenMetadataProperty.MEMBERSHIP_RATIONALE.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.MEMBERSHIP_RATIONALE.descriptionGUID;
        String attribute2Name = OpenMetadataProperty.EXPRESSION.name;
        String attribute2Description = OpenMetadataProperty.EXPRESSION.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.EXPRESSION.descriptionGUID;
        String attribute3Name = OpenMetadataProperty.MEMBERSHIP_STATUS.name;
        String attribute3Description = OpenMetadataProperty.MEMBERSHIP_STATUS.description;
        String attribute3DescriptionGUID = OpenMetadataProperty.MEMBERSHIP_STATUS.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getEnumTypeDefAttribute(CollectionMemberStatus.getOpenTypeName(), attribute3Name, attribute3Description, attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getIntTypeDefAttribute(OpenMetadataProperty.CONFIDENCE.name, OpenMetadataProperty.CONFIDENCE.description, OpenMetadataProperty.CONFIDENCE.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.STEWARD.name, OpenMetadataProperty.STEWARD.description, OpenMetadataProperty.STEWARD.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.SOURCE.name, OpenMetadataProperty.SOURCE.description, OpenMetadataProperty.SOURCE.descriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update0137ToDos() {
        this.archiveBuilder.addTypeDefPatch(this.updateActionTargetRelationship());
    }

    private TypeDefPatch updateActionTargetRelationship() {
        String typeName = OpenMetadataType.ACTION_TARGET_RELATIONSHIP.typeName;
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.TO_DO_STATUS.name;
        String attribute1Description = OpenMetadataProperty.TO_DO_STATUS.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.TO_DO_STATUS.descriptionGUID;
        String attribute2Name = OpenMetadataProperty.START_DATE.name;
        String attribute2Description = OpenMetadataProperty.START_DATE.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.START_DATE.descriptionGUID;
        String attribute3Name = OpenMetadataProperty.COMPLETION_DATE.name;
        String attribute3Description = OpenMetadataProperty.COMPLETION_DATE.description;
        String attribute3DescriptionGUID = OpenMetadataProperty.COMPLETION_DATE.descriptionGUID;
        String attribute4Name = OpenMetadataProperty.ACTION_TARGET_NAME.name;
        String attribute4Description = OpenMetadataProperty.ACTION_TARGET_NAME.description;
        String attribute4DescriptionGUID = OpenMetadataProperty.ACTION_TARGET_NAME.descriptionGUID;
        String attribute5Name = OpenMetadataProperty.COMPLETION_MESSAGE.name;
        String attribute5Description = OpenMetadataProperty.COMPLETION_MESSAGE.description;
        String attribute5DescriptionGUID = OpenMetadataProperty.COMPLETION_MESSAGE.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getEnumTypeDefAttribute(ToDoStatus.getOpenTypeName(), attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getDateTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getDateTypeDefAttribute(attribute3Name, attribute3Description, attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute4Name, attribute4Description, attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute5Name, attribute5Description, attribute5DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void add0220DataFileCollectionDataSet() {
        this.archiveBuilder.addEntityDef(this.getDataFileCollectionDataSetEntity());
    }

    private EntityDef getDataFileCollectionDataSetEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.DATA_FILE_COLLECTION, this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_SET.typeName));
    }

    private void add0224TableDataSet() {
        this.archiveBuilder.addEntityDef(this.getTableDataSetEntity());
    }

    private EntityDef getTableDataSetEntity() {
        String guid = OpenMetadataType.TABLE_DATA_SET.typeGUID;
        String name = OpenMetadataType.TABLE_DATA_SET.typeName;
        String description = OpenMetadataType.TABLE_DATA_SET.description;
        String descriptionGUID = OpenMetadataType.TABLE_DATA_SET.descriptionGUID;
        String descriptionWiki = OpenMetadataType.TABLE_DATA_SET.wikiURL;
        return this.archiveHelper.getDefaultEntityDef(guid, name, this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_SET.typeName), description, descriptionGUID, descriptionWiki);
    }

    private void add0239DeployedReportType() {
        this.archiveBuilder.addEntityDef(this.getDeployedReportTypeEntity());
    }

    private EntityDef getDeployedReportTypeEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.DEPLOYED_REPORT_TYPE, this.archiveBuilder.getEntityDef(OpenMetadataType.ASSET.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ID));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.AUTHOR));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.URL));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.CREATED_TIME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.LAST_MODIFIED_TIME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.LAST_MODIFIER));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private void update0462GovernanceActionProcesses() {
        this.archiveBuilder.addTypeDefPatch(this.update0462GovernanceActionExecutorRelationship());
    }

    private TypeDefPatch update0462GovernanceActionExecutorRelationship() {
        String typeName = "GovernanceActionExecutor";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("GovernanceActionExecutor");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.REQUEST_PARAMETER_FILTER.name;
        String attribute1Description = OpenMetadataProperty.REQUEST_PARAMETER_FILTER.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.REQUEST_PARAMETER_FILTER.descriptionGUID;
        String attribute2Name = OpenMetadataProperty.REQUEST_PARAMETER_MAP.name;
        String attribute2Description = OpenMetadataProperty.REQUEST_PARAMETER_MAP.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.REQUEST_PARAMETER_MAP.descriptionGUID;
        String attribute3Name = OpenMetadataProperty.ACTION_TARGET_FILTER.name;
        String attribute3Description = OpenMetadataProperty.ACTION_TARGET_FILTER.description;
        String attribute3DescriptionGUID = OpenMetadataProperty.ACTION_TARGET_FILTER.descriptionGUID;
        String attribute4Name = OpenMetadataProperty.ACTION_TARGET_MAP.name;
        String attribute4Description = OpenMetadataProperty.ACTION_TARGET_MAP.description;
        String attribute4DescriptionGUID = OpenMetadataProperty.ACTION_TARGET_MAP.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getArrayStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringStringTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getArrayStringTypeDefAttribute(attribute3Name, attribute3Description, attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringStringTypeDefAttribute(attribute4Name, attribute4Description, attribute4DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void create0464DynamicIntegrationGroups() {
        this.archiveBuilder.addEntityDef(this.addIntegrationGroupEntity());
        this.archiveBuilder.addEntityDef(this.addIntegrationConnectorEntity());
        this.archiveBuilder.addEntityDef(this.addIntegrationReportEntity());
        this.archiveBuilder.addRelationshipDef(this.addRegisteredIntegrationConnectorRelationship());
        this.archiveBuilder.addRelationshipDef(this.addCatalogTargetRelationship());
        this.archiveBuilder.addRelationshipDef(this.addRelatedIntegrationReportRelationship());
    }

    private EntityDef addIntegrationGroupEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.INTEGRATION_GROUP.typeGUID, OpenMetadataType.INTEGRATION_GROUP.typeName, this.archiveBuilder.getEntityDef(OpenMetadataType.SOFTWARE_SERVER_CAPABILITY.typeName), OpenMetadataType.INTEGRATION_GROUP.description, OpenMetadataType.INTEGRATION_GROUP.descriptionGUID, OpenMetadataType.INTEGRATION_GROUP.wikiURL);
    }

    private EntityDef addIntegrationConnectorEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.INTEGRATION_CONNECTOR.typeGUID, OpenMetadataType.INTEGRATION_CONNECTOR.typeName, this.archiveBuilder.getEntityDef(OpenMetadataType.DEPLOYED_CONNECTOR.typeName), OpenMetadataType.INTEGRATION_CONNECTOR.description, OpenMetadataType.INTEGRATION_CONNECTOR.descriptionGUID, OpenMetadataType.INTEGRATION_CONNECTOR.wikiURL);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.USES_BLOCKING_CALLS.name;
        String attribute1Description = OpenMetadataProperty.USES_BLOCKING_CALLS.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.USES_BLOCKING_CALLS.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getBooleanTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef addIntegrationReportEntity() {
        String guid = "b8703d3f-8668-4e6a-bf26-27db1607220d";
        String name = "IntegrationReport";
        String description = "Details of the metadata changes made by the execution of the refresh() method by an integration connector.";
        String descriptionGUID = null;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("b8703d3f-8668-4e6a-bf26-27db1607220d", "IntegrationReport", this.archiveBuilder.getEntityDef(OpenMetadataType.OPEN_METADATA_ROOT.typeName), "Details of the metadata changes made by the execution of the refresh() method by an integration connector.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "connectorName";
        String attribute1Description = "Name of the integration connector for logging purposes.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "connectorId";
        String attribute2Description = "Unique identifier of the integration connector deployment.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "serverName";
        String attribute3Description = "Name of the integration daemon where the integration connector is/was running.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "refreshStartDate";
        String attribute4Description = "Date/time when the refresh() call was made.";
        String attribute4DescriptionGUID = null;
        String attribute5Name = "refreshCompletionDate";
        String attribute5Description = "Date/time when the integration connector returned from the refresh() call.";
        String attribute5DescriptionGUID = null;
        String attribute6Name = "createdElements";
        String attribute6Description = "List of elements that were created.";
        String attribute6DescriptionGUID = null;
        String attribute7Name = "updatedElements";
        String attribute7Description = "List of elements that were updated.";
        String attribute7DescriptionGUID = null;
        String attribute8Name = "deletedElements";
        String attribute8Description = "List of elements that were deleted.";
        String attribute8DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("connectorName", "Name of the integration connector for logging purposes.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("connectorId", "Unique identifier of the integration connector deployment.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("serverName", "Name of the integration daemon where the integration connector is/was running.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getDateTypeDefAttribute("refreshStartDate", "Date/time when the refresh() call was made.", attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getDateTypeDefAttribute("refreshCompletionDate", "Date/time when the integration connector returned from the refresh() call.", attribute5DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getArrayStringTypeDefAttribute("createdElements", "List of elements that were created.", attribute6DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getArrayStringTypeDefAttribute("updatedElements", "List of elements that were updated.", attribute7DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getArrayStringTypeDefAttribute("deletedElements", "List of elements that were deleted.", attribute8DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringStringTypeDefAttribute(OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, OpenMetadataProperty.ADDITIONAL_PROPERTIES.description, OpenMetadataProperty.ADDITIONAL_PROPERTIES.descriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef addRegisteredIntegrationConnectorRelationship() {
        String guid = "7528bcd4-ae4c-47d0-a33f-4aeebbaa92c2";
        String name = "RegisteredIntegrationConnector";
        String description = "A link between an integration group and an integration connector that is part of the group.";
        String descriptionGUID = null;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("7528bcd4-ae4c-47d0-a33f-4aeebbaa92c2", "RegisteredIntegrationConnector", null, "A link between an integration group and an integration connector that is part of the group.", descriptionGUID, ClassificationPropagationRule.NONE);
        String end1EntityType = "IntegrationGroup";
        String end1AttributeName = "includedInIntegrationGroups";
        String end1AttributeDescription = "An integration group that this integration connector is a member of.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("IntegrationGroup"), "includedInIntegrationGroups", "An integration group that this integration connector is a member of.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "IntegrationConnector";
        String end2AttributeName = "registeredIntegrationConnectors";
        String end2AttributeDescription = "An integration connector that should run as part of the integration group.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("IntegrationConnector"), "registeredIntegrationConnectors", "An integration connector that should run as part of the integration group.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "connectorName";
        String attribute1Description = "Name of the connector for logging purposes.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "connectorUserId";
        String attribute2Description = "UserId for the integration connector to use when working with open metadata.  The default userId comes from the hosting server if this value is blank.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "metadataSourceQualifiedName";
        String attribute3Description = "Qualified name of a software server capability that is the owner/home of the metadata catalogued by the integration connector.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "startDate";
        String attribute4Description = "Earliest time that the connector can run.";
        String attribute4DescriptionGUID = null;
        String attribute5Name = "stopTime";
        String attribute5Description = "Latest time that the connector can run.";
        String attribute5DescriptionGUID = null;
        String attribute6Name = "refreshTimeInterval";
        String attribute6Description = "Describes how frequently the integration connector should run - in minutes.";
        String attribute6DescriptionGUID = null;
        String attribute7Name = "permittedSynchronization";
        String attribute7Description = "Defines the permitted directions of flow of metadata updates between open metadata and a third party technology.";
        String attribute7DescriptionGUID = null;
        String attribute8Name = "generateIntegrationReport";
        String attribute8Description = "Should the integration daemon create integration reports based on the integration connector's activity? (Default is true.)";
        String attribute8DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("connectorName", "Name of the connector for logging purposes.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("connectorUserId", "UserId for the integration connector to use when working with open metadata.  The default userId comes from the hosting server if this value is blank.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("metadataSourceQualifiedName", "Qualified name of a software server capability that is the owner/home of the metadata catalogued by the integration connector.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getDateTypeDefAttribute("startDate", "Earliest time that the connector can run.", attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getDateTypeDefAttribute("stopTime", "Latest time that the connector can run.", attribute5DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getLongTypeDefAttribute("refreshTimeInterval", "Describes how frequently the integration connector should run - in minutes.", attribute6DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getEnumTypeDefAttribute("PermittedSynchronization", "permittedSynchronization", "Defines the permitted directions of flow of metadata updates between open metadata and a third party technology.", attribute7DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getBooleanTypeDefAttribute("generateIntegrationReport", "Should the integration daemon create integration reports based on the integration connector's activity? (Default is true.)", attribute8DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef addCatalogTargetRelationship() {
        String guid = "bc5a5eb1-881b-4055-aa2c-78f314282ac2";
        String name = "CatalogTarget";
        String description = "Identifies an element that an integration connector is to work with.";
        String descriptionGUID = null;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("bc5a5eb1-881b-4055-aa2c-78f314282ac2", "CatalogTarget", null, "Identifies an element that an integration connector is to work with.", descriptionGUID, ClassificationPropagationRule.NONE);
        String end1EntityType = "IntegrationConnector";
        String end1AttributeName = "cataloguedByConnectors";
        String end1AttributeDescription = "An integration connector managing metadata synchronization.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("IntegrationConnector"), "cataloguedByConnectors", "An integration connector managing metadata synchronization.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "catalogTargets";
        String end2AttributeDescription = "An open metadata element that the integration connector is working on.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.OPEN_METADATA_ROOT.typeName), "catalogTargets", "An open metadata element that the integration connector is working on.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "catalogTargetName";
        String attribute1Description = "Symbolic name of the catalog target to help the integration connector to choose when to use it.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("catalogTargetName", "Symbolic name of the catalog target to help the integration connector to choose when to use it.", attribute1DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef addRelatedIntegrationReportRelationship() {
        String guid = "83d12156-f8f3-4b4b-b31b-18c140df9aa3";
        String name = "RelatedIntegrationReport";
        String description = "Links an integration report to the anchor entity it describes.";
        String descriptionGUID = null;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("83d12156-f8f3-4b4b-b31b-18c140df9aa3", "RelatedIntegrationReport", null, "Links an integration report to the anchor entity it describes.", descriptionGUID, ClassificationPropagationRule.NONE);
        String end1AttributeName = "anchorSubject";
        String end1AttributeDescription = "The anchor entity that the integration report describes.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.OPEN_METADATA_ROOT.typeName), "anchorSubject", "The anchor entity that the integration report describes.", end1AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "IntegrationReport";
        String end2AttributeName = "integrationReports";
        String end2AttributeDescription = "A description of the changes made to the anchor entity by an integration report.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("IntegrationReport"), "integrationReports", "A description of the changes made to the anchor entity by an integration report.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void update0545ReferenceData() {
        this.archiveBuilder.addTypeDefPatch(this.updateReferenceValueAssignment());
    }

    private TypeDefPatch updateReferenceValueAssignment() {
        String typeName = "ReferenceValueAssignment";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("ReferenceValueAssignment");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "attributeName";
        String attribute1Description = "The name of the attribute that the reference data assignment represents.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("attributeName", "The name of the attribute that the reference data assignment represents.", attribute1DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void addFormulaTypeAttribute() {
        this.archiveBuilder.addTypeDefPatch(this.updateDataSet());
        this.archiveBuilder.addTypeDefPatch(this.updateProcess());
        this.archiveBuilder.addTypeDefPatch(this.updateCalculatedValue());
        this.archiveBuilder.addTypeDefPatch(this.updateProcessCall());
        this.archiveBuilder.addTypeDefPatch(this.updateDataFlow());
    }

    private TypeDefPatch updateDataSet() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.DATA_SET.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.FORMULA_TYPE.name;
        String attribute1Description = OpenMetadataProperty.FORMULA_TYPE.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.FORMULA_TYPE.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateProcess() {
        String typeName = OpenMetadataType.PROCESS.typeName;
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.FORMULA_TYPE.name;
        String attribute1Description = OpenMetadataProperty.FORMULA_TYPE.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.FORMULA_TYPE.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateCalculatedValue() {
        String typeName = "CalculatedValue";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("CalculatedValue");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.FORMULA_TYPE.name;
        String attribute1Description = OpenMetadataProperty.FORMULA_TYPE.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.FORMULA_TYPE.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateProcessCall() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.PROCESS_CALL.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.FORMULA_TYPE));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateDataFlow() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.DATA_FLOW.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.FORMULA_TYPE));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update0470IncidentClassifierSet() {
        this.archiveBuilder.addTypeDefPatch(this.updateIncidentClassifierSetClassification());
    }

    private TypeDefPatch updateIncidentClassifierSetClassification() {
        String typeName = "IncidentClassifierSet";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("IncidentClassifierSet");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "incidentClassifierCategory";
        String attribute1Description = "The category of classifiers used to set the incidentClassifiers in IncidentReport.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("incidentClassifierCategory", "The category of classifiers used to set the incidentClassifiers in IncidentReport.", attribute1DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update0484AgreementActor() {
        this.archiveBuilder.addTypeDefPatch(this.updateAgreementActorRelationship());
    }

    private TypeDefPatch updateAgreementActorRelationship() {
        String typeName = "AgreementActor";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("AgreementActor");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setUpdateMultiLink(true);
        typeDefPatch.setMultiLink(true);
        return typeDefPatch;
    }

    private void update0720InformationSupplyChains() {
        this.archiveBuilder.addRelationshipDef(this.getInformationSupplyChainLinkRelationship());
    }

    private RelationshipDef getInformationSupplyChainLinkRelationship() {
        String guid = "207e5130-ab7c-4048-9249-a63a43c13d60";
        String name = "InformationSupplyChainLink";
        String description = "A link between two related information supply chain segments -or to their source or destination.";
        String descriptionGUID = null;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("207e5130-ab7c-4048-9249-a63a43c13d60", "InformationSupplyChainLink", null, "A link between two related information supply chain segments -or to their source or destination.", descriptionGUID, ClassificationPropagationRule.NONE);
        String end1AttributeName = "supplyFrom";
        String end1AttributeDescription = "Logical source of the information supply chain.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "supplyFrom", "Logical source of the information supply chain.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "supplyTo";
        String end2AttributeDescription = "Logical destination of an information supply chain.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "supplyTo", "Logical destination of an information supply chain.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.DESCRIPTION.name, OpenMetadataProperty.DESCRIPTION.description, OpenMetadataProperty.DESCRIPTION.descriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }
}

