/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.utilities;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ArrayPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.MapPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.StructPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.PropertyComparisonOperator;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.PropertyCondition;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.utilities.OMRSRepositoryPropertiesHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PatchErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMRSRepositoryPropertiesUtilities
implements OMRSRepositoryPropertiesHelper {
    public static final String METADATA_COLLECTION_ID_PROPERTY_NAME = "metadataCollectionId";
    public static final String METADATA_COLLECTION_NAME_PROPERTY_NAME = "metadataCollectionName";
    private static final String stringMapTypeGUID = "005c7c14-ac84-4136-beed-959401b041f8";
    private static final String stringMapTypeName = "map<" + PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getName() + "," + PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getName() + ">";
    private static final String booleanMapTypeGUID = "8fa603dd-c2c5-43fc-8ff4-92141f2414ab";
    private static final String booleanMapTypeName = "map<" + PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getName() + "," + PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BOOLEAN.getName() + ">";
    private static final String intMapTypeGUID = "8fa603dd-c2c5-43fc-8ff4-92141f2414ac";
    private static final String intMapTypeName = "map<" + PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getName() + "," + PrimitiveDefCategory.OM_PRIMITIVE_TYPE_INT.getName() + ">";
    private static final String longMapTypeGUID = "8fa603dd-c2c5-43fc-8ff4-92141f2414ae";
    private static final String longMapTypeName = "map<" + PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getName() + "," + PrimitiveDefCategory.OM_PRIMITIVE_TYPE_LONG.getName() + ">";
    private static final String dateMapTypeGUID = "ee293c68-e34d-4885-a512-f927d35a5893";
    private static final String dateMapTypeName = "map<" + PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getName() + "," + PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DATE.getName() + ">";
    private static final String doubleMapTypeGUID = "17211869-ed39-4ba9-bead-ffd967df65a8";
    private static final String doubleMapTypeName = "map<" + PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getName() + "," + PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DOUBLE.getName() + ">";
    private static final String objectMapTypeGUID = "8fa603dd-c2c5-43fc-8ff4-92141f2414ad";
    private static final String objectMapTypeName = "map<" + PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getName() + "," + PrimitiveDefCategory.OM_PRIMITIVE_TYPE_UNKNOWN.getName() + ">";
    private static final String stringArrayTypeGUID = "0428b5d3-f824-459c-b7f5-f8151de59707";
    private static final String stringArrayTypeName = "array<" + PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getName() + ">";
    private static final String intArrayTypeGUID = "0103fe10-98b0-4910-8ee0-21d529f7ff6d";
    private static final String intArrayTypeName = "array<" + PrimitiveDefCategory.OM_PRIMITIVE_TYPE_INT.getName() + ">";
    private static final Logger log = LoggerFactory.getLogger(OMRSRepositoryPropertiesUtilities.class);

    protected void removeProperty(String propertyName, InstanceProperties properties) {
        Map<String, InstancePropertyValue> instancePropertyValueMap;
        if (properties != null && (instancePropertyValueMap = properties.getInstanceProperties()) != null) {
            instancePropertyValueMap.remove(propertyName);
            properties.setInstanceProperties(instancePropertyValueMap);
        }
    }

    @Override
    public String getStringProperty(String sourceName, String propertyName, InstanceProperties properties, String methodName) {
        InstancePropertyValue instancePropertyValue;
        String thisMethodName = "getStringProperty";
        if (properties != null && (instancePropertyValue = properties.getPropertyValue(propertyName)) != null) {
            try {
                PrimitivePropertyValue primitivePropertyValue;
                if (instancePropertyValue.getInstancePropertyCategory() == InstancePropertyCategory.PRIMITIVE && (primitivePropertyValue = (PrimitivePropertyValue)instancePropertyValue).getPrimitiveDefCategory() == PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING && primitivePropertyValue.getPrimitiveValue() != null) {
                    String retrievedProperty = primitivePropertyValue.getPrimitiveValue().toString();
                    log.debug("Retrieved " + propertyName + " property: " + retrievedProperty);
                    return retrievedProperty;
                }
            }
            catch (Exception error) {
                this.throwHelperLogicError(sourceName, methodName, "getStringProperty");
            }
        }
        log.debug("No " + propertyName + " property");
        return null;
    }

    @Override
    public String removeStringProperty(String sourceName, String propertyName, InstanceProperties properties, String methodName) {
        String retrievedProperty = null;
        if (properties != null && (retrievedProperty = this.getStringProperty(sourceName, propertyName, properties, methodName)) != null) {
            this.removeProperty(propertyName, properties);
            log.debug("Properties left: " + properties);
        }
        log.debug("Retrieved " + propertyName + " property: " + retrievedProperty);
        return retrievedProperty;
    }

    @Override
    public int getEnumPropertyOrdinal(String sourceName, String propertyName, InstanceProperties properties, String methodName) {
        InstancePropertyValue instancePropertyValue = properties.getPropertyValue(propertyName);
        if (instancePropertyValue instanceof EnumPropertyValue) {
            EnumPropertyValue enumPropertyValue = (EnumPropertyValue)instancePropertyValue;
            return enumPropertyValue.getOrdinal();
        }
        return -1;
    }

    @Override
    public int removeEnumPropertyOrdinal(String sourceName, String propertyName, InstanceProperties properties, String methodName) {
        int retrievedProperty = 0;
        if (properties != null) {
            retrievedProperty = this.getEnumPropertyOrdinal(sourceName, propertyName, properties, methodName);
            this.removeProperty(propertyName, properties);
            log.debug("Properties left: " + properties);
        }
        log.debug("Retrieved " + propertyName + " property ordinal : " + retrievedProperty);
        return retrievedProperty;
    }

    @Override
    public InstanceProperties getMapProperty(String sourceName, String propertyName, InstanceProperties properties, String methodName) {
        InstancePropertyValue instancePropertyValue;
        String thisMethodName = "getMapProperty";
        if (properties != null && (instancePropertyValue = properties.getPropertyValue(propertyName)) != null) {
            try {
                if (instancePropertyValue.getInstancePropertyCategory() == InstancePropertyCategory.MAP) {
                    MapPropertyValue mapPropertyValue = (MapPropertyValue)instancePropertyValue;
                    log.debug("Retrieved map property " + propertyName);
                    return mapPropertyValue.getMapValues();
                }
            }
            catch (Exception error) {
                this.throwHelperLogicError(sourceName, methodName, "getMapProperty");
            }
        }
        log.debug("Map property " + propertyName + " not present");
        return null;
    }

    @Override
    public List<String> getStringArrayProperty(String sourceName, String propertyName, InstanceProperties properties, String callingMethodName) {
        InstancePropertyValue instancePropertyValue;
        String thisMethodName = "getStringArrayProperty";
        if (properties != null && (instancePropertyValue = properties.getPropertyValue(propertyName)) != null) {
            log.debug("getStringArrayPropertyretrieved array property " + propertyName + " for " + callingMethodName);
            try {
                ArrayPropertyValue arrayPropertyValue;
                if (instancePropertyValue.getInstancePropertyCategory() == InstancePropertyCategory.ARRAY && (arrayPropertyValue = (ArrayPropertyValue)instancePropertyValue).getArrayCount() > 0) {
                    log.debug("getStringArrayProperty found that array property " + propertyName + " has " + arrayPropertyValue.getArrayCount() + " elements.");
                    return this.getInstancePropertiesAsArray(arrayPropertyValue.getArrayValues(), callingMethodName);
                }
            }
            catch (Exception error) {
                this.throwHelperLogicError(sourceName, callingMethodName, "getStringArrayProperty");
            }
        }
        log.debug(propertyName + " not present in " + properties);
        return null;
    }

    @Override
    public List<String> removeStringArrayProperty(String sourceName, String propertyName, InstanceProperties properties, String methodName) {
        List<String> retrievedProperty = null;
        if (properties != null && (retrievedProperty = this.getStringArrayProperty(sourceName, propertyName, properties, methodName)) != null) {
            this.removeProperty(propertyName, properties);
            log.debug("Properties left: " + properties);
        }
        log.debug("Retrieved " + propertyName + " property: " + retrievedProperty);
        return retrievedProperty;
    }

    private List<String> getInstancePropertiesAsArray(InstanceProperties instanceProperties, String callingMethodName) {
        String thisMethodName = "getInstancePropertiesAsArray";
        if (instanceProperties != null) {
            Map<String, InstancePropertyValue> instancePropertyValues = instanceProperties.getInstanceProperties();
            ArrayList<String> resultingArray = new ArrayList<String>();
            for (String arrayOrdinalName : instancePropertyValues.keySet()) {
                if (arrayOrdinalName != null) {
                    log.debug("getInstancePropertiesAsArray processing array element: " + arrayOrdinalName);
                    int arrayOrdinalNumber = Integer.decode(arrayOrdinalName);
                    InstancePropertyValue actualPropertyValue = instanceProperties.getPropertyValue(arrayOrdinalName);
                    if (actualPropertyValue != null) {
                        if (actualPropertyValue.getInstancePropertyCategory() == InstancePropertyCategory.PRIMITIVE) {
                            PrimitivePropertyValue primitivePropertyValue = (PrimitivePropertyValue)actualPropertyValue;
                            resultingArray.add(arrayOrdinalNumber, primitivePropertyValue.getPrimitiveValue().toString());
                            continue;
                        }
                        log.error("getInstancePropertiesAsArray skipping collection value: " + actualPropertyValue + " from method " + callingMethodName);
                        continue;
                    }
                    log.error("getInstancePropertiesAsArray skipping null value from method " + callingMethodName);
                    continue;
                }
                log.error("getInstancePropertiesAsArray skipping null ordinal from method " + callingMethodName);
            }
            log.debug("getInstancePropertiesAsArray returning array: " + resultingArray + " to method " + callingMethodName);
            return resultingArray;
        }
        log.debug("getInstancePropertiesAsArray has no property values to extract for method " + callingMethodName);
        return null;
    }

    @Override
    public Map<String, String> getStringMapFromProperty(String sourceName, String propertyName, InstanceProperties properties, String methodName) {
        Map<String, Object> mapFromProperty = this.getMapFromProperty(sourceName, propertyName, properties, methodName);
        if (mapFromProperty != null) {
            HashMap<String, String> stringMapFromProperty = new HashMap<String, String>();
            for (String mapPropertyName : mapFromProperty.keySet()) {
                Object actualPropertyValue = mapFromProperty.get(mapPropertyName);
                if (actualPropertyValue == null) continue;
                stringMapFromProperty.put(mapPropertyName, actualPropertyValue.toString());
            }
            if (!stringMapFromProperty.isEmpty()) {
                return stringMapFromProperty;
            }
        }
        return null;
    }

    @Override
    public Map<String, String> removeStringMapFromProperty(String sourceName, String propertyName, InstanceProperties properties, String methodName) {
        Map<String, String> retrievedProperty = null;
        if (properties != null && (retrievedProperty = this.getStringMapFromProperty(sourceName, propertyName, properties, methodName)) != null) {
            this.removeProperty(propertyName, properties);
            log.debug("Properties left: " + properties);
        }
        log.debug("Retrieved " + propertyName + " property: " + retrievedProperty);
        return retrievedProperty;
    }

    @Override
    public Map<String, Boolean> getBooleanMapFromProperty(String sourceName, String propertyName, InstanceProperties properties, String methodName) {
        Map<String, Object> mapFromProperty = this.getMapFromProperty(sourceName, propertyName, properties, methodName);
        if (mapFromProperty != null) {
            HashMap<String, Boolean> booleanMap = new HashMap<String, Boolean>();
            for (String mapPropertyName : mapFromProperty.keySet()) {
                Object actualPropertyValue = mapFromProperty.get(mapPropertyName);
                if (actualPropertyValue == null) continue;
                booleanMap.put(mapPropertyName, (Boolean)actualPropertyValue);
            }
            if (!booleanMap.isEmpty()) {
                return booleanMap;
            }
        }
        return null;
    }

    @Override
    public Map<String, Boolean> removeBooleanMapFromProperty(String sourceName, String propertyName, InstanceProperties properties, String methodName) {
        Map<String, Boolean> retrievedProperty = null;
        if (properties != null && (retrievedProperty = this.getBooleanMapFromProperty(sourceName, propertyName, properties, methodName)) != null) {
            this.removeProperty(propertyName, properties);
            log.debug("Properties left: " + properties);
        }
        log.debug("Retrieved " + propertyName + " property: " + retrievedProperty);
        return retrievedProperty;
    }

    @Override
    public Map<String, Long> getLongMapFromProperty(String sourceName, String propertyName, InstanceProperties properties, String methodName) {
        Map<String, Object> mapFromProperty = this.getMapFromProperty(sourceName, propertyName, properties, methodName);
        if (mapFromProperty != null) {
            HashMap<String, Long> longMap = new HashMap<String, Long>();
            for (String mapPropertyName : mapFromProperty.keySet()) {
                Object actualPropertyValue = mapFromProperty.get(mapPropertyName);
                if (actualPropertyValue == null) continue;
                longMap.put(mapPropertyName, Long.parseLong(actualPropertyValue.toString()));
            }
            if (!longMap.isEmpty()) {
                return longMap;
            }
        }
        return null;
    }

    @Override
    public Map<String, Long> removeLongMapFromProperty(String sourceName, String propertyName, InstanceProperties properties, String methodName) {
        Map<String, Long> retrievedProperty = null;
        if (properties != null && (retrievedProperty = this.getLongMapFromProperty(sourceName, propertyName, properties, methodName)) != null) {
            this.removeProperty(propertyName, properties);
            log.debug("Properties left: " + properties);
        }
        log.debug("Retrieved " + propertyName + " property: " + retrievedProperty);
        return retrievedProperty;
    }

    @Override
    public Map<String, Date> getDateMapFromProperty(String sourceName, String propertyName, InstanceProperties properties, String methodName) {
        Map<String, Object> mapFromProperty = this.getMapFromProperty(sourceName, propertyName, properties, methodName);
        if (mapFromProperty != null) {
            HashMap<String, Date> dateMap = new HashMap<String, Date>();
            for (String mapPropertyName : mapFromProperty.keySet()) {
                Object actualPropertyValue = mapFromProperty.get(mapPropertyName);
                if (actualPropertyValue == null) continue;
                Long timestamp = (Long)actualPropertyValue;
                dateMap.put(mapPropertyName, new Date(timestamp));
            }
            if (!dateMap.isEmpty()) {
                return dateMap;
            }
        }
        return null;
    }

    @Override
    public Map<String, Date> removeDateMapFromProperty(String sourceName, String propertyName, InstanceProperties properties, String methodName) {
        Map<String, Date> retrievedProperty = null;
        if (properties != null && (retrievedProperty = this.getDateMapFromProperty(sourceName, propertyName, properties, methodName)) != null) {
            this.removeProperty(propertyName, properties);
            log.debug("Properties left: " + properties);
        }
        log.debug("Retrieved " + propertyName + " property: " + retrievedProperty);
        return retrievedProperty;
    }

    @Override
    public Map<String, Double> getDoubleMapFromProperty(String sourceName, String propertyName, InstanceProperties properties, String methodName) {
        Map<String, Object> mapFromProperty = this.getMapFromProperty(sourceName, propertyName, properties, methodName);
        if (mapFromProperty != null) {
            HashMap<String, Double> doubleMap = new HashMap<String, Double>();
            for (String mapPropertyName : mapFromProperty.keySet()) {
                Object actualPropertyValue = mapFromProperty.get(mapPropertyName);
                if (actualPropertyValue == null) continue;
                doubleMap.put(mapPropertyName, Double.parseDouble(actualPropertyValue.toString()));
            }
            if (!doubleMap.isEmpty()) {
                return doubleMap;
            }
        }
        return null;
    }

    @Override
    public Map<String, Double> removeDoubleMapFromProperty(String sourceName, String propertyName, InstanceProperties properties, String methodName) {
        Map<String, Double> retrievedProperty = null;
        if (properties != null && (retrievedProperty = this.getDoubleMapFromProperty(sourceName, propertyName, properties, methodName)) != null) {
            this.removeProperty(propertyName, properties);
            log.debug("Properties left: " + properties);
        }
        log.debug("Retrieved " + propertyName + " property: " + retrievedProperty);
        return retrievedProperty;
    }

    @Override
    public Map<String, Integer> getIntegerMapFromProperty(String sourceName, String propertyName, InstanceProperties properties, String methodName) {
        Map<String, Object> mapFromProperty = this.getMapFromProperty(sourceName, propertyName, properties, methodName);
        if (mapFromProperty != null) {
            HashMap<String, Integer> integerMap = new HashMap<String, Integer>();
            for (String mapPropertyName : mapFromProperty.keySet()) {
                Object actualPropertyValue = mapFromProperty.get(mapPropertyName);
                if (actualPropertyValue == null) continue;
                integerMap.put(mapPropertyName, (Integer)actualPropertyValue);
            }
            if (!integerMap.isEmpty()) {
                return integerMap;
            }
        }
        return null;
    }

    @Override
    public Map<String, Integer> removeIntegerMapFromProperty(String sourceName, String propertyName, InstanceProperties properties, String methodName) {
        Map<String, Integer> retrievedProperty = null;
        if (properties != null && (retrievedProperty = this.getIntegerMapFromProperty(sourceName, propertyName, properties, methodName)) != null) {
            this.removeProperty(propertyName, properties);
            log.debug("Properties left: " + properties);
        }
        log.debug("Retrieved " + propertyName + " property: " + retrievedProperty);
        return retrievedProperty;
    }

    @Override
    public Map<String, List<String>> getStringArrayStringMapFromProperty(String sourceName, String propertyName, InstanceProperties properties, String methodName) {
        String thisMethodName = "getStringArrayStringMapFromProperty";
        Map<String, Object> mapFromProperty = this.getMapFromProperty(sourceName, propertyName, properties, methodName);
        if (mapFromProperty != null) {
            HashMap<String, List<String>> stringArrayMap = new HashMap<String, List<String>>();
            for (String mapPropertyName : mapFromProperty.keySet()) {
                Object actualPropertyValue = mapFromProperty.get(mapPropertyName);
                if (!(actualPropertyValue instanceof HashMap)) continue;
                HashMap propertyValue = (HashMap)actualPropertyValue;
                ArrayList<String> unpackedValue = new ArrayList<String>();
                for (Object value : propertyValue.values()) {
                    unpackedValue.add(value.toString());
                }
                log.debug("getStringArrayStringMapFromProperty found that array property " + propertyName + " has elements: " + unpackedValue);
                stringArrayMap.put(mapPropertyName, unpackedValue);
            }
            if (!stringArrayMap.isEmpty()) {
                return stringArrayMap;
            }
        }
        return null;
    }

    @Override
    public Map<String, List<String>> removeStringArrayStringMapFromProperty(String sourceName, String propertyName, InstanceProperties properties, String methodName) {
        Map<String, List<String>> retrievedProperty = null;
        if (properties != null && (retrievedProperty = this.getStringArrayStringMapFromProperty(sourceName, propertyName, properties, methodName)) != null) {
            this.removeProperty(propertyName, properties);
            log.debug("Properties left: " + properties);
        }
        log.debug("Retrieved " + propertyName + " property: " + retrievedProperty);
        return retrievedProperty;
    }

    @Override
    public Map<String, Object> getMapFromProperty(String sourceName, String propertyName, InstanceProperties properties, String methodName) {
        InstancePropertyValue instancePropertyValue;
        String thisMethodName = "getMapFromProperty";
        if (properties != null && (instancePropertyValue = properties.getPropertyValue(propertyName)) != null) {
            try {
                if (instancePropertyValue.getInstancePropertyCategory() == InstancePropertyCategory.MAP) {
                    MapPropertyValue mapInstancePropertyValue = (MapPropertyValue)instancePropertyValue;
                    log.debug("Retrieved map property " + propertyName);
                    return this.getInstancePropertiesAsMap(mapInstancePropertyValue.getMapValues());
                }
            }
            catch (Exception error) {
                this.throwHelperLogicError(sourceName, methodName, "getMapFromProperty");
            }
        }
        log.debug("Map property " + propertyName + " not present");
        return null;
    }

    @Override
    public Map<String, Object> removeMapFromProperty(String sourceName, String propertyName, InstanceProperties properties, String methodName) {
        Map<String, Object> retrievedProperty = null;
        if (properties != null && (retrievedProperty = this.getMapFromProperty(sourceName, propertyName, properties, methodName)) != null) {
            this.removeProperty(propertyName, properties);
            log.debug("Properties left: " + properties);
        }
        log.debug("Retrieved " + propertyName + " property: " + retrievedProperty);
        return retrievedProperty;
    }

    @Override
    public Map<String, Object> getInstancePropertiesAsMap(InstanceProperties instanceProperties) {
        if (instanceProperties != null) {
            Map<String, InstancePropertyValue> instancePropertyValues = instanceProperties.getInstanceProperties();
            HashMap<String, Object> resultingMap = new HashMap<String, Object>();
            if (instancePropertyValues != null) {
                for (String mapPropertyName : instancePropertyValues.keySet()) {
                    InstancePropertyValue actualPropertyValue = instanceProperties.getPropertyValue(mapPropertyName);
                    if (actualPropertyValue == null) continue;
                    if (actualPropertyValue.getInstancePropertyCategory() == InstancePropertyCategory.PRIMITIVE) {
                        PrimitivePropertyValue primitivePropertyValue = (PrimitivePropertyValue)actualPropertyValue;
                        resultingMap.put(mapPropertyName, primitivePropertyValue.getPrimitiveValue());
                        continue;
                    }
                    if (actualPropertyValue.getInstancePropertyCategory() == InstancePropertyCategory.ENUM) {
                        EnumPropertyValue enumPropertyValue = (EnumPropertyValue)actualPropertyValue;
                        resultingMap.put(mapPropertyName, enumPropertyValue.getSymbolicName());
                        continue;
                    }
                    if (actualPropertyValue.getInstancePropertyCategory() == InstancePropertyCategory.MAP) {
                        MapPropertyValue mapPropertyValue = (MapPropertyValue)actualPropertyValue;
                        resultingMap.put(mapPropertyName, mapPropertyValue.valueAsObject());
                        continue;
                    }
                    if (actualPropertyValue.getInstancePropertyCategory() == InstancePropertyCategory.ARRAY) {
                        ArrayPropertyValue arrayPropertyValue = (ArrayPropertyValue)actualPropertyValue;
                        resultingMap.put(mapPropertyName, arrayPropertyValue.valueAsObject());
                        continue;
                    }
                    if (actualPropertyValue.getInstancePropertyCategory() == InstancePropertyCategory.STRUCT) {
                        StructPropertyValue structPropertyValue = (StructPropertyValue)actualPropertyValue;
                        resultingMap.put(mapPropertyName, structPropertyValue);
                        continue;
                    }
                    resultingMap.put(mapPropertyName, actualPropertyValue);
                }
            }
            log.debug("Returning map: " + resultingMap);
            return resultingMap;
        }
        log.debug("No Properties present");
        return null;
    }

    @Override
    public int getIntProperty(String sourceName, String propertyName, InstanceProperties properties, String methodName) {
        InstancePropertyValue instancePropertyValue;
        String thisMethodName = "getIntProperty";
        if (properties != null && (instancePropertyValue = properties.getPropertyValue(propertyName)) != null) {
            try {
                PrimitivePropertyValue primitivePropertyValue;
                if (instancePropertyValue.getInstancePropertyCategory() == InstancePropertyCategory.PRIMITIVE && (primitivePropertyValue = (PrimitivePropertyValue)instancePropertyValue).getPrimitiveDefCategory() == PrimitiveDefCategory.OM_PRIMITIVE_TYPE_INT) {
                    log.debug("Retrieved integer property " + propertyName);
                    if (primitivePropertyValue.getPrimitiveValue() != null) {
                        return Integer.parseInt(primitivePropertyValue.getPrimitiveValue().toString());
                    }
                }
            }
            catch (Exception error) {
                this.throwHelperLogicError(sourceName, methodName, "getIntProperty");
            }
        }
        log.debug("Integer property " + propertyName + " not present");
        return 0;
    }

    @Override
    public int removeIntProperty(String sourceName, String propertyName, InstanceProperties properties, String methodName) {
        int retrievedProperty = 0;
        if (properties != null) {
            retrievedProperty = this.getIntProperty(sourceName, propertyName, properties, methodName);
            this.removeProperty(propertyName, properties);
            log.debug("Properties left: " + properties);
        }
        log.debug("Retrieved " + propertyName + " property: " + retrievedProperty);
        return retrievedProperty;
    }

    @Override
    public long getLongProperty(String sourceName, String propertyName, InstanceProperties properties, String methodName) {
        InstancePropertyValue instancePropertyValue;
        String thisMethodName = "getLongProperty";
        if (properties != null && (instancePropertyValue = properties.getPropertyValue(propertyName)) != null) {
            try {
                PrimitivePropertyValue primitivePropertyValue;
                if (instancePropertyValue.getInstancePropertyCategory() == InstancePropertyCategory.PRIMITIVE && (primitivePropertyValue = (PrimitivePropertyValue)instancePropertyValue).getPrimitiveDefCategory() == PrimitiveDefCategory.OM_PRIMITIVE_TYPE_LONG) {
                    log.debug("Retrieved long property " + propertyName);
                    if (primitivePropertyValue.getPrimitiveValue() != null) {
                        return Long.parseLong(primitivePropertyValue.getPrimitiveValue().toString());
                    }
                }
            }
            catch (Exception error) {
                this.throwHelperLogicError(sourceName, methodName, "getLongProperty");
            }
        }
        log.debug("Long property " + propertyName + " not present");
        return 0L;
    }

    @Override
    public long removeLongProperty(String sourceName, String propertyName, InstanceProperties properties, String methodName) {
        long retrievedProperty = 0L;
        if (properties != null) {
            retrievedProperty = this.getLongProperty(sourceName, propertyName, properties, methodName);
            this.removeProperty(propertyName, properties);
            log.debug("Properties left: " + properties);
        }
        log.debug("Retrieved " + propertyName + " property: " + retrievedProperty);
        return retrievedProperty;
    }

    @Override
    public Date getDateProperty(String sourceName, String propertyName, InstanceProperties properties, String methodName) {
        InstancePropertyValue instancePropertyValue;
        String thisMethodName = "getDateProperty";
        if (properties != null && (instancePropertyValue = properties.getPropertyValue(propertyName)) != null) {
            try {
                PrimitivePropertyValue primitivePropertyValue;
                if (instancePropertyValue.getInstancePropertyCategory() == InstancePropertyCategory.PRIMITIVE && (primitivePropertyValue = (PrimitivePropertyValue)instancePropertyValue).getPrimitiveDefCategory() == PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DATE) {
                    log.debug("Retrieved date property " + propertyName);
                    if (primitivePropertyValue.getPrimitiveValue() != null) {
                        Long timestamp = (Long)primitivePropertyValue.getPrimitiveValue();
                        return new Date(timestamp);
                    }
                }
            }
            catch (Exception error) {
                this.throwHelperLogicError(sourceName, methodName, "getDateProperty");
            }
        }
        log.debug("Date property " + propertyName + " not present");
        return null;
    }

    @Override
    public Date removeDateProperty(String sourceName, String propertyName, InstanceProperties properties, String methodName) {
        Date retrievedProperty = null;
        if (properties != null) {
            retrievedProperty = this.getDateProperty(sourceName, propertyName, properties, methodName);
            this.removeProperty(propertyName, properties);
            log.debug("Properties left: " + properties);
        }
        log.debug("Retrieved " + propertyName + " property: " + retrievedProperty);
        return retrievedProperty;
    }

    @Override
    public boolean getBooleanProperty(String sourceName, String propertyName, InstanceProperties properties, String methodName) {
        InstancePropertyValue instancePropertyValue;
        String thisMethodName = "getBooleanProperty";
        if (properties != null && (instancePropertyValue = properties.getPropertyValue(propertyName)) != null) {
            try {
                PrimitivePropertyValue primitivePropertyValue;
                if (instancePropertyValue.getInstancePropertyCategory() == InstancePropertyCategory.PRIMITIVE && (primitivePropertyValue = (PrimitivePropertyValue)instancePropertyValue).getPrimitiveDefCategory() == PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BOOLEAN) {
                    log.debug("Retrieved boolean property " + propertyName);
                    if (primitivePropertyValue.getPrimitiveValue() != null) {
                        return Boolean.parseBoolean(primitivePropertyValue.getPrimitiveValue().toString());
                    }
                }
            }
            catch (Exception error) {
                this.throwHelperLogicError(sourceName, methodName, "getBooleanProperty");
            }
        }
        log.debug("Boolean property " + propertyName + " not present");
        return false;
    }

    @Override
    public boolean removeBooleanProperty(String sourceName, String propertyName, InstanceProperties properties, String methodName) {
        boolean retrievedProperty = false;
        if (properties != null) {
            retrievedProperty = this.getBooleanProperty(sourceName, propertyName, properties, methodName);
            this.removeProperty(propertyName, properties);
            log.debug("Properties left: " + properties);
        }
        log.debug("Retrieved " + propertyName + " property: " + retrievedProperty);
        return retrievedProperty;
    }

    @Override
    public InstanceProperties addObjectPropertyToInstance(String sourceName, InstanceProperties properties, String propertyName, Object propertyValue, String methodName) {
        if (propertyValue != null) {
            InstanceProperties resultingProperties;
            log.debug("Adding property " + propertyName + " for " + methodName);
            if (properties == null) {
                log.debug("First property");
                resultingProperties = new InstanceProperties();
            } else {
                resultingProperties = properties;
            }
            PrimitivePropertyValue primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setHeaderVersion(1L);
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_UNKNOWN);
            primitivePropertyValue.setPrimitiveValue(propertyValue);
            primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_UNKNOWN.getName());
            primitivePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_UNKNOWN.getGUID());
            resultingProperties.setProperty(propertyName, primitivePropertyValue);
            return resultingProperties;
        }
        log.debug("Null property");
        return properties;
    }

    @Override
    public InstanceProperties addStringPropertyToInstance(String sourceName, InstanceProperties properties, String propertyName, String propertyValue, String methodName) {
        if (propertyValue != null) {
            InstanceProperties resultingProperties;
            log.debug("Adding property " + propertyName + " for " + methodName);
            if (properties == null) {
                log.debug("First property");
                resultingProperties = new InstanceProperties();
            } else {
                resultingProperties = properties;
            }
            PrimitivePropertyValue primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setHeaderVersion(1L);
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            primitivePropertyValue.setPrimitiveValue(propertyValue);
            primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getName());
            primitivePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getGUID());
            resultingProperties.setProperty(propertyName, primitivePropertyValue);
            return resultingProperties;
        }
        log.debug("Null property");
        return properties;
    }

    @Override
    public InstanceProperties addIntPropertyToInstance(String sourceName, InstanceProperties properties, String propertyName, int propertyValue, String methodName) {
        InstanceProperties resultingProperties;
        log.debug("Adding property " + propertyName + " for " + methodName);
        if (properties == null) {
            log.debug("First property");
            resultingProperties = new InstanceProperties();
        } else {
            resultingProperties = properties;
        }
        PrimitivePropertyValue primitivePropertyValue = new PrimitivePropertyValue();
        primitivePropertyValue.setHeaderVersion(1L);
        primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_INT);
        primitivePropertyValue.setPrimitiveValue(propertyValue);
        primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_INT.getName());
        primitivePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_INT.getGUID());
        resultingProperties.setProperty(propertyName, primitivePropertyValue);
        return resultingProperties;
    }

    @Override
    public InstanceProperties addLongPropertyToInstance(String sourceName, InstanceProperties properties, String propertyName, long propertyValue, String methodName) {
        InstanceProperties resultingProperties;
        log.debug("Adding property " + propertyName + " for " + methodName);
        if (properties == null) {
            log.debug("First property");
            resultingProperties = new InstanceProperties();
        } else {
            resultingProperties = properties;
        }
        PrimitivePropertyValue primitivePropertyValue = new PrimitivePropertyValue();
        primitivePropertyValue.setHeaderVersion(1L);
        primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_LONG);
        primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_LONG.getName());
        primitivePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_LONG.getGUID());
        primitivePropertyValue.setPrimitiveValue(propertyValue);
        resultingProperties.setProperty(propertyName, primitivePropertyValue);
        return resultingProperties;
    }

    @Override
    public InstanceProperties addDoublePropertyToInstance(String sourceName, InstanceProperties properties, String propertyName, double propertyValue, String methodName) {
        InstanceProperties resultingProperties;
        log.debug("Adding property " + propertyName + " for " + methodName);
        if (properties == null) {
            log.debug("First property");
            resultingProperties = new InstanceProperties();
        } else {
            resultingProperties = properties;
        }
        PrimitivePropertyValue primitivePropertyValue = new PrimitivePropertyValue();
        primitivePropertyValue.setHeaderVersion(1L);
        primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DOUBLE);
        primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DOUBLE.getName());
        primitivePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DOUBLE.getGUID());
        primitivePropertyValue.setPrimitiveValue(propertyValue);
        resultingProperties.setProperty(propertyName, primitivePropertyValue);
        return resultingProperties;
    }

    @Override
    public InstanceProperties addFloatPropertyToInstance(String sourceName, InstanceProperties properties, String propertyName, float propertyValue, String methodName) {
        InstanceProperties resultingProperties;
        log.debug("Adding property " + propertyName + " for " + methodName);
        if (properties == null) {
            log.debug("First property");
            resultingProperties = new InstanceProperties();
        } else {
            resultingProperties = properties;
        }
        PrimitivePropertyValue primitivePropertyValue = new PrimitivePropertyValue();
        primitivePropertyValue.setHeaderVersion(1L);
        primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_FLOAT);
        primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_FLOAT.getName());
        primitivePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_FLOAT.getGUID());
        primitivePropertyValue.setPrimitiveValue(Float.valueOf(propertyValue));
        resultingProperties.setProperty(propertyName, primitivePropertyValue);
        return resultingProperties;
    }

    @Override
    public InstanceProperties addDatePropertyToInstance(String sourceName, InstanceProperties properties, String propertyName, Date propertyValue, String methodName) {
        if (propertyValue != null) {
            InstanceProperties resultingProperties;
            log.debug("Adding property " + propertyName + " for " + methodName);
            if (properties == null) {
                log.debug("First property");
                resultingProperties = new InstanceProperties();
            } else {
                resultingProperties = properties;
            }
            PrimitivePropertyValue primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setHeaderVersion(1L);
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DATE);
            primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DATE.getName());
            primitivePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DATE.getGUID());
            Long longValue = propertyValue.getTime();
            primitivePropertyValue.setPrimitiveValue(longValue);
            resultingProperties.setProperty(propertyName, primitivePropertyValue);
            return resultingProperties;
        }
        return properties;
    }

    @Override
    public InstanceProperties addBooleanPropertyToInstance(String sourceName, InstanceProperties properties, String propertyName, boolean propertyValue, String methodName) {
        InstanceProperties resultingProperties;
        log.debug("Adding property " + propertyName + " for " + methodName);
        if (properties == null) {
            log.debug("First property");
            resultingProperties = new InstanceProperties();
        } else {
            resultingProperties = properties;
        }
        PrimitivePropertyValue primitivePropertyValue = new PrimitivePropertyValue();
        primitivePropertyValue.setHeaderVersion(1L);
        primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BOOLEAN);
        primitivePropertyValue.setPrimitiveValue(propertyValue);
        primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BOOLEAN.getName());
        primitivePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BOOLEAN.getGUID());
        resultingProperties.setProperty(propertyName, primitivePropertyValue);
        return resultingProperties;
    }

    @Override
    public InstanceProperties addEnumPropertyToInstance(String sourceName, InstanceProperties properties, String propertyName, String attributeTypeGUID, String attributeTypeName, int ordinal, String symbolicName, String description, String methodName) {
        InstanceProperties resultingProperties;
        log.debug("Adding property " + propertyName + " for " + methodName);
        if (properties == null) {
            log.debug("First property");
            resultingProperties = new InstanceProperties();
        } else {
            resultingProperties = properties;
        }
        EnumPropertyValue enumPropertyValue = new EnumPropertyValue();
        enumPropertyValue.setHeaderVersion(1L);
        enumPropertyValue.setOrdinal(ordinal);
        enumPropertyValue.setSymbolicName(symbolicName);
        enumPropertyValue.setDescription(description);
        enumPropertyValue.setTypeGUID(attributeTypeGUID);
        enumPropertyValue.setTypeName(attributeTypeName);
        resultingProperties.setProperty(propertyName, enumPropertyValue);
        return resultingProperties;
    }

    @Override
    public InstanceProperties addStringArrayPropertyToInstance(String sourceName, InstanceProperties properties, String propertyName, List<String> arrayValues, String methodName) {
        if (arrayValues != null) {
            log.debug("Adding property " + propertyName + " for " + methodName + " from " + sourceName);
            InstanceProperties resultingProperties = properties == null ? new InstanceProperties() : properties;
            ArrayPropertyValue arrayPropertyValue = new ArrayPropertyValue();
            arrayPropertyValue.setHeaderVersion(1L);
            arrayPropertyValue.setTypeGUID(stringArrayTypeGUID);
            arrayPropertyValue.setTypeName(stringArrayTypeName);
            arrayPropertyValue.setArrayCount(arrayValues.size());
            int index = 0;
            for (String arrayValue : arrayValues) {
                PrimitivePropertyValue primitivePropertyValue = new PrimitivePropertyValue();
                primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
                primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getName());
                primitivePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getGUID());
                primitivePropertyValue.setPrimitiveValue(arrayValue);
                arrayPropertyValue.setArrayValue(index, primitivePropertyValue);
                ++index;
            }
            resultingProperties.setProperty(propertyName, arrayPropertyValue);
            log.debug("Returning instanceProperty: " + resultingProperties);
            return resultingProperties;
        }
        log.debug("Null property");
        return properties;
    }

    @Override
    public InstanceProperties addMapPropertyToInstance(String sourceName, InstanceProperties properties, String propertyName, Map<String, Object> mapValues, String methodName) {
        if (mapValues != null) {
            log.debug("Adding property " + propertyName + " for " + methodName);
            if (!mapValues.isEmpty()) {
                InstanceProperties resultingProperties;
                if (properties == null) {
                    resultingProperties = new InstanceProperties();
                    resultingProperties.setHeaderVersion(1L);
                } else {
                    resultingProperties = properties;
                }
                InstanceProperties mapInstanceProperties = this.addPropertyMapToInstance(sourceName, null, mapValues, methodName);
                if (mapInstanceProperties != null) {
                    MapPropertyValue mapPropertyValue = new MapPropertyValue();
                    mapPropertyValue.setHeaderVersion(1L);
                    mapPropertyValue.setMapValues(mapInstanceProperties);
                    mapPropertyValue.setTypeGUID(objectMapTypeGUID);
                    mapPropertyValue.setTypeName(objectMapTypeName);
                    resultingProperties.setProperty(propertyName, mapPropertyValue);
                    log.debug("Returning instanceProperty: " + resultingProperties);
                    return resultingProperties;
                }
            }
        }
        log.debug("Null property");
        return properties;
    }

    @Override
    public InstanceProperties addStringMapPropertyToInstance(String sourceName, InstanceProperties properties, String propertyName, Map<String, String> mapValues, String methodName) {
        if (mapValues != null && !mapValues.isEmpty()) {
            log.debug("Adding property " + propertyName + " for " + methodName);
            if (!mapValues.isEmpty()) {
                InstanceProperties resultingProperties;
                if (properties == null) {
                    resultingProperties = new InstanceProperties();
                    resultingProperties.setHeaderVersion(1L);
                } else {
                    resultingProperties = properties;
                }
                InstanceProperties mapInstanceProperties = this.addStringPropertyMapToInstance(sourceName, null, propertyName, mapValues, methodName);
                if (mapInstanceProperties != null) {
                    MapPropertyValue mapPropertyValue = new MapPropertyValue();
                    mapPropertyValue.setHeaderVersion(1L);
                    mapPropertyValue.setMapValues(mapInstanceProperties);
                    mapPropertyValue.setTypeGUID(stringMapTypeGUID);
                    mapPropertyValue.setTypeName(stringMapTypeName);
                    resultingProperties.setProperty(propertyName, mapPropertyValue);
                    log.debug("Returning instanceProperty: " + resultingProperties);
                    return resultingProperties;
                }
            }
        }
        log.debug("Null property");
        return properties;
    }

    @Override
    public InstanceProperties addBooleanMapPropertyToInstance(String sourceName, InstanceProperties properties, String propertyName, Map<String, Boolean> mapValues, String methodName) {
        if (mapValues != null) {
            log.debug("Adding property " + propertyName + " for " + methodName);
            if (!mapValues.isEmpty()) {
                InstanceProperties resultingProperties;
                if (properties == null) {
                    resultingProperties = new InstanceProperties();
                    resultingProperties.setHeaderVersion(1L);
                } else {
                    resultingProperties = properties;
                }
                InstanceProperties mapInstanceProperties = this.addBooleanPropertyMapToInstance(sourceName, null, propertyName, mapValues, methodName);
                if (mapInstanceProperties != null) {
                    MapPropertyValue mapPropertyValue = new MapPropertyValue();
                    mapPropertyValue.setHeaderVersion(1L);
                    mapPropertyValue.setMapValues(mapInstanceProperties);
                    mapPropertyValue.setTypeGUID(booleanMapTypeGUID);
                    mapPropertyValue.setTypeName(booleanMapTypeName);
                    resultingProperties.setProperty(propertyName, mapPropertyValue);
                    log.debug("Returning instanceProperty: " + resultingProperties);
                    return resultingProperties;
                }
            }
        }
        log.debug("Null property");
        return properties;
    }

    @Override
    public InstanceProperties addDateMapPropertyToInstance(String sourceName, InstanceProperties properties, String propertyName, Map<String, Date> mapValues, String methodName) {
        if (mapValues != null) {
            log.debug("Adding property " + propertyName + " for " + methodName);
            if (!mapValues.isEmpty()) {
                InstanceProperties resultingProperties;
                if (properties == null) {
                    resultingProperties = new InstanceProperties();
                    resultingProperties.setHeaderVersion(1L);
                } else {
                    resultingProperties = properties;
                }
                InstanceProperties mapInstanceProperties = this.addDatePropertyMapToInstance(sourceName, null, propertyName, mapValues, methodName);
                if (mapInstanceProperties != null) {
                    MapPropertyValue mapPropertyValue = new MapPropertyValue();
                    mapPropertyValue.setHeaderVersion(1L);
                    mapPropertyValue.setMapValues(mapInstanceProperties);
                    mapPropertyValue.setTypeGUID(dateMapTypeGUID);
                    mapPropertyValue.setTypeName(dateMapTypeName);
                    resultingProperties.setProperty(propertyName, mapPropertyValue);
                    log.debug("Returning instanceProperty: " + resultingProperties);
                    return resultingProperties;
                }
            }
        }
        log.debug("Null property");
        return properties;
    }

    @Override
    public InstanceProperties addLongMapPropertyToInstance(String sourceName, InstanceProperties properties, String propertyName, Map<String, Long> mapValues, String methodName) {
        if (mapValues != null) {
            log.debug("Adding property " + propertyName + " for " + methodName);
            if (!mapValues.isEmpty()) {
                InstanceProperties resultingProperties;
                if (properties == null) {
                    resultingProperties = new InstanceProperties();
                    resultingProperties.setHeaderVersion(1L);
                } else {
                    resultingProperties = properties;
                }
                InstanceProperties mapInstanceProperties = this.addLongPropertyMapToInstance(sourceName, null, propertyName, mapValues, methodName);
                if (mapInstanceProperties != null) {
                    MapPropertyValue mapPropertyValue = new MapPropertyValue();
                    mapPropertyValue.setHeaderVersion(1L);
                    mapPropertyValue.setMapValues(mapInstanceProperties);
                    mapPropertyValue.setTypeGUID(longMapTypeGUID);
                    mapPropertyValue.setTypeName(longMapTypeName);
                    resultingProperties.setProperty(propertyName, mapPropertyValue);
                    log.debug("Returning instanceProperty: " + resultingProperties);
                    return resultingProperties;
                }
            }
        }
        log.debug("Null property");
        return properties;
    }

    @Override
    public InstanceProperties addDoubleMapPropertyToInstance(String sourceName, InstanceProperties properties, String propertyName, Map<String, Double> mapValues, String methodName) {
        if (mapValues != null) {
            log.debug("Adding property " + propertyName + " for " + methodName);
            if (!mapValues.isEmpty()) {
                InstanceProperties resultingProperties;
                if (properties == null) {
                    resultingProperties = new InstanceProperties();
                    resultingProperties.setHeaderVersion(1L);
                } else {
                    resultingProperties = properties;
                }
                InstanceProperties mapInstanceProperties = this.addDoublePropertyMapToInstance(sourceName, null, propertyName, mapValues, methodName);
                if (mapInstanceProperties != null) {
                    MapPropertyValue mapPropertyValue = new MapPropertyValue();
                    mapPropertyValue.setHeaderVersion(1L);
                    mapPropertyValue.setMapValues(mapInstanceProperties);
                    mapPropertyValue.setTypeGUID(doubleMapTypeGUID);
                    mapPropertyValue.setTypeName(doubleMapTypeName);
                    resultingProperties.setProperty(propertyName, mapPropertyValue);
                    log.debug("Returning instanceProperty: " + resultingProperties);
                    return resultingProperties;
                }
            }
        }
        log.debug("Null property");
        return properties;
    }

    @Override
    public InstanceProperties addIntMapPropertyToInstance(String sourceName, InstanceProperties properties, String propertyName, Map<String, Integer> mapValues, String methodName) {
        if (mapValues != null) {
            log.debug("Adding property " + propertyName + " for " + methodName);
            if (!mapValues.isEmpty()) {
                InstanceProperties resultingProperties;
                if (properties == null) {
                    resultingProperties = new InstanceProperties();
                    resultingProperties.setHeaderVersion(1L);
                } else {
                    resultingProperties = properties;
                }
                InstanceProperties mapInstanceProperties = this.addIntPropertyMapToInstance(sourceName, null, propertyName, mapValues, methodName);
                if (mapInstanceProperties != null) {
                    MapPropertyValue mapPropertyValue = new MapPropertyValue();
                    mapPropertyValue.setHeaderVersion(1L);
                    mapPropertyValue.setMapValues(mapInstanceProperties);
                    mapPropertyValue.setTypeGUID(intMapTypeGUID);
                    mapPropertyValue.setTypeName(intMapTypeName);
                    resultingProperties.setProperty(propertyName, mapPropertyValue);
                    log.debug("Returning instanceProperty: " + resultingProperties);
                    return resultingProperties;
                }
            }
        }
        log.debug("Null property");
        return properties;
    }

    @Override
    public InstanceProperties addStringArrayStringMapPropertyToInstance(String sourceName, InstanceProperties properties, String propertyName, Map<String, List<String>> mapValues, String methodName) {
        if (mapValues != null) {
            log.debug("Adding property " + propertyName + " for " + methodName);
            if (!mapValues.isEmpty()) {
                InstanceProperties resultingInstanceProperties;
                if (properties == null) {
                    resultingInstanceProperties = new InstanceProperties();
                    resultingInstanceProperties.setHeaderVersion(1L);
                } else {
                    resultingInstanceProperties = properties;
                }
                InstanceProperties mapInstanceProperties = new InstanceProperties();
                for (String mapKey : mapValues.keySet()) {
                    List<String> mapEntry = mapValues.get(mapKey);
                    ArrayPropertyValue arrayPropertyValue = new ArrayPropertyValue();
                    arrayPropertyValue.setHeaderVersion(1L);
                    arrayPropertyValue.setTypeGUID(stringArrayTypeGUID);
                    arrayPropertyValue.setTypeName(stringArrayTypeName);
                    arrayPropertyValue.setArrayCount(mapEntry.size());
                    int index = 0;
                    for (String arrayValue : mapEntry) {
                        PrimitivePropertyValue primitivePropertyValue = new PrimitivePropertyValue();
                        primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
                        primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getName());
                        primitivePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getGUID());
                        primitivePropertyValue.setPrimitiveValue(arrayValue);
                        arrayPropertyValue.setArrayValue(index, primitivePropertyValue);
                        ++index;
                    }
                    mapInstanceProperties.setProperty(mapKey, arrayPropertyValue);
                }
                MapPropertyValue mapPropertyValue = new MapPropertyValue();
                mapPropertyValue.setHeaderVersion(1L);
                mapPropertyValue.setMapValues(mapInstanceProperties);
                mapPropertyValue.setTypeGUID(objectMapTypeGUID);
                mapPropertyValue.setTypeName(objectMapTypeName);
                resultingInstanceProperties.setProperty(propertyName, mapPropertyValue);
                log.debug("Returning instanceProperty: " + resultingInstanceProperties);
                return resultingInstanceProperties;
            }
        }
        log.debug("Null property");
        return properties;
    }

    @Override
    public InstanceProperties addPropertyMapToInstance(String sourceName, InstanceProperties properties, Map<String, Object> mapValues, String methodName) {
        if (mapValues != null && !mapValues.isEmpty()) {
            InstanceProperties resultingProperties;
            log.debug("Building map property for " + methodName);
            if (properties == null) {
                resultingProperties = new InstanceProperties();
                resultingProperties.setHeaderVersion(1L);
            } else {
                resultingProperties = properties;
            }
            int propertyCount = 0;
            for (String mapPropertyName : mapValues.keySet()) {
                PrimitivePropertyValue primitivePropertyValue;
                Object mapPropertyValue = mapValues.get(mapPropertyName);
                if (mapPropertyValue instanceof String) {
                    primitivePropertyValue = new PrimitivePropertyValue();
                    primitivePropertyValue.setHeaderVersion(1L);
                    primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
                    primitivePropertyValue.setPrimitiveValue(mapPropertyValue);
                    primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getName());
                    primitivePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getGUID());
                    resultingProperties.setProperty(mapPropertyName, primitivePropertyValue);
                    ++propertyCount;
                    continue;
                }
                if (mapPropertyValue instanceof Integer) {
                    primitivePropertyValue = new PrimitivePropertyValue();
                    primitivePropertyValue.setHeaderVersion(1L);
                    primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_INT);
                    primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_INT.getName());
                    primitivePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_INT.getGUID());
                    primitivePropertyValue.setPrimitiveValue(mapPropertyValue);
                    resultingProperties.setProperty(mapPropertyName, primitivePropertyValue);
                    ++propertyCount;
                    continue;
                }
                if (mapPropertyValue instanceof Long) {
                    primitivePropertyValue = new PrimitivePropertyValue();
                    primitivePropertyValue.setHeaderVersion(1L);
                    primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_LONG);
                    primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_LONG.getName());
                    primitivePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_LONG.getGUID());
                    primitivePropertyValue.setPrimitiveValue(mapPropertyValue);
                    resultingProperties.setProperty(mapPropertyName, primitivePropertyValue);
                    ++propertyCount;
                    continue;
                }
                if (mapPropertyValue instanceof Short) {
                    primitivePropertyValue = new PrimitivePropertyValue();
                    primitivePropertyValue.setHeaderVersion(1L);
                    primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_SHORT);
                    primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_SHORT.getName());
                    primitivePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_SHORT.getGUID());
                    primitivePropertyValue.setPrimitiveValue(mapPropertyValue);
                    resultingProperties.setProperty(mapPropertyName, primitivePropertyValue);
                    ++propertyCount;
                    continue;
                }
                if (mapPropertyValue instanceof Date) {
                    primitivePropertyValue = new PrimitivePropertyValue();
                    primitivePropertyValue.setHeaderVersion(1L);
                    primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DATE);
                    primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DATE.getName());
                    primitivePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DATE.getGUID());
                    Long timestamp = ((Date)mapPropertyValue).getTime();
                    primitivePropertyValue.setPrimitiveValue(timestamp);
                    resultingProperties.setProperty(mapPropertyName, primitivePropertyValue);
                    ++propertyCount;
                    continue;
                }
                if (mapPropertyValue instanceof Character) {
                    primitivePropertyValue = new PrimitivePropertyValue();
                    primitivePropertyValue.setHeaderVersion(1L);
                    primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_CHAR);
                    primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_CHAR.getName());
                    primitivePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_CHAR.getGUID());
                    primitivePropertyValue.setPrimitiveValue(mapPropertyValue);
                    resultingProperties.setProperty(mapPropertyName, primitivePropertyValue);
                    ++propertyCount;
                    continue;
                }
                if (mapPropertyValue instanceof Byte) {
                    primitivePropertyValue = new PrimitivePropertyValue();
                    primitivePropertyValue.setHeaderVersion(1L);
                    primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BYTE);
                    primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BYTE.getName());
                    primitivePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BYTE.getGUID());
                    primitivePropertyValue.setPrimitiveValue(mapPropertyValue);
                    resultingProperties.setProperty(mapPropertyName, primitivePropertyValue);
                    ++propertyCount;
                    continue;
                }
                if (mapPropertyValue instanceof Boolean) {
                    primitivePropertyValue = new PrimitivePropertyValue();
                    primitivePropertyValue.setHeaderVersion(1L);
                    primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BOOLEAN);
                    primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BOOLEAN.getName());
                    primitivePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BOOLEAN.getGUID());
                    primitivePropertyValue.setPrimitiveValue(mapPropertyValue);
                    resultingProperties.setProperty(mapPropertyName, primitivePropertyValue);
                    ++propertyCount;
                    continue;
                }
                if (mapPropertyValue instanceof Float) {
                    primitivePropertyValue = new PrimitivePropertyValue();
                    primitivePropertyValue.setHeaderVersion(1L);
                    primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_FLOAT);
                    primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_FLOAT.getName());
                    primitivePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_FLOAT.getGUID());
                    primitivePropertyValue.setPrimitiveValue(mapPropertyValue);
                    resultingProperties.setProperty(mapPropertyName, primitivePropertyValue);
                    ++propertyCount;
                    continue;
                }
                if (mapPropertyValue instanceof BigDecimal) {
                    primitivePropertyValue = new PrimitivePropertyValue();
                    primitivePropertyValue.setHeaderVersion(1L);
                    primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BIGDECIMAL);
                    primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BIGDECIMAL.getName());
                    primitivePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BIGDECIMAL.getGUID());
                    primitivePropertyValue.setPrimitiveValue(mapPropertyValue);
                    resultingProperties.setProperty(mapPropertyName, primitivePropertyValue);
                    ++propertyCount;
                    continue;
                }
                if (mapPropertyValue instanceof BigInteger) {
                    primitivePropertyValue = new PrimitivePropertyValue();
                    primitivePropertyValue.setHeaderVersion(1L);
                    primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BIGINTEGER);
                    primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BIGINTEGER.getName());
                    primitivePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BIGINTEGER.getGUID());
                    primitivePropertyValue.setPrimitiveValue(mapPropertyValue);
                    resultingProperties.setProperty(mapPropertyName, primitivePropertyValue);
                    ++propertyCount;
                    continue;
                }
                if (mapPropertyValue instanceof Double) {
                    primitivePropertyValue = new PrimitivePropertyValue();
                    primitivePropertyValue.setHeaderVersion(1L);
                    primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DOUBLE);
                    primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DOUBLE.getName());
                    primitivePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DOUBLE.getGUID());
                    primitivePropertyValue.setPrimitiveValue(mapPropertyValue);
                    resultingProperties.setProperty(mapPropertyName, primitivePropertyValue);
                    ++propertyCount;
                    continue;
                }
                if (mapPropertyValue instanceof InstancePropertyValue) {
                    resultingProperties.setProperty(mapPropertyName, (InstancePropertyValue)mapPropertyValue);
                    ++propertyCount;
                    continue;
                }
                if (mapPropertyValue == null) continue;
                primitivePropertyValue = new PrimitivePropertyValue();
                primitivePropertyValue.setHeaderVersion(1L);
                primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_UNKNOWN);
                primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_UNKNOWN.getName());
                primitivePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_UNKNOWN.getGUID());
                primitivePropertyValue.setPrimitiveValue(mapPropertyValue);
                resultingProperties.setProperty(mapPropertyName, primitivePropertyValue);
                ++propertyCount;
            }
            if (propertyCount > 0) {
                log.debug("Returning instanceProperty: " + resultingProperties);
                return resultingProperties;
            }
        }
        log.debug("Null property");
        return properties;
    }

    @Override
    public InstanceProperties addStringPropertyMapToInstance(String sourceName, InstanceProperties properties, String propertyName, Map<String, String> mapValues, String methodName) {
        if (mapValues != null && !mapValues.isEmpty()) {
            InstanceProperties resultingProperties;
            log.debug("Adding property " + propertyName + " for " + methodName);
            if (properties == null) {
                resultingProperties = new InstanceProperties();
                resultingProperties.setHeaderVersion(1L);
            } else {
                resultingProperties = properties;
            }
            int propertyCount = 0;
            for (String mapPropertyName : mapValues.keySet()) {
                String mapPropertyValue = mapValues.get(mapPropertyName);
                if (mapPropertyValue == null) continue;
                PrimitivePropertyValue primitivePropertyValue = new PrimitivePropertyValue();
                primitivePropertyValue.setHeaderVersion(1L);
                primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
                primitivePropertyValue.setPrimitiveValue(mapPropertyValue);
                primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getName());
                primitivePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getGUID());
                resultingProperties.setProperty(mapPropertyName, primitivePropertyValue);
                ++propertyCount;
            }
            if (propertyCount > 0) {
                log.debug("Returning instanceProperty: " + resultingProperties);
                return resultingProperties;
            }
        }
        log.debug("Null property");
        return properties;
    }

    @Override
    public InstanceProperties addBooleanPropertyMapToInstance(String sourceName, InstanceProperties properties, String propertyName, Map<String, Boolean> mapValues, String methodName) {
        if (mapValues != null && !mapValues.isEmpty()) {
            InstanceProperties resultingProperties;
            log.debug("Adding property " + propertyName + " for " + methodName);
            if (properties == null) {
                resultingProperties = new InstanceProperties();
                resultingProperties.setHeaderVersion(1L);
            } else {
                resultingProperties = properties;
            }
            int propertyCount = 0;
            for (String mapPropertyName : mapValues.keySet()) {
                Boolean mapPropertyValue = mapValues.get(mapPropertyName);
                if (mapPropertyValue == null) continue;
                PrimitivePropertyValue primitivePropertyValue = new PrimitivePropertyValue();
                primitivePropertyValue.setHeaderVersion(1L);
                primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BOOLEAN);
                primitivePropertyValue.setPrimitiveValue(mapPropertyValue);
                primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BOOLEAN.getName());
                primitivePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BOOLEAN.getGUID());
                resultingProperties.setProperty(mapPropertyName, primitivePropertyValue);
                ++propertyCount;
            }
            if (propertyCount > 0) {
                log.debug("Returning instanceProperty: " + resultingProperties);
                return resultingProperties;
            }
        }
        log.debug("Null property");
        return properties;
    }

    @Override
    public InstanceProperties addLongPropertyMapToInstance(String sourceName, InstanceProperties properties, String propertyName, Map<String, Long> mapValues, String methodName) {
        if (mapValues != null && !mapValues.isEmpty()) {
            InstanceProperties resultingProperties;
            log.debug("Adding property " + propertyName + " for " + methodName);
            if (properties == null) {
                resultingProperties = new InstanceProperties();
                resultingProperties.setHeaderVersion(1L);
            } else {
                resultingProperties = properties;
            }
            int propertyCount = 0;
            for (String mapPropertyName : mapValues.keySet()) {
                Long mapPropertyValue = mapValues.get(mapPropertyName);
                if (mapPropertyValue == null) continue;
                PrimitivePropertyValue primitivePropertyValue = new PrimitivePropertyValue();
                primitivePropertyValue.setHeaderVersion(1L);
                primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_LONG);
                primitivePropertyValue.setPrimitiveValue(mapPropertyValue);
                primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_LONG.getName());
                primitivePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_LONG.getGUID());
                resultingProperties.setProperty(mapPropertyName, primitivePropertyValue);
                ++propertyCount;
            }
            if (propertyCount > 0) {
                log.debug("Returning instanceProperty: " + resultingProperties);
                return resultingProperties;
            }
        }
        log.debug("Null property");
        return properties;
    }

    @Override
    public InstanceProperties addDatePropertyMapToInstance(String sourceName, InstanceProperties properties, String propertyName, Map<String, Date> mapValues, String methodName) {
        if (mapValues != null && !mapValues.isEmpty()) {
            InstanceProperties resultingProperties;
            log.debug("Adding property " + propertyName + " for " + methodName);
            if (properties == null) {
                resultingProperties = new InstanceProperties();
                resultingProperties.setHeaderVersion(1L);
            } else {
                resultingProperties = properties;
            }
            int propertyCount = 0;
            for (String mapPropertyName : mapValues.keySet()) {
                Date mapPropertyValue = mapValues.get(mapPropertyName);
                if (mapPropertyValue == null) continue;
                PrimitivePropertyValue primitivePropertyValue = new PrimitivePropertyValue();
                primitivePropertyValue.setHeaderVersion(1L);
                primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DATE);
                primitivePropertyValue.setPrimitiveValue(mapPropertyValue.getTime());
                primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DATE.getName());
                primitivePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DATE.getGUID());
                resultingProperties.setProperty(mapPropertyName, primitivePropertyValue);
                ++propertyCount;
            }
            if (propertyCount > 0) {
                log.debug("Returning instanceProperty: " + resultingProperties);
                return resultingProperties;
            }
        }
        log.debug("Null property");
        return properties;
    }

    @Override
    public InstanceProperties addDoublePropertyMapToInstance(String sourceName, InstanceProperties properties, String propertyName, Map<String, Double> mapValues, String methodName) {
        if (mapValues != null && !mapValues.isEmpty()) {
            InstanceProperties resultingProperties;
            log.debug("Adding property " + propertyName + " for " + methodName);
            if (properties == null) {
                resultingProperties = new InstanceProperties();
                resultingProperties.setHeaderVersion(1L);
            } else {
                resultingProperties = properties;
            }
            int propertyCount = 0;
            for (String mapPropertyName : mapValues.keySet()) {
                Double mapPropertyValue = mapValues.get(mapPropertyName);
                if (mapPropertyValue == null) continue;
                PrimitivePropertyValue primitivePropertyValue = new PrimitivePropertyValue();
                primitivePropertyValue.setHeaderVersion(1L);
                primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DOUBLE);
                primitivePropertyValue.setPrimitiveValue(mapPropertyValue);
                primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DOUBLE.getName());
                primitivePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DOUBLE.getGUID());
                resultingProperties.setProperty(mapPropertyName, primitivePropertyValue);
                ++propertyCount;
            }
            if (propertyCount > 0) {
                log.debug("Returning instanceProperty: " + resultingProperties);
                return resultingProperties;
            }
        }
        log.debug("Null property");
        return properties;
    }

    @Override
    public InstanceProperties addIntPropertyMapToInstance(String sourceName, InstanceProperties properties, String propertyName, Map<String, Integer> mapValues, String methodName) {
        if (mapValues != null && !mapValues.isEmpty()) {
            InstanceProperties resultingProperties;
            log.debug("Adding property " + propertyName + " for " + methodName);
            if (properties == null) {
                resultingProperties = new InstanceProperties();
                resultingProperties.setHeaderVersion(1L);
            } else {
                resultingProperties = properties;
            }
            int propertyCount = 0;
            for (String mapPropertyName : mapValues.keySet()) {
                Integer mapPropertyValue = mapValues.get(mapPropertyName);
                if (mapPropertyValue == null) continue;
                PrimitivePropertyValue primitivePropertyValue = new PrimitivePropertyValue();
                primitivePropertyValue.setHeaderVersion(1L);
                primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_INT);
                primitivePropertyValue.setPrimitiveValue(mapPropertyValue);
                primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_INT.getName());
                primitivePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_INT.getGUID());
                resultingProperties.setProperty(mapPropertyName, primitivePropertyValue);
                ++propertyCount;
            }
            if (propertyCount > 0) {
                log.debug("Returning instanceProperty: " + resultingProperties);
                return resultingProperties;
            }
        }
        log.debug("Null property");
        return properties;
    }

    public void validateTypeDefPatch(String sourceName, TypeDefPatch typeDefPatch, String methodName) throws InvalidParameterException, PatchErrorException {
        String thisMethodName = "validateTypeDefPatch";
        String parameterName = "typeDefPatch";
        if (typeDefPatch == null) {
            throw new InvalidParameterException(OMRSErrorCode.NULL_TYPEDEF_PATCH.getMessageDefinition(methodName, sourceName), this.getClass().getName(), "validateTypeDefPatch", "typeDefPatch");
        }
        if (typeDefPatch.getUpdateToVersion() <= typeDefPatch.getApplyToVersion()) {
            throw new PatchErrorException(OMRSErrorCode.INVALID_PATCH_VERSION.getMessageDefinition(methodName, sourceName, Long.toString(typeDefPatch.getApplyToVersion()), Long.toString(typeDefPatch.getUpdateToVersion()), typeDefPatch.toString()), this.getClass().getName(), methodName);
        }
        if (typeDefPatch.getNewVersionName() == null) {
            this.logNullMandatoryPatchField(sourceName, typeDefPatch, "newVersionName", methodName);
        }
        if (typeDefPatch.getUpdatedBy() == null) {
            this.logNullMandatoryPatchField(sourceName, typeDefPatch, "updatedBy", methodName);
        }
        if (typeDefPatch.getUpdateTime() == null) {
            this.logNullMandatoryPatchField(sourceName, typeDefPatch, "updatedTime", methodName);
        }
    }

    private void logNullMandatoryPatchField(String sourceName, TypeDefPatch typeDefPatch, String fieldName, String methodName) throws PatchErrorException {
        throw new PatchErrorException(OMRSErrorCode.NULL_MANDATORY_PATCH_FIELD.getMessageDefinition(methodName, sourceName, fieldName, typeDefPatch.toString()), this.getClass().getName(), methodName);
    }

    public TypeDef applyPatch(String sourceName, TypeDef originalTypeDef, TypeDefPatch typeDefPatch, String methodName) throws InvalidParameterException, PatchErrorException {
        String thisMethodName = "applyPatch";
        String typeDefParameterName = "originalTypeDef";
        this.validateTypeDefPatch(sourceName, typeDefPatch, methodName);
        if (originalTypeDef == null) {
            throw new InvalidParameterException(OMRSErrorCode.NULL_TYPEDEF.getMessageDefinition("originalTypeDef", methodName, sourceName), this.getClass().getName(), "applyPatch", "originalTypeDef");
        }
        TypeDef updatedTypeDef = originalTypeDef.cloneFromSubclass();
        if (originalTypeDef.getVersion() == typeDefPatch.getApplyToVersion()) {
            updatedTypeDef.setVersion(typeDefPatch.getUpdateToVersion());
            updatedTypeDef.setVersionName(typeDefPatch.getNewVersionName());
            updatedTypeDef.setUpdatedBy(typeDefPatch.getUpdatedBy());
            updatedTypeDef.setUpdateTime(typeDefPatch.getUpdateTime());
            if (typeDefPatch.getTypeDefStatus() != null) {
                updatedTypeDef.setStatus(typeDefPatch.getTypeDefStatus());
            }
            if (typeDefPatch.getDescription() != null) {
                updatedTypeDef.setDescription(typeDefPatch.getDescription());
            }
            if (typeDefPatch.getDescriptionGUID() != null) {
                updatedTypeDef.setDescriptionGUID(typeDefPatch.getDescriptionGUID());
            }
            if (typeDefPatch.getSuperType() != null) {
                updatedTypeDef.setSuperType(typeDefPatch.getSuperType());
            }
            if (typeDefPatch.getPropertyDefinitions() != null) {
                List<TypeDefAttribute> existingProperties = originalTypeDef.getPropertiesDefinition();
                if (existingProperties == null) {
                    updatedTypeDef.setPropertiesDefinition(typeDefPatch.getPropertyDefinitions());
                } else {
                    HashMap<String, TypeDefAttribute> newProperties = new HashMap<String, TypeDefAttribute>();
                    for (TypeDefAttribute propertyDefinition : existingProperties) {
                        if (propertyDefinition == null) continue;
                        newProperties.put(propertyDefinition.getAttributeName(), propertyDefinition);
                    }
                    for (TypeDefAttribute newPropertyDefinition : typeDefPatch.getPropertyDefinitions()) {
                        TypeDefAttribute oldPropertyDefinition;
                        String newPropertyName;
                        if (newPropertyDefinition == null || (newPropertyName = newPropertyDefinition.getAttributeName()) == null || (oldPropertyDefinition = newProperties.put(newPropertyName, newPropertyDefinition)) == null || oldPropertyDefinition.getAttributeType().equals(newPropertyDefinition.getAttributeType())) continue;
                        String newPropertyType = "<null>";
                        if (newPropertyDefinition.getAttributeType() != null) {
                            newPropertyType = newPropertyDefinition.getAttributeType().toString();
                        }
                        throw new PatchErrorException(OMRSErrorCode.INCOMPATIBLE_PROPERTY_PATCH.getMessageDefinition(methodName, sourceName, newPropertyName, oldPropertyDefinition.getAttributeType().toString(), newPropertyType, typeDefPatch.toString()), this.getClass().getName(), methodName);
                    }
                    updatedTypeDef.setPropertiesDefinition(new ArrayList<TypeDefAttribute>(newProperties.values()));
                }
            }
            if (typeDefPatch.getTypeDefOptions() != null) {
                updatedTypeDef.setOptions(typeDefPatch.getTypeDefOptions());
            }
            if (typeDefPatch.getExternalStandardMappings() != null) {
                updatedTypeDef.setExternalStandardMappings(typeDefPatch.getExternalStandardMappings());
            }
            if (typeDefPatch.getValidInstanceStatusList() != null) {
                updatedTypeDef.setValidInstanceStatusList(typeDefPatch.getValidInstanceStatusList());
            }
            if (typeDefPatch.getInitialStatus() != null) {
                updatedTypeDef.setInitialStatus(typeDefPatch.getInitialStatus());
            }
            TypeDefCategory category = originalTypeDef.getCategory();
            try {
                switch (category) {
                    case ENTITY_DEF: {
                        break;
                    }
                    case RELATIONSHIP_DEF: {
                        RelationshipDef relationshipDef = (RelationshipDef)updatedTypeDef;
                        if (typeDefPatch.getEndDef1() != null) {
                            relationshipDef.setEndDef1(typeDefPatch.getEndDef1());
                        }
                        if (typeDefPatch.getEndDef2() != null) {
                            relationshipDef.setEndDef2(typeDefPatch.getEndDef2());
                        }
                        if (!typeDefPatch.getUpdateMultiLink()) break;
                        relationshipDef.setMultiLink(typeDefPatch.getMultiLink());
                        break;
                    }
                    case CLASSIFICATION_DEF: {
                        ClassificationDef classificationDef = (ClassificationDef)updatedTypeDef;
                        if (typeDefPatch.getValidEntityDefs() == null) break;
                        classificationDef.setValidEntityDefs(typeDefPatch.getValidEntityDefs());
                    }
                }
            }
            catch (ClassCastException castError) {
                this.throwHelperLogicError(sourceName, methodName, "applyPatch", castError);
            }
            return updatedTypeDef;
        }
        if (typeDefPatch.getApplyToVersion() < originalTypeDef.getVersion()) {
            return originalTypeDef;
        }
        throw new PatchErrorException(OMRSErrorCode.INCOMPATIBLE_PATCH_VERSION.getMessageDefinition(methodName, sourceName, Long.toString(typeDefPatch.getApplyToVersion()), Long.toString(originalTypeDef.getVersion()), typeDefPatch.toString()), this.getClass().getName(), methodName);
    }

    @Override
    public SearchProperties getSearchPropertiesFromInstanceProperties(String sourceName, InstanceProperties properties, MatchCriteria matchCriteria) {
        SearchProperties matchProperties = null;
        if (properties != null) {
            matchProperties = new SearchProperties();
            ArrayList<PropertyCondition> conditions = new ArrayList<PropertyCondition>();
            Iterator<String> propertyNames = properties.getPropertyNames();
            while (propertyNames.hasNext()) {
                String propertyName = propertyNames.next();
                PropertyCondition pc = new PropertyCondition();
                pc.setProperty(propertyName);
                InstancePropertyValue ipv = properties.getPropertyValue(propertyName);
                if (ipv.getInstancePropertyCategory().equals(InstancePropertyCategory.PRIMITIVE) && ((PrimitivePropertyValue)ipv).getPrimitiveDefCategory().equals(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING)) {
                    pc.setOperator(PropertyComparisonOperator.LIKE);
                } else {
                    pc.setOperator(PropertyComparisonOperator.EQ);
                }
                pc.setValue(ipv);
                conditions.add(pc);
            }
            matchProperties.setConditions(conditions);
            matchProperties.setMatchCriteria(matchCriteria);
        }
        return matchProperties;
    }

    protected List<String> getUniquePropertiesList(List<TypeDefAttribute> definedAttributes, List<String> currentList) {
        List<String> newList = currentList;
        if (newList == null) {
            newList = new ArrayList<String>();
        }
        if (definedAttributes != null) {
            for (TypeDefAttribute attribute : definedAttributes) {
                if (attribute == null || !attribute.isUnique()) continue;
                newList.add(attribute.getAttributeName());
            }
        }
        if (newList.isEmpty()) {
            return null;
        }
        return newList;
    }

    private void throwHelperLogicError(String sourceName, String originatingMethodName, String localMethodName) {
        throw new OMRSLogicErrorException(OMRSErrorCode.HELPER_LOGIC_ERROR.getMessageDefinition(sourceName, localMethodName, originatingMethodName), this.getClass().getName(), localMethodName);
    }

    private void throwHelperLogicError(String sourceName, String originatingMethodName, String localMethodName, Exception unexpectedException) {
        throw new OMRSLogicErrorException(OMRSErrorCode.HELPER_LOGIC_EXCEPTION.getMessageDefinition(sourceName, localMethodName, originatingMethodName), this.getClass().getName(), localMethodName, unexpectedException);
    }
}

