/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.samples.archiveutilities;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.frameworks.connectors.ConnectorProviderBase;
import org.odpi.openmetadata.frameworks.connectors.controls.ConfigurationPropertyType;
import org.odpi.openmetadata.frameworks.connectors.controls.TemplateType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ConnectorType;
import org.odpi.openmetadata.frameworks.governanceaction.GovernanceServiceProviderBase;
import org.odpi.openmetadata.frameworks.governanceaction.controls.ActionTargetType;
import org.odpi.openmetadata.frameworks.governanceaction.controls.GuardType;
import org.odpi.openmetadata.frameworks.governanceaction.controls.RequestParameterType;
import org.odpi.openmetadata.frameworks.governanceaction.controls.RequestTypeType;
import org.odpi.openmetadata.frameworks.governanceaction.properties.NewActionTarget;
import org.odpi.openmetadata.frameworks.integration.connectors.IntegrationConnectorProvider;
import org.odpi.openmetadata.frameworks.openmetadata.controls.PlaceholderPropertyType;
import org.odpi.openmetadata.frameworks.openmetadata.controls.ReplacementAttributeType;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.DeployedImplementationType;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.SpecificationPropertyType;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.frameworks.surveyaction.SurveyActionServiceProvider;
import org.odpi.openmetadata.frameworks.surveyaction.controls.AnalysisStepType;
import org.odpi.openmetadata.frameworks.surveyaction.controls.AnnotationTypeType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.OpenMetadataArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.samples.archiveutilities.SimpleCatalogArchiveHelper;

public class GovernanceArchiveHelper
extends SimpleCatalogArchiveHelper {
    public GovernanceArchiveHelper(OpenMetadataArchiveBuilder archiveBuilder, String archiveGUID, String archiveRootName, String originatorName, Date creationDate, long versionNumber, String versionName) {
        super(archiveBuilder, archiveGUID, archiveRootName, archiveRootName, originatorName, creationDate, versionNumber, versionName);
    }

    public GovernanceArchiveHelper(OpenMetadataArchiveBuilder archiveBuilder, String archiveGUID, String archiveName, String archiveRootName, String originatorName, Date creationDate, long versionNumber, String versionName) {
        super(archiveBuilder, archiveGUID, archiveName, archiveRootName, originatorName, creationDate, versionNumber, versionName);
    }

    public GovernanceArchiveHelper(OpenMetadataArchiveBuilder archiveBuilder, String archiveGUID, String archiveRootName, String originatorName, Date creationDate, long versionNumber, String versionName, String guidMapFileName) {
        super(archiveBuilder, archiveGUID, archiveRootName, originatorName, creationDate, versionNumber, versionName, guidMapFileName);
    }

    public String addIntegrationConnector(String connectorProviderName, Map<String, Object> configurationProperties, String qualifiedName, String displayName, String description, String endpointAddress, Map<String, String> additionalProperties) {
        try {
            Class<?> connectorProviderClass = Class.forName(connectorProviderName);
            Object potentialConnectorProvider = connectorProviderClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            IntegrationConnectorProvider connectorProvider = (IntegrationConnectorProvider)potentialConnectorProvider;
            ConnectorType connectorType = connectorProvider.getConnectorType();
            String connectorTypeGUID = super.addConnectorType(null, connectorType.getGUID(), connectorType.getQualifiedName(), connectorType.getDisplayName(), connectorType.getDescription(), connectorType.getSupportedDeployedImplementationType(), connectorType.getSupportedAssetTypeName(), connectorType.getExpectedDataFormat(), connectorType.getConnectorProviderClassName(), connectorType.getConnectorFrameworkName(), connectorType.getConnectorInterfaceLanguage(), connectorType.getConnectorInterfaces(), connectorType.getTargetTechnologySource(), connectorType.getTargetTechnologyName(), connectorType.getTargetTechnologyInterfaces(), connectorType.getTargetTechnologyVersions(), connectorType.getRecognizedSecuredProperties(), connectorType.getRecognizedConfigurationProperties(), connectorType.getRecognizedAdditionalProperties(), connectorType.getAdditionalProperties());
            HashMap<String, Object> extendedProperties = new HashMap<String, Object>();
            extendedProperties.put(OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, DeployedImplementationType.INTEGRATION_CONNECTOR.getDeployedImplementationType());
            String connectorGUID = super.addAsset(DeployedImplementationType.INTEGRATION_CONNECTOR.getAssociatedTypeName(), qualifiedName, displayName, description, additionalProperties, extendedProperties);
            this.addSupportedTemplateTypes(connectorGUID, DeployedImplementationType.INTEGRATION_CONNECTOR.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName, connectorProvider.getSupportedTemplateTypes());
            this.addSupportedConfigurationProperties(connectorGUID, DeployedImplementationType.INTEGRATION_CONNECTOR.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName, connectorProvider.getSupportedConfigurationProperties());
            String endpointGUID = null;
            if (endpointAddress != null) {
                endpointGUID = super.addEndpoint(connectorGUID, DeployedImplementationType.INTEGRATION_CONNECTOR.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName, qualifiedName + "_endpoint", displayName + "'s first catalog target", "Endpoint for integration connector: " + qualifiedName, endpointAddress, null, null);
            }
            String connectionGUID = super.addConnection(qualifiedName + "_implementation", displayName + " Integration Connector Provider Implementation", "Connection for integration connector: " + qualifiedName, null, null, null, null, configurationProperties, null, connectorTypeGUID, endpointGUID, connectorGUID, DeployedImplementationType.INTEGRATION_CONNECTOR.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName);
            if (connectorGUID != null && connectionGUID != null) {
                super.addConnectionForAsset(connectorGUID, null, connectionGUID);
            }
            return connectorGUID;
        }
        catch (Exception error) {
            System.out.println("Invalid connector type " + connectorProviderName + " for integration connector.  Exception " + error.getClass().getName() + " with message " + error.getMessage());
            return null;
        }
    }

    public void addCatalogTargetRelationship(String integrationConnectorGUID, String targetElementGUID, String catalogTargetName, String connectionName, Map<String, Object> configurationProperties, Map<String, String> templates, String metadataSourceQualifiedName) {
        String methodName = "addCatalogTargetRelationship";
        EntityDetail end1Entity = this.archiveBuilder.getEntity(integrationConnectorGUID);
        EntityDetail end2Entity = this.archiveBuilder.getEntity(targetElementGUID);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(end1Entity);
        EntityProxy end2 = this.archiveHelper.getEntityProxy(end2Entity);
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, "catalogTargetName", catalogTargetName, "addCatalogTargetRelationship");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, "connectionName", connectionName, "addCatalogTargetRelationship");
        properties = this.archiveHelper.addMapPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.CONFIGURATION_PROPERTIES.name, configurationProperties, "addCatalogTargetRelationship");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, "templates", templates, "addCatalogTargetRelationship");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, "metadataSourceQualifiedName", metadataSourceQualifiedName, "addCatalogTargetRelationship");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship("CatalogTarget", this.idToGUIDMap.getGUID(integrationConnectorGUID + "_to_" + targetElementGUID + "_catalog_target_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public String addIntegrationGroup(String qualifiedName, String displayName, String description, String capabilityVersion, String patchLevel, String source, Map<String, String> additionalProperties, Map<String, Object> extendedProperties) {
        return super.addSoftwareCapability(DeployedImplementationType.INTEGRATION_GROUP.getAssociatedTypeName(), qualifiedName, displayName, description, DeployedImplementationType.INTEGRATION_GROUP.getDeployedImplementationType(), capabilityVersion, patchLevel, source, additionalProperties, extendedProperties, (Classification)null, null, null, null);
    }

    public void addRegisteredIntegrationConnector(String integrationGroupGUID, String connectorName, String connectorUserId, String metadataSourceQualifiedName, long refreshTimeInterval, String integrationConnectorGUID) {
        String methodName = "addRegisteredIntegrationConnector";
        EntityDetail groupEntity = this.archiveBuilder.getEntity(integrationGroupGUID);
        EntityDetail connectorEntity = this.archiveBuilder.getEntity(integrationConnectorGUID);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(groupEntity);
        EntityProxy end2 = this.archiveHelper.getEntityProxy(connectorEntity);
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, "connectorName", connectorName, "addRegisteredIntegrationConnector");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, "connectorUserId", connectorUserId, "addRegisteredIntegrationConnector");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, "metadataSourceQualifiedName", metadataSourceQualifiedName, "addRegisteredIntegrationConnector");
        properties = this.archiveHelper.addLongPropertyToInstance(this.archiveRootName, properties, "refreshTimeInterval", refreshTimeInterval, "addRegisteredIntegrationConnector");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship("RegisteredIntegrationConnector", this.idToGUIDMap.getGUID(integrationGroupGUID + "_to_" + integrationConnectorGUID + "_" + connectorName + "_registered_integration_connector_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public String addGovernanceService(String typeName, String deployedImplementationType, String connectorProviderName, Map<String, Object> configurationProperties, String qualifiedName, String displayName, String description, Map<String, String> additionalProperties) {
        try {
            String assetTypeName = OpenMetadataType.GOVERNANCE_SERVICE.typeName;
            if (typeName != null) {
                assetTypeName = typeName;
            }
            Class<?> connectorProviderClass = Class.forName(connectorProviderName);
            Object potentialConnectorProvider = connectorProviderClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            ConnectorProviderBase serviceProvider = (ConnectorProviderBase)potentialConnectorProvider;
            ConnectorType connectorType = serviceProvider.getConnectorType();
            String connectorTypeGUID = super.addConnectorType(null, connectorType.getGUID(), connectorType.getQualifiedName(), connectorType.getDisplayName(), connectorType.getDescription(), connectorType.getSupportedDeployedImplementationType(), connectorType.getSupportedAssetTypeName(), connectorType.getExpectedDataFormat(), connectorType.getConnectorProviderClassName(), connectorType.getConnectorFrameworkName(), connectorType.getConnectorInterfaceLanguage(), connectorType.getConnectorInterfaces(), connectorType.getTargetTechnologySource(), connectorType.getTargetTechnologyName(), connectorType.getTargetTechnologyInterfaces(), connectorType.getTargetTechnologyVersions(), connectorType.getRecognizedSecuredProperties(), connectorType.getRecognizedConfigurationProperties(), connectorType.getRecognizedAdditionalProperties(), connectorType.getAdditionalProperties());
            HashMap<String, Object> extendedProperties = new HashMap<String, Object>();
            extendedProperties.put(OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, deployedImplementationType);
            String serviceGUID = super.addAsset(assetTypeName, qualifiedName, displayName, description, additionalProperties, extendedProperties);
            if (serviceGUID != null) {
                this.addSupportedConfigurationProperties(serviceGUID, assetTypeName, OpenMetadataType.ASSET.typeName, serviceProvider.getSupportedConfigurationProperties());
                this.addSupportedTemplateTypes(serviceGUID, assetTypeName, OpenMetadataType.ASSET.typeName, serviceProvider.getSupportedTemplateTypes());
                String connectionGUID = super.addConnection(qualifiedName + "_implementation", displayName + " Governance Service Provider Implementation", "Connection for governance service: " + qualifiedName, null, null, null, null, configurationProperties, null, connectorTypeGUID, null, serviceGUID, assetTypeName, OpenMetadataType.ASSET.typeName);
                if (connectionGUID != null) {
                    super.addConnectionForAsset(serviceGUID, null, connectionGUID);
                }
                if (serviceProvider instanceof GovernanceServiceProviderBase) {
                    GovernanceServiceProviderBase governanceServiceProviderBase = (GovernanceServiceProviderBase)serviceProvider;
                    this.addSupportedRequestTypes(serviceGUID, assetTypeName, OpenMetadataType.ASSET.typeName, governanceServiceProviderBase.getSupportedRequestTypes());
                    this.addSupportedRequestParameters(serviceGUID, assetTypeName, OpenMetadataType.ASSET.typeName, governanceServiceProviderBase.getSupportedRequestParameters());
                    this.addSupportedActionTargets(serviceGUID, assetTypeName, OpenMetadataType.ASSET.typeName, governanceServiceProviderBase.getSupportedActionTargetTypes());
                    this.addProducedRequestParameters(serviceGUID, assetTypeName, OpenMetadataType.ASSET.typeName, governanceServiceProviderBase.getProducedRequestParameters());
                    this.addProducedActionTargets(serviceGUID, assetTypeName, OpenMetadataType.ASSET.typeName, governanceServiceProviderBase.getProducedActionTargetTypes());
                    this.addProducedGuards(serviceGUID, assetTypeName, OpenMetadataType.ASSET.typeName, governanceServiceProviderBase.getProducedGuards());
                    if (serviceProvider instanceof SurveyActionServiceProvider) {
                        SurveyActionServiceProvider surveyActionServiceProvider = (SurveyActionServiceProvider)serviceProvider;
                        this.addSupportedAnalysisSteps(serviceGUID, assetTypeName, OpenMetadataType.ASSET.typeName, surveyActionServiceProvider.getSupportedAnalysisSteps());
                        this.addProducedAnnotationTypes(serviceGUID, assetTypeName, OpenMetadataType.ASSET.typeName, surveyActionServiceProvider.getProducedAnnotationTypes());
                    }
                }
            }
            return serviceGUID;
        }
        catch (Exception error) {
            System.out.println("Invalid connector type " + connectorProviderName + " for governance service.  Exception " + error.getClass().getName() + " with message " + error.getMessage());
            return null;
        }
    }

    public void addReplacementAttributes(String parentGUID, String parentTypeName, String parentDomainName, List<ReplacementAttributeType> replacementAttributeTypes) {
        if (replacementAttributeTypes != null) {
            for (ReplacementAttributeType replacementAttributeType : replacementAttributeTypes) {
                Map<String, String> additionalProperties = replacementAttributeType.getOtherPropertyValues();
                if (additionalProperties == null) {
                    additionalProperties = new HashMap<String, String>();
                }
                String required = "false";
                if (replacementAttributeType.getRequired()) {
                    required = "true";
                }
                additionalProperties.put(OpenMetadataProperty.DESCRIPTION.name, replacementAttributeType.getDescription());
                additionalProperties.put(OpenMetadataProperty.DATA_TYPE.name, replacementAttributeType.getDataType());
                additionalProperties.put(OpenMetadataProperty.EXAMPLE.name, replacementAttributeType.getExample());
                additionalProperties.put(OpenMetadataProperty.REQUIRED.name, required);
                String validValueGUID = this.addValidValue(null, null, parentGUID, parentTypeName, parentDomainName, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, parentTypeName + ":" + parentGUID + ":PlaceholderProperty:" + replacementAttributeType.getName(), replacementAttributeType.getName(), SpecificationPropertyType.REPLACEMENT_ATTRIBUTE.getDescription(), SpecificationPropertyType.REPLACEMENT_ATTRIBUTE.getPropertyType(), null, null, null, replacementAttributeType.getName(), false, true, additionalProperties);
                if (validValueGUID == null) continue;
                this.addSpecificationPropertyAssignmentRelationship(parentGUID, validValueGUID, SpecificationPropertyType.REPLACEMENT_ATTRIBUTE.getPropertyType());
            }
        }
    }

    public void addPlaceholderProperties(String parentGUID, String parentTypeName, String parentDomainName, List<PlaceholderPropertyType> placeholderPropertyTypes) {
        if (placeholderPropertyTypes != null) {
            for (PlaceholderPropertyType placeholderPropertyType : placeholderPropertyTypes) {
                Map<String, String> additionalProperties = placeholderPropertyType.getOtherPropertyValues();
                if (additionalProperties == null) {
                    additionalProperties = new HashMap<String, String>();
                }
                String required = "false";
                if (placeholderPropertyType.getRequired()) {
                    required = "true";
                }
                additionalProperties.put(OpenMetadataProperty.DESCRIPTION.name, placeholderPropertyType.getDescription());
                additionalProperties.put(OpenMetadataProperty.DATA_TYPE.name, placeholderPropertyType.getDataType());
                additionalProperties.put(OpenMetadataProperty.EXAMPLE.name, placeholderPropertyType.getExample());
                additionalProperties.put(OpenMetadataProperty.REQUIRED.name, required);
                String validValueGUID = this.addValidValue(null, null, parentGUID, parentTypeName, parentDomainName, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, parentTypeName + ":" + parentGUID + ":PlaceholderProperty:" + placeholderPropertyType.getName(), placeholderPropertyType.getName(), SpecificationPropertyType.PLACEHOLDER_PROPERTY.getDescription(), SpecificationPropertyType.PLACEHOLDER_PROPERTY.getPropertyType(), null, null, null, placeholderPropertyType.getName(), false, true, additionalProperties);
                if (validValueGUID == null) continue;
                this.addSpecificationPropertyAssignmentRelationship(parentGUID, validValueGUID, SpecificationPropertyType.PLACEHOLDER_PROPERTY.getPropertyType());
            }
        }
    }

    public void addSupportedTemplateTypes(String parentGUID, String parentTypeName, String parentDomainName, List<TemplateType> templateTypes) {
        if (templateTypes != null) {
            for (TemplateType templateType : templateTypes) {
                Map<String, String> additionalProperties = templateType.getOtherPropertyValues();
                if (additionalProperties == null) {
                    additionalProperties = new HashMap<String, String>();
                }
                String required = "false";
                if (templateType.getRequired()) {
                    required = "true";
                }
                additionalProperties.put(OpenMetadataProperty.DESCRIPTION.name, templateType.getTemplateDescription());
                additionalProperties.put(OpenMetadataProperty.OPEN_METADATA_TYPE_NAME.name, templateType.getTypeName());
                additionalProperties.put(OpenMetadataProperty.REQUIRED.name, required);
                String validValueGUID = this.addValidValue(null, null, parentGUID, parentTypeName, parentDomainName, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, parentTypeName + ":" + parentGUID + ":SupportedTemplate:" + templateType.getTemplateName(), templateType.getTemplateName(), SpecificationPropertyType.SUPPORTED_TEMPLATE.getDescription(), SpecificationPropertyType.SUPPORTED_TEMPLATE.getPropertyType(), null, null, null, templateType.getTemplateName(), false, true, additionalProperties);
                if (validValueGUID == null) continue;
                this.addSpecificationPropertyAssignmentRelationship(parentGUID, validValueGUID, SpecificationPropertyType.SUPPORTED_TEMPLATE.getPropertyType());
            }
        }
    }

    public void addSupportedConfigurationProperties(String parentGUID, String parentTypeName, String parentDomainName, List<ConfigurationPropertyType> configurationPropertyTypes) {
        if (configurationPropertyTypes != null) {
            for (ConfigurationPropertyType configurationPropertyType : configurationPropertyTypes) {
                Map<String, String> additionalProperties = configurationPropertyType.getOtherPropertyValues();
                if (additionalProperties == null) {
                    additionalProperties = new HashMap<String, String>();
                }
                additionalProperties.put(OpenMetadataProperty.DESCRIPTION.name, configurationPropertyType.getDescription());
                additionalProperties.put(OpenMetadataProperty.DATA_TYPE.name, configurationPropertyType.getDataType());
                additionalProperties.put(OpenMetadataProperty.EXAMPLE.name, configurationPropertyType.getExample());
                additionalProperties.put(OpenMetadataProperty.DESCRIPTION.name, configurationPropertyType.getDescription());
                String required = "false";
                if (configurationPropertyType.getRequired()) {
                    required = "true";
                }
                additionalProperties.put(OpenMetadataProperty.REQUIRED.name, required);
                String validValueGUID = this.addValidValue(null, null, parentGUID, parentTypeName, parentDomainName, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, parentTypeName + ":" + parentGUID + ":SupportedConfigurationProperty:" + configurationPropertyType.getName(), configurationPropertyType.getName(), SpecificationPropertyType.SUPPORTED_CONFIGURATION_PROPERTY.getDescription(), SpecificationPropertyType.SUPPORTED_CONFIGURATION_PROPERTY.getPropertyType(), null, null, null, configurationPropertyType.getName(), false, true, additionalProperties);
                if (validValueGUID == null) continue;
                this.addSpecificationPropertyAssignmentRelationship(parentGUID, validValueGUID, SpecificationPropertyType.SUPPORTED_CONFIGURATION_PROPERTY.getPropertyType());
            }
        }
    }

    public void addSupportedRequestTypes(String parentGUID, String parentTypeName, String parentDomainName, List<RequestTypeType> supportedRequestTypes) {
        if (supportedRequestTypes != null) {
            for (RequestTypeType supportedRequestType : supportedRequestTypes) {
                Map<String, String> additionalProperties = supportedRequestType.getOtherPropertyValues();
                if (additionalProperties == null) {
                    additionalProperties = new HashMap<String, String>();
                }
                additionalProperties.put(OpenMetadataProperty.DESCRIPTION.name, supportedRequestType.getDescription());
                String validValueGUID = this.addValidValue(null, null, parentGUID, parentTypeName, parentDomainName, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, parentTypeName + ":" + parentGUID + ":SupportedRequestType:" + supportedRequestType.getRequestType(), supportedRequestType.getRequestType(), SpecificationPropertyType.SUPPORTED_REQUEST_TYPE.getDescription(), SpecificationPropertyType.SUPPORTED_REQUEST_TYPE.getPropertyType(), null, null, null, supportedRequestType.getRequestType(), false, true, additionalProperties);
                if (validValueGUID == null) continue;
                this.addSpecificationPropertyAssignmentRelationship(parentGUID, validValueGUID, SpecificationPropertyType.SUPPORTED_REQUEST_TYPE.getPropertyType());
            }
        }
    }

    public void addSupportedRequestParameters(String parentGUID, String parentTypeName, String parentDomainName, List<RequestParameterType> supportedRequestParameters) {
        if (supportedRequestParameters != null) {
            for (RequestParameterType supportedRequestParameter : supportedRequestParameters) {
                Map<String, String> additionalProperties = supportedRequestParameter.getOtherPropertyValues();
                if (additionalProperties == null) {
                    additionalProperties = new HashMap<String, String>();
                }
                String required = "false";
                if (supportedRequestParameter.getRequired()) {
                    required = "true";
                }
                additionalProperties.put(OpenMetadataProperty.DESCRIPTION.name, supportedRequestParameter.getDescription());
                additionalProperties.put(OpenMetadataProperty.DATA_TYPE.name, supportedRequestParameter.getDataType());
                additionalProperties.put(OpenMetadataProperty.EXAMPLE.name, supportedRequestParameter.getExample());
                additionalProperties.put(OpenMetadataProperty.REQUIRED.name, required);
                String validValueGUID = this.addValidValue(null, null, parentGUID, parentTypeName, parentDomainName, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, parentTypeName + ":" + parentGUID + ":SupportedRequestParameter:" + supportedRequestParameter.getName(), supportedRequestParameter.getName(), SpecificationPropertyType.SUPPORTED_REQUEST_PARAMETER.getDescription(), SpecificationPropertyType.SUPPORTED_REQUEST_PARAMETER.getPropertyType(), null, null, null, supportedRequestParameter.getName(), false, true, additionalProperties);
                if (validValueGUID == null) continue;
                this.addSpecificationPropertyAssignmentRelationship(parentGUID, validValueGUID, SpecificationPropertyType.SUPPORTED_REQUEST_PARAMETER.getPropertyType());
            }
        }
    }

    public void addSupportedActionTargets(String parentGUID, String parentTypeName, String parentDomainName, List<ActionTargetType> actionTargetTypes) {
        if (actionTargetTypes != null) {
            for (ActionTargetType supportedActionTarget : actionTargetTypes) {
                Map<String, String> additionalProperties = supportedActionTarget.getOtherPropertyValues();
                if (additionalProperties == null) {
                    additionalProperties = new HashMap<String, String>();
                }
                String required = "false";
                if (supportedActionTarget.getRequired()) {
                    required = "true";
                }
                additionalProperties.put(OpenMetadataProperty.DESCRIPTION.name, supportedActionTarget.getDescription());
                additionalProperties.put(OpenMetadataProperty.DATA_TYPE.name, supportedActionTarget.getTypeName());
                additionalProperties.put(OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, supportedActionTarget.getDeployedImplementationType());
                additionalProperties.put(OpenMetadataProperty.REQUIRED.name, required);
                String validValueGUID = this.addValidValue(null, null, parentGUID, parentTypeName, parentDomainName, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, parentTypeName + ":" + parentGUID + ":SupportedActionTarget:" + supportedActionTarget.getName(), supportedActionTarget.getName(), SpecificationPropertyType.SUPPORTED_ACTION_TARGET.getDescription(), SpecificationPropertyType.SUPPORTED_ACTION_TARGET.getPropertyType(), null, null, null, supportedActionTarget.getName(), false, true, additionalProperties);
                if (validValueGUID == null) continue;
                this.addSpecificationPropertyAssignmentRelationship(parentGUID, validValueGUID, SpecificationPropertyType.SUPPORTED_ACTION_TARGET.getPropertyType());
            }
        }
    }

    public void addSupportedAnalysisSteps(String parentGUID, String parentTypeName, String parentDomainName, List<AnalysisStepType> analysisStepTypes) {
        if (analysisStepTypes != null) {
            for (AnalysisStepType analysisStepType : analysisStepTypes) {
                Map<String, String> additionalProperties = analysisStepType.getOtherPropertyValues();
                if (additionalProperties == null) {
                    additionalProperties = new HashMap<String, String>();
                }
                additionalProperties.put(OpenMetadataProperty.DESCRIPTION.name, analysisStepType.getDescription());
                String validValueGUID = this.addValidValue(null, null, parentGUID, parentTypeName, parentDomainName, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, parentTypeName + ":" + parentGUID + ":SupportedAnalysisStep:" + analysisStepType.getName(), analysisStepType.getName(), SpecificationPropertyType.SUPPORTED_ANALYSIS_STEP.getDescription(), SpecificationPropertyType.SUPPORTED_ANALYSIS_STEP.getPropertyType(), null, null, null, analysisStepType.getName(), false, true, additionalProperties);
                if (validValueGUID == null) continue;
                this.addSpecificationPropertyAssignmentRelationship(parentGUID, validValueGUID, SpecificationPropertyType.SUPPORTED_ANALYSIS_STEP.getPropertyType());
            }
        }
    }

    public void addProducedAnnotationTypes(String parentGUID, String parentTypeName, String parentDomainName, List<AnnotationTypeType> annotationTypeTypes) {
        if (annotationTypeTypes != null) {
            for (AnnotationTypeType annotationTypeType : annotationTypeTypes) {
                Map<String, String> additionalProperties = annotationTypeType.getOtherPropertyValues();
                if (additionalProperties == null) {
                    additionalProperties = new HashMap<String, String>();
                }
                additionalProperties.put(OpenMetadataProperty.SUMMARY.name, annotationTypeType.getSummary());
                additionalProperties.put(OpenMetadataProperty.EXPLANATION.name, annotationTypeType.getExplanation());
                additionalProperties.put(OpenMetadataProperty.EXPRESSION.name, annotationTypeType.getExpression());
                additionalProperties.put(OpenMetadataProperty.ANALYSIS_STEP.name, annotationTypeType.getAnalysisStepName());
                additionalProperties.put(OpenMetadataProperty.OPEN_METADATA_TYPE_NAME.name, annotationTypeType.getOpenMetadataTypeName());
                String validValueGUID = this.addValidValue(null, null, parentGUID, parentTypeName, parentDomainName, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, parentTypeName + ":" + parentGUID + ":ProducedAnnotationType:" + annotationTypeType.getName(), annotationTypeType.getOpenMetadataTypeName() + ":" + annotationTypeType.getName(), SpecificationPropertyType.PRODUCED_ANNOTATION_TYPE.getDescription(), SpecificationPropertyType.PRODUCED_ANNOTATION_TYPE.getPropertyType(), null, null, null, annotationTypeType.getName(), false, true, additionalProperties);
                if (validValueGUID == null) continue;
                this.addSpecificationPropertyAssignmentRelationship(parentGUID, validValueGUID, SpecificationPropertyType.PRODUCED_ANNOTATION_TYPE.getPropertyType());
            }
        }
    }

    public void addProducedRequestParameters(String parentGUID, String parentTypeName, String parentDomainName, List<RequestParameterType> producedRequestParameters) {
        if (producedRequestParameters != null) {
            for (RequestParameterType producedRequestParameter : producedRequestParameters) {
                Map<String, String> additionalProperties = producedRequestParameter.getOtherPropertyValues();
                if (additionalProperties == null) {
                    additionalProperties = new HashMap<String, String>();
                }
                String required = "false";
                if (producedRequestParameter.getRequired()) {
                    required = "true";
                }
                additionalProperties.put(OpenMetadataProperty.DESCRIPTION.name, producedRequestParameter.getDescription());
                additionalProperties.put(OpenMetadataProperty.DATA_TYPE.name, producedRequestParameter.getDataType());
                additionalProperties.put(OpenMetadataProperty.EXAMPLE.name, producedRequestParameter.getExample());
                additionalProperties.put(OpenMetadataProperty.REQUIRED.name, required);
                String validValueGUID = this.addValidValue(null, null, parentGUID, parentTypeName, parentDomainName, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, parentTypeName + ":" + parentGUID + ":ProducedRequestParameter:" + producedRequestParameter.getName(), producedRequestParameter.getName(), SpecificationPropertyType.PRODUCED_REQUEST_PARAMETER.getDescription(), SpecificationPropertyType.PRODUCED_REQUEST_PARAMETER.getPropertyType(), null, null, null, producedRequestParameter.getName(), false, true, additionalProperties);
                if (validValueGUID == null) continue;
                this.addSpecificationPropertyAssignmentRelationship(parentGUID, validValueGUID, SpecificationPropertyType.PRODUCED_REQUEST_PARAMETER.getPropertyType());
            }
        }
    }

    public void addProducedActionTargets(String parentGUID, String parentTypeName, String parentDomainName, List<ActionTargetType> actionTargetTypes) {
        if (actionTargetTypes != null) {
            for (ActionTargetType actionTargetType : actionTargetTypes) {
                Map<String, String> additionalProperties = actionTargetType.getOtherPropertyValues();
                if (additionalProperties == null) {
                    additionalProperties = new HashMap<String, String>();
                }
                String required = "false";
                if (actionTargetType.getRequired()) {
                    required = "true";
                }
                additionalProperties.put(OpenMetadataProperty.DESCRIPTION.name, actionTargetType.getDescription());
                additionalProperties.put(OpenMetadataProperty.DATA_TYPE.name, actionTargetType.getTypeName());
                additionalProperties.put(OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, actionTargetType.getDeployedImplementationType());
                additionalProperties.put(OpenMetadataProperty.REQUIRED.name, required);
                String validValueGUID = this.addValidValue(null, null, parentGUID, parentTypeName, parentDomainName, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, parentTypeName + ":" + parentGUID + ":ProducedActionTarget:" + actionTargetType.getName(), actionTargetType.getName(), SpecificationPropertyType.PRODUCED_ACTION_TARGET.getDescription(), SpecificationPropertyType.PRODUCED_ACTION_TARGET.getPropertyType(), null, null, null, actionTargetType.getName(), false, true, additionalProperties);
                if (validValueGUID == null) continue;
                this.addSpecificationPropertyAssignmentRelationship(parentGUID, validValueGUID, SpecificationPropertyType.PRODUCED_ACTION_TARGET.getPropertyType());
            }
        }
    }

    public void addProducedGuards(String parentGUID, String parentTypeName, String parentDomainName, List<GuardType> guardTypes) {
        if (guardTypes != null) {
            for (GuardType guardType : guardTypes) {
                Map<String, String> additionalProperties = guardType.getOtherPropertyValues();
                if (additionalProperties == null) {
                    additionalProperties = new HashMap<String, String>();
                }
                additionalProperties.put(OpenMetadataProperty.DESCRIPTION.name, guardType.getDescription());
                additionalProperties.put("completionStatus", guardType.getCompletionStatus().getName());
                additionalProperties.put("completionStatusDescription", guardType.getCompletionStatus().getDescription());
                String validValueGUID = this.addValidValue(null, null, parentGUID, parentTypeName, parentDomainName, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, parentTypeName + ":" + parentGUID + ":ProducedGuard:" + guardType.getGuard(), guardType.getGuard(), SpecificationPropertyType.PRODUCED_GUARD.getDescription(), SpecificationPropertyType.PRODUCED_GUARD.getPropertyType(), guardType.getCompletionStatus().getName(), null, null, guardType.getGuard(), false, true, additionalProperties);
                if (validValueGUID == null) continue;
                this.addSpecificationPropertyAssignmentRelationship(parentGUID, validValueGUID, SpecificationPropertyType.PRODUCED_GUARD.getPropertyType());
            }
        }
    }

    public String addGovernanceEngine(String typeName, String qualifiedName, String displayName, String description, String capabilityType, String capabilityVersion, String patchLevel, String source, String userId, Map<String, String> additionalProperties, Map<String, Object> extendedProperties) {
        String capabilityGUID;
        String engineTypeName = OpenMetadataType.GOVERNANCE_ENGINE.typeName;
        if (typeName != null) {
            engineTypeName = typeName;
        }
        if ((capabilityGUID = super.addSoftwareCapability(engineTypeName, qualifiedName, displayName, description, capabilityType, capabilityVersion, patchLevel, source, additionalProperties, extendedProperties, (Classification)null, null, null, null)) != null) {
            this.addITProfile(capabilityGUID, userId, qualifiedName + ":ActorProfile", displayName, description, null);
        }
        return capabilityGUID;
    }

    public void addSupportedGovernanceService(String engineGUID, String requestType, String serviceRequestType, Map<String, String> requestParameters, String serviceGUID) {
        String methodName = "addSupportedGovernanceService";
        EntityDetail engineEntity = this.archiveBuilder.getEntity(engineGUID);
        EntityDetail serviceEntity = this.archiveBuilder.getEntity(serviceGUID);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(engineEntity);
        EntityProxy end2 = this.archiveHelper.getEntityProxy(serviceEntity);
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.REQUEST_TYPE.name, requestType, "addSupportedGovernanceService");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.SERVICE_REQUEST_TYPE.name, serviceRequestType, "addSupportedGovernanceService");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.REQUEST_PARAMETERS.name, requestParameters, "addSupportedGovernanceService");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(OpenMetadataType.SUPPORTED_GOVERNANCE_SERVICE_RELATIONSHIP.typeName, this.idToGUIDMap.getGUID(engineGUID + "_to_" + serviceGUID + "_" + requestType + "_supported_governance_service_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public String addGovernanceActionProcess(String typeName, String qualifiedName, String name, String versionIdentifier, String description, String formula, int domainIdentifier, Map<String, String> additionalProperties, Map<String, Object> extendedProperties, List<Classification> classifications) {
        Map<String, Object> processExtendedProperties;
        String processTypeName = "GovernanceActionProcess";
        if (typeName != null) {
            processTypeName = typeName;
        }
        if ((processExtendedProperties = extendedProperties) == null) {
            processExtendedProperties = new HashMap<String, Object>();
            processExtendedProperties.put("domainIdentifier", domainIdentifier);
        }
        return super.addProcess(processTypeName, qualifiedName, name, versionIdentifier, description, formula, additionalProperties, extendedProperties, classifications);
    }

    public String addGovernanceActionType(String typeName, String anchorGUID, String anchorTypeName, String anchorDomainName, String qualifiedName, String displayName, String description, int domainIdentifier, List<RequestParameterType> supportedRequestParameters, List<ActionTargetType> supportedActionTargets, List<AnalysisStepType> supportedAnalysisSteps, List<AnnotationTypeType> supportedAnnotationTypes, List<RequestParameterType> producedRequestParameters, List<ActionTargetType> producedActionTargets, List<GuardType> producedGuards, int waitTime, Map<String, String> additionalProperties, Map<String, Object> extendedProperties, List<Classification> classifications) {
        String methodName = "addGovernanceActionType";
        String actionTypeName = "GovernanceActionType";
        if (typeName != null) {
            actionTypeName = typeName;
        }
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName, "addGovernanceActionType");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DISPLAY_NAME.name, displayName, "addGovernanceActionType");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DESCRIPTION.name, description, "addGovernanceActionType");
        properties = this.archiveHelper.addIntPropertyToInstance(this.archiveRootName, properties, "domainIdentifier", domainIdentifier, "addGovernanceActionType");
        properties = this.archiveHelper.addIntPropertyToInstance(this.archiveRootName, properties, "waitTime", waitTime, "addGovernanceActionType");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, additionalProperties, "addGovernanceActionType");
        properties = this.archiveHelper.addPropertyMapToInstance(this.archiveRootName, properties, extendedProperties, "addGovernanceActionType");
        List<Classification> entityClassifications = classifications;
        if (anchorGUID != null) {
            if (entityClassifications == null) {
                entityClassifications = new ArrayList<Classification>();
            }
            entityClassifications.add(this.getAnchorClassification(anchorGUID, anchorTypeName, anchorDomainName, "addGovernanceActionType"));
        }
        EntityDetail assetEntity = this.archiveHelper.getEntityDetail(actionTypeName, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, entityClassifications);
        this.archiveBuilder.addEntity(assetEntity);
        this.addSupportedRequestParameters(assetEntity.getGUID(), actionTypeName, "GovernanceActionType", supportedRequestParameters);
        this.addSupportedActionTargets(assetEntity.getGUID(), actionTypeName, "GovernanceActionType", supportedActionTargets);
        this.addSupportedAnalysisSteps(assetEntity.getGUID(), actionTypeName, "GovernanceActionType", supportedAnalysisSteps);
        this.addProducedAnnotationTypes(assetEntity.getGUID(), actionTypeName, "GovernanceActionType", supportedAnnotationTypes);
        this.addProducedRequestParameters(assetEntity.getGUID(), actionTypeName, "GovernanceActionType", producedRequestParameters);
        this.addProducedActionTargets(assetEntity.getGUID(), actionTypeName, "GovernanceActionType", producedActionTargets);
        this.addProducedGuards(assetEntity.getGUID(), actionTypeName, "GovernanceActionType", producedGuards);
        return assetEntity.getGUID();
    }

    public String addGovernanceActionProcessStep(String typeName, String anchorGUID, String anchorTypeName, String anchorDomainName, String qualifiedName, String displayName, String description, int domainIdentifier, List<RequestParameterType> supportedRequestParameters, List<ActionTargetType> supportedActionTargets, List<AnalysisStepType> supportedAnalysisSteps, List<AnnotationTypeType> supportedAnnotationTypes, List<RequestParameterType> producedRequestParameters, List<ActionTargetType> producedActionTargets, List<GuardType> producedGuards, int waitTime, boolean ignoreMultipleTriggers, Map<String, String> additionalProperties, Map<String, Object> extendedProperties, List<Classification> classifications) {
        String methodName = "addGovernanceActionProcessStep";
        String actionTypeName = "GovernanceActionProcessStep";
        if (typeName != null) {
            actionTypeName = typeName;
        }
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName, "addGovernanceActionProcessStep");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DISPLAY_NAME.name, displayName, "addGovernanceActionProcessStep");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DESCRIPTION.name, description, "addGovernanceActionProcessStep");
        properties = this.archiveHelper.addIntPropertyToInstance(this.archiveRootName, properties, "domainIdentifier", domainIdentifier, "addGovernanceActionProcessStep");
        properties = this.archiveHelper.addIntPropertyToInstance(this.archiveRootName, properties, "waitTime", waitTime, "addGovernanceActionProcessStep");
        properties = this.archiveHelper.addBooleanPropertyToInstance(this.archiveRootName, properties, "ignoreMultipleTriggers", ignoreMultipleTriggers, "addGovernanceActionProcessStep");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, additionalProperties, "addGovernanceActionProcessStep");
        properties = this.archiveHelper.addPropertyMapToInstance(this.archiveRootName, properties, extendedProperties, "addGovernanceActionProcessStep");
        List<Classification> entityClassifications = classifications;
        if (anchorGUID != null) {
            if (entityClassifications == null) {
                entityClassifications = new ArrayList<Classification>();
            }
            entityClassifications.add(this.getAnchorClassification(anchorGUID, anchorTypeName, anchorDomainName, "addGovernanceActionProcessStep"));
        }
        EntityDetail assetEntity = this.archiveHelper.getEntityDetail(actionTypeName, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, entityClassifications);
        this.archiveBuilder.addEntity(assetEntity);
        this.addSupportedRequestParameters(assetEntity.getGUID(), actionTypeName, "GovernanceActionType", supportedRequestParameters);
        this.addSupportedActionTargets(assetEntity.getGUID(), actionTypeName, "GovernanceActionType", supportedActionTargets);
        this.addSupportedAnalysisSteps(assetEntity.getGUID(), actionTypeName, "GovernanceActionType", supportedAnalysisSteps);
        this.addProducedAnnotationTypes(assetEntity.getGUID(), actionTypeName, "GovernanceActionType", supportedAnnotationTypes);
        this.addProducedRequestParameters(assetEntity.getGUID(), actionTypeName, "GovernanceActionType", producedRequestParameters);
        this.addProducedActionTargets(assetEntity.getGUID(), actionTypeName, "GovernanceActionType", producedActionTargets);
        this.addProducedGuards(assetEntity.getGUID(), actionTypeName, "GovernanceActionType", producedGuards);
        return assetEntity.getGUID();
    }

    public void addGovernanceActionProcessFlow(String governanceActionProcessGUID, String guard, Map<String, String> requestParameters, String governanceActionProcessStepGUID) {
        String methodName = "addGovernanceActionFlow";
        EntityDetail processEntity = this.archiveBuilder.getEntity(governanceActionProcessGUID);
        EntityDetail actionTypeEntity = this.archiveBuilder.getEntity(governanceActionProcessStepGUID);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(processEntity);
        EntityProxy end2 = this.archiveHelper.getEntityProxy(actionTypeEntity);
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, "guard", guard, "addGovernanceActionFlow");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.REQUEST_PARAMETERS.name, requestParameters, "addGovernanceActionFlow");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship("GovernanceActionProcessFlow", this.idToGUIDMap.getGUID(governanceActionProcessGUID + "_to_" + governanceActionProcessStepGUID + "_governance_action_process_flow_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addNextGovernanceActionProcessStep(String governanceActionProcessStepGUID, String guard, boolean mandatoryGuard, String nextGovernanceActionTypeGUID) {
        String methodName = "addNextGovernanceActionProcessStep";
        EntityDetail actionTypeEntity = this.archiveBuilder.getEntity(governanceActionProcessStepGUID);
        EntityDetail nextActionTypeEntity = this.archiveBuilder.getEntity(nextGovernanceActionTypeGUID);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(actionTypeEntity);
        EntityProxy end2 = this.archiveHelper.getEntityProxy(nextActionTypeEntity);
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, "guard", guard, "addNextGovernanceActionProcessStep");
        properties = this.archiveHelper.addBooleanPropertyToInstance(this.archiveRootName, properties, "mandatoryGuard", mandatoryGuard, "addNextGovernanceActionProcessStep");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship("NextGovernanceActionProcessStep", this.idToGUIDMap.getGUID(governanceActionProcessStepGUID + "_to_" + nextGovernanceActionTypeGUID + "_next_governance_action_process_step_relationship_with_guard_" + guard), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addGovernanceActionExecutor(String governanceActionGUID, String requestType, Map<String, String> requestParameters, List<String> requestParameterFilter, Map<String, String> requestParameterMap, List<String> actionTargetFilter, Map<String, String> actionTargetMap, String governanceEngineGUID) {
        String methodName = "addGovernanceActionExecutor";
        EntityDetail actionTypeEntity = this.archiveBuilder.getEntity(governanceActionGUID);
        EntityDetail engineEntity = this.archiveBuilder.getEntity(governanceEngineGUID);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(actionTypeEntity);
        EntityProxy end2 = this.archiveHelper.getEntityProxy(engineEntity);
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.REQUEST_TYPE.name, requestType, "addGovernanceActionExecutor");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.REQUEST_PARAMETERS.name, requestParameters, "addGovernanceActionExecutor");
        properties = this.archiveHelper.addStringArrayPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.REQUEST_PARAMETER_FILTER.name, requestParameterFilter, "addGovernanceActionExecutor");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.REQUEST_PARAMETER_MAP.name, requestParameterMap, "addGovernanceActionExecutor");
        properties = this.archiveHelper.addStringArrayPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.ACTION_TARGET_FILTER.name, actionTargetFilter, "addGovernanceActionExecutor");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.ACTION_TARGET_MAP.name, actionTargetMap, "addGovernanceActionExecutor");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship("GovernanceActionExecutor", this.idToGUIDMap.getGUID(governanceActionGUID + "_to_" + governanceEngineGUID + "_governance_action_executor_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addTargetForActionType(String governanceActionTypeGUID, NewActionTarget actionTarget) {
        String methodName = "addTargetForActionType";
        EntityDetail actionTypeEntity = this.archiveBuilder.getEntity(governanceActionTypeGUID);
        EntityDetail targetEntity = this.archiveBuilder.getEntity(actionTarget.getActionTargetGUID());
        EntityProxy end1 = this.archiveHelper.getEntityProxy(actionTypeEntity);
        EntityProxy end2 = this.archiveHelper.getEntityProxy(targetEntity);
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.ACTION_TARGET_NAME.name, actionTarget.getActionTargetName(), "addTargetForActionType");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(OpenMetadataType.TARGET_FOR_ACTION_TYPE.typeName, this.idToGUIDMap.getGUID(governanceActionTypeGUID + "_to_" + actionTarget.getActionTargetGUID() + "_target_for_action_type_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addTargetForActionProcess(String governanceActionProcessGUID, NewActionTarget actionTarget) {
        String methodName = "addTargetForActionProcess";
        EntityDetail actionTypeEntity = this.archiveBuilder.getEntity(governanceActionProcessGUID);
        EntityDetail targetEntity = this.archiveBuilder.getEntity(actionTarget.getActionTargetGUID());
        EntityProxy end1 = this.archiveHelper.getEntityProxy(actionTypeEntity);
        EntityProxy end2 = this.archiveHelper.getEntityProxy(targetEntity);
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.ACTION_TARGET_NAME.name, actionTarget.getActionTargetName(), "addTargetForActionProcess");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(OpenMetadataType.TARGET_FOR_ACTION_PROCESS.typeName, this.idToGUIDMap.getGUID(governanceActionProcessGUID + "_to_" + actionTarget.getActionTargetGUID() + "_target_for_action_process_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addApprovedPurpose(String referenceableGUID, String dataProcessingPurposeGUID) {
        EntityDetail referenceableEntity = this.archiveBuilder.getEntity(referenceableGUID);
        EntityDetail purposeEntity = this.archiveBuilder.getEntity(dataProcessingPurposeGUID);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(referenceableEntity);
        EntityProxy end2 = this.archiveHelper.getEntityProxy(purposeEntity);
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(OpenMetadataType.APPROVED_PURPOSE_RELATIONSHIP.typeName, this.idToGUIDMap.getGUID(referenceableGUID + "_to_" + dataProcessingPurposeGUID + "_approved_purpose_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
    }
}

