/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.archiveconnector.file;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.odpi.openmetadata.adapters.repositoryservices.archiveconnector.file.ffdc.FileBasedOpenMetadataArchiveStoreConnectorAuditCode;
import org.odpi.openmetadata.adapters.repositoryservices.archiveconnector.file.ffdc.FileBasedOpenMetadataArchiveStoreConnectorErrorCode;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectionDetails;
import org.odpi.openmetadata.frameworks.connectors.properties.EndpointDetails;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.OpenMetadataArchiveStoreConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBasedOpenMetadataArchiveStoreConnector
extends OpenMetadataArchiveStoreConnector {
    private static final String defaultFilename = "open.metadata.omarchive";
    private String archiveStoreName = null;
    private static final Logger log = LoggerFactory.getLogger(FileBasedOpenMetadataArchiveStoreConnector.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final ObjectWriter OBJECT_WRITER = OBJECT_MAPPER.writer();
    private static final ObjectReader OBJECT_READER = OBJECT_MAPPER.reader();

    @Override
    public void initialize(String connectorInstanceId, ConnectionDetails connectionDetails) {
        super.initialize(connectorInstanceId, connectionDetails);
        EndpointDetails endpoint = connectionDetails.getEndpoint();
        if (endpoint != null) {
            this.archiveStoreName = endpoint.getAddress();
        }
        if (this.archiveStoreName == null) {
            this.archiveStoreName = defaultFilename;
        }
    }

    @Override
    public OpenMetadataArchive getArchiveContents() throws RepositoryErrorException {
        OpenMetadataArchive newOpenMetadataArchive;
        String methodName = "getArchiveContents";
        File archiveStoreFile = new File(this.archiveStoreName);
        try {
            log.debug("Retrieving open metadata archive from file");
            if (this.auditLog != null) {
                String actionDescription = "Opening open metadata archive";
                this.auditLog.logMessage("Opening open metadata archive", FileBasedOpenMetadataArchiveStoreConnectorAuditCode.OPENING_FILE.getMessageDefinition(this.archiveStoreName));
            }
            String configStoreFileContents = FileUtils.readFileToString(archiveStoreFile, "UTF-8");
            newOpenMetadataArchive = OBJECT_READER.readValue(configStoreFileContents, OpenMetadataArchive.class);
        }
        catch (IOException ioException) {
            if (this.auditLog != null) {
                this.auditLog.logException("getArchiveContents", FileBasedOpenMetadataArchiveStoreConnectorAuditCode.BAD_FILE.getMessageDefinition(this.archiveStoreName, ioException.getClass().getName(), ioException.getMessage()), ioException);
            }
            log.error("Error opening archive", ioException);
            throw new RepositoryErrorException(FileBasedOpenMetadataArchiveStoreConnectorErrorCode.BAD_FILE.getMessageDefinition(this.archiveStoreName, ioException.getClass().getName(), ioException.getMessage()), this.getClass().getName(), "getArchiveContents");
        }
        return newOpenMetadataArchive;
    }

    @Override
    public void setArchiveContents(OpenMetadataArchive archiveContents) {
        File archiveStoreFile = new File(this.archiveStoreName);
        try {
            log.debug("Writing open metadata archive store properties: " + String.valueOf(archiveContents));
            if (archiveContents == null) {
                archiveStoreFile.delete();
            } else {
                String archiveStoreFileContents = OBJECT_WRITER.writeValueAsString(archiveContents);
                FileUtils.writeStringToFile(archiveStoreFile, archiveStoreFileContents, (String)null, false);
            }
        }
        catch (IOException ioException) {
            log.debug("Unusable Server config Store :(", ioException);
        }
    }

    @Override
    public void start() throws ConnectorCheckedException {
        super.start();
    }

    @Override
    public void disconnect() throws ConnectorCheckedException {
        super.disconnect();
        log.debug("Closing Config Store.");
    }
}

