/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.jar.JarFile;

public class IsolatedConnectorClassLoader
extends URLClassLoader {
    private final ClassLoader defaultClassLoader;
    private final JarFile jarfile;
    private final String jarFileName;
    private final String jarFileSpec;

    public IsolatedConnectorClassLoader(String jarFileName) throws IOException {
        this(jarFileName, Thread.currentThread().getContextClassLoader().getParent(), Thread.currentThread().getContextClassLoader());
    }

    protected IsolatedConnectorClassLoader(String jarFileName, ClassLoader jdkClassLoader, ClassLoader defaultClassLoader) throws IOException {
        super(new URL[0], jdkClassLoader);
        this.defaultClassLoader = defaultClassLoader;
        this.jarFileName = jarFileName;
        this.jarfile = new JarFile(jarFileName);
        super.addURL(new File(jarFileName).toURI().toURL());
        this.jarFileSpec = "jar:file:" + jarFileName + "!/";
        super.addURL(new URL(this.jarFileSpec));
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        try {
            return super.findClass(name);
        }
        catch (ClassNotFoundException notFound) {
            return this.defaultClassLoader.loadClass(name);
        }
    }
}

