/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties;

import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetPropertyElementBase;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectionDetails;
import org.odpi.openmetadata.frameworks.connectors.properties.VirtualConnectionDetails;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.EmbeddedConnection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.VirtualConnection;

public class EmbeddedConnectionDetails
extends AssetPropertyElementBase {
    protected EmbeddedConnection embeddedConnectionBean;

    public EmbeddedConnectionDetails(EmbeddedConnection embeddedConnectionBean) {
        this.embeddedConnectionBean = embeddedConnectionBean == null ? new EmbeddedConnection() : embeddedConnectionBean;
    }

    public EmbeddedConnectionDetails(EmbeddedConnectionDetails template) {
        super(template);
        this.embeddedConnectionBean = template == null ? new EmbeddedConnection() : template.getEmbeddedConnectionBean();
    }

    protected EmbeddedConnection getEmbeddedConnectionBean() {
        return this.embeddedConnectionBean;
    }

    public int getPosition() {
        return this.embeddedConnectionBean.getPosition();
    }

    public String getDisplayName() {
        return this.embeddedConnectionBean.getDisplayName();
    }

    public ConnectionDetails getConnectionProperties() {
        Connection embeddedConnection = this.embeddedConnectionBean.getEmbeddedConnection();
        if (embeddedConnection == null) {
            return null;
        }
        if (embeddedConnection instanceof VirtualConnection) {
            VirtualConnection virtualConnection = (VirtualConnection)embeddedConnection;
            return new VirtualConnectionDetails(virtualConnection);
        }
        return new ConnectionDetails(embeddedConnection);
    }

    public Map<String, Object> getArguments() {
        return this.embeddedConnectionBean.getArguments();
    }

    public String toString() {
        return this.embeddedConnectionBean.toString();
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof EmbeddedConnectionDetails)) {
            return false;
        }
        EmbeddedConnectionDetails that = (EmbeddedConnectionDetails)objectToCompare;
        if (!super.equals(objectToCompare)) {
            return false;
        }
        return Objects.equals(this.getEmbeddedConnectionBean(), that.getEmbeddedConnectionBean());
    }

    @Override
    public int hashCode() {
        return this.embeddedConnectionBean.hashCode();
    }
}

