/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectionDetails;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectorTypeDetails;
import org.odpi.openmetadata.frameworks.connectors.properties.EmbeddedConnectionDetails;
import org.odpi.openmetadata.frameworks.connectors.properties.EndpointDetails;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ConnectorType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.EmbeddedConnection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Endpoint;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.VirtualConnection;

public class VirtualConnectionDetails
extends ConnectionDetails {
    protected VirtualConnection connectionBean;

    public VirtualConnectionDetails(VirtualConnection connectionBean) {
        super(connectionBean);
        this.connectionBean = connectionBean == null ? new VirtualConnection() : connectionBean;
    }

    public VirtualConnectionDetails(VirtualConnectionDetails templateConnection) {
        super(templateConnection);
        this.connectionBean = templateConnection == null ? new VirtualConnection() : new VirtualConnection(templateConnection.getConnectionBean());
    }

    @Override
    protected VirtualConnection getConnectionBean() {
        return this.connectionBean;
    }

    public List<EmbeddedConnectionDetails> getEmbeddedConnections() {
        List<EmbeddedConnection> embeddedConnectionBeans = this.connectionBean.getEmbeddedConnections();
        if (embeddedConnectionBeans == null) {
            return null;
        }
        ArrayList<EmbeddedConnectionDetails> embeddedConnectionDetailsList = new ArrayList<EmbeddedConnectionDetails>();
        for (EmbeddedConnection embeddedConnectionBean : embeddedConnectionBeans) {
            embeddedConnectionDetailsList.add(new EmbeddedConnectionDetails(embeddedConnectionBean));
        }
        return embeddedConnectionDetailsList;
    }

    @Override
    public String getConnectionName() {
        String connectionName = "<Unknown>";
        String qualifiedName = this.connectionBean.getQualifiedName();
        String displayName = this.connectionBean.getDisplayName();
        if (qualifiedName != null && !qualifiedName.isEmpty()) {
            connectionName = qualifiedName;
        } else if (displayName != null && !displayName.isEmpty()) {
            connectionName = displayName;
        }
        return connectionName;
    }

    @Override
    public String getDescription() {
        return this.connectionBean.getDescription();
    }

    @Override
    public ConnectorTypeDetails getConnectorType() {
        ConnectorType connectorType = this.connectionBean.getConnectorType();
        if (connectorType == null) {
            return null;
        }
        return new ConnectorTypeDetails(connectorType);
    }

    @Override
    public EndpointDetails getEndpoint() {
        Endpoint endpoint = this.connectionBean.getEndpoint();
        if (endpoint == null) {
            return null;
        }
        return new EndpointDetails(endpoint);
    }

    @Override
    public Map<String, String> getSecuredProperties() {
        return this.connectionBean.getSecuredProperties();
    }

    @Override
    public String toString() {
        return this.connectionBean.toString();
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        VirtualConnectionDetails that = (VirtualConnectionDetails)objectToCompare;
        return Objects.equals(this.getConnectionBean(), that.getConnectionBean());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getConnectionBean());
    }
}

