/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties.beans;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Date;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Referenceable;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Note
extends Referenceable {
    protected String text = null;
    protected Date lastUpdate = null;
    protected String user = null;

    public Note() {
    }

    public Note(Note templateNote) {
        super(templateNote);
        if (templateNote != null) {
            this.text = templateNote.getText();
            this.user = templateNote.getUser();
            Date templateLastUpdate = templateNote.getLastUpdate();
            if (templateLastUpdate != null) {
                this.lastUpdate = new Date(templateLastUpdate.getTime());
            }
        }
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Date getLastUpdate() {
        if (this.lastUpdate == null) {
            return this.lastUpdate;
        }
        return new Date(this.lastUpdate.getTime());
    }

    public void setLastUpdate(Date lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    @Override
    public String toString() {
        return "Note{extendedProperties=" + String.valueOf(this.getExtendedProperties()) + ", status=" + String.valueOf(this.getStatus()) + ", type=" + String.valueOf(this.getType()) + ", origin=" + String.valueOf(this.getOrigin()) + ", versions=" + String.valueOf(this.getVersions()) + ", GUID='" + this.getGUID() + "', classifications=" + String.valueOf(this.getClassifications()) + ", text='" + this.text + "', lastUpdate=" + String.valueOf(this.lastUpdate) + ", user='" + this.user + "', headerVersion=" + this.getHeaderVersion() + ", qualifiedName='" + this.getQualifiedName() + "', additionalProperties=" + String.valueOf(this.getAdditionalProperties()) + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        Note note = (Note)objectToCompare;
        return Objects.equals(this.getText(), note.getText()) && Objects.equals(this.getLastUpdate(), note.getLastUpdate()) && Objects.equals(this.getUser(), note.getUser());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getText(), this.getLastUpdate(), this.getUser());
    }
}

