/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties.beans;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.GovernedReferenceable;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaAttribute;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaType;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="class")
@JsonSubTypes(value={@JsonSubTypes.Type(value=SchemaAttribute.class, name="SchemaAttribute"), @JsonSubTypes.Type(value=SchemaType.class, name="SchemaType")})
public abstract class SchemaElement
extends GovernedReferenceable {
    protected boolean isDeprecated = false;
    protected String displayName = null;
    protected String description = null;
    protected boolean isCalculatedValue = false;
    protected String expression = null;
    protected String expressionType = null;

    public SchemaElement() {
    }

    public SchemaElement(SchemaElement template) {
        super(template);
        if (template != null) {
            this.isDeprecated = template.getIsDeprecated();
            this.displayName = template.getDisplayName();
            this.description = template.getDescription();
            this.isCalculatedValue = template.getIsCalculatedValue();
            this.expression = template.getExpression();
            this.expression = template.getExpressionType();
        }
    }

    public boolean getIsDeprecated() {
        return this.isDeprecated;
    }

    public void setIsDeprecated(boolean deprecated) {
        this.isDeprecated = deprecated;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String name) {
        this.displayName = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean getIsCalculatedValue() {
        return this.isCalculatedValue;
    }

    public void setIsCalculatedValue(boolean calculatedValue) {
        this.isCalculatedValue = calculatedValue;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getExpressionType() {
        return this.expressionType;
    }

    public void setExpressionType(String expressionType) {
        this.expressionType = expressionType;
    }

    public abstract SchemaElement cloneSchemaElement();

    @Override
    public String toString() {
        return "SchemaElement{isDeprecated=" + this.isDeprecated + ", displayName='" + this.displayName + "', description='" + this.description + "', isCalculatedValue=" + this.isCalculatedValue + ", expression='" + this.expression + "', expressionType='" + this.expressionType + "', qualifiedName='" + this.getQualifiedName() + "', additionalProperties=" + String.valueOf(this.getAdditionalProperties()) + ", meanings=" + String.valueOf(this.getMeanings()) + ", searchKeywords=" + String.valueOf(this.getSearchKeywords()) + ", type=" + String.valueOf(this.getType()) + ", GUID='" + this.getGUID() + "', classifications=" + String.valueOf(this.getClassifications()) + ", extendedProperties=" + String.valueOf(this.getExtendedProperties()) + ", headerVersion=" + this.getHeaderVersion() + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        SchemaElement that = (SchemaElement)objectToCompare;
        return this.isDeprecated == that.isDeprecated && this.isCalculatedValue == that.isCalculatedValue && Objects.equals(this.displayName, that.displayName) && Objects.equals(this.description, that.description) && Objects.equals(this.expression, that.expression) && Objects.equals(this.expressionType, that.expressionType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.isDeprecated, this.displayName, this.description, this.expression, this.expressionType);
    }
}

