/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.governanceaction;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.AuditLoggingComponent;
import org.odpi.openmetadata.frameworks.auditlog.ComponentDescription;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.governanceaction.GovernanceActionContext;
import org.odpi.openmetadata.frameworks.governanceaction.GovernanceActionService;
import org.odpi.openmetadata.frameworks.governanceaction.GovernanceContext;
import org.odpi.openmetadata.frameworks.governanceaction.ffdc.GAFErrorCode;
import org.odpi.openmetadata.frameworks.governanceaction.ffdc.GovernanceServiceException;
import org.odpi.openmetadata.frameworks.openmetadata.search.PropertyHelper;

public abstract class GovernanceActionServiceConnector
extends ConnectorBase
implements GovernanceActionService,
AuditLoggingComponent {
    protected String governanceServiceName = "<Unknown>";
    protected AuditLog auditLog = null;
    protected PropertyHelper propertyHelper = new PropertyHelper();

    @Override
    public void setAuditLog(AuditLog auditLog) {
        this.auditLog = auditLog;
    }

    @Override
    public ComponentDescription getConnectorComponentDescription() {
        if (this.auditLog != null && this.auditLog.getReport() != null) {
            return this.auditLog.getReport().getReportingComponent();
        }
        return null;
    }

    public void setGovernanceServiceName(String governanceServiceName) {
        this.governanceServiceName = governanceServiceName;
    }

    protected void handleUnexpectedException(String methodName, Throwable error) throws ConnectorCheckedException {
        throw new GovernanceServiceException(GAFErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.governanceServiceName, error.getClass().getName(), methodName, error.getMessage()), this.getClass().getName(), methodName);
    }

    public abstract void setGovernanceContext(GovernanceActionContext var1);

    public void validateContext(GovernanceContext governanceContext) throws ConnectorCheckedException {
        String methodName = "start";
        if (governanceContext == null) {
            throw new GovernanceServiceException(GAFErrorCode.NULL_GOVERNANCE_CONTEXT.getMessageDefinition(this.governanceServiceName), this.getClass().getName(), "start");
        }
    }

    protected List<String> getArrayRequestParameter(String propertyName, Map<String, String> requestParameters, List<String> defaultValue) {
        if (requestParameters != null && requestParameters.containsKey(propertyName)) {
            String arrayOption = requestParameters.get(propertyName);
            String[] options = arrayOption.toString().split(",");
            return new ArrayList<String>(Arrays.asList(options));
        }
        return defaultValue;
    }

    protected boolean getBooleanRequestParameter(String propertyName, Map<String, String> requestParameters) {
        if (requestParameters != null && requestParameters.containsKey(propertyName)) {
            String booleanOption = requestParameters.get(propertyName);
            return !"FALSE".equals(booleanOption) && !"false".equals(booleanOption) && !"False".equals(booleanOption);
        }
        return false;
    }

    protected int getIntRequestParameter(String propertyName, Map<String, String> requestParameters) {
        String integerOption;
        if (requestParameters != null && requestParameters.get(propertyName) != null && (integerOption = requestParameters.get(propertyName)) != null) {
            return Integer.parseInt(integerOption);
        }
        return 0;
    }

    protected long getLongRequestParameter(String propertyName, Map<String, String> requestParameters) {
        String integerOption;
        if (requestParameters != null && requestParameters.get(propertyName) != null && (integerOption = requestParameters.get(propertyName)) != null) {
            return Long.parseLong(integerOption);
        }
        return 0L;
    }

    protected String getStringRequestParameter(String propertyName, Map<String, String> requestParameters) {
        if (requestParameters != null && requestParameters.get(propertyName) != null) {
            return requestParameters.get(propertyName);
        }
        return null;
    }

    @Override
    public void disconnect() throws ConnectorCheckedException {
        super.disconnectConnectors(this.embeddedConnectors);
        super.disconnect();
    }
}

