/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.integration.context;

import java.util.List;
import org.odpi.openmetadata.frameworks.openmetadata.client.OpenMetadataClient;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.properties.TranslationDetail;

public class MultiLanguageManagement {
    private final OpenMetadataClient openMetadataStore;
    private final String userId;

    public MultiLanguageManagement(OpenMetadataClient openMetadataStore, String userId) {
        this.openMetadataStore = openMetadataStore;
        this.userId = userId;
    }

    public void setTranslation(String elementGUID, TranslationDetail translationDetail) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openMetadataStore.setTranslation(this.userId, elementGUID, translationDetail);
    }

    public void clearTranslation(String elementGUID, String language, String locale) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openMetadataStore.clearTranslation(this.userId, elementGUID, language, locale);
    }

    public TranslationDetail getTranslation(String elementGUID, String language, String locale) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataStore.getTranslation(this.userId, elementGUID, language, locale);
    }

    public List<TranslationDetail> getTranslations(String elementGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataStore.getTranslations(this.userId, elementGUID, startFrom, pageSize);
    }
}

