/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.integration.iterator;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.integration.ffdc.OIFAuditCode;
import org.odpi.openmetadata.frameworks.integration.iterator.MemberAction;
import org.odpi.openmetadata.frameworks.openmetadata.enums.PermittedSynchronization;
import org.odpi.openmetadata.frameworks.openmetadata.properties.MetadataCorrelationHeader;
import org.odpi.openmetadata.frameworks.openmetadata.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.RelatedMetadataElement;

public class MemberElement {
    private final OpenMetadataElement element;
    private final RelatedMetadataElement rootSchemaType;
    private MetadataCorrelationHeader externalIdentifier = null;
    private final Map<String, Map<String, String>> vendorProperties;
    private final String catalogTargetName;
    private final String connectorName;
    private final boolean isElementActive;
    private final PermittedSynchronization targetPermittedSynchronization;
    private final AuditLog auditLog;
    private PermittedSynchronization instanceSyncDirection = null;

    MemberElement(OpenMetadataElement element, RelatedMetadataElement rootSchemaType, List<MetadataCorrelationHeader> externalIdentifiers, String externalScopeGUID, Map<String, Map<String, String>> vendorProperties, boolean isElementActive, String catalogTargetName, String connectorName, PermittedSynchronization targetPermittedSynchronization, AuditLog auditLog) {
        this.element = element;
        this.rootSchemaType = rootSchemaType;
        this.vendorProperties = vendorProperties;
        this.isElementActive = isElementActive;
        this.catalogTargetName = catalogTargetName;
        this.connectorName = connectorName;
        this.targetPermittedSynchronization = targetPermittedSynchronization;
        this.auditLog = auditLog;
        if (element == null) {
            this.instanceSyncDirection = PermittedSynchronization.FROM_THIRD_PARTY;
        }
        if (externalIdentifiers != null && externalScopeGUID != null) {
            for (MetadataCorrelationHeader externalIdentifier : externalIdentifiers) {
                if (externalIdentifier == null || !externalScopeGUID.equals(externalIdentifier.getExternalScopeGUID())) continue;
                this.externalIdentifier = externalIdentifier;
                if (externalIdentifier.getSynchronizationDirection() == null) continue;
                this.instanceSyncDirection = externalIdentifier.getSynchronizationDirection();
            }
        }
        if (this.instanceSyncDirection == null) {
            this.instanceSyncDirection = targetPermittedSynchronization;
        }
    }

    public OpenMetadataElement getElement() {
        return this.element;
    }

    public RelatedMetadataElement getRootSchemaType() {
        return this.rootSchemaType;
    }

    public MetadataCorrelationHeader getExternalIdentifier() {
        return this.externalIdentifier;
    }

    public Map<String, String> getVendorProperties(String vendorIdentifier) {
        return this.vendorProperties.get(vendorIdentifier);
    }

    public MemberAction getMemberAction(Date thirdPartyElementCreationTime, Date thirdPartyElementLastUpdateTime) {
        String methodName = "getMemberAction";
        if (this.element != null) {
            if (this.isElementActive) {
                if (thirdPartyElementCreationTime == null) {
                    if (this.externalIdentifier == null) {
                        if (this.targetPermittedSynchronization == PermittedSynchronization.BOTH_DIRECTIONS || this.targetPermittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
                            return MemberAction.CREATE_INSTANCE_IN_THIRD_PARTY;
                        }
                        if (this.targetPermittedSynchronization == PermittedSynchronization.FROM_THIRD_PARTY) {
                            this.auditLog.logMessage("getMemberAction", OIFAuditCode.IGNORED_EGERIA_ELEMENT.getMessageDefinition(this.connectorName, this.element.getType().getTypeName(), this.element.getElementGUID(), this.element.getOrigin().getHomeMetadataCollectionName(), this.element.getOrigin().getHomeMetadataCollectionId(), this.catalogTargetName, this.targetPermittedSynchronization.getName()));
                            return MemberAction.NO_ACTION;
                        }
                    } else if (this.instanceSyncDirection != null) {
                        if (this.instanceSyncDirection == PermittedSynchronization.BOTH_DIRECTIONS || this.instanceSyncDirection == PermittedSynchronization.FROM_THIRD_PARTY) {
                            return MemberAction.DELETE_INSTANCE_IN_OPEN_METADATA;
                        }
                        if (this.instanceSyncDirection == PermittedSynchronization.TO_THIRD_PARTY) {
                            return MemberAction.CREATE_INSTANCE_IN_THIRD_PARTY;
                        }
                    }
                } else {
                    DateComparison dateComparison = this.compareAges(thirdPartyElementCreationTime, thirdPartyElementLastUpdateTime);
                    if (dateComparison == DateComparison.DATES_EQUAL) {
                        return MemberAction.NO_ACTION;
                    }
                    if (dateComparison == DateComparison.EGERIA_COPY_NEWEST) {
                        if (this.instanceSyncDirection == PermittedSynchronization.FROM_THIRD_PARTY) {
                            return MemberAction.UPDATE_INSTANCE_IN_OPEN_METADATA;
                        }
                        if (this.instanceSyncDirection == PermittedSynchronization.BOTH_DIRECTIONS || this.instanceSyncDirection == PermittedSynchronization.TO_THIRD_PARTY) {
                            return MemberAction.UPDATE_INSTANCE_IN_THIRD_PARTY;
                        }
                    }
                    if (dateComparison == DateComparison.THIRD_PARTY_COPY_NEWEST) {
                        if (this.instanceSyncDirection == PermittedSynchronization.TO_THIRD_PARTY) {
                            return MemberAction.UPDATE_INSTANCE_IN_THIRD_PARTY;
                        }
                        if (this.instanceSyncDirection == PermittedSynchronization.BOTH_DIRECTIONS || this.instanceSyncDirection == PermittedSynchronization.FROM_THIRD_PARTY) {
                            return MemberAction.UPDATE_INSTANCE_IN_OPEN_METADATA;
                        }
                    }
                }
            } else {
                if (this.targetPermittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
                    return MemberAction.DELETE_INSTANCE_IN_THIRD_PARTY;
                }
                if (this.targetPermittedSynchronization == PermittedSynchronization.FROM_THIRD_PARTY) {
                    return MemberAction.CREATE_INSTANCE_IN_OPEN_METADATA;
                }
                if (this.targetPermittedSynchronization == PermittedSynchronization.BOTH_DIRECTIONS) {
                    DateComparison dateComparison = this.compareAges(thirdPartyElementCreationTime, thirdPartyElementLastUpdateTime);
                    if (dateComparison == DateComparison.EGERIA_COPY_NEWEST || dateComparison == DateComparison.DATES_EQUAL) {
                        return MemberAction.DELETE_INSTANCE_IN_THIRD_PARTY;
                    }
                    if (dateComparison == DateComparison.THIRD_PARTY_COPY_NEWEST) {
                        return MemberAction.CREATE_INSTANCE_IN_OPEN_METADATA;
                    }
                }
            }
        } else {
            return MemberAction.CREATE_INSTANCE_IN_OPEN_METADATA;
        }
        this.auditLog.logMessage("getMemberAction", OIFAuditCode.UNKNOWN_ACTION.getMessageDefinition(this.connectorName, this.toString()));
        return MemberAction.UNKNOWN_ACTION;
    }

    private Date getLastChangeToElement(Date createTime, Date lastUpdateTime) {
        Date lastChange = lastUpdateTime;
        if (lastChange == null) {
            lastChange = createTime;
        }
        assert (lastChange != null);
        return lastChange;
    }

    private DateComparison compareAges(Date thirdPartyElementCreationTime, Date thirdPartyElementLastUpdateTime) {
        Date elementComparisonDate = this.getLastChangeToElement(this.element.getVersions().getCreateTime(), this.element.getVersions().getUpdateTime());
        Date thirdPartyComparisonDate = this.getLastChangeToElement(thirdPartyElementCreationTime, thirdPartyElementLastUpdateTime);
        if (thirdPartyComparisonDate.after(elementComparisonDate)) {
            if (this.externalIdentifier != null) {
                if (this.externalIdentifier.getLastSynchronized() != null && thirdPartyComparisonDate.after(this.externalIdentifier.getLastSynchronized())) {
                    return DateComparison.THIRD_PARTY_COPY_NEWEST;
                }
                return DateComparison.DATES_EQUAL;
            }
            return DateComparison.THIRD_PARTY_COPY_NEWEST;
        }
        if (elementComparisonDate.after(thirdPartyComparisonDate)) {
            if (this.externalIdentifier != null) {
                if (this.externalIdentifier.getLastSynchronized() != null && this.externalIdentifier.getLastSynchronized().before(elementComparisonDate)) {
                    return DateComparison.EGERIA_COPY_NEWEST;
                }
                return DateComparison.DATES_EQUAL;
            }
            return DateComparison.EGERIA_COPY_NEWEST;
        }
        return DateComparison.DATES_EQUAL;
    }

    public String toString() {
        String elementGUID = "null";
        if (this.element != null) {
            elementGUID = this.element.getElementGUID();
        }
        return "MemberElement{element=" + elementGUID + "externalIdentifiers=" + String.valueOf(this.externalIdentifier) + ", catalogTargetName='" + this.catalogTargetName + "', isElementActive=" + this.isElementActive + ", targetPermittedSynchronization=" + String.valueOf(this.targetPermittedSynchronization) + ", auditLog=" + String.valueOf(this.auditLog) + ", instanceSyncDirection=" + String.valueOf(this.instanceSyncDirection) + "}";
    }

    static enum DateComparison {
        EGERIA_COPY_NEWEST,
        DATES_EQUAL,
        THIRD_PARTY_COPY_NEWEST;

    }
}

