/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.converters;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import org.odpi.openmetadata.frameworks.openmetadata.converters.OpenMetadataConverterBase;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.CollectionElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.OpenMetadataRelationship;
import org.odpi.openmetadata.frameworks.openmetadata.properties.RelatedMetadataElement;
import org.odpi.openmetadata.frameworks.openmetadata.search.PropertyHelper;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;

public class CollectionConverter<B>
extends OpenMetadataConverterBase<B> {
    public CollectionConverter(PropertyHelper propertyHelper, String serviceName, String serverName) {
        super(propertyHelper, serviceName, serverName);
    }

    @Override
    public B getNewBean(Class<B> beanClass, OpenMetadataElement openMetadataElement, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof CollectionElement) {
                CollectionElement bean = (CollectionElement)returnBean;
                if (openMetadataElement != null) {
                    bean.setElementHeader(super.getMetadataElementHeader(beanClass, openMetadataElement, methodName));
                    bean.setProperties(super.getCollectionProperties(openMetadataElement));
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), OpenMetadataElement.class.getName(), methodName);
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    @Override
    public B getNewBean(Class<B> beanClass, RelatedMetadataElement relatedMetadataElement, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof CollectionElement) {
                CollectionElement bean = (CollectionElement)returnBean;
                if (relatedMetadataElement != null) {
                    bean.setElementHeader(super.getMetadataElementHeader(beanClass, relatedMetadataElement.getElement(), methodName));
                    bean.setProperties(super.getCollectionProperties(relatedMetadataElement.getElement()));
                    bean.setRelatedBy(super.getRelatedBy(beanClass, relatedMetadataElement, methodName));
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), OpenMetadataElement.class.getName(), methodName);
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    @Override
    public B getNewBean(Class<B> beanClass, OpenMetadataElement element, OpenMetadataRelationship relationship, String methodName) throws PropertyServerException {
        B returnBean = this.getNewBean(beanClass, element, methodName);
        if (returnBean instanceof CollectionElement) {
            CollectionElement bean = (CollectionElement)returnBean;
            bean.setRelatedBy(super.getRelatedBy(beanClass, relationship, methodName));
        }
        return returnBean;
    }

    @Override
    public B getNewComplexBean(Class<B> beanClass, OpenMetadataElement primaryElement, List<RelatedMetadataElement> relationships, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof CollectionElement) {
                CollectionElement bean = (CollectionElement)returnBean;
                if (primaryElement != null) {
                    bean.setElementHeader(super.getMetadataElementHeader(beanClass, primaryElement, methodName));
                    bean.setProperties(this.getCollectionProperties(primaryElement));
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), OpenMetadataElement.class.getName(), methodName);
                }
                if (relationships != null) {
                    bean.setExternalReferences(this.getAttribution(beanClass, relationships));
                    bean.setOtherRelatedElements(this.getOtherRelatedElements(beanClass, relationships, Collections.singletonList(OpenMetadataType.EXTERNAL_REFERENCE_LINK_RELATIONSHIP.typeName)));
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }
}

