/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.converters;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.frameworks.openmetadata.converters.ProjectConverter;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ProjectElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ProjectHierarchy;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.RelatedMetadataElementSummary;
import org.odpi.openmetadata.frameworks.openmetadata.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.RelatedMetadataElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.projects.ProjectProperties;
import org.odpi.openmetadata.frameworks.openmetadata.search.ElementProperties;
import org.odpi.openmetadata.frameworks.openmetadata.search.PropertyHelper;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;

public class ProjectHierarchyConverter<B>
extends ProjectConverter<B> {
    private final List<ProjectHierarchy> children;

    public ProjectHierarchyConverter(PropertyHelper propertyHelper, String serviceName, String serverName, List<ProjectHierarchy> children) {
        super(propertyHelper, serviceName, serverName);
        this.children = children;
    }

    @Override
    public B getNewComplexBean(Class<B> beanClass, OpenMetadataElement primaryElement, List<RelatedMetadataElement> relationships, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof ProjectHierarchy) {
                ProjectHierarchy bean = (ProjectHierarchy)returnBean;
                bean.setElementHeader(super.getMetadataElementHeader(beanClass, primaryElement, methodName));
                if (primaryElement == null) {
                    this.handleMissingMetadataInstance(beanClass.getName(), OpenMetadataElement.class.getName(), methodName);
                } else {
                    bean.setProperties(this.getProjectProperties(primaryElement));
                    bean.setResourceList(this.getResourceList(beanClass, relationships));
                    bean.setProjectManagers(this.getProjectManagers(beanClass, relationships));
                    bean.setProjectTeam(this.getProjectTeam(beanClass, relationships));
                    bean.setChildren(this.children);
                    bean.setDependentProjects(this.getDependentProjects(beanClass, relationships));
                    bean.setDependsOnProjects(this.getDependsOnProjects(beanClass, relationships));
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    @Override
    public B getNewComplexBean(Class<B> beanClass, RelatedMetadataElement primaryElement, List<RelatedMetadataElement> relationships, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof ProjectElement) {
                ProjectElement bean = (ProjectElement)returnBean;
                ProjectProperties projectProperties = new ProjectProperties();
                OpenMetadataElement openMetadataElement = primaryElement.getElement();
                bean.setElementHeader(super.getMetadataElementHeader(beanClass, openMetadataElement, methodName));
                if (openMetadataElement != null) {
                    ElementProperties elementProperties = new ElementProperties(openMetadataElement.getElementProperties());
                    projectProperties.setQualifiedName(this.removeQualifiedName(elementProperties));
                    projectProperties.setAdditionalProperties(this.removeAdditionalProperties(elementProperties));
                    projectProperties.setIdentifier(this.removeIdentifier(elementProperties));
                    projectProperties.setName(this.removeName(elementProperties));
                    projectProperties.setDescription(this.removeDescription(elementProperties));
                    projectProperties.setProjectStatus(this.removeProjectStatus(elementProperties));
                    projectProperties.setProjectHealth(this.removeProjectHealth(elementProperties));
                    projectProperties.setProjectPhase(this.removeProjectPhase(elementProperties));
                    projectProperties.setPriority(this.removeIntPriority(elementProperties));
                    projectProperties.setStartDate(this.removeStartDate(elementProperties));
                    projectProperties.setPlannedEndDate(this.removePlannedEndDate(elementProperties));
                    projectProperties.setEffectiveFrom(openMetadataElement.getEffectiveFromTime());
                    projectProperties.setEffectiveTo(openMetadataElement.getEffectiveToTime());
                    projectProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
                    projectProperties.setExtendedProperties(this.getRemainingExtendedProperties(elementProperties));
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), OpenMetadataElement.class.getName(), methodName);
                }
                if (relationships != null) {
                    bean.setResourceList(this.getResourceList(beanClass, relationships));
                    bean.setProjectManagers(this.getProjectManagers(beanClass, relationships));
                    bean.setProjectTeam(this.getProjectTeam(beanClass, relationships));
                }
                bean.setProperties(projectProperties);
                bean.setRelatedBy(super.getRelatedBy(beanClass, primaryElement, methodName));
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    protected List<RelatedMetadataElementSummary> getDependentProjects(Class<B> beanClass, List<RelatedMetadataElement> projectElements) throws PropertyServerException {
        String methodName = "getDependentProjects";
        if (projectElements != null) {
            ArrayList<RelatedMetadataElementSummary> dependentProject = new ArrayList<RelatedMetadataElementSummary>();
            for (RelatedMetadataElement projectElement : projectElements) {
                if (projectElement == null || !this.propertyHelper.isTypeOf(projectElement, OpenMetadataType.PROJECT_DEPENDENCY_RELATIONSHIP.typeName) || !projectElement.getElementAtEnd1()) continue;
                dependentProject.add(super.getRelatedElementSummary(beanClass, projectElement, "getDependentProjects"));
            }
            return dependentProject;
        }
        return null;
    }

    protected List<RelatedMetadataElementSummary> getDependsOnProjects(Class<B> beanClass, List<RelatedMetadataElement> projectElements) throws PropertyServerException {
        String methodName = "getDependsOnProjects";
        if (projectElements != null) {
            ArrayList<RelatedMetadataElementSummary> dependsOnProject = new ArrayList<RelatedMetadataElementSummary>();
            for (RelatedMetadataElement projectElement : projectElements) {
                if (projectElement == null || !this.propertyHelper.isTypeOf(projectElement, OpenMetadataType.PROJECT_DEPENDENCY_RELATIONSHIP.typeName) || projectElement.getElementAtEnd1()) continue;
                dependsOnProject.add(super.getRelatedElementSummary(beanClass, projectElement, "getDependsOnProjects"));
            }
            return dependsOnProject;
        }
        return null;
    }
}

