/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.converters;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.frameworks.openmetadata.converters.OpenMetadataConverterBase;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementHeader;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.MetadataElementSummary;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.RelatedMetadataElementSummary;
import org.odpi.openmetadata.frameworks.openmetadata.properties.RelatedMetadataElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.RelatedMetadataElementList;
import org.odpi.openmetadata.frameworks.openmetadata.search.PropertyHelper;

public class RelatedMetadataElementSummaryConverter<B>
extends OpenMetadataConverterBase<B> {
    public RelatedMetadataElementSummaryConverter(PropertyHelper propertyHelper, String serviceName, String serverName) {
        super(propertyHelper, serviceName, serverName);
    }

    @Override
    public B getNewBean(Class<B> beanClass, RelatedMetadataElement relatedMetadataElement, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof RelatedMetadataElementSummary) {
                RelatedMetadataElementSummary relatedElementSummary = (RelatedMetadataElementSummary)returnBean;
                MetadataElementSummary elementSummary = new MetadataElementSummary();
                ElementHeader elementHeader = new ElementHeader(relatedMetadataElement);
                elementHeader.setGUID(relatedMetadataElement.getRelationshipGUID());
                relatedElementSummary.setRelationshipHeader(elementHeader);
                if (relatedMetadataElement.getRelationshipProperties() != null) {
                    relatedElementSummary.setRelationshipProperties(relatedMetadataElement.getRelationshipProperties().getPropertiesAsStrings());
                }
                elementHeader = new ElementHeader(relatedMetadataElement.getElement());
                elementHeader.setGUID(relatedMetadataElement.getElement().getElementGUID());
                elementHeader.setClassifications(this.getElementClassifications(relatedMetadataElement.getElement().getClassifications()));
                elementSummary.setElementHeader(elementHeader);
                if (relatedMetadataElement.getElement().getElementProperties() != null) {
                    elementSummary.setProperties(relatedMetadataElement.getElement().getElementProperties().getPropertiesAsStrings());
                }
                relatedElementSummary.setRelatedElement(elementSummary);
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    public List<B> getNewBeans(Class<B> beanClass, List<RelatedMetadataElement> relatedMetadataElements, String methodName) throws PropertyServerException {
        ArrayList<B> results = null;
        if (relatedMetadataElements != null) {
            results = new ArrayList<B>();
            for (RelatedMetadataElement relatedMetadataElement : relatedMetadataElements) {
                if (relatedMetadataElement == null) continue;
                results.add(this.getNewBean(beanClass, relatedMetadataElement, methodName));
            }
        }
        return results;
    }

    public List<B> getNewBeans(Class<B> beanClass, RelatedMetadataElementList relatedMetadataElements, String methodName) throws PropertyServerException {
        if (relatedMetadataElements != null) {
            return this.getNewBeans(beanClass, relatedMetadataElements.getElementList(), methodName);
        }
        return null;
    }
}

