/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.converters;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.frameworks.openmetadata.converters.OpenMetadataConverterBase;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementStub;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.SolutionPortElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.RelatedMetadataElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.solutions.SolutionPortProperties;
import org.odpi.openmetadata.frameworks.openmetadata.search.ElementProperties;
import org.odpi.openmetadata.frameworks.openmetadata.search.PropertyHelper;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;

public class SolutionPortConverter<B>
extends OpenMetadataConverterBase<B> {
    public SolutionPortConverter(PropertyHelper propertyHelper, String serviceName, String serverName) {
        super(propertyHelper, serviceName, serverName);
    }

    @Override
    public B getNewComplexBean(Class<B> beanClass, OpenMetadataElement primaryElement, List<RelatedMetadataElement> relationships, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof SolutionPortElement) {
                SolutionPortElement bean = (SolutionPortElement)returnBean;
                SolutionPortProperties portProperties = new SolutionPortProperties();
                bean.setElementHeader(super.getMetadataElementHeader(beanClass, primaryElement, methodName));
                if (primaryElement != null) {
                    ElementProperties elementProperties = new ElementProperties(primaryElement.getElementProperties());
                    portProperties.setQualifiedName(this.removeQualifiedName(elementProperties));
                    portProperties.setAdditionalProperties(this.removeAdditionalProperties(elementProperties));
                    portProperties.setDisplayName(this.removeDisplayName(elementProperties));
                    portProperties.setDescription(this.removeDescription(elementProperties));
                    portProperties.setVersion(this.removeVersionIdentifier(elementProperties));
                    portProperties.setSolutionPortDirection(this.removeSolutionPortDirection(elementProperties));
                    portProperties.setEffectiveFrom(primaryElement.getEffectiveFromTime());
                    portProperties.setEffectiveTo(primaryElement.getEffectiveToTime());
                    portProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
                    portProperties.setExtendedProperties(this.getRemainingExtendedProperties(elementProperties));
                    bean.setProperties(portProperties);
                    if (relationships != null) {
                        ArrayList<ElementStub> delegationPorts = new ArrayList<ElementStub>();
                        for (RelatedMetadataElement relatedMetadataElement : relationships) {
                            if (relatedMetadataElement == null) continue;
                            if (this.propertyHelper.isTypeOf(relatedMetadataElement, OpenMetadataType.SOLUTION_PORT_SCHEMA_RELATIONSHIP.typeName)) {
                                bean.setSchemaType(super.getElementStub(beanClass, relatedMetadataElement.getElement(), methodName));
                                continue;
                            }
                            if (!this.propertyHelper.isTypeOf(relatedMetadataElement, OpenMetadataType.SOLUTION_PORT_DELEGATION_RELATIONSHIP.typeName)) continue;
                            delegationPorts.add(super.getElementStub(beanClass, relatedMetadataElement.getElement(), methodName));
                        }
                        if (!delegationPorts.isEmpty()) {
                            bean.setDelegationPorts(delegationPorts);
                        }
                    }
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), OpenMetadataElement.class.getName(), methodName);
                }
                bean.setProperties(portProperties);
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }
}

