/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.converters;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.frameworks.openmetadata.converters.OpenMetadataConverterBase;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.RelatedMetadataElementSummary;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.SolutionRoleElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.RelatedMetadataElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.actors.ActorRoleProperties;
import org.odpi.openmetadata.frameworks.openmetadata.search.ElementProperties;
import org.odpi.openmetadata.frameworks.openmetadata.search.PropertyHelper;

public class SolutionRoleConverter<B>
extends OpenMetadataConverterBase<B> {
    public SolutionRoleConverter(PropertyHelper propertyHelper, String serviceName, String serverName) {
        super(propertyHelper, serviceName, serverName);
    }

    @Override
    public B getNewComplexBean(Class<B> beanClass, OpenMetadataElement primaryElement, List<RelatedMetadataElement> relationships, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof SolutionRoleElement) {
                SolutionRoleElement bean = (SolutionRoleElement)returnBean;
                ActorRoleProperties roleProperties = new ActorRoleProperties();
                bean.setElementHeader(super.getMetadataElementHeader(beanClass, primaryElement, methodName));
                if (primaryElement != null) {
                    ElementProperties elementProperties = new ElementProperties(primaryElement.getElementProperties());
                    roleProperties.setQualifiedName(this.removeQualifiedName(elementProperties));
                    roleProperties.setAdditionalProperties(this.removeAdditionalProperties(elementProperties));
                    roleProperties.setRoleId(this.removeIdentifier(elementProperties));
                    roleProperties.setScope(this.removeScope(elementProperties));
                    roleProperties.setTitle(this.removeName(elementProperties));
                    roleProperties.setDescription(this.removeDescription(elementProperties));
                    roleProperties.setDomainIdentifier(this.removeDomainIdentifier(elementProperties));
                    roleProperties.setEffectiveFrom(primaryElement.getEffectiveFromTime());
                    roleProperties.setEffectiveTo(primaryElement.getEffectiveToTime());
                    roleProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
                    roleProperties.setExtendedProperties(this.getRemainingExtendedProperties(elementProperties));
                    bean.setProperties(roleProperties);
                    if (relationships != null) {
                        ArrayList<RelatedMetadataElementSummary> relatedMetadataElementSummaries = new ArrayList<RelatedMetadataElementSummary>();
                        for (RelatedMetadataElement relatedMetadataElement : relationships) {
                            if (relatedMetadataElement == null) continue;
                            relatedMetadataElementSummaries.add(super.getRelatedElementSummary(beanClass, relatedMetadataElement, methodName));
                        }
                        bean.setSolutionComponents(relatedMetadataElementSummaries);
                    }
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), OpenMetadataElement.class.getName(), methodName);
                }
                bean.setProperties(roleProperties);
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }
}

