/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.metadataelements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementHeader;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.MetadataElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.SchemaAttributeElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.SchemaTypeElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.schema.apis.APIParameterProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class APIParameterElement
implements MetadataElement {
    private ElementHeader elementHeader = null;
    private APIParameterProperties properties = null;
    private SchemaTypeElement type = null;

    public APIParameterElement() {
    }

    public APIParameterElement(APIParameterElement template) {
        if (template != null) {
            this.elementHeader = template.getElementHeader();
            this.properties = template.getProperties();
            this.type = template.getType();
        }
    }

    public APIParameterElement(SchemaAttributeElement template) {
        if (template != null) {
            this.elementHeader = template.getElementHeader();
            if (template.getSchemaAttributeProperties() != null) {
                this.properties = new APIParameterProperties(template.getSchemaAttributeProperties());
            }
            this.type = template.getSchemaTypeElement();
        }
    }

    @Override
    public ElementHeader getElementHeader() {
        return this.elementHeader;
    }

    @Override
    public void setElementHeader(ElementHeader elementHeader) {
        this.elementHeader = elementHeader;
    }

    public APIParameterProperties getProperties() {
        return this.properties;
    }

    public void setProperties(APIParameterProperties properties) {
        this.properties = properties;
    }

    public SchemaTypeElement getType() {
        return this.type;
    }

    public void setType(SchemaTypeElement type) {
        this.type = type;
    }

    public String toString() {
        return "APIParameterElement{elementHeader=" + String.valueOf(this.elementHeader) + ", properties=" + String.valueOf(this.properties) + ", type=" + String.valueOf(this.type) + "}";
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        APIParameterElement that = (APIParameterElement)objectToCompare;
        return Objects.equals(this.elementHeader, that.elementHeader) && Objects.equals(this.properties, that.properties) && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.elementHeader, this.properties, this.type);
    }
}

