/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.metadataelements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ActorRoleAppointee;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ActorRoleElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.Appointee;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ActorRoleHistory
extends ActorRoleAppointee {
    private List<Appointee> predecessors = null;
    private List<Appointee> successors = null;

    public ActorRoleHistory() {
    }

    public ActorRoleHistory(ActorRoleHistory template) {
        super(template);
        if (template != null) {
            this.predecessors = template.getPredecessors();
            this.successors = template.getSuccessors();
        }
    }

    public ActorRoleHistory(ActorRoleElement template) {
        super(template);
    }

    public List<Appointee> getPredecessors() {
        return this.predecessors;
    }

    public void setPredecessors(List<Appointee> predecessors) {
        this.predecessors = predecessors;
    }

    public List<Appointee> getSuccessors() {
        return this.successors;
    }

    public void setSuccessors(List<Appointee> successors) {
        this.successors = successors;
    }

    @Override
    public String toString() {
        return "ActorRoleHistory{predecessors=" + String.valueOf(this.predecessors) + ", successors=" + String.valueOf(this.successors) + "} " + super.toString();
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        ActorRoleHistory that = (ActorRoleHistory)objectToCompare;
        return Objects.equals(this.predecessors, that.predecessors) && Objects.equals(this.successors, that.successors);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.predecessors, this.successors);
    }
}

