/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.metadataelements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementHeader;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.MetadataElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.RelatedMetadataElementSummary;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class AttributedMetadataElement
implements MetadataElement {
    private ElementHeader elementHeader = null;
    private List<RelatedMetadataElementSummary> externalReferences = null;
    private List<RelatedMetadataElementSummary> otherRelatedElements = null;
    private String mermaidGraph = null;

    public AttributedMetadataElement() {
    }

    public AttributedMetadataElement(AttributedMetadataElement template) {
        if (template != null) {
            this.elementHeader = template.getElementHeader();
            this.externalReferences = template.getExternalReferences();
            this.otherRelatedElements = template.getOtherRelatedElements();
            this.mermaidGraph = template.getMermaidGraph();
        }
    }

    @Override
    public ElementHeader getElementHeader() {
        return this.elementHeader;
    }

    @Override
    public void setElementHeader(ElementHeader elementHeader) {
        this.elementHeader = elementHeader;
    }

    public void setExternalReferences(List<RelatedMetadataElementSummary> externalReferences) {
        this.externalReferences = externalReferences;
    }

    public List<RelatedMetadataElementSummary> getExternalReferences() {
        return this.externalReferences;
    }

    public List<RelatedMetadataElementSummary> getOtherRelatedElements() {
        return this.otherRelatedElements;
    }

    public void setOtherRelatedElements(List<RelatedMetadataElementSummary> otherRelatedElements) {
        this.otherRelatedElements = otherRelatedElements;
    }

    public String getMermaidGraph() {
        return this.mermaidGraph;
    }

    public void setMermaidGraph(String mermaidGraph) {
        this.mermaidGraph = mermaidGraph;
    }

    public String toString() {
        return "AttributedMetadataElement{elementHeader=" + String.valueOf(this.elementHeader) + ", externalReferences=" + String.valueOf(this.externalReferences) + ", otherRelatedElements=" + String.valueOf(this.otherRelatedElements) + ", mermaidGraph='" + this.mermaidGraph + "'}";
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        AttributedMetadataElement that = (AttributedMetadataElement)objectToCompare;
        return Objects.equals(this.elementHeader, that.elementHeader) && Objects.equals(this.externalReferences, that.externalReferences) && Objects.equals(this.otherRelatedElements, that.otherRelatedElements) && Objects.equals(this.mermaidGraph, that.mermaidGraph);
    }

    public int hashCode() {
        return Objects.hash(this.elementHeader, this.externalReferences, this.otherRelatedElements, this.mermaidGraph);
    }
}

