/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.metadataelements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.AttributedMetadataElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.RelatedBy;
import org.odpi.openmetadata.frameworks.openmetadata.properties.collections.CollectionProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class CollectionElement
extends AttributedMetadataElement {
    private CollectionProperties properties = null;
    private RelatedBy relatedBy = null;

    public CollectionElement() {
    }

    public CollectionElement(CollectionElement template) {
        super(template);
        if (template != null) {
            this.properties = template.getProperties();
            this.relatedBy = template.getRelatedBy();
        }
    }

    public CollectionProperties getProperties() {
        return this.properties;
    }

    public void setProperties(CollectionProperties properties) {
        this.properties = properties;
    }

    public RelatedBy getRelatedBy() {
        return this.relatedBy;
    }

    public void setRelatedBy(RelatedBy relatedBy) {
        this.relatedBy = relatedBy;
    }

    @Override
    public String toString() {
        return "CollectionElement{properties=" + String.valueOf(this.properties) + ", relatedBy=" + String.valueOf(this.relatedBy) + "} " + super.toString();
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        CollectionElement that = (CollectionElement)objectToCompare;
        return Objects.equals(this.properties, that.properties) && Objects.equals(this.relatedBy, that.relatedBy);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.properties, this.relatedBy);
    }
}

