/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.metadataelements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.openmetadata.enums.CommunityMembershipType;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementStub;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.PersonalRoleElement;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class CommunityMembershipElement
extends PersonalRoleElement {
    private CommunityMembershipType membershipType = null;
    private ElementStub community = null;

    public CommunityMembershipElement() {
    }

    public CommunityMembershipElement(CommunityMembershipElement template) {
        super(template);
        if (template != null) {
            this.membershipType = template.getMembershipType();
            this.community = template.getCommunity();
        }
    }

    public CommunityMembershipType getMembershipType() {
        return this.membershipType;
    }

    public void setMembershipType(CommunityMembershipType membershipType) {
        this.membershipType = membershipType;
    }

    public ElementStub getCommunity() {
        return this.community;
    }

    public void setCommunity(ElementStub community) {
        this.community = community;
    }

    @Override
    public String toString() {
        return "CommunityMembershipElement{membershipType=" + String.valueOf(this.membershipType) + ", community='" + String.valueOf(this.community) + "', elementHeader=" + String.valueOf(this.getElementHeader()) + ", properties=" + String.valueOf(this.getProperties()) + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        CommunityMembershipElement that = (CommunityMembershipElement)objectToCompare;
        return this.membershipType == that.membershipType && Objects.equals(this.community, that.community);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getMembershipType(), this.getCommunity());
    }
}

