/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.metadataelements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.AttributedMetadataElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.RelatedMetadataElementSummary;
import org.odpi.openmetadata.frameworks.openmetadata.properties.datadictionaries.DataClassProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class DataClassElement
extends AttributedMetadataElement {
    private DataClassProperties properties = null;
    private List<RelatedMetadataElementSummary> nestedDataClasses = null;
    private List<RelatedMetadataElementSummary> specializedDataClasses = null;

    public DataClassElement() {
    }

    public DataClassElement(DataClassElement template) {
        super(template);
        if (template != null) {
            this.properties = template.getProperties();
            this.nestedDataClasses = template.getNestedDataClasses();
            this.specializedDataClasses = template.getSpecializedDataClasses();
        }
    }

    public DataClassProperties getProperties() {
        return this.properties;
    }

    public void setProperties(DataClassProperties properties) {
        this.properties = properties;
    }

    public List<RelatedMetadataElementSummary> getNestedDataClasses() {
        return this.nestedDataClasses;
    }

    public void setNestedDataClasses(List<RelatedMetadataElementSummary> nestedDataClasses) {
        this.nestedDataClasses = nestedDataClasses;
    }

    public List<RelatedMetadataElementSummary> getSpecializedDataClasses() {
        return this.specializedDataClasses;
    }

    public void setSpecializedDataClasses(List<RelatedMetadataElementSummary> specializedDataClasses) {
        this.specializedDataClasses = specializedDataClasses;
    }

    @Override
    public String toString() {
        return "DataClassElement{properties=" + String.valueOf(this.properties) + ", nestedDataClasses=" + String.valueOf(this.nestedDataClasses) + ", specializedDataClasses=" + String.valueOf(this.specializedDataClasses) + "} " + super.toString();
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        DataClassElement that = (DataClassElement)objectToCompare;
        return Objects.equals(this.properties, that.properties) && Objects.equals(this.nestedDataClasses, that.nestedDataClasses) && Objects.equals(this.specializedDataClasses, that.specializedDataClasses);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.properties, this.nestedDataClasses, this.specializedDataClasses);
    }
}

