/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.metadataelements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.AttributedMetadataElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.MemberDataField;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.RelatedMetadataElementSummary;
import org.odpi.openmetadata.frameworks.openmetadata.properties.datadictionaries.DataFieldProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class DataFieldElement
extends AttributedMetadataElement {
    private DataFieldProperties properties = null;
    private List<MemberDataField> nestedDataFields = null;
    private List<RelatedMetadataElementSummary> assignedDataClasses = null;
    private List<RelatedMetadataElementSummary> assignedMeanings = null;
    private List<RelatedMetadataElementSummary> memberOfCollections = null;

    public DataFieldElement() {
    }

    public DataFieldElement(DataFieldElement template) {
        super(template);
        if (template != null) {
            this.properties = template.getProperties();
            this.nestedDataFields = template.getNestedDataFields();
            this.assignedDataClasses = template.getAssignedDataClasses();
            this.assignedMeanings = template.getAssignedMeanings();
            this.memberOfCollections = template.getMemberOfCollections();
        }
    }

    public DataFieldProperties getProperties() {
        return this.properties;
    }

    public void setProperties(DataFieldProperties properties) {
        this.properties = properties;
    }

    public List<MemberDataField> getNestedDataFields() {
        return this.nestedDataFields;
    }

    public void setNestedDataFields(List<MemberDataField> nestedDataFields) {
        this.nestedDataFields = nestedDataFields;
    }

    public List<RelatedMetadataElementSummary> getAssignedDataClasses() {
        return this.assignedDataClasses;
    }

    public void setAssignedDataClasses(List<RelatedMetadataElementSummary> assignedDataClasses) {
        this.assignedDataClasses = assignedDataClasses;
    }

    public List<RelatedMetadataElementSummary> getAssignedMeanings() {
        return this.assignedMeanings;
    }

    public void setAssignedMeanings(List<RelatedMetadataElementSummary> assignedMeanings) {
        this.assignedMeanings = assignedMeanings;
    }

    public List<RelatedMetadataElementSummary> getMemberOfCollections() {
        return this.memberOfCollections;
    }

    public void setMemberOfCollections(List<RelatedMetadataElementSummary> memberOfCollections) {
        this.memberOfCollections = memberOfCollections;
    }

    @Override
    public String toString() {
        return "DataFieldElement{properties=" + String.valueOf(this.properties) + ", nestedDataFields=" + String.valueOf(this.nestedDataFields) + ", assignedDataClasses=" + String.valueOf(this.assignedDataClasses) + ", assignedMeanings=" + String.valueOf(this.assignedMeanings) + ", memberOfCollections=" + String.valueOf(this.memberOfCollections) + "} " + super.toString();
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        DataFieldElement that = (DataFieldElement)objectToCompare;
        return Objects.equals(this.properties, that.properties) && Objects.equals(this.nestedDataFields, that.nestedDataFields) && Objects.equals(this.assignedDataClasses, that.assignedDataClasses) && Objects.equals(this.assignedMeanings, that.assignedMeanings) && Objects.equals(this.memberOfCollections, that.memberOfCollections);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.properties, this.nestedDataFields, this.assignedDataClasses, this.assignedMeanings, this.memberOfCollections);
    }
}

