/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.metadataelements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.AttributedMetadataElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.CorrelatedMetadataElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.RelatedBy;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.RelatedMetadataElementSummary;
import org.odpi.openmetadata.frameworks.openmetadata.properties.MetadataCorrelationHeader;
import org.odpi.openmetadata.frameworks.openmetadata.properties.glossaries.GlossaryTermProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class GlossaryTermElement
extends AttributedMetadataElement
implements CorrelatedMetadataElement {
    private List<MetadataCorrelationHeader> correlationHeaders = null;
    private GlossaryTermProperties glossaryTermProperties = null;
    private RelatedBy relatedBy = null;
    private RelatedMetadataElementSummary parentGlossary = null;
    private List<RelatedMetadataElementSummary> categoryMembership = null;
    private List<RelatedMetadataElementSummary> relatedTerms = null;
    private List<RelatedMetadataElementSummary> relatedDefinitions = null;
    private List<RelatedMetadataElementSummary> semanticAssignments = null;

    public GlossaryTermElement() {
    }

    public GlossaryTermElement(GlossaryTermElement template) {
        super(template);
        if (template != null) {
            this.correlationHeaders = template.getCorrelationHeaders();
            this.glossaryTermProperties = template.getGlossaryTermProperties();
            this.relatedBy = template.getRelatedElement();
            this.parentGlossary = template.getParentGlossary();
            this.categoryMembership = template.getCategoryMembership();
            this.relatedTerms = template.getRelatedTerms();
            this.relatedDefinitions = template.getRelatedDefinitions();
            this.semanticAssignments = template.getSemanticAssignments();
        }
    }

    @Override
    public List<MetadataCorrelationHeader> getCorrelationHeaders() {
        return this.correlationHeaders;
    }

    @Override
    public void setCorrelationHeaders(List<MetadataCorrelationHeader> correlationHeaders) {
        this.correlationHeaders = correlationHeaders;
    }

    public GlossaryTermProperties getGlossaryTermProperties() {
        return this.glossaryTermProperties;
    }

    public void setGlossaryTermProperties(GlossaryTermProperties glossaryTermProperties) {
        this.glossaryTermProperties = glossaryTermProperties;
    }

    public RelatedBy getRelatedElement() {
        return this.relatedBy;
    }

    public void setRelatedElement(RelatedBy relatedBy) {
        this.relatedBy = relatedBy;
    }

    public RelatedMetadataElementSummary getParentGlossary() {
        return this.parentGlossary;
    }

    public void setParentGlossary(RelatedMetadataElementSummary parentGlossary) {
        this.parentGlossary = parentGlossary;
    }

    public List<RelatedMetadataElementSummary> getCategoryMembership() {
        return this.categoryMembership;
    }

    public void setCategoryMembership(List<RelatedMetadataElementSummary> categoryMembership) {
        this.categoryMembership = categoryMembership;
    }

    public List<RelatedMetadataElementSummary> getRelatedTerms() {
        return this.relatedTerms;
    }

    public void setRelatedToTerms(List<RelatedMetadataElementSummary> relatedToTerms) {
        this.relatedTerms = relatedToTerms;
    }

    public List<RelatedMetadataElementSummary> getRelatedDefinitions() {
        return this.relatedDefinitions;
    }

    public void setRelatedDefinitions(List<RelatedMetadataElementSummary> relatedDefinitions) {
        this.relatedDefinitions = relatedDefinitions;
    }

    public List<RelatedMetadataElementSummary> getSemanticAssignments() {
        return this.semanticAssignments;
    }

    public void setSemanticAssignments(List<RelatedMetadataElementSummary> semanticAssignments) {
        this.semanticAssignments = semanticAssignments;
    }

    @Override
    public String toString() {
        return "GlossaryTermElement{correlationHeaders=" + String.valueOf(this.correlationHeaders) + ", glossaryTermProperties=" + String.valueOf(this.glossaryTermProperties) + ", relatedBy=" + String.valueOf(this.relatedBy) + ", parentGlossary=" + String.valueOf(this.parentGlossary) + ", categoryMembership=" + String.valueOf(this.categoryMembership) + ", relatedTerms=" + String.valueOf(this.relatedTerms) + ", relatedDefinitions=" + String.valueOf(this.relatedDefinitions) + ", semanticAssignments=" + String.valueOf(this.semanticAssignments) + ", relatedElement=" + String.valueOf(this.getRelatedElement()) + "} " + super.toString();
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        GlossaryTermElement that = (GlossaryTermElement)objectToCompare;
        return Objects.equals(this.correlationHeaders, that.correlationHeaders) && Objects.equals(this.glossaryTermProperties, that.glossaryTermProperties) && Objects.equals(this.relatedBy, that.relatedBy) && Objects.equals(this.parentGlossary, that.parentGlossary) && Objects.equals(this.categoryMembership, that.categoryMembership) && Objects.equals(this.relatedTerms, that.relatedTerms) && Objects.equals(this.relatedDefinitions, that.relatedDefinitions) && Objects.equals(this.semanticAssignments, that.semanticAssignments);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.correlationHeaders, this.glossaryTermProperties, this.relatedBy, this.parentGlossary, this.categoryMembership, this.relatedTerms, this.relatedDefinitions, this.semanticAssignments);
    }
}

